000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEEINVC.
000300 AUTHOR. T S.
000400***************************************************************
000500*    LIST OF INVC DATABASE                                *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300***  SELECT PRT-FILE  ASSIGN TO "I:\TPS\TEST\SOURCE\SEEINVC.TXT"
001400     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEEINVC.TXT"
001500         ORGANIZATION IS LINE SEQUENTIAL
001600         FILE STATUS IS TPS-FILE-STATUS.
001700 DATA DIVISION.
001800 FILE SECTION.
001900 FD  PRT-FILE                                                     00001600
002000     LABEL RECORDS ARE OMITTED                                    00001700
002100     RECORD CONTAINS 200 CHARACTERS.                              00001800
002200 01  PRT-RECORD.
002300        05  PRT-the-KEY-ACCT-NO               PIC  X(10).
002301        05  FILLER                            PIC  X(01).
002302        05  PRT-the-KEY-SUB-ACCT              PIC  X(02).
002303        05  FILLER                            PIC  X(01).
002304        05  PRT-the-RECEIVE-DATE              PIC  X(08).
002305        05  FILLER                            PIC  X(01).
002306        05  PRT-the-RECEIVE-NUMBER            PIC  X(05).
002309        05  FILLER                            PIC  X(01).
002310        05  PRT-INVOICE-AMOUNT                PIC $,$$$,$$$.99.
002311        05  FILLER                            PIC  X(01).
002312        05  PRT-PAYEE-NAME                    PIC  X(36).
002313        05  FILLER                            PIC  X(01).
002314******  05  PRT-KEY-ACCT-NO                   PIC  9(10).
002320*       05  PRT-KEY-ACCT-NO                   PIC  X(10).
002400*       05  FILLER                            PIC  X(01).
002401*       05  PRT-INVOICE-NUMBER                PIC  X(20).
002402*       05  FILLER                            PIC  X(01).
002500*       05  PRT-INVOICE-DATE                  PIC  X(08).
002600*       05  FILLER                            PIC  X(01).
003100*       05  PRT-DUE-DATE                      PIC  X(08).
003200*       05  FILLER                            PIC  X(01).
003300*       05  PRT-KEY-SUB-ACCT                  PIC  9(02).
003400*       05  FILLER                            PIC  X(01).
003500*       05  PRT-KEY-RECEIVE-DATE              PIC  9(08).
003600*       05  FILLER                            PIC  X(01).
003700*       05  PRT-KEY-RECEIVE-NUMBER            PIC  9(08).
003800*       05  FILLER                            PIC  X(01).
003900*       05  PRT-ADDRESSOR-NAME                PIC  X(36).
004000*       05  FILLER                            PIC  X(01).
004300*       05  PRT-PAYEE-ACCOUNT-NUMBER          PIC  X(36).
004400*       05  FILLER                            PIC  X(01).
004500*
004600
004700
004800 WORKING-STORAGE SECTION.
004900     COPY "TPSFILES.CPY".
005000     COPY "KEYVALUE.CPY".
005100 01  TPS-INVC-REC.
005200     COPY "TPSINVC.CPY".
005300 01  TPSIO022                      PIC X(08) VALUE 'TPSIO022'.
005400 01  PROGRAM-NAMES.
005500  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
005600  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005700 01  TPS-FILE-STATUS                       PIC XX.
005800     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
005900 LINKAGE SECTION.
006000 01 TPS-PARAMETER.
006100    05 TPS-PARAMETER-VALUE PIC XX.
006200
006300 PROCEDURE DIVISION USING
006400                          TPS-PARAMETER.
006500 SEEINVC-BEGIN.
006600    PERFORM OPEN-THE-FILES
006700       THRU OPEN-THE-FILES-EXIT.
006800    PERFORM READ-THE-INVC
006900       THRU READ-THE-INVC-EXIT.
007000 SEEINVC-COMMON-EXIT.
007100    PERFORM CLOSE-THE-FILES
007200       THRU CLOSE-THE-FILES-EXIT.
007300    STOP RUN.
007400
007500 READ-THE-INVC.
007600    MOVE LOW-VALUES TO INVC-KEY.
007620    MOVE ZEROS                 TO INVC-ACCT-NO.
007630****MOVE '0101000347'          TO INVC-ACCT-NO.
007640****MOVE '0101000271'          TO INVC-ACCT-NO.
007650****MOVE '0150000123'          TO INVC-ACCT-NO.
007651    MOVE '0101000255'          TO INVC-ACCT-NO.
007652    MOVE '00'                  TO INVC-SUB-ACCT.
007660*   MOVE '99999999'            TO INVC-receive-date
007670*   MOVE '99999'               TO INVC-receive-NUMBER
007700    MOVE F-PRIME TO FILE-KEY.
007800**  MOVE F-START-HIGH TO FILE-ACTION.
007810    MOVE F-START TO FILE-ACTION.
007900    CALL TPSIO022 USING FILE-REQUEST TPS-INVC-REC.
008000    IF NO-RECORD-WAS-FOUND GO TO READ-THE-INVC-EXIT.
008100    IF NOT A-SUCCESSFUL-OPERATION
008200       MOVE ' INVC ' TO FILE-NAME
008300       MOVE 'SEEINVC-SBR' TO FILE-TEXT
008400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008500       GO TO SEEINVC-COMMON-EXIT.
008600
008700 READ-ALL-INVC-RECORDS.
008800    MOVE F-PRIME TO FILE-KEY.
008900    MOVE F-READ-NEXT TO FILE-ACTION.
009000    CALL TPSIO022 USING FILE-REQUEST TPS-INVC-REC.
009100    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-INVC-EXIT.
009200    IF NOT A-SUCCESSFUL-OPERATION
009300       MOVE ' INVC ' TO FILE-NAME
009400       MOVE 'SEEINVC-BRN' TO FILE-TEXT
009500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009600       GO TO SEEINVC-COMMON-EXIT.
009700
009701      if INVC-ACCT-NO not = 0101000255
009702         GO TO READ-THE-INVC-EXIT
009703       end-if.
009704
009710*     IF INVC-INVOICE-AMOUNT(1:2) NOT = '99'
009720*        GO TO READ-ALL-INVC-RECORDS
009800*      END-IF.
009810
009811*     IF INVC-PAYEE-NAME(1:08) = 'Internal'
009820*        CONTINUE
009830*       ELSE
009831*     IF INVC-PAYEE-NAME(1:08) = 'INTERNAL'
009832*        CONTINUE
009833*       ELSE
009834*        GO TO READ-ALL-INVC-RECORDS
009835*      END-IF
009836*     END-IF.
009840
009841*     IF INVC-INVOICE-NUMBER = SPACES
009842*        GO TO READ-ALL-INVC-RECORDS
009843*       ELSE
009844*     IF INVC-INVOICE-NUMBER = LOW-VALUES
009845*        GO TO READ-ALL-INVC-RECORDS
009846*       END-IF
009847*      END-IF.
009850
009900       MOVE SPACES                TO PRT-RECORD.
010100
010200*     IF INVC-ACCT-NO IS NOT NUMERIC
010201*        MOVE '9999999999'   TO INVC-ACCT-NO
010202*        MOVE SPACES         TO PRT-KEY-ACCT-NO
010203*       ELSE
010210*        MOVE INVC-ACCT-NO
010300*             TO PRT-KEY-ACCT-NO
010310*      END-IF.
010320
010330*     IF INVC-ACCT-NO = '0150000073'
010331*        NEXT SENTENCE
010332*      END-IF.
010340
010341      IF INVC-RECEIVE-DATE(1:4) < '2014'
010343          GO TO READ-ALL-INVC-RECORDS
010344       END-IF.
010345
010346*     IF INVC-PAYEE-NAME = SPACES
010347*        GO TO ITS-A-DEPOSIT
010348*      END-IF.
010349
010350*     IF INVC-INVOICE-AMOUNT NOT NUMERIC
010351*        MOVE '999999999'  TO INVC-INVOICE-AMOUNT
010352*        GO TO ITS-A-DEPOSIT
010353*      END-IF.
010354
010355****  GO TO READ-ALL-INVC-RECORDS.
010356
010357 ITS-A-DEPOSIT.
010360
010370
010400****  MOVE INVC-SUB-ACCT
010500****       TO PRT-KEY-?????.
010600*     MOVE INVC-RECEIVE-DATE
010700*          TO PRT-KEY-RECEIVE-DATE.
010800*     MOVE INVC-RECEIVE-NUMBER
010900*          TO PRT-KEY-RECEIVE-NUMBER.
011000
011100*     MOVE INVC-ADDRESSOR-NAME
011200*          TO PRT-ADDRESSOR-NAME.
011300      MOVE INVC-PAYEE-NAME
011400           TO PRT-PAYEE-NAME.
011500*     MOVE INVC-PAYEE-ACCOUNT-NUMBER
011600*          TO PRT-PAYEE-ACCOUNT-NUMBER.
011700*     MOVE INVC-INVOICE-DATE
011800*          TO PRT-INVOICE-DATE.
011900*     MOVE INVC-INVOICE-NUMBER
012000*          TO PRT-INVOICE-NUMBER.
012100      MOVE INVC-INVOICE-AMOUNT
012200           TO PRT-INVOICE-AMOUNT.
012300*     MOVE INVC-DUE-DATE
012400*          TO PRT-DUE-DATE.
012510
012511      IF INVC-ACCT-NO IS NOT NUMERIC
012512         MOVE 'XXXXXXXXXX'
012513            TO  PRT-the-KEY-ACCT-NO
012514        ELSE
012515         MOVE INVC-ACCT-NO
012516            TO  PRT-the-KEY-ACCT-NO
012517       END-IF.
012518
012519      IF INVC-SUB-ACCT IS NOT NUMERIC
012520         MOVE 'XX'
012521            TO  PRT-the-KEY-SUB-ACCT
012522        ELSE
012524         MOVE INVC-SUB-ACCT
012525            TO  PRT-the-KEY-SUB-ACCT
012526       END-IF.
012527
012528      IF INVC-RECEIVE-DATE IS NOT NUMERIC
012529         MOVE 'XXXXXXXX'
012530            TO  PRT-the-RECEIVE-DATE
012531        ELSE
012532         MOVE INVC-RECEIVE-DATE
012533            TO  PRT-the-RECEIVE-DATE
012534       END-IF.
012535
012536      IF INVC-RECEIVE-NUMBER IS NOT NUMERIC
012537         MOVE 'XXXXX'
012538            TO  PRT-the-RECEIVE-NUMBER
012539        ELSE
012540         MOVE INVC-RECEIVE-NUMBER
012541            TO  PRT-the-RECEIVE-NUMBER
012542       END-IF.
012550
012600       WRITE PRT-RECORD.
012700       GO TO READ-ALL-INVC-RECORDS.
012710
012800 READ-THE-INVC-EXIT. EXIT.
012900
013000
013100 FILE-ERROR.
013200     CALL TPSIOERR USING FILE-REQUEST.
013300     CANCEL TPSIOERR.
013400 FILE-ERROR-EXIT. EXIT.
013500
013600
013700 OPEN-THE-FILES.
013800    OPEN OUTPUT PRT-FILE.
013900    MOVE F-PRIME    TO FILE-KEY.
014000    MOVE F-OPEN-INPUT TO FILE-ACTION.
014100    CALL TPSIO022 USING FILE-REQUEST TPS-INVC-REC.
014200    IF FILE-STATUS NOT = '00' AND '05'
014300       MOVE ' INVC ' TO FILE-NAME
014400       MOVE 'SEEINVC-ORC' TO FILE-TEXT
014500       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014600       GO TO SEEINVC-COMMON-EXIT.
014700 OPEN-THE-FILES-EXIT. EXIT.
014800
014900 CLOSE-THE-FILES.
015000    CLOSE PRT-FILE.
015100      MOVE F-PRIME TO FILE-KEY.
015200      MOVE F-CLOSE TO FILE-ACTION.
015300      CALL TPSIO022 USING FILE-REQUEST TPS-INVC-REC.
015400      IF NOT A-SUCCESSFUL-OPERATION
015500         MOVE ' INVC ' TO FILE-NAME
015600         MOVE 'SEEINVC-CCK' TO FILE-TEXT
015700         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
015800      END-IF.
015900
016000 CLOSE-THE-FILES-EXIT. EXIT.
016100
