000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. seediary.
000300 AUTHOR. T S.
000400***************************************************************
000500*    list of client/diary control database                    *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                                                                 
001300     SELECT PRT-FILE  ASSIGN TO 'c:\tps\app\seediary.TXT'                                                         
001400         ORGANIZATION IS LINE SEQUENTIAL                                                                          
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE
001900     LABEL RECORDS ARE OMITTED                                    0
002000     RECORD CONTAINS 200 CHARACTERS.                              00001800
002100 01   PRT-RECORD.
002112        05  PRT-CLIENT-group                  PIC  X(02).
002113        05  FILLER                            PIC  X(02).
002112        05  PRT-CLIENT-FIRST-INITIAL          PIC  X(01).
002113        05  FILLER                            PIC  X(01).
002112        05  PRT-CLIENT-NAME                   PIC  X(20).
002113        05  FILLER                            PIC  X(02).
002112        05  PRT-1st-day                       PIC  X(10).
002115        05  FILLER                            PIC  X(01).
002112        05  PRT-2nd-day                       PIC  X(10).
002115        05  FILLER                            PIC  X(02).
017711        05  PRT-DATE-OF-REPORT                PIC  X(08).                                                         
003900        05  FILLER                            PIC  X(150).
009500
009600
009700 WORKING-STORAGE SECTION.
009800     COPY "TPSFILES.CPY".
009900     COPY "KEYVALUE.CPY".
010110                                                                                                                  
010000 01  TPS-PROFL-REC.
010100     COPY "TPSPROFL.CPY".
010000 01  TPS-diary-REC.
010100     COPY "TPSdiary.CPY".
010110                                                                                                                  
010210 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
010210 01  TPSIO006                      PIC X(08) VALUE 'TPSIO006'.
010210 01  TPSIO024                      PIC X(08) VALUE 'TPSIO024'.
010220
010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010500  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010600 01  TPS-FILE-STATUS                       PIC XX.
010700     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
010800                                                                                                                  
010230
010600 01  SAVE-ACCT-NO                 PIC  9(10) VALUE ZEROS.
010230
010600*01  type-diary-run-flag               pic  9(01) value 0.                                                          
010600*01  type-diary-run-flag               pic  9(01) value 1.                                                          
010600 01  type-diary-run-flag               pic  9(01) value 0.
010600     88 fix-diary-new-account                     value 1.                                                          
010600     88 fix-diary-del-account                     value 2.                                                          
010800                                                                                                                  
010800 LINKAGE SECTION.
010900 01 TPS-PARAMETER.
011000    05 TPS-PARAMETER-VALUE PIC XX.
011100
011200 PROCEDURE DIVISION USING tps-parameter.
011300                                                                                                                  
011400 seediary-BEGIN.
011500    PERFORM OPEN-THE-FILES
011600       THRU OPEN-THE-FILES-EXIT.
011601
010600    if fix-diary-new-account                                                                                        
010600       perform create-new-account-diary thru                                                                        
010600               create-new-account-diary-exit                                                                        
011601     end-if.                                                                                                        
011601
010600    if fix-diary-del-account                                                                                        
010600       perform delete-the-account-diary thru                                                                        
010600               delete-the-account-diary-exit                                                                        
011601     end-if.                                                                                                        
011601
011601
026299    MOVE SPACES           TO PRT-RECORD.                                                                          
011610    INITIALIZE TPS-diary-REC.
011630
011700    PERFORM READ-THE-diary
011800       THRU READ-THE-diary-EXIT.
011630
011630
011900 seediary-COMMON-EXIT.
012000    PERFORM CLOSE-THE-FILES
012100       THRU CLOSE-THE-FILES-EXIT.
012200    GOBACK.                                                                                                       
012200    STOP RUN.
012300
012400 READ-THE-diary.
012500    INITIALIZE TPS-diary-REC.
012300
012600    MOVE F-PRIME TO FILE-KEY.
012700    MOVE F-START TO FILE-ACTION.
012800    CALL TPSIO024 USING FILE-REQUEST TPS-diary-REC.
012900    IF NO-RECORD-WAS-FOUND GO TO READ-THE-diary-EXIT.
013000    IF NOT A-SUCCESSFUL-OPERATION
013100       MOVE 'diary ' TO FILE-NAME
013200       MOVE 'seediary-SBR' TO FILE-TEXT
013300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
013400       GO TO seediary-COMMON-EXIT.
013500
013600 READ-ALL-diary-RECORDS.
013700    MOVE F-PRIME TO FILE-KEY.
013800    MOVE F-READ-NEXT TO FILE-ACTION.
013900    CALL TPSIO024 USING FILE-REQUEST TPS-diary-REC.
014000    IF END-OF-FILE-WAS-REACHED                                                                                      
014000       GO TO READ-THE-diary-EXIT                                                                                    
           end-if.                                                                                                        
014100    IF NOT A-SUCCESSFUL-OPERATION
014200       MOVE 'dairy ' TO FILE-NAME
014300       MOVE 'seediary-BRN' TO FILE-TEXT
014400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014500       GO TO seediary-COMMON-EXIT.
014600
014600    IF DIARY-RPT-ACCT-NO NOT = SAVE-ACCT-NO
026100       WRITE PRT-RECORD
026101       MOVE SPACES      TO PRT-RECORD
014600       MOVE DIARY-RPT-ACCT-NO TO SAVE-ACCT-NO
013600    ELSE
014600       MOVE DIARY-RPT-ACCT-NO TO SAVE-ACCT-NO.
014600
014600*   if diary-rpt-end-date < '20020131'
013600*      go to READ-ALL-diary-RECORDS.                                                                              
014600
017600 PRINT-THE-RECORD.
017700    MOVE SPACES                TO PRT-RECORD.                                                                     
017701    PERFORM READ-THE-PROFL THRU                                                                                   
017702            READ-THE-PROFL-EXIT.                                                                                  
017711 
017711    IF CLNT-PROFILE-ADD-DATE(1:1) > '7'
013600       GO TO READ-ALL-diary-RECORDS.                                                                              
014600
028313    MOVE CLNT-PROFILE-ACCT-NO(3:2)                                                                                
002112         TO PRT-CLIENT-group.                                                                                     
017706    MOVE CLNT-PROFILE-FIRST-NAME(1:1)                                                                             
002112         TO PRT-CLIENT-FIRST-INITIAL.                                                                             
017706    MOVE CLNT-PROFILE-LAST-NAME                                                                                   
002112         TO PRT-CLIENT-NAME.                                                                                      
017711 
017711    MOVE DIARY-RPT-DATE-OF-REPORT                                                                                 
017711         TO PRT-DATE-OF-REPORT                                                                                    
017711 
017500    if diary-rpt-schedule = '99'                                                                                  
002112       move 'Daily     '             to PRT-1st-day                                                               
026100       WRITE PRT-RECORD                                                                                           
026101       MOVE SPACES                TO PRT-RECORD                                                                   
013600       go to read-all-diary-records
017711     end-if.                                                                                                      
                                                                                                                        
017500    if diary-rpt-day1 = '1'                                                                                       
002112       move 'Monday    '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '2'                                                                                       
002112       move 'Tuesday   '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '3'                                                                                       
002112       move 'Wednesday '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '4'                                                                                       
002112       move 'Thursday  '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '5'                                                                                       
002112       move 'Friday    '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '6'                                                                                       
002112       move 'Saturday  '             to PRT-1st-day                                                               
            else
017500    if diary-rpt-day1 = '7'                                                                                       
002112       move 'Sunday    '             to PRT-1st-day                                                               
            else
002112       move '          '             to PRT-1st-day                                                               
           end-if.
002112                                                                                                                  
017500    if diary-rpt-day2 = '1'                                                                                       
002112       move 'Monday    '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '2'                                                                                       
002112       move 'Tuesday   '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '3'                                                                                       
002112       move 'Wednesday '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '4'                                                                                       
002112       move 'Thursday  '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '5'                                                                                       
002112       move 'Friday    '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '6'                                                                                       
002112       move 'Saturday  '             to PRT-2nd-day                                                               
            else
017500    if diary-rpt-day2 = '7'                                                                                       
002112       move 'Sunday    '             to PRT-2nd-day                                                               
            else
002112       move '          '             to PRT-2nd-day                                                               
           end-if.
002112                                                                                                                  
026100*   WRITE PRT-RECORD.
026101*   MOVE SPACES                TO PRT-RECORD.
026102
013600    GO TO READ-ALL-diary-RECORDS.                                                                                 
026302
026310 READ-THE-diary-EXIT. EXIT.
026400
026410
026420
026559
026560
026600 FILE-ERROR.
026700     CALL TPSIOERR USING FILE-REQUEST.
026800     CANCEL TPSIOERR.
026900 FILE-ERROR-EXIT. EXIT.
027000
027100
027200 OPEN-THE-FILES.
027300    OPEN OUTPUT PRT-FILE.
027400    MOVE F-PRIME    TO FILE-KEY.
027500    MOVE F-OPEN-I-O TO FILE-ACTION.
027600    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
027700    IF FILE-STATUS NOT = '00' AND '05'
027800       MOVE 'PROFL ' TO FILE-NAME
027900       MOVE 'seediary-ORC' TO FILE-TEXT
028000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028100       GO TO seediary-COMMON-EXIT.
014600                                                                                                                  
028110    MOVE F-PRIME    TO FILE-KEY.
028120    MOVE F-OPEN-I-O TO FILE-ACTION.
028130    CALL TPSIO024 USING FILE-REQUEST TPS-diary-REC.
028140    IF FILE-STATUS NOT = '00' AND '05'
028150       MOVE 'dairy ' TO FILE-NAME
028160       MOVE 'seediary-ORC' TO FILE-TEXT
028170       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028180       GO TO seediary-COMMON-EXIT.
028200 OPEN-THE-FILES-EXIT. EXIT.
028300
028301
028304
028310 READ-THE-PROFL.
028313    MOVE diary-rpt-ACCT-NO     TO CLNT-PROFILE-ACCT-NO.                                                           
028314    MOVE diary-rpt-SUB-ACCT    TO CLNT-PROFILE-SUB-ACCT.                                                          
028315    MOVE F-PRIME TO FILE-KEY.
028316    MOVE F-READ  TO FILE-ACTION.
028317    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028318    IF NO-RECORD-WAS-FOUND
028319       MOVE ZEROS         TO CLNT-PROFILE-ACCT-NO
028320                             CLNT-PROFILE-SUB-ACCT
028313       MOVE diary-rpt-ACCT-NO     TO CLNT-PROFILE-last-name                                                         
028313       MOVE spaces                TO CLNT-PROFILE-first-name                                                        
028322       GO TO READ-THE-PROFL-EXIT
028323     END-IF.
028324    IF NOT A-SUCCESSFUL-OPERATION
028325       MOVE ' BILLS' TO FILE-NAME
028326       MOVE 'seediary-SBR' TO FILE-TEXT
028327       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028328       GO TO seediary-COMMON-EXIT.
028329
028338 READ-THE-PROFL-EXIT. EXIT.
028339
028340
028341
028350
028400 CLOSE-THE-FILES.
028500    CLOSE PRT-FILE.
028600      MOVE F-PRIME TO FILE-KEY.
028700      MOVE F-CLOSE TO FILE-ACTION.
028810      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028900      IF NOT A-SUCCESSFUL-OPERATION
029000         MOVE 'PROFL ' TO FILE-NAME
029100         MOVE 'seediary-CCK' TO FILE-TEXT
029200         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029300      END-IF.
029310      MOVE F-PRIME TO FILE-KEY.
029320      MOVE F-CLOSE TO FILE-ACTION.
029330      CALL TPSIO024 USING FILE-REQUEST TPS-diary-REC.
029340      IF NOT A-SUCCESSFUL-OPERATION
029350         MOVE 'diary ' TO FILE-NAME
029360         MOVE 'seediary-CCK' TO FILE-TEXT
029370         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029380      END-IF.
029400
029500 CLOSE-THE-FILES-EXIT. EXIT.
029600
029700
029700
029700
010600 create-new-account-diary.                                                                                          
029330      initialize tps-diary-rec.                                                                                     
029700      move '0106000010'            to diary-rpt-acct-no.                                                            
029700      move '00'                    to diary-rpt-sub-acct.                                                           
029700      move '20060208'              to diary-rpt-date-of-report.                                                     
029700      move zeros                   to diary-rpt-start-date                                                          
029700                                      diary-rpt-end-date.                                                           
029700
017500      move '5'                     to diary-rpt-day1.                                                               
017500      move '9'                     to diary-rpt-day2.                                                               
002112                                                                                                                  
028315    move f-prime to file-key.
028316    move f-write to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr1' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
029700    move '0101000990'              to diary-rpt-acct-no.                                                            
002112                                                                                                                  
028315    move f-prime to file-key.
028316    move f-write to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr2' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
002112                                                                                                                  
010600 create-new-account-diary-exit. exit.                                                                               
029800
029800
010600 delete-the-account-diary.                                                                                          
029330      initialize tps-diary-rec.                                                                                     
029700      move '0106000011'            to diary-rpt-acct-no.                                                            
029700      move '00'                    to diary-rpt-sub-acct.                                                           
029700      move '20060208'              to diary-rpt-date-of-report.                                                     
028315                                                                                                                    
028315    move f-prime to file-key.
028316    move f-read  to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr2' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
002112                                                                                                                  
028315    move f-prime to file-key.
028316    move f-delet to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr1' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
029330      initialize tps-diary-rec.                                                                                     
029700      move '0106000011'            to diary-rpt-acct-no.                                                            
029700      move '00'                    to diary-rpt-sub-acct.                                                           
029700      move '20060210'              to diary-rpt-date-of-report.                                                     
028315                                                                                                                    
028315    move f-prime to file-key.
028316    move f-read  to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr2' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
029700      move '20060203'              to diary-rpt-date-of-report.                                                     
017500      move '5'                     to diary-rpt-day1.                                                               
017500      move '9'                     to diary-rpt-day2.                                                               
029700      move '20060203'              to diary-rpt-end-date.                                                           
002112                                                                                                                  
028315    move f-prime to file-key.
028316    move f-write to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr2' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
029700      move '20060210'              to diary-rpt-date-of-report.                                                     
002112                                                                                                                  
028315    move f-prime to file-key.
028316    move f-delet to file-action.
028130    call tpsio024 using file-request tps-diary-rec.
028324    if not a-successful-operation
028150       move 'dairy ' to file-name
028160       move 'seediary-wr1' to file-text
028170       perform file-error thru file-error-exit
028180       go to seediary-common-exit.
002112                                                                                                                  
029800
010600 delete-the-account-diary-exit. exit.                                                                               
029800
029800
