000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEECHECK.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*    LIST OF CHECK DATABASE                                   *
000600***************************************************************
000600*@@@@@@@@@@@@@@  IMPORTANT CHANGE  @@@@@@@@@@@@@@@@@@@@@@@@@@@*
000600* 03/26/14 CHANGED NISSANOFF BALANCE AMOUNT FROM $17,384.18   *
000600*   JM     TO $3,832.62 ON ZERO TRANSACTION RECORD            *
000600*@@@@@@@@@@@@@@  IMPORTANT CHANGE  @@@@@@@@@@@@@@@@@@@@@@@@@@@*
      * 04/05/07-updated address from franklin ave 2 stewart ave  ts*                                                     
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEECHECK.TXT"         00001000
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
007500                                                                                                                  
008600   select  tape-file  assign to 'c:\tps\app\tapschck.txt'
008600***    select  tape-file  assign to "lpt1"
007900             file status is tps-file-status
                   organization is line sequential.
000000                                                                                                                    
009400                                                                                                                    
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 200 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002101*   05  PRINT-line-NO              PIC  zz9.
002101*   05  PRINT-period               PIC  x(01).
003100*   05  PRINT-ASTERIK              PIC  X(01) VALUE SPACE.
          05  print-client-NO            pic  x(10) value spaces.
      *   05  filler redefines print-client-name.
002101*       10  PRINT-ACCT-NO          PIC  x(10).
002102    05  FILLER                     PIC  X(01) VALUE SPACE.
002156    05  PRINT-TRANSACTION-NO       PIC  9(05).
002157    05  FILLER                     PIC  X(01) VALUE SPACE.
002103    05  PRINT-RECEIVE-DATE         PIC  9(08).
002104    05  FILLER                     PIC  X(01) VALUE SPACE.
002156    05  PRINT-OPEN-BAL             PIC  9(07)V99.
002157    05  FILLER                     PIC  X(01) VALUE SPACE.
002103    05  PRINT-NEXT-TRAN            PIC  9(05).
002104    05  FILLER                     PIC  X(01) VALUE SPACE.
002105    05  PRINT-RECEIVE-NUMBER       PIC  X(05).
002159    05  FILLER                     PIC  X(01) VALUE SPACE.
          05  PRINT-CHECK-TYPE           PIC  X(01)     VALUE SPACE.
002104    05  FILLER                     PIC  X(01) VALUE SPACE.
002156    05  PRINT-BALANCE              PIC  9(10)V99.
002106    05  FILLER                     PIC  X(01) VALUE SPACE.
002158    05  PRINT-TRANSACTION-CODE     PIC  X(01).
002155    05  FILLER                     PIC  X(01) VALUE SPACE.
002111    05  PRINT-NUMBER               PIC  9(05).
002120    05  FILLER                     PIC  X(01) VALUE SPACE.
002130    05  PRINT-AMOUNT               PIC  9(10)v99.
002140    05  FILLER                     PIC  X(01) VALUE SPACE.
002154    05  PRINT-DATE                 PIC  9(08).
      *   05  prt-RECONCILE-DATE         PIC  x(08).
002102*   05  FILLER                     PIC  X(01) VALUE '<'.
002152*   05  PRINT-PAYEE-NAME           PIC  X(36).
002155*   05  FILLER                     PIC  X(02).
002154*   05  PRINT-add-date-chg         PIC  x(08).
002510*   05  FILLER                     PIC  X(01) VALUE SPACE.
004000*   05  PRINT-CURRENT-BALANCE      PIC  Z,ZZZ,ZZZ.ZZ-.
002170    05  FILLER                     PIC  X(01) VALUE SPACE.
002301    05  PRINT-MISCELLANEOUS        PIC  X(30) VALUE SPACE.
      *   05  FILLER                     PIC X(01) VALUE SPACE.
      *   05  PRINT-CHECK-OPENING-BALANCE PIC Z,ZZZ,ZZZ.ZZ.
      *   05  PRINT-AUTO-SCHED           PIC  X(01).
002302*   05  FILLER                     PIC  X(01) VALUE SPACE.
002303*   05  PRINT-AUTO-START-DATE      PIC  9(08).
002304*   05  FILLER                     PIC  X(01) VALUE SPACE.
002305*   05  PRINT-AUTO-AMT1            PIC  $,$$$,$$$.$$.
002306*   05  FILLER                     PIC  X(01) VALUE SPACE.
002307*   05  PRINT-AUTO-START-DATE2     PIC  9(02).
002308*   05  FILLER                     PIC  X(01) VALUE SPACE.
002309*   05  PRINT-AUTO-AMT2            PIC  $,$$$,$$$.$$.
002311*   05  FILLER                     PIC  X(01) VALUE SPACE.
002400*   05  PRINT-SUB-ACCT             PIC  9(02).
004100*   05  FILLER                     PIC  X(01) VALUE SPACE.
004400*   05  PRINT-CHANGE-DATE          PIC  9(08).
004500                                                                                                                    
000000                                                                                                                  
008600 fd  tape-file                                                                                                      
           label records are omitted
           record contains 200 characters.
       01  tape-record                       pic  x(200).
000000                                                    
004500                                                                                                                    
004500                                                                                                                    
004500                                                                                                                    
004500 WORKING-STORAGE SECTION.
004600     COPY "TPSFILES.CPY".
004700     COPY "KEYVALUE.CPY".
004710     COPY "PCL5VALU.CPY".
      *    ------------------------------------------------------------
002101 01  todays-date-ymd       PIC  9(06) value 0.
002100
002101 01  ws-date-ymd       PIC  X(06) VALUE SPACES.
       01  ws-packed-date-ymd     pic 9(6)  COMP-3 VALUE 0.
       01  ws-packed-date-ymd-X   redefines ws-packed-date-ymd
                                   pic X(6).
      *    ------------------------------------------------------------
002100                                                                                                                    
002100 01  alt-PRT-RECORD.                                                                                                
002101    05  alt-PRINT-ACCT-NO          PIC  x(10).                                                                      
002102    05  FILLER                     PIC  X(01) VALUE SPACE.
002154    05  alt-PRINT-sub-acct         PIC  x(02).                                                                      
002155    05  FILLER                     PIC  X(20) VALUE SPACE.                                                          
004710                                                                                                                    
004800 01  sav-check-rec                pic  x(193).
004710                                                                                                                    
004800 01  TPS-fgnck-REC.
004900     COPY "TPSfgnck.CPY".
004910 01  TPS-MAIL-REC.
004920     COPY "TPSMAIL.CPY".
004910 01  TPS-profl-REC.
004920     COPY "TPSprofl.CPY".
004800 01  TPS-CHECK-REC.
004900     COPY "TPSCHECK.CPY".
004800 01  tps-recon-rec.
004900     copy "tpsrecon.cpy".
005000 01  TPSIOCHK                      PIC X(08) VALUE 'TPSIOCHK'.
005010 01  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
005010 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
005010 01  tpsio015                      pic x(08) value 'tpsio015'.
005010 01  tpsio026                      pic x(08) value 'tpsio026'.
005100 01  PROGRAM-NAMES.
005200  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
005300  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
005400 01  CHECK-AMOUNT-CHAR                     PIC  9(10).
005401 01  CHECK-TOTAL               PIC  9(10) VALUE ZERO.
005410 01  TPS-FILE-STATUS                       PIC XX.
005500     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
005510
005511 01  CURRENT-ACCT              PIC  9(10) VALUE ZEROS.
005512 01  CURRENT-CHECK-DATE        PIC  9(08) VALUE ZEROS.
005520
002101 01 line-NO                    PIC  9(03) value zeros.
005521
005522 01 NUM-CHECKS                 PIC  9(07) VALUE ZEROS.
005523 01 AMT-CHECKS                 PIC S9(10)V9(02) VALUE ZEROS.
005524 01 NUM-DEPOSITS               PIC  9(07) VALUE ZEROS.
005525 01 AMT-DEPOSITS               PIC S9(10)V9(02) VALUE ZEROS.
005530

000100 01 tape-today                   pic  x(06).                                                                        
043900*     '         1         2         3         4         5'                           00044800
043900*     '12345678901234567890123456789012345678901234567890'                           00044800
       01 tape-hdr-line0.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(40) value spaces.                                                        
          05 filler                       pic  x(50) value                                                                
043900      'Signature Bank Deposit Receipt for  '.                                                                       
          05 filler                       pic  x(20) value spaces.                                                        
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800
       01 tape-hdr-line1.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(36) value                                                                
043900      'TPS Administrative Group, LLC       '.                                                                       
          05 filler                       pic  x(20) value spaces.                                                        
          05 tape-hdr-date                pic  x(08) value 'xx/xx/xx'.                                                    
          05 filler                       pic  x(10) value spaces.                                                        
          05 filler                       pic  x(05) value 'Page '.                                                       
          05 tape-hdr-page-num            pic  zz9.                                                                       
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800
       01 tape-hdr-line1a.                                                                                                
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(40) value                                                                
043900      'Signature Bank Primary A/C 1500405860'.                                                                      
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800
       01 tape-hdr-line2.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(36) value                                                                
043900      '623 Stewart Ave, Suite 201          '.                                                                       
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800
       01 tape-hdr-line3.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(36) value                                                                
043900      'Garden City, NY  11530              '.                                                                       
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800
       01 tape-hdr-line4.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                       pic  x(06) value spaces.                                                        
          05 filler                       pic  x(36) value                                                                
043900      '516.739.7200                        '.                                                                       
          05 filler                       pic  x(06) value spaces.                                                        
043900                                                                                     00044800


       01 tape-prt-line.                                                                                                  
          05 filler                         pic  x(10).                                                                   
          05 tape-prt-line-num              pic  zzzz9.                                                                 
          05 tape-prt-period                pic  x(01).                                                                 
          05 filler                         pic  x(03).                                                                 
          05 tape-prt-check-amount          pic  $$$,$$$,$$$.99.
          05 filler                         pic  x(06).                                                                 
          05 tape-prt-client-name           pic  x(36).                                                                 
          05 filler                         pic  x(03).                                                                 
043900                                                                                     00044800
       01 tape-tot-line1.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                         pic  x(06).                                                                   
          05 filler                         pic  x(03).                                                                 
          05 filler                         pic  x(13) value                                                            
            '-------------'.                                                                                              
          05 filler                         pic  x(06).                                                                 
          05 filler                         pic  x(03).                                                                 
043900                                                                                     00044800
       01 tape-tot-line2.                                                                                                 
          05 filler                         pic  x(10).                                                                   
          05 filler                         pic  x(01).                                                                   
043900    05 tape-prt-check-detail          pic  zzzz9.                                                                   
          05 filler                         pic  x(03) value ' @ '.                                                       
          05 tape-prt-check-total           pic  $$$,$$$,$$$.99.
          05 filler                         pic  x(06).                                                                 
          05 filler                         pic  x(03).                                                                 
043900                                                                                     00044800
043900 01 tape-page-cnt                     pic  9(03) value 0.                                                           
043900 01 tape-line-cnt                     pic  9(02) value 46.                                                          
043900 01 tape-line-num                     pic  9(05) value 0.                                                           
043900                                                                                     00044800
043900 01 tape-check-items                  pic  9(05) value 0.                                                           
043900 01 tape-check-dollars                pic s9(10)v9(02) value 0.
043900                                                                                     00044800
043900 01 tape-dummy-dollars           pic s9(10)v9(02) value 100.00.
043900                                                                                     00044800
056500 01  tape-is-active-flag        pic  9(01) value 0.                                                                 
056500     88 tape-is-active                     value 1.                                                                 
030600                                                                                                                    
041500 01  tape-idx                              pic s9(4) comp.                           00042400                       
050100                                                                                     00052000
050200 01  table-the-tape occurs 1000 times.                                                                              
026500     05 tbl-tape-check-amount              pic s9(10)v9(02).
026500     05 tbl-tape-client-name               pic  x(36).                                                              
055300
000100                                                                                                                    
043900 01 calc-transactions                 pic  9(05) value 0.                                                           
043900 01 calc-check-dollars                pic s9(10)v9(02) value 0.
043900 01 crnt-check-dollars                pic s9(10)v9(02) value 0.
000100                                                                                                                    
043900 01 calc-transactions-void            pic  9(05) value 0.                                                           
043900 01 calc-check-dollars-void           pic s9(10)v9(02) value 0.
043900 01 calc-transactions-stop            pic  9(05) value 0.                                                           
043900 01 calc-check-dollars-stop           pic s9(10)v9(02) value 0.
000100                                                                                                                    
005540
005540***********  adjust open for i/o when necessary ********************
005540***********  adjust open for i/o when necessary ********************
005540
005540***********  adjust open for i/o when necessary ********************
005540***********  adjust open for i/o when necessary ********************
005540
005550
005550 01 checks-issued-from-date   pic  9(08) value 20010901.                                                          
005550 01 checks-issued-to-date     pic  9(08) value 20020831.                                                          
005550 01 checks-issued-count       pic  9(07) value 0.                                                                 
005550                                                 
005550
026500 01 save-check-amount         pic s9(10)v9(02).
005540
005540*01 search-for-void-flag       pic  9(02) value 00.
005540*01 search-for-void-flag       pic  9(02) value 01.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 02.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 03.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 04.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 05.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 06.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 07.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 08.                                                                 
      *01 search-for-void-flag       pic  9(02) value 09.
005540*01 search-for-void-flag       pic  9(02) value 10.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 11.
005540*01 search-for-void-flag       pic  9(02) value 12.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 13.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 14.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 15.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 16.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 17.
005540*01 search-for-void-flag       pic  9(02) value 18.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 19.                                                                 
005540*01 search-for-void-flag       pic  9(02) value 20.                                                                 
005540 01 search-for-void-flag       pic  9(02) value 00.
005540    88 search-for-void                    value 01.                                                                 
005540    88 search-checks-issued               value 02.                                                                 
005540    88 bad-recons-white                   value 03.                                                                 
005540    88 bad-recons-petersmeyer             value 04.                                                                 
005540    88 bad-recons-appel                   value 05.                                                                 
005540    88 bad-recons-calloway                value 06.                                                                 
005540    88 bad-zero-gackstatter               value 07.                                                                 
005540    88 display-cash-reserve               value 08.                                                                 
005540    88 bad-recons-siciliano               value 09.                                                                 
005540    88 fix-swiss-startup-stuff            value 10.                                                                 
005540    88 fix-zero-record                    value 11.                                                                 
005540    88 lets-test-the-tape                 value 12.                                                                 
005540    88 fix-void-plus-fgn                  value 13.                                                                 
005540    88 chg-debit-to-elec-debit            value 14.                                                                 
005540    88 search-for-deposit                 value 15.                                                                 
005540    88 calc-current-balance               value 16.                                                                 
005540    88 fix-3-lamphere-records             value 17.                                                                 
005540**  88 unvoid-a-check-record   do not use value 18.                                                                 
005540    88 void-a-credit-record               value 19.                                                                              
005540    88 void-a-debit-record                value 20.                                                                              
                     
005900    88 repair-citron-account              value 21.                                                                              
                     

005550
005550
005600 LINKAGE SECTION.
005700 01 TPS-PARAMETER.
005800    05 TPS-PARAMETER-VALUE PIC XX.
005900
006000 PROCEDURE DIVISION USING
006100                          TPS-PARAMETER.
006200 SEECHECK-BEGIN.
009248
      *open output tape-file.
      **    Place a numeric DATE value in an unsigned packed field.
      *   ACCEPT  todays-date-ymd from DATE.
005540*   ADD zero to todays-date-ymd GIVING ws-packed-date-ymd.
      **    Convert a Packed Field to a Display field.
      **    Attention! The following statement does the Convert!
002101*   MOVE WS-PACKED-DATE-YMD TO ws-date-ymd.

005540    if lets-test-the-tape
012900       perform test-the-tape thru                                                                                   
012900               test-the-tape-exit
006700       go to seecheck-common-exit
005900     end-if.
005900
006300    PERFORM OPEN-THE-FILES
006400       THRU OPEN-THE-FILES-EXIT.
005900
005900    if repair-citron-account
005900       perform fix-citron-account thru                                                                                           
005900               fix-citron-account-exit
006700       go to seecheck-common-exit
005900     end-if.
005900
005540*   if unvoid-a-check-record
005900*      perform make-it-good-again thru
005900*              make-it-good-again-exit
006700*      go to seecheck-common-exit
005900*    end-if.
005900
005540    if void-a-credit-record                                                                                                      
005900       perform void-credit-tps thru                                                                                              
005900               void-credit-tps-exit                                                                                              
005900     end-if.
005900
005540    if void-a-debit-record                                                                                                       
                     
005900       perform void-debit-tps thru                                                                                               
                     
005900               void-debit-tps-exit                                                                                               
                     
005900     end-if.
005900
005540    if fix-3-lamphere-records                                                                                       
005900       perform fix-lamphere-ed-records thru                                                                         
005900               fix-lamphere-ed-records-exit                                                                         
005540       move 00                 to search-for-void-flag                                                              
006700***    go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005540    if calc-current-balance                                                                                         
005900       perform calc-new-zero-balance thru                                                                           
005900               calc-new-zero-balance-exit                                                                           
006700       go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005900************  caution with this one ****************
005540    if fix-zero-record                                                                                              
005900       perform fix-the-new-zero-record thru                                                                         
005900               fix-the-new-zero-record-exit                                                                         
006700**     go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005540    if chg-debit-to-elec-debit                                                                                      
005540       perform make-debit-into-elec-debit thru                                                                      
005540               make-debit-into-elec-debit-exit                                                                      
006700****   go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005540    if fix-swiss-startup-stuff                                                                                      
005900       perform fix-swiss-account thru                                                                               
005900               fix-swiss-account-exit                                                                               
005900     end-if.
005900
005540    if fix-void-plus-fgn                                                                                            
005900       perform search-and-delete thru                                                                               
005900               search-and-delete-exit                                                                               
005900     end-if.
005900
005540    if bad-recons-white                                                                                             
005900       perform fix-recon-white thru                                                                                 
005900               fix-recon-white-exit                                                                                 
005900     end-if.
005900
005540    if bad-recons-petersmeyer                                                                                       
005900       perform fix-recon-petersmeyer thru
005900               fix-recon-petersmeyer-exit
005900     end-if.
005900
005540    if bad-recons-appel                                                                                             
005900       perform fix-recon-appel thru                                                                                 
005900               fix-recon-appel-exit                                                                                 
005900     end-if.
005900
005540    if bad-recons-calloway                                                                                          
005900       perform fix-recon-calloway thru                                                                              
005900               fix-recon-calloway-exit                                                                              
006700       go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005540    if bad-recons-siciliano                                                                                         
005900       perform fix-recon-siciliano thru                                                                             
005900               fix-recon-siciliano-exit                                                                             
006700***    go to seecheck-common-exit                                                                                   
005900     end-if.
005900
005540    if bad-zero-gackstatter                                                                                         
005900       perform delete-zero-gackstatter thru                                                                         
005900               delete-zero-gackstatter-exit                                                                         
005900     end-if.
005900
006500    PERFORM READ-THE-CHECKS                          
006600       THRU READ-THE-CHECKS-EXIT.
009363       MOVE SPACES                TO PRT-RECORD.
010600       MOVE CHECK-TOTAL            TO PRINT-AMOUNT.
011900       WRITE PRT-RECORD AFTER 1.
000000*     perform print-tape-info thru
000000*             print-tape-info-exit.

006700 SEECHECK-COMMON-EXIT.
006800    PERFORM CLOSE-THE-FILES
006900       THRU CLOSE-THE-FILES-EXIT.
007000    GOBACK.                                                                                                       
007100
007200 READ-THE-CHECKS.
007300    MOVE LOW-VALUES TO CHECK-KEY OF TPS-CHECK-REC.
007330*   MOVE '0106000581'   TO CHECK-ACCT-NO.
007330*   MOVE '0101001972'   TO CHECK-ACCT-NO.
007330    MOVE '0101000297'   TO CHECK-ACCT-NO.
                  
000000  
026876
      *   move 16846          to check-transaction-no.
                  
                  
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
007700    IF NO-RECORD-WAS-FOUND GO TO READ-THE-CHECKS-EXIT.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' CHECK' TO FILE-NAME
008000       MOVE 'SEECHECK-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO SEECHECK-COMMON-EXIT.
008300 READ-ALL-CHECK-NUMBERS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008700    IF END-OF-FILE-WAS-REACHED 
               GO TO READ-THE-CHECKS-EXIT.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
009230
009248       IF CHECK-ACCT-NO NOT = 0101000297
                GO TO READ-ALL-CHECK-NUMBERS.
      *         PERFORM DELETE-REC THRU
      *                 END-DELETE-REC.
             IF CHECK-RECEIVE-DATE < 20171201
                GO TO READ-ALL-CHECK-NUMBERS.
                
009262       IF CHECK-ACCT-NO = '0101001329'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 08292 TO CHECK-NEXT-TRAN
                    MOVE 9106.74 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.
009262
             IF CHECK-ACCT-NO = '0101001329'
009248           IF CHECK-TRANSACTION-NO > 08292
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.
009262
009248
009262       IF CHECK-ACCT-NO = '0101001444'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 08852 TO CHECK-NEXT-TRAN
                    MOVE 39562.18 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.
009262
             IF CHECK-ACCT-NO = '0101001444'
009248           IF CHECK-TRANSACTION-NO > 08852
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.

009248
009262       IF CHECK-ACCT-NO = '0105000038'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 02953 TO CHECK-NEXT-TRAN
                    MOVE 6982.57 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.


009262       IF CHECK-ACCT-NO = '0105000038'
009248           IF CHECK-TRANSACTION-NO > 02953
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.
009262
             IF CHECK-ACCT-NO = '0105000103'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 01740 TO CHECK-NEXT-TRAN
                    MOVE 5231.22 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.

             IF CHECK-ACCT-NO = '0105000103'
009248           IF CHECK-TRANSACTION-NO > 01740
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.

             IF CHECK-ACCT-NO = '0105000772'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 00177 TO CHECK-NEXT-TRAN
                    MOVE 95971.13 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.

             IF CHECK-ACCT-NO = '0105000772'
009248           IF CHECK-TRANSACTION-NO > 00177
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.

             IF CHECK-ACCT-NO = '0106000185'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 05562 TO CHECK-NEXT-TRAN
                    MOVE 46668.13 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.

             IF CHECK-ACCT-NO = '0106000185'
009248           IF CHECK-TRANSACTION-NO > 05562
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.

             IF CHECK-ACCT-NO = '0106000219'
009248          IF CHECK-RECEIVE-DATE = ZEROS AND
009248             CHECK-TRANSACTION-NO  = ZEROS
                    MOVE 08749 TO CHECK-NEXT-TRAN
                    MOVE 50517.67 TO CHECK-CURRENT-BALANCE
                    PERFORM REWRITE-REC THRU
                            REWRITE-REC-EXIT.

             IF CHECK-ACCT-NO = '0106000219'
009248           IF CHECK-TRANSACTION-NO > 08749
                    PERFORM DELETE-REC THRU
                            END-DELETE-REC.
009248
009262*      IF CHECK-DATE >= 20150801 AND
009269*         CHECK-DATE <=  20150914
      *           CONTINUE
      *          ELSE
009218*         GO TO READ-ALL-CHECK-NUMBERS.

009262*      IF CHECK-DATE > 20151001
      *           CONTINUE
      *          ELSE
009218*         GO TO READ-ALL-CHECK-NUMBERS.

      *      IF CHECK-RECEIVE-DATE = 20140203 AND
      *         CHECK-RECONCILE-DATE = 20140714 AND
009218*         CHECK-NUMBER = 99998 AND
009218*         CHECK-TRANSACTION-NO = 03692
      *           CONTINUE
      *      ELSE
009218*         GO TO READ-ALL-CHECK-NUMBERS.
000000
009363       MOVE SPACES                TO PRT-RECORD.

009386       MOVE CHECK-ACCT-NO          TO PRINT-CLIENT-NO.
009800       MOVE CHECK-RECEIVE-DATE     TO PRINT-RECEIVE-DATE
009800       MOVE CHECK-OPENING-BALANCE  TO PRINT-OPEN-BAL
009900       MOVE CHECK-NEXT-TRAN        TO PRINT-NEXT-TRAN
009900       MOVE CHECK-RECEIVE-NUMBER   TO PRINT-RECEIVE-NUMBER
009901
009910       MOVE CHECK-TRANSACTION-NO   TO PRINT-TRANSACTION-NO.
009901       MOVE CHECK-MISCELLANEOUS-FIELD TO PRINT-MISCELLANEOUS.
010200       MOVE CHECK-TRANSACTION-CODE TO PRINT-TRANSACTION-CODE.
010200       MOVE CHECK-TYPE-ACCT        TO PRINT-CHECK-TYPE.
010400
010500       MOVE CHECK-CURRENT-BALANCE TO PRINT-BALANCE.
010500       MOVE CHECK-NUMBER        TO PRINT-NUMBER.
010600       MOVE CHECK-AMOUNT           TO PRINT-AMOUNT.
010700       MOVE CHECK-DATE             TO PRINT-DATE.
002130*      move check-current-balance  to PRINT-balance.
      *      MOVE CHECK-RECONCILE-STATUS TO PRINT-RECONCILE-STATUS.

             ADD 1            TO CHECK-TOTAL.
011900       WRITE PRT-RECORD.
009360
009356       GO TO READ-ALL-CHECK-NUMBERS.
009248
009248*-------------------------------------------------
009248
      *      IF CHECK-ADJUST-MENT
      *            MOVE 'CHECK-ADJUST-MENT' TO PRINT-TRANS-DISCRIPT.

      *
      *      IF CHECK-ADJUST-PLUS
      *            MOVE 'CHECK-ADJUST-PLUS' TO PRINT-TRANS-DISCRIPT.
005100*      IF CHECK-ADJUST-MINUS
      *            MOVE 'CHECK-ADJUST-MINUS' TO PRINT-TRANS-DISCRIPT.
005200*      IF CHECK-DEPOSIT
      *            MOVE 'CHECK-DEPOSIT' TO PRINT-TRANS-DISCRIPT.
005300*      IF CHECK-INTEREST
      *            MOVE 'CHECK-INTEREST' TO PRINT-TRANS-DISCRIPT.
005400*      IF CHECK-WITHDRAWAL
      *            MOVE 'CHECK-WITHDRAWAL' TO PRINT-TRANS-DISCRIPT.
005500*      IF CHECK-SERVICE-CHARGE
      *            MOVE 'CHECK-SERVICE-CHARGE' TO PRINT-TRANS-DISCRIPT.
005600*      IF CHECK-FINANCE-CHARGE
      *            MOVE 'CHECK-FINANCE-CHARGE' TO PRINT-TRANS-DISCRIPT.
005620*      IF VOID-ADJUST-MENT
      *            MOVE 'VOID-ADJUST-MENT' TO PRINT-TRANS-DISCRIPT.
005630*      IF VOID-ADJUST-PLUS
      *            MOVE 'VOID-ADJUST-PLUS' TO PRINT-TRANS-DISCRIPT.
005640*      IF VOID-ADJUST-MINUS
      *            MOVE 'VOID-ADJUST-MINUS' TO PRINT-TRANS-DISCRIPT.
005650*      IF VOID-DEPOSIT
      *            MOVE 'VOID-DEPOSIT' TO PRINT-TRANS-DISCRIPT.
005660*      IF VOID-INTEREST
      *            MOVE 'VOID-INTEREST' TO PRINT-TRANS-DISCRIPT.
005670*      IF VOID-WITHDRAWAL
      *            MOVE 'VOID-WITHDRAWAL' TO PRINT-TRANS-DISCRIPT.
005680*      IF VOID-SERVICE-CHARGE
      *            MOVE 'VOID-SERVICE-CHARGE' TO PRINT-TRANS-DISCRIPT.
005690*      IF VOID-FINANCE-CHARGE
      *            MOVE 'VOID-FINANCE-CHARGE' TO PRINT-TRANS-DISCRIPT.
002156
010400

      *     perform print-tape-info thru
000000*             print-tape-info-exit.
009362

009262
      *      IF CHECK-TYPE-ACCT = 'F'
009218*         GO TO READ-ALL-CHECK-NUMBERS.
009262
      *      IF CHECK-NUMBER = 99997
009218*         GO TO READ-ALL-CHECK-NUMBERS.
009248
009262*      IF CHECK-NUMBER > 03560
009218*         GO TO READ-ALL-CHECK-NUMBERS.
009268
010500*      if CHECK-RECONCILE-STATUS = 'Y' AND
00926 *      IF CHECK-RECONCILE-DATE = 20131231 AND
009269*       CHECK-RECONCIL-PREV-OPEN = 20131201
      *        CONTINUE
      *        ELSE
009269*         CHECK-RECONCIL-PREV-CLOSE = 20131231
009288*           MOVE 'N'    TO CHECK-RECONCILE-STATUS
      *           MOVE ZEROS  TO CHECK-RECONCILE-DATE
009268*                          CHECK-RECONCIL-PREV-OPEN
      *                          CHECK-RECONCIL-PREV-CLOSE
008400*           move f-prime to file-key
008500*           move f-rewrite  to file-action
008600*           call tpsiochk using file-request tps-check-rec
008800*             if not a-successful-operation
008900*                move ' check' to file-name
009000*                move 'seecheck-rew' to file-text
009100*                perform file-error thru file-error-exit
009200*                go to seecheck-common-exit
015200*             end-if
009269*      END-IF.
                     
                     
008600*         call tpsiochk using file-request tps-check-rec                                                                         
                     
008800*         if not a-successful-operation                                                                                          
                     
008900*            move ' check' to file-name                                                                                          
                     
009000*            move 'seecheck-del' to file-text                                                                                    
                     
009100*            perform file-error thru file-error-exit                                                                             
                     
009200*            go to seecheck-common-exit                                                                                          
                     
015200*          end-if                                                                                                                
                     
009200*       go to seecheck-common-exit.                                                                                              
                     
                     
009269
009269
009269
009273
009274*      IF CHECK-DATE not = '20120924'
009276*        GO TO READ-ALL-CHECK-NUMBERS.
009278**     if check-amount not = 256.92                                                                                              
                     
009278*      if check-amount = 44896.98
009362*         GO TO PRINT-THIS-CHECK.
009276*      GO TO READ-ALL-CHECK-NUMBERS.
                     
009269
009269
009275*      if CHECK-DATE  > '20090112'
009267*         GO TO READ-THE-CHECKS-EXIT.
009277
009292*      IF CHECK-NUMBER = 0                                                                                          
009278*         if check-amount > 9999.00                                                                                 
009274*            if check-date > '20091215'                                                                             
009362*               GO TO PRINT-THIS-CHECK                                                                              
009362*             End-if                                                                                                
009362*          End-if                                                                                                   
009362*       End-if.                                                                                                     
009279*      GO TO READ-ALL-CHECK-NUMBERS.                                                                                
009228
005540*      if search-for-deposit and                                                                                    
009274*          check-date  = '20081211' and                                                                             
009278*           check-amount = 20000.00 and                                                                             
009292*            check-number = 0                                                                                       
009362*             go to print-this-check                                                                                
009362*        else                                                                                                       
009279*             go to read-all-check-numbers                                                                          
009290*       end-if.                                                                                                   
009228
009228
005540*      if search-for-void
009288*         IF CHECK-TRANSACTION-NO = ZEROS
009289*            GO TO READ-ALL-CHECK-NUMBERS
009290*          END-IF
009288*         IF CHECK-number = '99998'
009289*            GO TO READ-ALL-CHECK-NUMBERS
009290*          END-IF
009313*         IF not CHECK-void
009289*            GO TO READ-ALL-CHECK-NUMBERS
009290*          END-IF
009274*         IF CHECK-DATE < '20040101'
009289*            GO TO READ-ALL-CHECK-NUMBERS
009290*          END-IF
009362***       go to PRINT-VOIDS-ONLY                                                                                  
009362*         go to print-this-check
                     
009290*       END-IF.
009229
005900
005540*      if display-cash-reserve
009288*         if check-transaction-no = zeros
009362*            go to print-this-check
      *          end-if
009272*         go to read-all-check-numbers
      *       end-if.
009269
009269
009292*      IF CHECK-NUMBER > 0                                                                                        
009272*        GO TO READ-ALL-CHECK-NUMBERS.
009269
009269
009269
009270*      IF CHECK-DATE NOT = '19990608'
009271*      IF CHECK-DATE  < '20090601'
009272*        GO TO READ-ALL-CHECK-NUMBERS.
009273
009274*      IF CHECK-DATE  > '19951231'
009275*      IF CHECK-DATE  > '20021130'
009276*        GO TO READ-ALL-CHECK-NUMBERS.
009277
009278*      IF CHECK-NUMBER NOT = '01030'
009279*        GO TO READ-ALL-CHECK-NUMBERS.
009280
009281*      IF CHECK-NUMBER IS NOT NUMERIC
009282*        GO TO READ-ALL-CHECK-NUMBERS.
009283
009284*      IF CHECK-ADD-PASSWORD(1:8) NOT = 'TPS2003 '
009285*        GO TO READ-ALL-CHECK-NUMBERS.
009286
009288*      IF CHECK-TRANSACTION-NO = ZEROS
009289*         GO TO READ-ALL-CHECK-NUMBERS
009290*       END-IF.
009286
009288*      IF CHECK-TRANSACTION-NO not = ZEROS                                                                          
009289*         go to read-all-check-numbers
      *        else                                                                                                       
002100*         move spaces              to alt-PRT-RECORD                                                                
002101*         move check-acct-no       to alt-PRINT-ACCT-NO                                                             
002154*         move check-sub-acct      to alt-PRINT-sub-acct                                                            
011900*         WRITE PRT-RECORD from alt-prt-record                                                                      
009289*         go to read-all-check-numbers
009290*       END-IF.
009291
009292*      IF CHECK-NUMBER < 00001
009293*         GO TO READ-ALL-CHECK-NUMBERS
009294*       END-IF.
009295
009296*      IF CHECK-reconcile-DATE NOT = '20011208'                                                                   
009297*         GO TO READ-ALL-CHECK-NUMBERS
009298*       END-IF.
009295
009296*      IF CHECK-DATE < '20030701'                                                                                   
009297*         GO TO READ-ALL-CHECK-NUMBERS
009298*       END-IF.
009295
009296*      IF CHECK-DATE > '20030930'                                                                                   
009297*         GO TO READ-ALL-CHECK-NUMBERS
009298*       END-IF.
009330
009331
009335
009335
009335
009335
009318***    if CHECK-AMOUNT < 30000.00
009318*      if CHECK-AMOUNT < 10000.00
009334*         GO TO READ-ALL-CHECK-NUMBERS
009298*       END-IF.
009299
009300
009301*      IF CHECK-NUMBER = ZEROS
009302*         IF CHECK-DEPOSIT
009303*            ADD 1               TO NUM-DEPOSITS
009304*            ADD CHECK-AMOUNT    TO AMT-DEPOSITS
009305*          END-IF
009306*         GO TO READ-ALL-CHECK-NUMBERS
009307*       END-IF.
009308
009309*      IF CHECK-STOP                                                                                              
009310*        GO TO READ-ALL-CHECK-NUMBERS                                                                             
009311*       END-IF.
009312
009316
009316
000000                                                                                     00035700
263300*    IF CHECK-TRANSACTION-NO = ZEROS                                                 00035790
263400*       GO TO READ-all-CHECK-numbers                                                 00035800
263500*     END-IF.                                                                        00035810
263600                                                                                     00035820
263700*    IF CHECK-NUMBER = ZEROS                                                         00035830
263800*       GO TO READ-all-CHECK-numbers                                                 00035840
263900*     END-IF.                                                                        00035850
264000                                                                                     00035860
264100*    IF CHECK-VOID                                                                   00035870
264200*       GO TO READ-all-CHECK-numbers                                                 00035880
264300*     END-IF.                                                                        00035890
264400                                                                                     00035900
263600*           DON'T ACCUMULATE ELECTRONIC DEBITS...............                        00036010
263700*    IF CHECK-NUMBER = 99998                                                         00036020
263800*       GO TO READ-all-CHECK-numbers                                                 00036030
263900*     END-IF.                                                                        00036040
265400            
009316
009316
009316
009316
005540*   if search-checks-issued
005550*      if check-date < checks-issued-from-date
009314*         go to read-all-check-numbers
      *       end-if.
005550*      if check-date > checks-issued-to-date
009314*         go to read-all-check-numbers
      *       end-if.
009317     add 1                     to num-checks.
009318     add check-amount          to amt-checks.
009314*    go to read-all-check-numbers.
      *    end-if.
005550                                                 
005550                                                 
005550                                                 
005550                                                 
009317*      ADD 1                     TO NUM-CHECKS.
009318*      ADD CHECK-AMOUNT          TO AMT-CHECKS.
009316
009319****   GO TO READ-ALL-CHECK-NUMBERS.
009328
009329
009336
009337*      IF CHECK-ADJUST-MENT OR
009338*         CHECK-ADJUST-PLUS OR
009339*         CHECK-DEPOSIT
009340*         GO TO READ-ALL-CHECK-NUMBERS
009341*         CONTINUE
009342*        ELSE
009343*         GO TO READ-ALL-CHECK-NUMBERS
009344*       END-IF.
009345
009346
009347*      IF CHECK-AMOUNT = 8.00
009348*         GO TO PRINT-THIS-CHECK
009349*       END-IF.
009350
009351*      IF CHECK-AMOUNT = 15.16
009352*         GO TO PRINT-THIS-CHECK
009353*       END-IF.
009354
009355*      IF CHECK-AMOUNT NOT = 25.29
009356*         GO TO READ-ALL-CHECK-NUMBERS
009357*       END-IF.
009358
009359
006600*      if CHECK-RECONCILE-YES                                                                                       
006900*         if CHECK-RECONCILE-DATE(1:4) = '2003'                                                                     
009362*            go to PRINT-THIS-CHECK                                                                                 
009357*          end-if                                                                                                   
009357*       end-if.
009360
009600   
009360
009360
006600*      if check-written-by-client                                                                                   
010700*         if CHECK-add-DATE not < '20030101'                                                                        
009357*          end-if                                                                                                   
009357*       end-if.
009361
009361
009362 PRINT-THIS-CHECK.
005540       if display-cash-reserve                                                                                      
009363          move spaces           to prt-record                                                                       
009364          move check-acct-no    to clnt-profile-acct-no
009364          move check-sub-acct   to clnt-profile-sub-acct
009369          move f-prime to file-key
009370          move f-read  to file-action
009371          call tpsio004 using file-request tps-profl-rec
009372          if not a-successful-operation
009384*            move check-acct-no  to print-acct-no
009373            else
      *            move clnt-profile-last-name
      *                           to print-client-name
                 end-if
002101          add 1                   to line-NO                                                                        
002101*         move line-no            to PRINT-line-NO
002101*         move '.'                to PRINT-period
                if check-overdraft-amt not numeric                                                                        
                   move 0         to check-overdraft-amt                                                                  
                 end-if
                move check-overdraft-amt   to print-amount
000000           perform print-tape-info thru
000000                   print-tape-info-exit

011900*         WRITE PRT-RECORD
012000          GO TO READ-ALL-CHECK-NUMBERS                                                                              
              end-if.
012001
009364       if CHECK-ACCT-NO not = clnt-profile-acct-no                                                                
009364          move CHECK-ACCT-NO    to clnt-profile-acct-no
009364          move CHECK-sub-ACCT   to clnt-profile-sub-acct
009369          MOVE F-PRIME TO FILE-KEY
009370          MOVE F-READ  TO FILE-ACTION
009371          CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC
009372          IF NOT A-SUCCESSFUL-OPERATION
009373             MOVE ' profl' TO FILE-NAME
009374             MOVE 'SEECHECK-BRN' TO FILE-TEXT
009375             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009376             GO TO SEECHECK-COMMON-EXIT
                 end-if
              end-if.



009364       MOVE CHECK-ACCT-NO         TO MAIL-ACCT-NO.
009365       MOVE CHECK-SUB-ACCT        TO MAIL-SUB-ACCT.
012001

009366       MOVE CHECK-RECEIVE-DATE    TO MAIL-RECEIVE-DATE.
009367       MOVE CHECK-RECEIVE-NUMBER  TO MAIL-RECEIVE-NUMBER.
009368
009292       IF CHECK-NUMBER > 0                                                                                        
009369          MOVE F-PRIME TO FILE-KEY                                                                                
009370          MOVE F-READ  TO FILE-ACTION                                                                             
009371          CALL TPSIOREC USING FILE-REqUEST TPS-MAIL-REC                                                           
007700          IF NO-RECORD-WAS-FOUND                                                                                  
                   continue                                                                                             
                  ELSE                                                                                                  
009372          IF NOT A-SUCCESSFUL-OPERATION                                                                           
009373             MOVE ' RECV ' TO FILE-NAME                                                                           
009374             MOVE 'SEECHECK-BRN' TO FILE-TEXT                                                                     
009375             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                              
009376             GO TO SEECHECK-COMMON-EXIT                                                                           
                  end-if                                                                                                
                 end-if.                                                                                                
009377
009377
009363       MOVE SPACES                TO PRT-RECORD.
009377
002101       add 1                   to line-NO.
002101*      move line-no            to PRINT-line-NO.
002101*      move '.'                to PRINT-period.
002101
      *      move clnt-profile-last-name  to print-client-name.
009383
009384*      MOVE CHECK-ACCT-NO          TO PRINT-ACCT-NO.
009385*      MOVE CHECK-SUB-ACCT         TO PRINT-SUB-ACCT.
009800       MOVE CHECK-RECEIVE-DATE     TO PRINT-RECEIVE-DATE
009900       MOVE CHECK-RECEIVE-NUMBER   TO PRINT-RECEIVE-NUMBER
009910       MOVE CHECK-TRANSACTION-NO   TO PRINT-TRANSACTION-NO.
009901
010000*      IF CHECK-TRANSACTION-CODE < SPACE
010100*         MOVE SPACE TO CHECK-TRANSACTION-CODE
010200       MOVE CHECK-TRANSACTION-CODE TO PRINT-TRANSACTION-CODE.
010300*      IF   CHECK-NUMBER IS NOT NUMERIC
010400*           MOVE 0 TO CHECK-NUMBER.
010400                                                                                                                  
010400       if check-written-by-client                                                                                   
010400          move check-written-by-client-number                                                                       
010500                                   to print-number                                                                  
010400         else                                                                                                     
010500          move check-number        to print-number                                                                  
010400        end-if.                                                                                                   
010600       MOVE CHECK-AMOUNT           TO PRINT-AMOUNT.
010700       MOVE CHECK-DATE             TO PRINT-DATE.
010400                                                                                                                  
011900       WRITE PRT-RECORD.
011910       ADD 1                      TO NUM-CHECKS.
011920       ADD CHECK-AMOUNT           TO CHECK-TOTAL.
012000       GO TO READ-ALL-CHECK-NUMBERS.
012001
012001
012001
009362 PRINT-VOIDS-ONLY.                                                                                                
009364       if CHECK-ACCT-NO not = clnt-profile-acct-no
009364          move CHECK-ACCT-NO    to clnt-profile-acct-no
009364          move CHECK-sub-ACCT   to clnt-profile-sub-acct
009369          MOVE F-PRIME TO FILE-KEY
009370          MOVE F-READ  TO FILE-ACTION
009371          CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC
009372          IF NOT A-SUCCESSFUL-OPERATION
009373             MOVE ' profl' TO FILE-NAME
009374             MOVE 'SEECHECK-BRN' TO FILE-TEXT
009375             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009376             GO TO SEECHECK-COMMON-EXIT
                 end-if
              end-if.



009384
009363       MOVE SPACES                TO PRT-RECORD.
009384***    MOVE CHECK-ACCT-NO         TO PRINT-ACCT-NO.                                                               
011900       WRITE PRT-RECORD.
009363       MOVE SPACES                TO PRT-RECORD.

002101       add 1                   to line-NO.
002101*      move line-no            to PRINT-line-NO.
002101*      move '.'                to PRINT-period.
002101
      *      move clnt-profile-last-name  to print-client-name.
009383
009800       MOVE CHECK-RECEIVE-DATE     TO PRINT-RECEIVE-DATE.
009900       MOVE CHECK-RECEIVE-NUMBER   TO PRINT-RECEIVE-NUMBER.
010500       MOVE CHECK-NUMBER           TO PRINT-NUMBER.
010600       MOVE CHECK-AMOUNT           TO PRINT-AMOUNT.
010700       MOVE CHECK-DATE             TO PRINT-DATE.
011900       WRITE PRT-RECORD.
011910       ADD 1                      TO NUM-CHECKS.
011920       ADD CHECK-AMOUNT           TO CHECK-TOTAL.
012000       GO TO READ-ALL-CHECK-NUMBERS.
012001
012001
012001
012001
012001
012001
012001
012001
012001
012001
012001
012001
012001
012001
012010*PRINT-ZERO-RECORD.
012011*      MOVE CHECK-ACCT-NO         TO PRINT-ACCT-NO.
012015*      IF CHECK-AUTO-SCHDLE1 NOT = 'B' AND 'M' AND 'Q'
012016*         GO TO READ-ALL-CHECK-NUMBERS.
012017*      MOVE CHECK-AUTO-SCHDLE1    TO PRINT-AUTO-SCHED.
012018*      IF CHECK-AUTO-START-DATE NOT NUMERIC
012019*         MOVE ZEROS              TO CHECK-AUTO-START-DATE.
012020*      MOVE CHECK-AUTO-START-DATE TO PRINT-AUTO-START-DATE.
012021*      IF CHECK-AUTO-AMT1 NOT NUMERIC
012022*         MOVE ZEROS              TO CHECK-AUTO-AMT1.
012023*      MOVE CHECK-AUTO-AMT1       TO PRINT-AUTO-AMT1.
012024*      IF CHECK-AUTO-DATE2 NOT NUMERIC
012025*         MOVE ZEROS              TO CHECK-AUTO-DATE2.
012026*      MOVE CHECK-AUTO-DATE2      TO PRINT-AUTO-START-DATE2.
012027*      IF CHECK-AUTO-AMT2 NOT NUMERIC
012028*         MOVE ZEROS              TO CHECK-AUTO-AMT2.
012029*      MOVE CHECK-AUTO-AMT2       TO PRINT-AUTO-AMT2.
012030*      WRITE PRT-RECORD.
012031*      GO TO READ-ALL-CHECK-NUMBERS.
012040*
012100 READ-THE-CHECKS-EXIT. EXIT.
012200
012300
012400
012500 FILE-ERROR.
012600     CALL TPSIOERR USING FILE-REQUEST.
012700     CANCEL TPSIOERR.
012800 FILE-ERROR-EXIT. EXIT.
012900
013000
013100 OPEN-THE-FILES.
013200    OPEN OUTPUT PRT-FILE.
013210*   WRITE PRT-RECORD FROM PCL5-LANDSCAPE
013220*                   AFTER ADVANCING 1 LINES.

013300    MOVE F-PRIME    TO FILE-KEY.
014020    move f-open-i-o   to file-action.                                                                               
013500    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
013600    IF FILE-STATUS NOT = '00' AND '05'
013700       MOVE 'CHECK ' TO FILE-NAME
013800       MOVE 'SEECHECK-ORC' TO FILE-TEXT
013900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014000       GO TO SEECHECK-COMMON-EXIT.

014010    MOVE F-PRIME    TO FILE-KEY.
014020    move f-open-i-o   to file-action.                                                                               
014030    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
014040    IF FILE-STATUS NOT = '00' AND '05'
014050       MOVE 'RECV  ' TO FILE-NAME
014060       MOVE 'SEECHECK-ORC' TO FILE-TEXT
014070       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080       GO TO SEECHECK-COMMON-EXIT.

014010    MOVE F-PRIME    TO FILE-KEY.
014020    MOVE F-OPEN-INPUT TO FILE-ACTION.
014030    CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC.
014040    IF FILE-STATUS NOT = '00' AND '05'
014050       MOVE 'profl ' TO FILE-NAME
014060       MOVE 'SEECHECK-ORC' TO FILE-TEXT
014070       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080       GO TO SEECHECK-COMMON-EXIT.
014100 OPEN-THE-FILES-EXIT. EXIT.

014200 CLOSE-THE-FILES.
014300    CLOSE PRT-FILE.
014400      MOVE F-PRIME TO FILE-KEY.
014500      MOVE F-CLOSE TO FILE-ACTION.
014600
014700      CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
014800      IF NOT A-SUCCESSFUL-OPERATION
014900         MOVE 'CHECK ' TO FILE-NAME
015000         MOVE 'SEECHECK-CCK' TO FILE-TEXT
015100         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
015200      END-IF.
015300
015400 CLOSE-THE-FILES-EXIT. EXIT.
015500
015500*03/07/12
005900 void-credit-tps.                                                                                                                
009364* 1st let's void the credit............                                                                                          
                     
009364      move '0150000057'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '11609'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
204300      move 'd'                 to check-transaction-code.                                                           
204600      move 'NYTHSCA   '        to CHECK-CHANGE-PASSWORD.                                                            
204700      move '20120307'          to check-change-date.
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009364*     now adjust the 0 records running balance...................                                                   
009364      move '0150000057'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move zeros                       to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
206800                                                                                                                  
206700      subtract 32661.30        from check-current-balance.
206800                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
005900 void-credit-tps-exit. exit.                                                                                                     
                     
361400 rewrite-rec.
008400      move f-prime to file-key.
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.
008800      if not a-successful-operation
008900         move ' check' to file-name
009000         move 'seecheck-rew' to file-text
009100         perform file-error thru file-error-exit
009200         go to seecheck-common-exit
015200       end-if.
009210 rewrite-rec-exit.  exit.
015500
005900 void-debit-tps.                                                                                                                 
                     
009364* 1st let's void the debit............                                                                                           
                     
009364      move '0106000458'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '01883'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
009000      move 'V'                 to check-void-or-stop                                                                             
                     
204300***   move 'd'                 to check-transaction-code.                                                           
204600      move 'NYTHSCA   '        to CHECK-CHANGE-PASSWORD.                                                            
204700      move '20120507'          to check-change-date.
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009364*     now adjust the 0 records running balance...................                                                   
009364      move '0106000458'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move zeros                       to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
206800                                                                                                                  
206700      add 250.00                 to check-current-balance.
206800                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
005900 void-debit-tps-exit. exit.                                                                                                      
                     
015500
015500
005900 fix-recon-white.                                                                                                   
009364* 1st let's fix the e/d record(flag as reconciled)............                                                      
009364      move '0120000062'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00470'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
000000                                                                                                                    
361000      move 'Y'                  to check-reconcile-status.                                                          
361200      move 'NYTHSCA   '         to check-reconcil-password.                                                         
361300      move '20030509'           to check-reconcile-date.                                                            
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009364* 2nd let's void the debit record(flag as void)............                                                         
009364      move '0120000062'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00492'                     to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
204300      move 'm'                 to check-transaction-code.                                                           
204600      move 'NYTHSCA   '        to CHECK-CHANGE-PASSWORD.                                                            
204700      move '20030509'          to check-change-date.
205000   
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
009364* 3rd now adjust the 0 records running balance...................                                                   
009364      move '0120000062'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move zeros                       to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
206300                                                                                                                  
206400*   IF VOIDED-TRAN-CODE = 'D' OR 'I' OR 'P' OR 'A'                                                                
206500*      subtract voided-tran-amt from check-current-balance                                                        
206600*     else                                                                                                        
206700*      add voided-tran-amt        to check-current-balance                                                        
      *    end-if.                                                                                                      
206800                                                                                                                  
206800                                                                                                                  
206700      add check-amount           to check-current-balance.
206800                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
009210
009364* 4th now adjust the recon record(cover sheet info)........                                                         
014030*     initialize tps-recon-rec.                                                                                     
014010*     move f-prime    to file-key.                                                                                  
013400*     move f-open-i-o to file-action.                                                                               
014030*     call tpsio015 using file-request tps-recon-rec.                                                               
014040*     if file-status not = '00' and '05'                                                                            
014050*        move 'recon ' to file-name                                                                                 
014060*        move 'seecheck-opn' to file-text                                                                           
014070*        perform file-error thru file-error-exit                                                                    
014080*        go to seecheck-common-exit                                                                                 
015200*      end-if.                                                                                                      
009210
009210
009364*     move '0120000062'           to chck-monthend-acct-no.                                                         
009364*     move '00'                   to chck-monthend-sub-acct.                                                        
009364*     move '2003033m'             to chck-opening-date-ccyymmdd.                                                    
009364*     move '20030430'             to chck-closing-date-ccyymmdd.                                                    
009210
008400*     move f-prime to file-key.                                                                                     
008500*     move f-read  to file-action.                                                                                  
014030*     call tpsio015 using file-request tps-recon-rec.                                                               
008800*     if not a-successful-operation                                                                                 
008900*        move ' recon' to file-name                                                                                 
009000*        move 'seecheck-rd1' to file-text                                                                           
009100*        perform file-error thru file-error-exit                                                                    
009200*        go to seecheck-common-exit                                                                                 
015200*      end-if.                                                                                                      
015500
009364*     move 0                      to chck-month-end-debit-number.                                                   
009364*     move 0                      to chck-month-end-debit-amount.                                                   
009210
009210
008400*     move f-prime to file-key.                                                                                     
008500*     move f-rewrite  to file-action.                                                                               
014030*     call tpsio015 using file-request tps-recon-rec.                                                               
008800*     if not a-successful-operation                                                                                 
008900*        move ' recon' to file-name                                                                                 
009000*        move 'seecheck-rew' to file-text                                                                           
009100*        perform file-error thru file-error-exit                                                                    
009200*        go to seecheck-common-exit                                                                                 
015200*      end-if.                                                                                                      
009210
014400*     move f-prime to file-key.
014500*     move f-close to file-action.
014030*     call tpsio015 using file-request tps-recon-rec.                                                               
008800*     if not a-successful-operation                                                                                 
008900*        move ' recon' to file-name                                                                                 
009000*        move 'seecheck-clo' to file-text                                                                           
009100*        perform file-error thru file-error-exit                                                                    
009200*        go to seecheck-common-exit                                                                                 
015200*      end-if.                                                                                                      
009210
005900 fix-recon-white-exit. exit.                                                                                        
015500
000000                                                                                                                  
015500
015500
005900 fix-recon-petersmeyer.                                                                                             
009364* 1st let's void the e/d records(flag as void)............                                                          
009364      move '0101000800'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00258'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
079400      move 'V'                  to check-void-or-stop.                                                              
080191      move 'Invalid entry     ' to check-miscellaneous-field.                                                       
080192                                                                                                                  
094400      move 'NYTHSCA   '            to check-change-password.                                                        
094500      move '20030430'              to check-change-date.                                                            
094600      move 'NYTHSCA   '            to check-reconcil-password.                                                      
094700      move '20030515'              to check-reconcile-date.                                                         
094800      move '0'                     to check-missing-status.                                                         
094900                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009364      move '0101000800'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00265'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
079400      move 'V'                  to check-void-or-stop.                                                              
080191      move 'Invalid entry     ' to check-miscellaneous-field.                                                       
080192                                                                                                                  
094400      move 'NYTHSCA   '            to check-change-password.                                                        
094500      move '20030430'              to check-change-date.                                                            
094600      move 'NYTHSCA   '            to check-reconcil-password.                                                      
094700      move '20030430'              to check-reconcile-date.                                                         
094800      move '0'                     to check-missing-status.                                                         
094900                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
009210
009210
009210
009364* 3rd now adjust the 0 records running balance...................                                                   
009364      move '0120000062'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move zeros                       to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
206300                                                                                                                  
206400*   IF VOIDED-TRAN-CODE = 'D' OR 'I' OR 'P' OR 'A'                                                                
206500*      subtract voided-tran-amt from check-current-balance                                                        
206600*     else                                                                                                        
206700*      add voided-tran-amt        to check-current-balance                                                        
      *    end-if.                                                                                                      
206800                                                                                                                  
206700****  add check-amount           to check-current-balance.
206800                                                                                                                  
206800                                                                                                                  
206700      add 692.50                 to check-current-balance.
206800                                                                                                                  
206700      add 692.50                 to check-current-balance.
206800                                                                                                                  
206800                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
009210
009210
009364* 4th now adjust the recon record(cover sheet info)........                                                         
014030      initialize tps-recon-rec.                                                                                     
014010      move f-prime    to file-key.                                                                                  
013400      move f-open-i-o to file-action.                                                                               
014030      call tpsio015 using file-request tps-recon-rec.                                                               
014040      if file-status not = '00' and '05'                                                                            
014050         move 'recon ' to file-name                                                                                 
014060         move 'seecheck-opn' to file-text                                                                           
014070         perform file-error thru file-error-exit                                                                    
014080         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009364      move '0101000800'           to chck-monthend-acct-no.                                                         
009364      move '00'                   to chck-monthend-sub-acct.                                                        
009364      move '20030401'             to chck-opening-date-ccyymmdd.                                                    
009364      move '20030430'             to chck-closing-date-ccyymmdd.                                                    
009210
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
014030      call tpsio015 using file-request tps-recon-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' recon' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
009364      move 10                     to chck-month-end-check-number.                                                   
009364      move 9111.42                to chck-month-end-check-amount.
009210
009364      move 1                      to chck-month-end-debit-number.                                                   
009364      move 94.81                  to chck-month-end-debit-amount.                                                   
009210
009210
000000*         10  CHCK-MONTH-END-OPENING-BALANC
004800*         10  CHCK-MONTH-END-CLOSING-BALANC
005000*         10  CHCK-MONTH-END-DEPOSIT-NUMBER
005100*         10  CHCK-MONTH-END-DEPOSIT-AMOUNT
005300*         10  CHCK-MONTH-END-CREDIT-NUMBER
005400*         10  CHCK-MONTH-END-CREDIT-AMOUNT
005600*         10  CHCK-MONTH-END-CHECK-NUMBER
005700*         10  CHCK-MONTH-END-CHECK-AMOUNT
005900*         10  CHCK-MONTH-END-DEBIT-NUMBER
006000*         10  CHCK-MONTH-END-DEBIT-AMOUNT
006307
009210
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
014030      call tpsio015 using file-request tps-recon-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' recon' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
014400      move f-prime to file-key.
014500      move f-close to file-action.
014030      call tpsio015 using file-request tps-recon-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' recon' to file-name                                                                                 
009000         move 'seecheck-clo' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
005900 fix-recon-petersmeyer-exit. exit.                                                                                  
015500
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
005900 fix-recon-appel.                                                                                                   
009364* 1st let's fix the e/d record(flag as reconciled)............                                                      
009364      move '0120000088'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00757'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
000000                                                                                                                    
361000      move 'Y'                  to check-reconcile-status.                                                          
361200      move 'NYTHSCA   '         to check-reconcil-password.                                                         
361300      move '20030515'           to check-reconcile-date.                                                            
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009364* 2nd let's void the debit record(flag as void)............                                                         
009364      move '0120000088'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00784'                     to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
204300      move 'm'                 to check-transaction-code.                                                           
204600      move 'NYTHSCA   '        to CHECK-CHANGE-PASSWORD.                                                            
204700      move '20030515'          to check-change-date.
205000   
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
009364* 3rd now adjust the 0 records running balance...................                                                   
009364      move '0120000088'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move zeros                       to check-transaction-no.
008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rd1' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
009210
009210
206300                                                                                                                  
206400*   IF VOIDED-TRAN-CODE = 'D' OR 'I' OR 'P' OR 'A'                                                                
206500*      subtract voided-tran-amt from check-current-balance                                                        
206600*     else                                                                                                        
206700*      add voided-tran-amt        to check-current-balance                                                        
      *    end-if.                                                                                                      
206800                                                                                                                  
206800                                                                                                                  
206700      add 4000.00                to check-current-balance.
206800                                                                                                                  
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.                                                                               
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
005900 fix-recon-appel-exit. exit.                                                                                        
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                    
005900 fix-recon-calloway.                                                                                                
007300    move low-values to check-key of tps-check-rec.
007320**  move '0103000014'   to check-acct-no.
007320**  move '0101001659'   to check-acct-no.
007320    move '0101002178'   to check-acct-no.
005900 start-fix-calloway.                                                                                                
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsiochk using file-request tps-check-rec.
007700    if no-record-was-found go to read-the-checks-exit.
007800    if not a-successful-operation
007900       move ' check' to file-name
008000       move 'seecheck-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seecheck-common-exit.
008300                                                                                                                    
008300 read-all-calloway-checks.                                                                                          
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsiochk using file-request tps-check-rec.
008700    if end-of-file-was-reached                                                                                      
005900*****  go to fix-recon-record                                                                                       
005900       go to fix-recon-calloway-exit                                                                                
009210     end-if.                                                                                                        
008800    if not a-successful-operation
008900       move ' check' to file-name
009000       move 'seecheck-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seecheck-common-exit.
009210
007320    if check-acct-no not = '0101002178'                                                                             
005900       go to fix-recon-record
005900****   go to fix-recon-calloway-exit
              
009210     end-if.                                                                                                        
009210
009288    if check-transaction-no = zeros                                                                                 
011200*      if check-reconcil-prev-open not = '20030301'                                                                 
008300*         go to read-all-calloway-checks                                                                            
009210*       end-if                                                                                                      
011200       move '20110625'     to check-reconcil-prev-open                                                              
011200       move '20110725'     to check-reconcil-prev-close                                                             
012510       move 18000.99       to check-reconcil-prev-close-bal                                                                      
                     
011200*      move '00000000'     to check-reconcil-prev-open                                                              
011200*                             check-reconcil-prev-close                                                             
012510*      move zeros          to check-reconcil-prev-close-bal                                                         
008400       move f-prime to file-key                                                                                     
008500       move f-rewrite  to file-action                                                                               
008600       call tpsiochk using file-request tps-check-rec                                                               
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if                                                                                                      
008300       go to read-all-calloway-checks                                                                               
015200     end-if.                                                                                                        
009210
009210
006600    if not check-reconcile-yes                                                                                      
008300       go to read-all-calloway-checks                                                                               
009210     end-if.                                                                                                        
009210
361300    if check-reconcile-date = '20110926'                                                                            
009210       go to unreconcile-this-record                                                                                
009210     end-if.                                                                                                        
009210
          go to read-all-calloway-checks.
009210
009210
009210
009210 unreconcile-this-record.                                                                                           
004800    move tps-check-rec              to sav-check-rec.                                                               
361000    move spaces                     to check-reconcile-status                                                       
361200                                       check-reconcil-password.                                                     
361300    move zeros                      to check-reconcile-date.                                                        
008400    move f-prime to file-key.                                                                                       
008500    move f-rewrite  to file-action.                                                                                 
008600    call tpsiochk using file-request tps-check-rec.                                                                 
008800    if not a-successful-operation                                                                                   
008900       move ' check' to file-name                                                                                   
009000       move 'seecheck-rew' to file-text                                                                             
009100       perform file-error thru file-error-exit                                                                      
009200       go to seecheck-common-exit                                                                                   
015200     end-if.                                                                                                        
009210
005550    add 1                 to checks-issued-count.                                                                   
009210
004800    move sav-check-rec              to tps-check-rec.                                                               
005900    go to start-fix-calloway.                                                                                       
009210
005900 fix-recon-record.                                                                                                  
013300    move f-prime    to file-key.
014020    move f-open-i-o   to file-action.                                                                               
007600    call tpsio015 using file-request tps-recon-rec.
013600    if file-status not = '00' and '05'
013700       move 'recon ' to file-name
013800       move 'seecheck-opn' to file-text
013900       perform file-error thru file-error-exit
014000       go to seecheck-common-exit.
007300    move low-values to chck-monthend-key.
009253    move '0101002178'           to chck-monthend-acct-no.                                                         
009254    move '00'                   to chck-monthend-sub-acct.                                                        
009255    move '20110726'             to chck-opening-date-ccyymmdd.                                                    
009256    move '20110825'             to chck-closing-date-ccyymmdd.                                                    
007400    move f-prime to file-key.
007500    move f-read  to file-action.
007600    call tpsio015 using file-request tps-recon-rec.
007800    if not a-successful-operation
007900       move ' recon' to file-name
008000       move 'seerecon-sbr' to file-text
008100       perform file-error thru file-error-exit
014000       go to seecheck-common-exit.
008210
008400    move f-prime to file-key.
008500    move f-delet to file-action.                                                                                    
008600    call tpsio015 using file-request tps-recon-rec.
008800    if not a-successful-operation
008900       move ' recon' to file-name
009000       move 'seerecon-brn' to file-text
009100       perform file-error thru file-error-exit
014000       go to seecheck-common-exit.
013300    move f-prime    to file-key.
014020    move f-open-i-o   to file-action.                                                                               
007600    call tpsio015 using file-request tps-recon-rec.
013600    if file-status not = '00' and '05'
013700       move 'recon ' to file-name
013800       move 'seecheck-opn' to file-text
013900       perform file-error thru file-error-exit
014000       go to seecheck-common-exit.
009210
005900 fix-recon-calloway-exit. exit.

       DELETE-REC.
000000                                                                                                                  
008400    move f-prime to file-key.
008500    move f-delet to file-action.
008600    call tpsiochk using file-request tps-check-rec.
008800    if not a-successful-operation
008900       move ' check' to file-name
009000       move 'seecheck-del' to file-text
009100       perform file-error thru file-error-exit
009200       go to seecheck-common-exit
015200     end-if.
000000                                                                                                                  
000000 END-DELETE-REC. EXIT.

005900 delete-zero-gackstatter.                                                                                           
009364    move '0101000867'                to check-acct-no.                                                              
009364    move '01'                        to check-sub-acct.                                                             
010200    move '00000'                     to check-transaction-no.                                                       
008400    move f-prime to file-key.                                                                                       
008500    move f-read  to file-action.                                                                                    
008600    call tpsiochk using file-request tps-check-rec.                                                                 
008800    if not a-successful-operation                                                                                   
008900       move ' check' to file-name                                                                                   
009000       move 'seecheck-rd1' to file-text                                                                             
009100       perform file-error thru file-error-exit                                                                      
009200       go to seecheck-common-exit                                                                                   
015200     end-if.                                                                                                        
008400                                                                                                                    
008400    move f-prime to file-key.                                                                                       
008500    move f-delet to file-action.
008600    call tpsiochk using file-request tps-check-rec.                                                                 
008800    if not a-successful-operation                                                                                   
008900       move ' check' to file-name                                                                                   
009000       move 'seecheck-del' to file-text                                                                             
009100       perform file-error thru file-error-exit                                                                      
009200       go to seecheck-common-exit                                                                                   
015200     end-if.                                                                                                        
015500
005900 delete-zero-gackstatter-exit. exit.                                                                                
015500
006800
361400  
005900 fix-recon-siciliano.                                                                                               
007300    move low-values to check-key of tps-check-rec.
007320**  move '0101000420'   to check-acct-no.
007320**  move '0101000321'   to check-acct-no.
007320    move '0106000474'   to check-acct-no.
005900 start-fix-siciliano.                                                                                               
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsiochk using file-request tps-check-rec.
007700    if no-record-was-found go to read-the-checks-exit.
007800    if not a-successful-operation
007900       move ' check' to file-name
008000       move 'seecheck-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seecheck-common-exit.
008300                                                                                                                    
008300 read-all-siciliano-checks.                                                                                         
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsiochk using file-request tps-check-rec.
008700    if end-of-file-was-reached                                                                                      
005900       go to fix-recon-siciliano-exit                                                                               
009210     end-if.                                                                                                        
008800    if not a-successful-operation
008900       move ' check' to file-name
009000       move 'seecheck-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seecheck-common-exit.
009210
007320**  if check-acct-no not = '0101000420'                                                                             
007320**  if check-acct-no not = '0101000321'                                                                             
007320    if check-acct-no not = '0106000474'                                                                             
005900       go to fix-recon-siciliano-exit                                                                               
009210     end-if.                                                                                                        
009210
009288    if check-transaction-no = zeros                                                                                 
011200       if check-reconcil-prev-open not = '20101201'
008300          go to read-all-siciliano-checks                                                                           
009210        end-if                                                                                                      
011200       move '00000000'     to check-reconcil-prev-open                                                              
011200       move '00000000'     to check-reconcil-prev-close                                                             
012510       move .01            to check-reconcil-prev-close-bal
008400       move f-prime to file-key                                                                                     
008500       move f-rewrite  to file-action                                                                               
008600       call tpsiochk using file-request tps-check-rec                                                               
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if                                                                                                      
008300       go to read-all-siciliano-checks                                                                              
015200     end-if.                                                                                                        
009210
009210
006600    if not check-reconcile-yes                                                                                      
008300       go to read-all-siciliano-checks                                                                              
009210     end-if.                                                                                                        
009210
361300    if check-reconcile-date = '20110628'                                                                            
009210       go to unreconcile-siciliano-record                                                                           
009210     end-if.                                                                                                        
009210
361300*   if check-reconcile-date = '20030423'                                                                            
009210*      go to unreconcile-siciliano-record                                                                           
009210*    end-if.                                                                                                        
009210
008300    go to read-all-siciliano-checks.                                                                                
009210
009210
009210
009210 unreconcile-siciliano-record.                                                                                      
004800    move tps-check-rec              to sav-check-rec.                                                               
361000    move spaces                     to check-reconcile-status                                                       
361200                                       check-reconcil-password.                                                     
361300    move zeros                      to check-reconcile-date.                                                        
008400    move f-prime to file-key.                                                                                       
008500    move f-rewrite  to file-action.                                                                                 
008600    call tpsiochk using file-request tps-check-rec.                                                                 
008800    if not a-successful-operation                                                                                   
008900       move ' check' to file-name                                                                                   
009000       move 'seecheck-rew' to file-text                                                                             
009100       perform file-error thru file-error-exit                                                                      
009200       go to seecheck-common-exit                                                                                   
015200     end-if.                                                                                                        
009210
005550    add 1                 to checks-issued-count.                                                                   
009210
004800    move sav-check-rec              to tps-check-rec.                                                               
005900    go to start-fix-siciliano.                                                                                      
009210
005900 fix-recon-siciliano-exit. exit.                                                                                    
000000                                                                                                                  
000000                                                                                                                  
005900 fix-swiss-account.                                                                                                 
009364**    move '0105000103'                to check-acct-no.                                                            
            move '0101001972'                to check-acct-no                                                                          
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00354'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rdx' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
000000                                                                                                                    
361000*     move 0.00                 to check-opening-balance.                                                           
361000*     move 40000.00             to check-current-balance.                                                           
361400                                                                                                                    
361000*     move '20090326'           to check-date.                                                                      
361400                                                                                                                    
361400      move 'D'                  to check-transaction-code.                                                                       
                     
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015200                                                                                                                    
            move '0101001972'                to check-acct-no                                                                          
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00000'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rdx' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
000000                                                                                                                    
361000      add 40000.00             to check-current-balance.                                                                         
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
005900 fix-swiss-account-exit. exit.                                                                                      
000000                                                                                                                  
000000                                                                                                                  
000000*                          goldman new account 06/02/06                                                             
005900 fix-the-new-zero-record.                                                                                           
009364      move '0106000490'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00000'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rdx' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
000000                                                                                                                    
094900*     move 500                  to check-number.                                                                    
361000*     move 0.01                 to check-opening-balance                                                            
361000**    move 3217.78              to check-current-balance.                                                           
361400**    move 11405                to check-next-tran.                                                                 
361000**    move 24725.80             to check-current-balance.                                                           
361000**    add  17761.25             to check-current-balance.                                                           
                                           
                                           
000000  
011200      move '20110807'     to check-reconcil-prev-open.                                                                           
                     
011900      move '20110831'     to check-reconcil-prev-close.                                                                          
                     
012510      move 22241.13       to check-reconcil-prev-close-bal.                                                                      
                     
                                           
                                           
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
361400                                                                                                                    
009364****************************************************************                                                    
361400                                                                                                                    
015200                                                                                                                    
005900 fix-the-new-zero-record-exit. exit.                                                                                
000000                                                                                                                  
011700                                                                                                                    
012900                                                                                                                    
012900 test-the-tape.                                                                                                     
000000      perform table-tape-info thru                                                                                  
000000              table-tape-info-exit.                                                                                 
000000      perform print-tape-info thru                                                                                  
000000              print-tape-info-exit.                                                                                 
012900 test-the-tape-exit. exit.                                                                                          
012900                                                                                                                    
012900                                                                                                                    
012900                                                                                                                    
012900                                                                                                                    
012900                                                                                                                    
055300*****************************************************************                                                   
055400
056800*   if mail-admin-xxxxxx = 'TPS1010S  '                                                                             
000000*      perform table-tape-info thru                                                                                 
000000*              table-tape-info-exit                                                                                 
000000*    end-if.                                                                                                        
056500                                                                                                                    
055300*****************************************************************                                                   
056500                                                                                                                    
000000 table-tape-info.                                                                                                   
056500    if not tape-is-active                                                                                           
056500       move '1'              to tape-is-active-flag                                                                 
145700       perform varying tape-idx from 1 by 1                                                                         
145700                 until tape-idx > 1000                                                                              
145700         if tape-idx < 101                                                                                          
026500            move 'Kenneth W Akeson'                                                                                 
026500                             to tbl-tape-client-name(tape-idx)                                                      
043900            add 25.32        to tape-dummy-dollars                                                                  
043900            move tape-dummy-dollars                                                                                 
026500                             to tbl-tape-check-amount(tape-idx)                                                     
026500           else                                                                                                     
026500            move high-values to tbl-tape-client-name(tape-idx)                                                      
026500            move zeros       to tbl-tape-check-amount(tape-idx)                                                     
000000          end-if                                                                                                    
145700        end-perform                                                                                                 
145700      move 0                 to tape-idx                                                                            
000000     end-if.                                                                                                        
145700*   set tape-idx up by 1.                                                                                           
000000*   move mail-addresee-name  to tbl-tape-client-name(tape-idx)                                                      
145700*   move mail-amount-to-pay  to tbl-tape-check-amount(tape-idx)                                                     
145700                                                                                                                    
000000 table-tape-info-exit. exit.                                                                                        
145700                                                                                                                    
056500                                                                                                                    
055300****** @ close the files ****************************************                                                   
056500                                                                                                                    
056500*   if tape-is-active                                                                                               
000000*      perform print-tape-info thru                                                                                 
000000*              print-tape-info-exit                                                                                 
000000*    end-if.                                                                                                        
056500                                                                                                                    
055300*****************************************************************                                                   
056500                                                                                                                    
145700                                                                                                                    
000000 print-tape-info.                                                                                                   
000100    accept tape-today from date.                                                                                    
000100    move '20'                   to tape-hdr-date(7:2).                                                              
000100    move tape-today(1:2)        to tape-hdr-date(9:2).                                                              
000100    move tape-today(3:2)        to tape-hdr-date(1:2).                                                              
000100    move tape-today(5:2)        to tape-hdr-date(4:2).                                                              
145700                                                                                                                    
145700    open output tape-file.                                                                                          
145700    perform varying tape-idx from 1 by 1                                                                            
026500            until tbl-tape-client-name(tape-idx)                                                                    
                                      = high-values                                                                       
043900      if tape-line-cnt > 45                                                                                         
145700         perform change-page-tape thru                                                                              
145700                 change-page-tape-exit                                                                              
000000       end-if                                                                                                       
            move spaces                to tape-prt-line                                                                   
043900      add 1                      to tape-line-num                                                                   
            move tape-line-num         to tape-prt-line-num                                                               
            move '.'                   to tape-prt-period                                                                 
026500      move tbl-tape-check-amount(tape-idx)                                                                          
                                       to tape-prt-check-amount                                                           
026500      move tbl-tape-client-name(tape-idx)                                                                           
                                       to tape-prt-client-name                                                            
            write tape-record from tape-prt-line                                                                          
043900      add 1                      to tape-check-items                                                                
026500      add tbl-tape-check-amount(tape-idx)                                                                           
043900                                 to tape-check-dollars                                                              
043900      add 1                      to tape-line-cnt                                                                   
145700     end-perform.                                                                                                   
269700                                                                                                                    
269700    write tape-record from pcl5-font-pc8                                                                            
269800                    after advancing 0 lines.                                                                        
269900    write tape-record from pcl5-prm-space-fixed                                                                     
270000                    after advancing 0 lines.                                                                        
270100    move 12            to pcl5-points-value.                                                                        
270200    write tape-record from pcl5-primary-height                                                                      
270300                    after advancing 0 lines.                                                                        
270400    write tape-record from pcl5-style-upright                                                                       
270500                    after advancing 0 lines.                                                                        
270600    write tape-record from pcl5-wt-bold                                                                             
270700                    after advancing 0 lines.                                                                        
          move spaces                  to tape-prt-line.                                                                  
          write tape-record from tape-prt-line.                                                                           
043900                                                                                     00044800
043900    move tape-check-items    to tape-prt-check-detail.                                                              
043900    move tape-check-dollars  to tape-prt-check-total.                                                               
145700                                                                                                                    
          write tape-record from tape-tot-line1.                                                                          
          write tape-record from tape-tot-line2.                                                                          
043900                                                                                     00044800
145700    close tape-file.                                                                                                
145700                                                                                                                    
000000 print-tape-info-exit. exit.                                                                                        
145700                                                                                                                    
145700                                                                                                                    
145700                                                                                                                    
145700                                                                                                                    
145700 change-page-tape.                                                                                                  
043900    move 0                       to tape-line-cnt.                                                                  
043900    add 1                        to tape-page-cnt.                                                                  
          move tape-page-cnt           to tape-hdr-page-num.                                                              
          write tape-record from pcl5-form-feed.                                                                          
000000*   write tape-record from pcl5-reset                                                                               
269400*                   after advancing 0 lines.                                                                        
269500*   write tape-record from pcl5-duplex-on                                                                           
269600*                   after advancing 0 lines.                                                                        
269700    write tape-record from pcl5-font-pc8                                                                            
269800                    after advancing 0 lines.                                                                        
269900    write tape-record from pcl5-prm-space-propo                                                                     
270000                    after advancing 0 lines.                                                                        
270100    move 12            to pcl5-points-value.                                                                        
270200    write tape-record from pcl5-primary-height                                                                      
270300                    after advancing 0 lines.                                                                        
270400    write tape-record from pcl5-style-upright                                                                       
270500                    after advancing 0 lines.                                                                        
270600    write tape-record from pcl5-wt-bold                                                                             
270700                    after advancing 0 lines.                                                                        
          write tape-record from tape-hdr-line0.                                                                          
          move spaces                  to tape-prt-line.                                                                  
          write tape-record from tape-prt-line.                                                                           
          write tape-record from tape-hdr-line1.                                                                          
          write tape-record from tape-hdr-line1a.                                                                         
          write tape-record from tape-hdr-line2.                                                                          
          write tape-record from tape-hdr-line3.                                                                          
          write tape-record from tape-hdr-line4.                                                                          
          move spaces                  to tape-prt-line.                                                                  
          write tape-record from tape-prt-line.                                                                           
          write tape-record from tape-prt-line.                                                                           
269700                                                                                                                    
269700    write tape-record from pcl5-font-pc8                                                                            
269800                    after advancing 0 lines.                                                                        
269900    write tape-record from pcl5-prm-space-fixed                                                                     
270000                    after advancing 0 lines.                                                                        
270100    move 12            to pcl5-points-value.                                                                        
270200    write tape-record from pcl5-primary-height                                                                      
270300                    after advancing 0 lines.                                                                        
270400    write tape-record from pcl5-style-upright                                                                       
270500                    after advancing 0 lines.                                                                        
270600    write tape-record from pcl5-wt-medium                                                                           
270700                    after advancing 0 lines.                                                                        
145700                                                                                                                    
145700 change-page-tape-exit. exit.                                                                                       
145700                                                                                                                    
145700                                                                                                                    
                                                                                                                        
000100                                                                                                                    
005900 search-and-delete.                                                                                                 
007300    move low-values to check-key of tps-check-rec.
007360    move '0101001261'   to check-acct-no.
007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' CHECK' TO FILE-NAME
008000       MOVE 'SEECHECK-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
008200       GO TO SEECHECK-COMMON-EXIT.
008300 search-all-records.                                                                                                
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008700    IF END-OF-FILE-WAS-REACHED GO TO search-and-delete-exit.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
009264       if check-acct-no not = '0101001261'
008300          go to search-all-records                                                                                  
008300****      go to search-and-delete-exit
009290        end-if.                                                                                                     
009210
009288       if check-number > zero                                                                                       
008300          go to search-all-records                                                                                  
009290        end-if.                                                                                                     
009269
009288       if check-transaction-no = zeros                                                                              
008300          go to search-all-records                                                                                  
009290        end-if.                                                                                                     
000000                                                                                                                    
202600                                                                                                                    
202700       if check-transaction-code  < 'a'
008300          go to search-all-records                                                                                  
009290        end-if.                                                                                                     
203400                                              
202600
202700       if check-transaction-code  > 'z'
008300          go to search-all-records
009290        end-if.
000000                                                                                                                    
205100*08/23/07                                                                                                           
206500    if debit-with-fgn-info                                                                                          
206500       initialize tps-fgnck-rec                                                                                     
028600       move check-acct-no         to fgn-check-acct-no                                                              
028800       move '00'                  to fgn-check-sub-acct                                                             
003600       move '99'                  to fgn-check-checking-ac-no                                                       
003800       move check-date            to fgn-check-receive-date                                                         
004200       move '11111'               to fgn-check-receive-number                                                       
004210       move check-date            to fgn-check-date                                                                 
004300       move '99997'               to fgn-check-number                                                               
004400       move check-amount          to fgn-check-amount                                                               
004800       move ' '                   to fgn-check-transaction-code                                                     
005700       move 0                     to fgn-check-tie-breaker                                                          
114100       move f-prime      to file-key                                                                                
114200       move f-open-i-o   to file-action                                                                             
114300       call tpsio026 using file-request tps-fgnck-rec                                                               
116600       if not a-successful-operation                                                                                
114500          move ' fgnck  ' to file-name                                                                              
114600          move 'tps3010-open' to file-text                                                                          
114700          perform file-error thru file-error-exit                                                                   
008200          go to seecheck-common-exit                                                                                
117000        end-if                                                                                                      
009269       perform read-outside-if thru                                                                                 
009269               read-outside-if-exit                                                                                 
116300       move f-prime to file-key                                                                                     
116400       move f-delet  to file-action                                                                                 
114300       call tpsio026 using file-request tps-fgnck-rec                                                               
116600       if not a-successful-operation                                                                                
116700          move ' fgnck  ' to file-name                                                                              
116800          move 'tps3010-del' to file-text                                                                           
116900          perform file-error thru file-error-exit                                                                   
008200          go to seecheck-common-exit                                                                                
117000        end-if                                                                                                      
116300       move f-prime to file-key                                                                                     
116400       move f-close to file-action                                                                                  
114300       call tpsio026 using file-request tps-fgnck-rec                                                               
116600       if not a-successful-operation                                                                                
116700          move ' fgnck  ' to file-name                                                                              
116800          move 'tps3010-clo' to file-text                                                                           
116900          perform file-error thru file-error-exit                                                                   
008200          go to seecheck-common-exit                                                                                
117000        end-if                                                                                                      
206500     end-if.                                                                                                        
205100                                                                                                                    
008300    go to search-all-records.                                                                                       
206100            
009269 read-outside-if.
116300       move f-prime to file-key.                                                                                    
116400       move f-read  to file-action.                                                                                 
114300       call tpsio026 using file-request tps-fgnck-rec.                                                              
116600       if not a-successful-operation                                                                                
005700          add 1            to fgn-check-tie-breaker                                                                 
005700          if fgn-check-tie-breaker < 6                                                                              
009269             go to read-outside-if                                                                                  
117000           end-if                                                                                                   
116300          move f-prime to file-key                                                                                  
116400          move f-close to file-action                                                                               
114300          call tpsio026 using file-request tps-fgnck-rec                                                            
116600          if not a-successful-operation                                                                             
116700             move ' fgnck  ' to file-name                                                                           
116800             move 'tps3010-clo' to file-text                                                                        
116900             perform file-error thru file-error-exit                                                                
008200             go to seecheck-common-exit                                                                             
117000           end-if                                                                                                   
005900          go to search-all-records
117000        end-if.
009269 read-outside-if-exit. exit.
000100                                                                                                                    
005900 search-and-delete-exit. exit.                                                                                      
000100                                                                                                                    
000100                                                                                                                    
000100                                                                                                                    
005540 make-debit-into-elec-debit.                                                                                        
007300    move low-values to check-key of tps-check-rec.
007360    move '01050000610002596'   to check-key of tps-check-rec.                                                       
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ  TO FILE-ACTION.                                                                                    
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
009288       move 99998           to check-number.
000000       move '20111213'      to CHECK-RECEIVE-DATE.                                                                  
004200       move 00004           to CHECK-RECEIVE-NUMBER.                                                                
004800       move ' '             to CHECK-TRANSACTION-CODE.                                                              
008400       move f-prime to file-key.                                                                                    
008500       move f-rewrite  to file-action.                                                                              
008600       call tpsiochk using file-request tps-check-rec.                                                              
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if.                                                                                                     
009269
      *        build receive record for splits
      *        build receive record for splits
      *        build receive record for splits
009269
009364       MOVE CHECK-ACCT-NO         TO MAIL-ACCT-NO.
009365       MOVE CHECK-SUB-ACCT        TO MAIL-SUB-ACCT.

009366       MOVE '20111213'            TO MAIL-RECEIVE-DATE.
009367       MOVE 00004                 TO MAIL-RECEIVE-NUMBER.
009368
009369       MOVE F-PRIME TO FILE-KEY.                                                                                                 
009370       MOVE F-READ  TO FILE-ACTION.                                                                                              
009371       CALL TPSIOREC USING FILE-REqUEST TPS-MAIL-REC                                                                             
009372       IF NOT A-SUCCESSFUL-OPERATION                                                                                             
009373          MOVE ' RECV ' TO FILE-NAME                                                                                             
009374          MOVE 'SEECHECK-rd ' TO FILE-TEXT                                                                                       
009375          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                                
009376          GO TO SEECHECK-COMMON-EXIT                                                                                             
              end-if.                                                                                                                  
                     
470100       move 02596      to mail-check-transaction-no.                                                                             
                     
000100                                                                                                                    
009368
009369       MOVE F-PRIME TO FILE-KEY.                                                                                                 
008500       move f-rewrite  to file-action.                                                                              
009371       CALL TPSIOREC USING FILE-REqUEST TPS-MAIL-REC                                                                             
009372       IF NOT A-SUCCESSFUL-OPERATION                                                                                             
009373          MOVE ' RECV ' TO FILE-NAME                                                                                             
009374          MOVE 'SEECHECK-rd ' TO FILE-TEXT                                                                                       
009375          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                                
009376          GO TO SEECHECK-COMMON-EXIT                                                                                             
              end-if.                                                                                                                  
                     
005540 make-debit-into-elec-debit-exit. exit.                                                                             
000100                                                                                                                    
000100                                                                                                                    
005900 calc-new-zero-balance.                                                                                             
007300    move low-values to check-key of tps-check-rec.
007311**  move '0101001204'   to check-acct-no.
007311    move '0101000024'   to check-acct-no.
                  
007400    move f-prime to file-key.
007500    move f-start to file-action.
007600    call tpsiochk using file-request tps-check-rec.
007700    if no-record-was-found go to read-the-checks-exit.
007800    if not a-successful-operation
007900       move ' check' to file-name
008000       move 'seecheck-sbr' to file-text
008100       perform file-error thru file-error-exit
008200       go to seecheck-common-exit.
008300 calc-all-check-numbers.                                                                                            
008400    move f-prime to file-key.
008500    move f-read-next to file-action.
008600    call tpsiochk using file-request tps-check-rec.
008700    if end-of-file-was-reached go to read-the-checks-exit.
008800    if not a-successful-operation
008900       move ' check' to file-name
009000       move 'seecheck-brn' to file-text
009100       perform file-error thru file-error-exit
009200       go to seecheck-common-exit.
009210
009250**     if check-acct-no not = '0101001204'
009250       if check-acct-no not = '0101000024'
005900          go to calc-new-zero-balance-exit                                                                          
009269        end-if.                                                                                                     
009269
043900       add 1                  to calc-transactions.                                                                 
009269
043900*      if calc-transactions(5:1) = 0                                                                                
008300*         go to break-check-numbers                                                                                 
009269*       end-if.                                                                                                     
009269
009269
043900*      if calc-transactions = 50 or 100 or 150 or 200 or 250                                                        
043900*                          or 300 or 350 or 400 or 450                                                              
043900*                          or 500 or 550 or 600 or 650                                                              
043900*                          or 700 or 750 or 800 or 850                                                              
043900*                          or 900 or 950 or 1000 or 1050                                                            
008300*         go to break-check-numbers                                                                                 
009269*       end-if.                                                                                                     
009269
008300 break-check-numbers.                                                                                               
009288       IF CHECK-TRANSACTION-NO = ZEROS                                                                              
000000          move CHECK-OPENING-BALANCE  to calc-check-dollars                                                         
                move CHECK-CURRENT-BALANCE  to crnt-check-dollars                                                         
008300          go to calc-all-check-numbers
009269        end-if.                                                                                                     
009228
009288       IF CHECK-number = ZEROS
009228          IF CHECK-TRANSACTION-CODE NOT < 'a' AND NOT > 'z'                                                         
008300             go to calc-all-check-numbers                                                                           
009269           end-if                                                                                                   
009269        end-if.                                                                                                     
009228
009288*      IF CHECK-number = ZEROS
009228*         IF CHECK-TRANSACTION-CODE NOT < 'a' AND NOT > 'z'                                                         
207000*            if check-transaction-code = 'd' or 'i' or 'p' or 'a'                                                   
207100*               SUBTRACT check-amount FROM calc-CHECK-dollars                                                       
008300*               go to calc-all-check-numbers                                                                        
207200*              ELSE                                                                           00210600              
207300*               ADD check-amount    TO Calc-cHECK-dollars                                                           
008300*               go to calc-all-check-numbers                                                                        
009269*             end-if                                                                                                
009269*          end-if                                                                                                   
009269*       end-if.                                                                                                     
009228
009228
009228
009228
009228
009288       IF CHECK-number = ZEROS
207000          IF check-TRANsaction-CODE = 'D' OR 'I' OR 'P' OR 'A'                                   00210400           
207300             ADD check-amount    TO Calc-cHECK-dollars                                                              
008300             go to calc-all-check-numbers                                                                           
207200            ELSE                                                                           00210600                 
207100             SUBTRACT check-amount FROM calc-CHECK-dollars                                                          
008300             go to calc-all-check-numbers                                                                           
009269           end-if                                                                                                   
009269        end-if.                                                                                                     
009228
009313       IF CHECK-void                                                                                                
043900          add 1                 to calc-transactions-void                                                           
043900          add check-amount      to calc-check-dollars-void                                                          
207100          SUBTRACT check-amount FROM calc-CHECK-dollars                                                             
008300          go to calc-all-check-numbers                                                                              
009269        end-if.                                                                                                     
009228
009313       IF CHECK-stop                                                                                                
043900          add 1                 to calc-transactions-stop                                                           
043900          add check-amount      to calc-check-dollars-stop                                                          
008300          go to calc-all-check-numbers                                                                              
009269        end-if.                                                                                                     
009228
207100       SUBTRACT check-amount FROM calc-CHECK-dollars.                                                               
008300       go to calc-all-check-numbers.                                                                                
009228
005900 calc-new-zero-balance-exit. exit.                                                                                  
009228
009269
000100                                                                                                                    
005900 fix-lamphere-ed-records.                                                                                           
007300    move low-values to check-key of tps-check-rec.
007360    move '01010012610002397'   to check-key of tps-check-rec.                                                       
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ  TO FILE-ACTION.                                                                                    
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
000000*      move '20090911'      to CHECK-RECEIVE-DATE.                                                                  
004200*      move 00001           to CHECK-RECEIVE-NUMBER.                                                                
004800***    move 'M'             to CHECK-TRANSACTION-CODE.                                                              
004800*      move ' '             to CHECK-TRANSACTION-CODE.                                                              
009288*      move 90001           to CHECK-number.                                                                        
361000       move 'Y'                  to check-reconcile-status.                                                         
361200       move 'NYTHSCA   '         to check-reconcil-password.
361300       move '20100230'           to check-reconcile-date.                                                           
008400       move f-prime to file-key.
008500       move f-rewrite  to file-action.                                                                              
008600       call tpsiochk using file-request tps-check-rec.                                                              
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if.                                                                                                     
000100                                                                                                                    
007300    move low-values to check-key of tps-check-rec.
007360    move '01010012610002398'   to check-key of tps-check-rec.                                                       
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ  TO FILE-ACTION.                                                                                    
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
000000*      move '20090911'      to CHECK-RECEIVE-DATE.                                                                  
004200*      move 00002           to CHECK-RECEIVE-NUMBER.                                                                
004800***    move 'M'             to CHECK-TRANSACTION-CODE.                                                              
004800*      move ' '             to CHECK-TRANSACTION-CODE.                                                              
009288*      move 90002           to CHECK-number.                                                                        
361000       move 'Y'                  to check-reconcile-status.                                                         
361200       move 'NYTHSCA   '         to check-reconcil-password.
361300       move '20100230'           to check-reconcile-date.                                                           
008400       move f-prime to file-key.                                                                                    
008500       move f-rewrite  to file-action.                                                                              
008600       call tpsiochk using file-request tps-check-rec.                                                              
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if.                                                                                                     
000100                                                                                                                    
000100                                                                                                                    
007300    move low-values to check-key of tps-check-rec.
007360    move '01010012610002399'   to check-key of tps-check-rec.                                                       
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ  TO FILE-ACTION.                                                                                    
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
000000*      move '20090911'      to CHECK-RECEIVE-DATE.                                                                  
004200*      move 00003           to CHECK-RECEIVE-NUMBER.                                                                
004800***    move 'M'             to CHECK-TRANSACTION-CODE.                                                              
004800*      move ' '             to CHECK-TRANSACTION-CODE.                                                              
009288*      move 90003           to CHECK-number.                                                                        
361000       move 'Y'                  to check-reconcile-status.                                                         
361200       move 'NYTHSCA   '         to check-reconcil-password.
361300       move '20100230'           to check-reconcile-date.                                                           
008400       move f-prime to file-key.                                                                                    
008500       move f-rewrite  to file-action.                                                                              
008600       call tpsiochk using file-request tps-check-rec.                                                              
008800       if not a-successful-operation                                                                                
008900          move ' check' to file-name                                                                                
009000          move 'seecheck-rew' to file-text                                                                          
009100          perform file-error thru file-error-exit                                                                   
009200          go to seecheck-common-exit                                                                                
015200        end-if.                                                                                                     
000100                                                                                                                    
005900 fix-lamphere-ed-records-exit. exit.                                                                                
000100                                                                                                                    
000100                                                                                                                    
000100                                                                                                                    
005900 make-it-good-again.                                                                                                
007300    move low-values to check-key of tps-check-rec.
000100                                                                                                                    
009364    move '0101002095'            to check-acct-no.                                                                  
009364    move '00'                    to check-sub-acct.                                                                 
010200    move '00785'                 to check-transaction-no.

008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ  TO FILE-ACTION.                                                                                    
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'SEECHECK-BRN' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
009200       GO TO SEECHECK-COMMON-EXIT.
009210
026500    move check-amount       to save-check-amount.                                                                   
009210
004800      move ' '                  to check-transaction-code.                                                          
079400      move ' '                  to check-void-or-stop.                                                              
080191      move '                  ' to check-miscellaneous-field.                                                       
080192                                                                                                                  
094400      move '          '            to check-change-password.                                                        
094500      move '        '              to check-change-date.                                                            
080192                                                                                                                  
008400    move f-prime to file-key.                                                                                       
008500    move f-rewrite  to file-action.                                                                                 
008600    call tpsiochk using file-request tps-check-rec.                                                                 
008800    if not a-successful-operation                                                                                   
008900       move ' check' to file-name                                                                                   
009000       move 'seecheck-rew' to file-text                                                                             
009100       perform file-error thru file-error-exit                                                                      
009200       go to seecheck-common-exit                                                                                   
015200     end-if.                                                                                                        
000100                                                                                                                    
009364      move '0101002095'                to check-acct-no.                                                            
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00000'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rdx' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
000000                                                                                                                    
026500      add save-check-amount to check-current-balance.                                                               
                                           
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
361400                                                                                                                    
005900 make-it-good-again-exit. exit.                                                                                     
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
005900 fix-citron-account.                                                                                                             
                     
            move '0105000061'                to check-acct-no                                                                          
009364      move '00'                        to check-sub-acct.                                                           
010200      move '00000'                     to check-transaction-no.

008400      move f-prime to file-key.                                                                                     
008500      move f-read  to file-action.                                                                                  
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rdx' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
015500
000000                                                                                                                    
361000*     add 40000.00             to check-current-balance.                                                                         
361000*     subtract 12000.00      from check-current-balance.                                                                         
361000      move 158.45         to check-current-balance                                                                               
129100                             check-reconcil-prev-close-bal.                                                                      
                     
361400                                                                                                                    
008400      move f-prime to file-key.                                                                                     
008500      move f-rewrite  to file-action.
008600      call tpsiochk using file-request tps-check-rec.                                                               
008800      if not a-successful-operation                                                                                 
008900         move ' check' to file-name                                                                                 
009000         move 'seecheck-rew' to file-text                                                                           
009100         perform file-error thru file-error-exit                                                                    
009200         go to seecheck-common-exit                                                                                 
015200       end-if.                                                                                                      
009210
005900 fix-citron-account-exit. exit.
       dump-records-open.
       dump-records.
       dump-records-close.
       dump-records-exit.
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
000000                                                                                                                  
