000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEECALEN.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*    LIST OF CALENDAR DATABASE                                *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200*    SELECT PRT-FILE  ASSIGN TO "LPT1"
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEECALEN.TXT"         00001000
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000     RECORD CONTAINS 200 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002100     02 PRT-stuffa                            pic  x(26).                                                           
002100     02 PRT-stuff                             pic  x(174).                                                          
002100     02 filler redefines PRT-stuff.                                                                                 
002200        05  dtl-oboyle-name                   PIC  X(20).                                                           
002300        05  FILLER                            PIC  X(02).
017414        05  dtl-oboyle-num-days               pic  z,zz9.                                                         
002300        05  FILLER                            PIC  X(02).
017414        05  dtl-oboyle-from-date              pic  x(08).                                                         
002300        05  FILLER                            PIC  X(02).
017414        05  dtl-oboyle-to-date                pic  x(08).                                                           
002300        05  FILLER                            PIC  X(02).
002640        05  dtl-oboyle-place                  PIC  X(35).
002700        05  FILLER                            PIC  X(133).                                                          
002100     02 filler redefines PRT-stuff.                                                                                 
002200        05  PRT-oboyle-name                   PIC  X(20).                                                           
002300        05  FILLER                            PIC  X(02).
017414        05  prt-oboyle-num-days               pic  z,zz9.                                                         
002300        05  FILLER                            PIC  X(02).
002640        05  PRT-oboyle-place                  PIC  X(35).
002700        05  FILLER                            PIC  X(153).                                                          
002100     02 filler redefines PRT-stuff.                                                                                 
002200        05  PRT-KEY-ACCT-NO                   PIC  X(10).
002300        05  FILLER                            PIC  X(01).
017414        05  prt-ADM-PRINT-MNTH-DATE-CYMD      pic  x(08).                                                         
002300        05  FILLER                            PIC  X(01).
002640        05  PRT-CAL-APPT-APPOINT-DATA         PIC  X(50).
002700        05  FILLER                            PIC  X(01).
002300
017414
017414        05  prt-ADM-PRINT-MNTH-from-CYMD      pic  x(08).                                                         
002300        05  FILLER                            PIC  X(01).
017414        05  prt-ADM-PRINT-MNTH-to-CYMD        pic  x(08).                                                         
002300        05  FILLER                            PIC  X(01).
017414        05  prt-ADM-appnt-wkly-from-CYMD      pic  x(08).                                                         
002300        05  FILLER                            PIC  X(01).
017414        05  prt-ADM-appnt-wkly-to-CYMD        pic  x(08).                                                         
002300        05  FILLER                            PIC  X(01).
002300        05  FILLER                            PIC  X(01).
002300        05  FILLER                            PIC  X(01).
002300        05  FILLER                            PIC  X(01).
002300        05  FILLER                            PIC  X(01).
002300        05  FILLER                            PIC  X(01).
002301        05  PRT-ADM-WKLY-ACTIVITY-DATE        PIC  X(08).
002302        05  FILLER                            PIC  X(01).
002303*       05  PRT-ADM-MNTH-ACTIVITY-DATE        PIC  X(08).
002310        05  FILLER                            PIC  X(01).
002400*       05  PRT-KEY-SUB-ACCT                  PIC  X(02).
002500*       05  FILLER                            PIC  X(01).
002510        05  PRT-RECEIVE-DATE                  PIC  X(08).
002520        05  FILLER                            PIC  X(01).
002600        05  PRT-KEY-DATE                      PIC  X(08).
002610*       05  FILLER                            PIC  X(01).
002620*       05  PRT-CAL-DB-MAINT-FIELD-CODE       PIC  X(04).
002630        05  FILLER                            PIC  X(01).
002701        05  PRT-CAL-APPT-ADD-PASSWORD         PIC  X(10).
002702        05  FILLER                            PIC  X(01).
002703        05  PRT-CAL-APPT-CHANGE-PASSWORD      PIC  X(10).
002704        05  FILLER                            PIC  X(01).
002705*       05  FILLER                            PIC  X(01).
002710*       05  PRT-APPT-PRINT-OPTION             PIC  X(01).
002720*       05  FILLER                            PIC  X(01).
002730*       05  PRT-APPT-ATTEND-OPTION            PIC  X(01).
002740*       05  FILLER                            PIC  X(01).
002800*       05  PRT-KEY-RECORD-NUMBER             PIC  X(04).
002900*       05  FILLER                            PIC  X(01).
003000*       05  PRT-KEY-SUB-RECORD-NUMBER         PIC  X(02).
003100*       05  FILLER                            PIC  X(01).
003200*       05  PRT-RECORD-TYPE                   PIC  X(02).
003300*       05  FILLER                            PIC  X(01).
003310*       05  PRT-APPT-TIME-FROM                PIC  X(06).
003320*       05  FILLER                            PIC  X(01).
003330*       05  PRT-APPT-TIME-TO                  PIC  X(06).
003340*       05  FILLER                            PIC  X(01).
003400*       05  PRT-CAL-APPT-ADD-BY               PIC  X(10).
003500*       05  FILLER                            PIC  X(01).
003600*       05  PRT-CAL-APPT-ADD-DATE             PIC  X(08).
003900*       05  FILLER                            PIC  X(07).
004000*       05  PRT-ADM-PRINT-YRLY-DATE-CYMD      PIC  9(08).
004100*       05  FILLER                            PIC  X(01).
004200*       05  PRT-ADM-PRINT-YRLY-DAYS-BEFORE    PIC  9(02).
004300*       05  FILLER                            PIC  X(01).
004400*       05  PRT-ADM-PRINT-YRLY-FROM-CYMD      PIC  9(08).
004500*       05  FILLER                            PIC  X(01).
004600*       05  PRT-ADM-PRINT-YRLY-TO-CYMD        PIC  9(08).
004900*       05  FILLER                            PIC  X(01).
005000*       05  PRT-ADM-PRINT-MNTH-DAYS-BEFORE    PIC  9(02).
005100*       05  FILLER                            PIC  X(01).
005110*       05  PRT-ADM-PRINT-MNTH-DATE-CYMD      PIC  9(08).
005120*       05  FILLER                            PIC  X(01).
005200*       05  PRT-ADM-PRINT-MNTH-FROM-CYMD      PIC  9(08).
005300*       05  FILLER                            PIC  X(01).
005400*       05  PRT-ADM-PRINT-MNTH-TO-CYMD        PIC  9(08).
005500*       05  FILLER                            PIC  X(01).
005600*       05  PRT-ADM-APPNT-WKLY-FROM-CYMD      PIC  9(08).
005700*       05  FILLER                            PIC  X(01).
005800*       05  PRT-ADM-APPNT-WKLY-TO-CYMD        PIC  9(08).
005900*       05  FILLER                            PIC  X(01).
006000*       05  PRT-ADM-DBASE-SEMI-FROM-CYMD      PIC  9(08).
006100*       05  FILLER                            PIC  X(01).
006200*       05  PRT-ADM-DBASE-SEMI-TO-CYMD        PIC  9(08).
006300*       05  FILLER                            PIC  X(01).
006400*
006500*
006600
006700
006800*       05  FILLER REDEFINES CAL-VARIABLE.
006900*           10  CAL-YR-MONTH-OF-YEAR  OCCURS 36 TIMES.
007000*               15  CAL-YR-MONTH-OF-YEAR-APPT  PIC S9(05) COMP-3.
007100*               15  CAL-YR-MONTH-OF-YEAR-EVENT PIC S9(05) COMP-3.
007200*               15  CAL-YR-MONTH-OF-YEAR-DELET PIC S9(05) COMP-3.
007300*           10  FILLER                        PIC  X(70).
007400
007500
007600
007700
007800*       05  FILLER REDEFINES CAL-VARIABLE.
007900*           10  CAL-MO-DAY-OF-MONTH   OCCURS 31 TIMES.
008000*******     10  FILLER REDEFINES CAL-MO-DAY-OF-MONTH.
008100*               15  CAL-MO-DAY-OF-MONTH-APPT  PIC S9(03) COMP-3.
008200*               15  CAL-MO-DAY-OF-MONTH-EVENT PIC S9(03) COMP-3.
008300*               15  CAL-MO-DAY-OF-MONTH-DELET PIC S9(01) COMP-3.
008400*           10  FILLER                        PIC  X(23).
008500
008600
008700
008800
008900*       05  FILLER REDEFINES CAL-VARIABLE.
009000*           10  CAL-DAY-NEXT-AVAIL-REC-NUM    PIC  9(04).
009100*           10  CAL-DAY-OF-MONTH-APPT         PIC S9(03) COMP-3.
009200*           10  CAL-DAY-OF-MONTH-EVENT        PIC S9(03) COMP-3.
009300*           10  CAL-DAY-OF-MONTH-DELET        PIC S9(01) COMP-3.
009400*           10  FILLER                        PIC  X(164).
009500
009600
009700
009800
009900*       05  FILLER REDEFINES CAL-VARIABLE.
010000*           10  CAL-APPT-START-TIME           PIC  X(04).
010100*           10  CAL-APPT-START-TIME-AM-PM     PIC  X(02).
010200*           10  CAL-APPT-STOP-TIME            PIC  X(04).
010300*           10  CAL-APPT-STOP-TIME-AM-PM      PIC  X(02).
010400*           10  CAL-APPT-APPOINT-DATA         PIC  X(50).
010500
010600
010700
010800
010900*           10  CAL-APPT-RECEIVE-DATE         PIC  X(08).
011000*           10  FILLER REDEFINES CAL-APPT-RECEIVE-DATE.
011100*               15  CAL-DB-MAINT-FIELD-CODE   PIC  X(04).
011200*               15  FILLER                    PIC  X(04).
011300*           10  CAL-APPT-RECEIVE-NUMBER       PIC S9(05) COMP-3.
011400
011500*           10  CAL-APPT-ADD-PASSWORD         PIC  X(10).
011600*           10  CAL-APPT-ADD-DATE             PIC  X(08).
011700*           10  CAL-APPT-CHANGE-PASSWORD      PIC  X(10).
011800*           10  CAL-APPT-CHANGE-DATE          PIC  X(08).
011900*           10  FILLER                        PIC  X(64).
012000
012100
012200
012300
012400
012500 WORKING-STORAGE SECTION.
012600     COPY "TPSFILES.CPY".
012700     COPY "KEYVALUE.CPY".
012800 01  TPS-CALEN-REC.
012900     COPY "TPSCALEN.CPY".
012800 01  TPS-brnch-REC.
012900     COPY "TPSbrnch.CPY".
013000 01  TPSIO003                      PIC X(08) VALUE 'TPSIO003'.
013000 01  TPSIO018                      PIC X(08) VALUE 'TPSIO018'.
013100 01  PROGRAM-NAMES.
013200  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
013210  10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
013300  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
013400 01  TPS-FILE-STATUS                       PIC XX.
013500     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
013510
013511                                                                                     00009900
013512  01  WS-DATE-REQUEST.                                                               00010000
013513      05  WS-DATE-PARAM          PIC  9(02).                                         00010100
013514                                                                                     00010200
013515      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00010300
013516      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00010400
013517          10  WS-DATE-REFORM         PIC  X(06).                                     00010500
013518          10  WS-DATE-EXTEND         PIC  X(04).                                     00010600
013519          10  FILLER                 PIC  X(10).                                     00010700
013520      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00010800
013521          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00010900
013522          10  FILLER                 PIC  X(14).                                     00011000
013523      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00011100
013524          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00011200
013525          10  FILLER                 PIC  X(12).                                     00011300
013526      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00011400
013527          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00011500
013528          10  FILLER                 PIC  X(10).                                     00011600
013529      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00011700
013530          10  WS-TIME-PARM1          PIC  X(06).                                     00011800
013531          10  WS-TIME-PARM2          PIC  X(06).                                     00011900
013532          10  WS-TIME-EXTEND         PIC  X(08).                                     00012000
013533      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00012100
013534          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00012200
013535          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00012300
013536          10  WS-TIME-EXTNDBY8       PIC  9(04).                                     00012400
013537*                                                                                    00012500
013538                                                                                     00012600
013539      05  WS-FIX-DATE-YMD            PIC  9(06).                                     00012700
013540      05  FILLER REDEFINES WS-FIX-DATE-YMD.                                          00012800
013541          10  WS-FIX-DATE-YY-YMD     PIC  9(02).                                     00012900
013542          10  WS-FIX-DATE-MM-YMD     PIC  9(02).                                     00013000
013543          10  WS-FIX-DATE-DD-YMD     PIC  9(02).                                     00013100
013544                                                                                     00013200
013545      05  WS-FIX-DATE-MDY            PIC  9(06).                                     00013300
013546      05  FILLER REDEFINES WS-FIX-DATE-MDY.                                          00013400
013547          10  WS-FIX-DATE-MM-MDY     PIC  9(02).                                     00013500
013548          10  WS-FIX-DATE-DD-MDY     PIC  9(02).                                     00013600
013549          10  WS-FIX-DATE-YY-MDY     PIC  9(02).                                     00013700
013550                                                                                     00013800
013551      05  WS-TIME-OF-DAY        PIC  9(08) VALUE ZERO.                               00013900
013552      05  FILLER REDEFINES WS-TIME-OF-DAY.                                           00014000
013553          10  WS-TIME-HH        PIC  9(02).                                          00014100
013554          10  WS-TIME-MM        PIC  9(02).                                          00014200
013555          10  WS-TIME-SS        PIC  9(04).                                          00014300
013556          10  FILLER REDEFINES WS-TIME-SS.                                           00014400
013557              15  WS-TIME-SS1   PIC  9(02).                                          00014500
013558              15  WS-TIME-SS2   PIC  9(02).                                          00014600
013559                                                                                     00014700
013561 01 line-of-dashes.                                                                                                 
013561    05 filler   pic  x(20) value '--------------------'.                                                            
013561    05 filler   pic  x(20) value '--------------------'.                                                            
013561    05 filler   pic  x(20) value '--------------------'.                                                            
013561    05 filler   pic  x(20) value '--------------------'.                                                            
013561
023200 01 oboyle-name               pic  x(03).                                                                           
023200 01 oboyle-place              pic  x(35).                                                                           
013570
013570
013570 01 calc-from-date            pic  9(08).                                                                           
013570 01 calc-to-date              pic  9(08).                                                                           
013570
013570
023200 01 current-inits             pic  x(03).                                                                           
023200 01 current-count             pic  9(04).                                                                           
013570
013570
023200 01 active-year               pic  9(04) value 2004.                                                                
013570
013570
013570
013570 01 the-idx                   pic s9(04) comp.                                                                      
013570 01 tbl-stuff                 occurs 1000 times.                                                                    
023200    05 tbl-name               pic  x(03).                                                                           
023200    05 tbl-domestic-or-fgn    pic  9(01).                                                                           
023200       88 tbl-domestic             value 0.                                                                         
023200       88 tbl-foreign              value 1.                                                                         
023200    05 tbl-place              pic  x(35).                                                                           
019310    05 tbl-count              pic  9(05).                                                                           
013570
013570
013570 01 date-fix-report.
180700    05 prt-BRNCH-CONTROL-OFFICE     pic  x(02).                                                                     
          05 filler                       pic  x(02).                                      00254400
180800    05 prt-BRNCH-CONTROL-GROUP      pic  x(02).                                                                     
          05 filler                       pic  x(02).                                      00254400
180800    05 prt-date                     pic  x(08).                                                                     
          05 filler                       pic  x(02).                                      00254400
180800    05 type-date                    pic  x(40).                                                                     
          05 filler                       pic  x(40).                                      00254400
                                                                                           00254400
013570
013570
013570
013570
013570
013570
013570
013570
013570
013570
004700 01 STATE-TABLE.                                                                                                    
000000     20  FILLER    PIC  X(02) VALUE 'AK'.
005300     20  FILLER    PIC  X(20) VALUE 'Alaska              '.
005600     20  FILLER    PIC  X(02) VALUE 'AL'.
005300     20  FILLER    PIC  X(20) VALUE 'Alabama             '.
005900     20  FILLER    PIC  X(02) VALUE 'AR'.
005300     20  FILLER    PIC  X(20) VALUE 'Arkansas            '.
006200     20  FILLER    PIC  X(02) VALUE 'AZ'.
005300     20  FILLER    PIC  X(20) VALUE 'Arizona             '.
006500     20  FILLER    PIC  X(02) VALUE 'CA'.
005300     20  FILLER    PIC  X(20) VALUE 'California          '.
006800     20  FILLER    PIC  X(02) VALUE 'CO'.
005300     20  FILLER    PIC  X(20) VALUE 'Colorado            '.
007200     20  FILLER    PIC  X(02) VALUE 'CT'.
005300     20  FILLER    PIC  X(20) VALUE 'Connecticut         '.
007500     20  FILLER    PIC  X(02) VALUE 'DC'.
005300     20  FILLER    PIC  X(20) VALUE 'Distric of Columbia '.
007800     20  FILLER    PIC  X(02) VALUE 'DE'.
005300     20  FILLER    PIC  X(20) VALUE 'Delaware            '.
008100     20  FILLER    PIC  X(02) VALUE 'FL'.
005300     20  FILLER    PIC  X(20) VALUE 'Florida             '.
008400     20  FILLER    PIC  X(02) VALUE 'GA'.
005300     20  FILLER    PIC  X(20) VALUE 'Georgia             '.
008700     20  FILLER    PIC  X(02) VALUE 'HI'.
005300     20  FILLER    PIC  X(20) VALUE 'Hawaii              '.
009000     20  FILLER    PIC  X(02) VALUE 'IA'.
005300     20  FILLER    PIC  X(20) VALUE 'Iowa                '.
009400     20  FILLER    PIC  X(02) VALUE 'ID'.
005300     20  FILLER    PIC  X(20) VALUE 'Idaho               '.
009700     20  FILLER    PIC  X(02) VALUE 'IL'.
005300     20  FILLER    PIC  X(20) VALUE 'Illinois            '.
010000     20  FILLER    PIC  X(02) VALUE 'IN'.
005300     20  FILLER    PIC  X(20) VALUE 'Indiana             '.
010300     20  FILLER    PIC  X(02) VALUE 'KS'.
005300     20  FILLER    PIC  X(20) VALUE 'Kansas              '.
010600     20  FILLER    PIC  X(02) VALUE 'KY'.
005300     20  FILLER    PIC  X(20) VALUE 'Kentucky            '.
010900     20  FILLER    PIC  X(02) VALUE 'LA'.
005300     20  FILLER    PIC  X(20) VALUE 'Louisiana           '.
011200     20  FILLER    PIC  X(02) VALUE 'MA'.
005300     20  FILLER    PIC  X(20) VALUE 'Massachusetts       '.
011600     20  FILLER    PIC  X(02) VALUE 'MD'.
005300     20  FILLER    PIC  X(20) VALUE 'Maryland            '.
012000     20  FILLER    PIC  X(02) VALUE 'ME'.
005300     20  FILLER    PIC  X(20) VALUE 'Maine               '.
012400     20  FILLER    PIC  X(02) VALUE 'MI'.
005300     20  FILLER    PIC  X(20) VALUE 'Michigan            '.
012700     20  FILLER    PIC  X(02) VALUE 'MN'.
005300     20  FILLER    PIC  X(20) VALUE 'Minnesota           '.
013000     20  FILLER    PIC  X(02) VALUE 'MO'.
005300     20  FILLER    PIC  X(20) VALUE 'Missouri            '.
013400     20  FILLER    PIC  X(02) VALUE 'MS'.
005300     20  FILLER    PIC  X(20) VALUE 'Mississippi         '.
013700     20  FILLER    PIC  X(02) VALUE 'MT'.
005300     20  FILLER    PIC  X(20) VALUE 'Montana             '.
014100     20  FILLER    PIC  X(02) VALUE 'NC'.
005300     20  FILLER    PIC  X(20) VALUE 'North Carolina      '.
014500     20  FILLER    PIC  X(02) VALUE 'ND'.
005300     20  FILLER    PIC  X(20) VALUE 'North Dakota        '.
014900     20  FILLER    PIC  X(02) VALUE 'NE'.
005300     20  FILLER    PIC  X(20) VALUE 'Nebraska            '.
015200     20  FILLER    PIC  X(02) VALUE 'NH'.
005300     20  FILLER    PIC  X(20) VALUE 'New Hampshire       '.
015500     20  FILLER    PIC  X(02) VALUE 'NJ'.
005300     20  FILLER    PIC  X(20) VALUE 'New Jersey          '.
015900     20  FILLER    PIC  X(02) VALUE 'NM'.
005300     20  FILLER    PIC  X(20) VALUE 'New Mexico          '.
016200     20  FILLER    PIC  X(02) VALUE 'NV'.
005300     20  FILLER    PIC  X(20) VALUE 'Nevada              '.
016600     20  FILLER    PIC  X(02) VALUE 'NY'.
005300     20  FILLER    PIC  X(20) VALUE 'New York            '.
017000     20  FILLER    PIC  X(02) VALUE 'OH'.
005300     20  FILLER    PIC  X(20) VALUE 'Ohio                '.
017300     20  FILLER    PIC  X(02) VALUE 'OK'.
005300     20  FILLER    PIC  X(20) VALUE 'Oklahoma            '.
017600     20  FILLER    PIC  X(02) VALUE 'OR'.
005300     20  FILLER    PIC  X(20) VALUE 'Oregon              '.
017900     20  FILLER    PIC  X(02) VALUE 'PA'.
005300     20  FILLER    PIC  X(20) VALUE 'Pennsylvania        '.
018300     20  FILLER    PIC  X(02) VALUE 'RI'.
005300     20  FILLER    PIC  X(20) VALUE 'Rhode Island        '.
018600     20  FILLER    PIC  X(02) VALUE 'SC'.
005300     20  FILLER    PIC  X(20) VALUE 'South Carolina      '.
019000     20  FILLER    PIC  X(02) VALUE 'SD'.
005300     20  FILLER    PIC  X(20) VALUE 'South Dakota        '.
019400     20  FILLER    PIC  X(02) VALUE 'TN'.
005300     20  FILLER    PIC  X(20) VALUE 'Tennessee           '.
019800     20  FILLER    PIC  X(02) VALUE 'TX'.
005300     20  FILLER    PIC  X(20) VALUE 'Texas               '.
020200     20  FILLER    PIC  X(02) VALUE 'UT'.
005300     20  FILLER    PIC  X(20) VALUE 'Utah                '.
020600     20  FILLER    PIC  X(02) VALUE 'VA'.
005300     20  FILLER    PIC  X(20) VALUE 'Virgina             '.
021000     20  FILLER    PIC  X(02) VALUE 'VT'.
005300     20  FILLER    PIC  X(20) VALUE 'Vermont             '.
021400     20  FILLER    PIC  X(02) VALUE 'WA'.
005300     20  FILLER    PIC  X(20) VALUE 'Washington          '.
021700     20  FILLER    PIC  X(02) VALUE 'WI'.
005300     20  FILLER    PIC  X(20) VALUE 'Wisconsin           '.
022000     20  FILLER    PIC  X(02) VALUE 'WV'.
005300     20  FILLER    PIC  X(20) VALUE 'West Virgina        '.
022400     20  FILLER    PIC  X(02) VALUE 'WY'.
005300     20  FILLER    PIC  X(20) VALUE 'Wyoming             '.
022500     20  FILLER    PIC  X(02) VALUE high-values.
005300     20  FILLER    PIC  X(20) VALUE high-values.  
022500                                                                                                                    
022600                                                                                                                    
022700 01 STATE-REDEF REDEFINES STATE-TABLE.                                                                              
022800      05  STATE-REDEF OCCURS 52 TIMES                                                                               
022900                                INDEXED BY STATE-IDX.                                                               
023200       10  STATE-ABBREV          PIC  X(02).                                                                        
023200       10  STATE-NAME            PIC  X(20).                                                                        
023300                           
013570
013570
000000 01  form-feed.                                                                                                     
090700     05 FILLER                 PIC  X(01) VALUE X'0C'.                                                              
017000
013570
013560                                                                                     00014800
013561
013561*01 what-r-we-doing           pic  9(01) value 0.                                                                   
013561*01 what-r-we-doing           pic  9(01) value 1.                                                                   
013561*01 what-r-we-doing           pic  9(01) value 2.                                                                   
013561 01 what-r-we-doing           pic  9(01) value 3.                                                                   
013561    88 oboyle-special-run                value 1.
013561    88 display-control-dates             value 2.
013561    88 correct-control-dates             value 3.
013561
013570
013570
013570
013570
013600 LINKAGE SECTION.
013700 01 TPS-PARAMETER.
013800    05 TPS-PARAMETER-VALUE PIC XX.
013900
014000 PROCEDURE DIVISION USING
014100                          TPS-PARAMETER.
014200 SEECALEN-BEGIN.
014300    PERFORM OPEN-THE-FILES
014400       THRU OPEN-THE-FILES-EXIT.
013900
013561    if correct-control-dates                                                                                        
000000       perform fix-the-dates thru                                                                                   
000000               fix-the-dates-exit                                                                                   
014700       go to seecalen-common-exit                                                                                   
013900     end-if.                                                                                                        
013900
013561    if display-control-dates                                                                                        
000000       perform show-the-dates thru                                                                                  
000000               show-the-dates-exit                                                                                  
014700       go to seecalen-common-exit                                                                                   
013900     end-if.                                                                                                        
013900
013561    if oboyle-special-run                                                                                           
013900       perform add-oboyle-places thru
013900               add-oboyle-places-exit
014700*****  go to seecalen-common-exit                                                                                   
013900     end-if.                                                                                                        
013900
014500    PERFORM READ-THE-CALEN
014600       THRU READ-THE-CALEN-EXIT.
013900
014700 SEECALEN-COMMON-EXIT.
014800    PERFORM CLOSE-THE-FILES
014900       THRU CLOSE-THE-FILES-EXIT.
015000    goback.                                                                                                       
015000    STOP RUN.
015100
015200 READ-THE-CALEN.
015300    MOVE LOW-VALUES TO CAL-KEY OF TPS-CALEN-REC.
015400    MOVE F-PRIME TO FILE-KEY.
015500    MOVE F-START TO FILE-ACTION.
015600    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
015700    IF NO-RECORD-WAS-FOUND GO TO READ-THE-CALEN-EXIT.
015800    IF NOT A-SUCCESSFUL-OPERATION
015900       MOVE ' CALEN' TO FILE-NAME
016000       MOVE 'SEECALEN-SBR' TO FILE-TEXT
016100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
016200       GO TO SEECALEN-COMMON-EXIT.
016300
016400 READ-ALL-CALEN-RECORDS.
016500    MOVE F-PRIME TO FILE-KEY.
016600    MOVE F-READ-NEXT TO FILE-ACTION.
016700    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
016800    IF END-OF-FILE-WAS-REACHED GO TO READ-THE-CALEN-EXIT.
016900    IF NOT A-SUCCESSFUL-OPERATION
017000       MOVE ' CALEN' TO FILE-NAME
017100       MOVE 'SEECALEN-BRN' TO FILE-TEXT
017200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
017300       GO TO SEECALEN-COMMON-EXIT.
017400
017401
017402*   IF CAL-CONTROL-REC AND
017403*      CAL-KEY-ACCT-NO(5:6) = ZEROS
017404*      CONTINUE
017405*     ELSE
017406*      GO TO READ-ALL-CALEN-RECORDS
017407*    END-IF.
017408
017412
017413*   IF CAL-CONTROL-REC and cal-key-acct-no(5:6) = zeros                                                           
017414*     IF CAL-ADM-PRINT-MNTH-DATE-CYMD not = '20010524'                                                            
017414*       move '99999999'           to CAL-ADM-PRINT-MNTH-DATE-CYMD                                                 
017414*                                    CAL-ADM-PRINT-MNTH-from-CYMD                                                 
017414*                                    CAL-ADM-PRINT-MNTH-to-CYMD                                                   
017414*                                    CAL-ADM-appnt-wkly-from-CYMD
017414*                                    CAL-ADM-appnt-wkly-to-CYMD
017414*       move '20010524'           to CAL-ADM-PRINT-MNTH-DATE-CYMD                                                 
017414*       move '20010601'           to CAL-ADM-PRINT-MNTH-from-CYMD                                                 
017414*       move '20010630'           to CAL-ADM-PRINT-MNTH-to-CYMD                                                   
017414*       move '20010603'           to CAL-ADM-appnt-wkly-from-CYMD
017414*       move '20010609'           to CAL-ADM-appnt-wkly-to-CYMD
017438*       PERFORM REWRITE-CALEN-RECORD THRU
017440*               REWRITE-CALEN-RECORD-EXIT
021400*       go to PRINT-THE-RECORD                                                                                    
017405*      ELSE                                                                                                       
021400*       go to PRINT-THE-RECORD                                                                                    
017406****    GO TO READ-ALL-CALEN-RECORDS                                                                              
017460*      END-IF
017470*     END-IF.
017412
017406**** GO TO READ-ALL-CALEN-RECORDS.                                                                                
017412
017412
017412
017413*   IF CAL-CONTROL-REC and cal-key-acct-no(5:6) = zeros                                                           
017414*     IF CAL-ADM-summary-from-CYMD = '20030701'                                                                   
017415*       MOVE '5'                TO cal-adm-summary-which-quarter                                                  
017416*       MOVE '20030101'         to cal-adm-summary-from-cymd
017416*       MOVE '20031231'         to cal-adm-summary-to-cymd                                                        
017438*       PERFORM REWRITE-CALEN-RECORD THRU
017440*               REWRITE-CALEN-RECORD-EXIT
021400*       go to PRINT-THE-RECORD                                                                                    
017405*      ELSE                                                                                                       
017406*       GO TO READ-ALL-CALEN-RECORDS                                                                              
017460*      END-IF
017470*     END-IF.
017500
017409
020960                                                                                     00024080
021050                                                                  
017410
017411
017412
017413*   IF CAL-CONTROL-REC
017414*     IF CAL-ADM-PRINT-MNTH-DATE-CYMD = '19991104'
017415*       MOVE 22                       TO WS-DATE-PARAM
017416*       MOVE SPACES                   TO WS-DATE-EXTEND
017417*       MOVE CAL-ADM-PRINT-MNTH-DATE-CYMD
017418*                                     TO WS-DATE-REFORM(1:8)
017419*       MOVE '007'                    TO WS-DATE-REFORM(9:3)
017420*       CALL TPSDATES USING WS-DATE-REQUEST
017421*       MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-PRINT-MNTH-DATE-CYMD
017422
017423*       MOVE 22                       TO WS-DATE-PARAM
017424*       MOVE SPACES                   TO WS-DATE-EXTEND
017425*       MOVE CAL-ADM-APPNT-WKLY-FROM-CYMD
017426*                                    TO WS-DATE-REFORM(1:8)
017427*       MOVE '007'                    TO WS-DATE-REFORM(9:3)
017428*       CALL TPSDATES USING WS-DATE-REQUEST
017429*       MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-APPNT-WKLY-FROM-CYMD
017430
017431*       MOVE 22                       TO WS-DATE-PARAM
017432*       MOVE SPACES                   TO WS-DATE-EXTEND
017433*       MOVE CAL-ADM-APPNT-WKLY-TO-CYMD
017434*                                     TO WS-DATE-REFORM(1:8)
017435*       MOVE '007'                    TO WS-DATE-REFORM(9:3)
017436*       CALL TPSDATES USING WS-DATE-REQUEST
017437*       MOVE WS-DATE-REFORM-LEN08 TO CAL-ADM-APPNT-WKLY-TO-CYMD
017438*       PERFORM REWRITE-CALEN-RECORD THRU
017440*               REWRITE-CALEN-RECORD-EXIT
017450*       GO TO READ-THE-CALEN-EXIT
017460*      END-IF
017470*     END-IF.
017500
017600**    INSPECT CAL-RECORD-TYPE REPLACING
017700**            ALL X'00' BY X'30'.
017800
017900**    IF HEX-CAL-RECORD-TYPE NOT = X'0000'
018000**    IF NOT CAL-CONTROL-REC
018100**       GO TO READ-ALL-CALEN-RECORDS.
018200
018300*     IF CAL-KEY-RECORD-NUMBER IS NOT NUMERIC
018400*        GO TO READ-ALL-CALEN-RECORDS.
018500
018600*     IF CAL-KEY-DATE-DD = ZEROS
018700*        GO TO READ-ALL-CALEN-RECORDS.
018800
018900*     IF CAL-KEY-ACCT-NO(5:6) NOT = ZEROS
019000*        GO TO READ-ALL-CALEN-RECORDS.
019100
019200*     IF CAL-KEY-ACCT-NO NOT = '0101000248'
019211*     IF CAL-KEY-ACCT-NO NOT = '0101000000'
019212      IF CAL-KEY-ACCT-NO NOT = '0101001071'
019300         GO TO READ-ALL-CALEN-RECORDS.
019310
019310      if not CAL-EVENT-REC                                                                                          
019300         GO TO READ-ALL-CALEN-RECORDS.
019310
023200      if cal-appt-appoint-data(1:6) = 'Event:'                                                                      
019310         continue
019310        else
023200      if cal-appt-appoint-data(1:5) = 'Date:'                                                                       
019310         continue
019310        else
019300         go to read-all-calen-records                                                                               
019310        end-if
019310       end-if.                                                                                                      
019310
019310
019310
019320*****  IF CAL-KEY-DATE < '19970101'
019330*****  IF CAL-KEY-DATE < '19960101'
019341****   IF CAL-KEY-DATE < '19980101'
019342****   IF CAL-KEY-DATE < '19971001'
019343*      IF CAL-KEY-DATE < '20010201'
019350*         GO TO READ-ALL-CALEN-RECORDS.
019360
019361*      IF CAL-APPT-RECEIVE-DATE(1:4) IS NUMERIC
019362*         IF CAL-APPT-RECEIVE-DATE(5:4) = SPACES
019363*            CONTINUE
019364*           ELSE
019365*            GO TO READ-ALL-CALEN-RECORDS
019366*          END-IF
019367*        ELSE
019368*      IF CAL-APPT-RECEIVE-DATE(1:4) IS NOT NUMERIC
019369*         GO TO READ-ALL-CALEN-RECORDS
019370*        END-IF
019371*       END-IF.
019372
019373*      IF NOT CAL-APPT-FROM-DB-MAINT
019374*         GO TO READ-ALL-CALEN-RECORDS
019375*       END-IF.
019376
019377*****   CAL-DB-MAINT-FIELD-CODE
019378
019379
019380****** IF CAL-KEY-DATE > '19971231'
019381*      IF CAL-KEY-DATE > '19970831'
019390*         GO TO READ-ALL-CALEN-RECORDS.
019400
019401*      IF CAL-KEY-DATE = '19971231'
019402*         GO TO READ-ALL-CALEN-RECORDS.
019403
019405*      IF CAL-APPT-ADD-PASSWORD(1:3) NOT = 'TPS'
019406*         GO TO READ-ALL-CALEN-RECORDS.
019407
019408
019409*      IF NOT CAL-APPT-FROM-DB-MAINT
019410*         GO TO READ-ALL-CALEN-RECORDS.
019420
019500
019600*     IF CAL-APPT-ADD-PASSWORD NOT = 'TPS4020 '
019700*        GO TO READ-ALL-CALEN-RECORDS.
019800
019900
020000*     IF CAL-KEY-ACCT-NO NOT NUMERIC
020100*        GO TO PRINT-THE-RECORD.
020200*     IF CAL-KEY-SUB-ACCT NOT NUMERIC
020300*        GO TO PRINT-THE-RECORD.
020400*     IF CAL-KEY-DATE NOT NUMERIC
020500*        GO TO PRINT-THE-RECORD.
020600*     IF CAL-KEY-RECORD-NUMBER NOT NUMERIC
020700*        GO TO PRINT-THE-RECORD.
020800*     IF CAL-KEY-SUB-RECORD-NUMBER NOT NUMERIC
020900*        GO TO PRINT-THE-RECORD.
021000*
021100*     GO TO READ-ALL-CALEN-RECORDS.
021200
021201***    IF CAL-KEY-RECORD-NUMBER NOT = '0001'
021202***       GO TO READ-ALL-CALEN-RECORDS.
021203
021204*      IF CAL-KEY-SUB-RECORD-NUMBER NOT = '01'
021205*         GO TO READ-ALL-CALEN-RECORDS.
021320
021321*      IF CAL-APPT-ADD-PASSWORD(1:7) NOT = 'NYLEZUT'
021322*         GO TO READ-ALL-CALEN-RECORDS.
021330
021340
021350
021400 PRINT-THE-RECORD.
021500       MOVE SPACES                TO PRT-RECORD.
021600
021600
021601       move  cal-key to prt-stuffa.                                                                                 
021600
021600
021601       MOVE  CAL-KEY-ACCT-NO TO
021602                  PRT-KEY-ACCT-NO.
021600
017414
017414
017414*      move CAL-ADM-PRINT-MNTH-DATE-CYMD                                                                            
017414*        to prt-ADM-PRINT-MNTH-DATE-CYMD.                                                                         
017414*      move CAL-ADM-PRINT-MNTH-from-CYMD                                                                          
017414*        to prt-ADM-PRINT-MNTH-from-CYMD.                                                                         
017414*      move CAL-ADM-PRINT-MNTH-to-CYMD                                                                            
017414*        to prt-ADM-PRINT-MNTH-to-CYMD.                                                                           
017414*      move CAL-ADM-appnt-wkly-from-CYMD                                                                          
017414*        to prt-ADM-appnt-wkly-from-CYMD.                                                                         
017414*      move CAL-ADM-appnt-wkly-to-CYMD                                                                            
017414*        to prt-ADM-appnt-wkly-to-CYMD.                                                                           
021600
021600
021600
021600
021610*      MOVE  CAL-ADM-WKLY-ACTIVITY-DATE TO
021611*                 PRT-ADM-WKLY-ACTIVITY-DATE.
021612*      MOVE  CAL-ADM-MNTH-ACTIVITY-DATE TO
021613*                 PRT-ADM-MNTH-ACTIVITY-DATE.
021620
003350
021630
021640
021641*      MOVE CAL-APPT-RECEIVE-DATE TO
021642*                 PRT-RECEIVE-DATE.
021650
021700*      MOVE  CAL-KEY-ACCT-NO TO
021800*                 PRT-KEY-ACCT-NO.
021900*      MOVE  CAL-KEY-SUB-ACCT TO
022000*                 PRT-KEY-SUB-ACCT.
022100*      MOVE CAL-KEY-DATE TO
022200*           PRT-KEY-DATE.
022210*      MOVE CAL-APPT-PRINT-OPTION TO
022211*           PRT-APPT-PRINT-OPTION.
022220*      MOVE CAL-APPT-ATTEND-OPTION TO
022230*           PRT-APPT-ATTEND-OPTION.
022300*      MOVE  CAL-KEY-RECORD-NUMBER TO
022400*                 PRT-KEY-RECORD-NUMBER.
022401*      MOVE  CAL-APPT-START-TIME(1:6) TO
022410*                 PRT-APPT-TIME-FROM.
022420*      MOVE  CAL-APPT-STOP-TIME(1:6) TO
022430*                 PRT-APPT-TIME-TO.
022500*      MOVE  CAL-KEY-SUB-RECORD-NUMBER TO
022600*                 PRT-KEY-SUB-RECORD-NUMBER
022700*      MOVE  CAL-APPT-ADD-PASSWORD TO
022800*                 PRT-CAL-APPT-ADD-BY.
022900*      IF CAL-APPT-ADD-DATE NUMERIC
023000*         MOVE  CAL-APPT-ADD-DATE      TO
023100*                 PRT-CAL-APPT-ADD-DATE.
023110*      MOVE CAL-DB-MAINT-FIELD-CODE    TO
023120*                 PRT-CAL-DB-MAINT-FIELD-CODE.
023200       MOVE  CAL-APPT-APPOINT-DATA     TO
023300                  PRT-CAL-APPT-APPOINT-DATA.
023310*      MOVE  CAL-APPT-ADD-PASSWORD     TO
023320*                 PRT-CAL-APPT-ADD-PASSWORD.
023330*      MOVE  CAL-APPT-CHANGE-PASSWORD     TO
023340*                 PRT-CAL-APPT-CHANGE-PASSWORD.
023400*
023500*      IF CAL-KEY-DATE-MM NOT = ZEROS
023600*        IF CAL-KEY-DATE-DD NOT = ZEROS
023700*          IF CAL-KEY-RECORD-NUMBER = ZEROS
023800*            IF CAL-KEY-SUB-RECORD-NUMBER = ZEROS
023900*              IF CAL-RECORD-TYPE = ZEROS
024000*                 MOVE SPACES        TO PRT-CAL-APPT-ADD-BY
024100*                 MOVE  CAL-DAY-NEXT-AVAIL-REC-NUM TO
024200*                           PRT-CAL-APPT-ADD-BY(1:4)
024300*           END-IF
024400*          END-IF
024500*         END-IF
024600*        END-IF
024700*       END-IF.
024800*
024900*      IF HEX-CAL-RECORD-TYPE NOT = X'0000'
025000*         MOVE  CAL-RECORD-TYPE TO
025100*                    PRT-RECORD-TYPE
025200*         WRITE PRT-RECORD
025300*         GO TO READ-ALL-CALEN-RECORDS.
025400
025500*      MOVE  CAL-ADM-PRINT-YRLY-DATE-CYMD TO
025600*                 PRT-ADM-PRINT-YRLY-DATE-CYMD.
025700*      MOVE  CAL-ADM-PRINT-YRLY-DAYS-BEFORE TO
025800*                 PRT-ADM-PRINT-YRLY-DAYS-BEFORE.
025900*      MOVE  CAL-ADM-PRINT-YRLY-FROM-CYMD TO
026000*                 PRT-ADM-PRINT-YRLY-FROM-CYMD.
026100*      MOVE  CAL-ADM-PRINT-YRLY-TO-CYMD TO
026200*                 PRT-ADM-PRINT-YRLY-TO-CYMD.
026300*      MOVE  CAL-ADM-PRINT-MNTH-DATE-CYMD TO
026400*                 PRT-ADM-PRINT-MNTH-DATE-CYMD.
026500*      MOVE  CAL-ADM-PRINT-MNTH-DAYS-BEFORE TO
026600*                 PRT-ADM-PRINT-MNTH-DAYS-BEFORE.
026700*      MOVE  CAL-ADM-PRINT-MNTH-FROM-CYMD TO
026800*                 PRT-ADM-PRINT-MNTH-FROM-CYMD.
026900*      MOVE  CAL-ADM-PRINT-MNTH-TO-CYMD TO
027000*                 PRT-ADM-PRINT-MNTH-TO-CYMD.
027100*      MOVE  CAL-ADM-APPNT-WKLY-FROM-CYMD TO
027200*                 PRT-ADM-APPNT-WKLY-FROM-CYMD.
027300*      MOVE  CAL-ADM-APPNT-WKLY-TO-CYMD TO
027400*                 PRT-ADM-APPNT-WKLY-TO-CYMD.
027500*      MOVE  CAL-ADM-DBASE-SEMI-FROM-CYMD TO
027600*                 PRT-ADM-DBASE-SEMI-FROM-CYMD.
027700*      MOVE  CAL-ADM-DBASE-SEMI-TO-CYMD TO
027800*                 PRT-ADM-DBASE-SEMI-TO-CYMD.
027900
032100
032200
032300       WRITE PRT-RECORD.
032400       GO TO READ-ALL-CALEN-RECORDS.
032500 READ-THE-CALEN-EXIT. EXIT.
032600
032700
032800 FILE-ERROR.
032900     CALL TPSIOERR USING FILE-REQUEST.
033000     CANCEL TPSIOERR.
033100 FILE-ERROR-EXIT. EXIT.
033200
033300
033400 OPEN-THE-FILES.
033500    OPEN OUTPUT PRT-FILE.
033600    MOVE F-PRIME    TO FILE-KEY.
033700    MOVE F-OPEN-I-O TO FILE-ACTION.
033800    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
033900    IF FILE-STATUS NOT = '00' AND '05'
034000       MOVE 'CALEN ' TO FILE-NAME
034100       MOVE 'SEECALEN-ORC' TO FILE-TEXT
034200       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
034300       GO TO SEECALEN-COMMON-EXIT.
034400 OPEN-THE-FILES-EXIT. EXIT.
034500
034600 CLOSE-THE-FILES.
034700    CLOSE PRT-FILE.
034800      MOVE F-PRIME TO FILE-KEY.
034900      MOVE F-CLOSE TO FILE-ACTION.
035000      CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
035100      IF NOT A-SUCCESSFUL-OPERATION
035200         MOVE 'CALEN ' TO FILE-NAME
035300         MOVE 'SEECALEN-CCK' TO FILE-TEXT
035400         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
035500      END-IF.
035600
035700 CLOSE-THE-FILES-EXIT. EXIT.
035800
035900
035910
035920 REWRITE-CALEN-RECORD.
035930    MOVE F-PRIME TO FILE-KEY.
035940    MOVE F-REWRITE TO FILE-ACTION.
035950    CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.
035970    IF NOT A-SUCCESSFUL-OPERATION
035980       MOVE ' CALEN' TO FILE-NAME
035990       MOVE 'SEECALEN-REW' TO FILE-TEXT
035991       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
035992       GO TO SEECALEN-COMMON-EXIT.
035993 REWRITE-CALEN-RECORD-EXIT. EXIT.
035994
035994
035994
036000
013900 add-oboyle-places.                                                                                                 
013570     perform varying the-idx from 1 by 1
013570               until the-idx > 1000                                                                                 
023200       move high-values   to tbl-name(the-idx)                                                                      
023200                             tbl-place(the-idx)                                                                     
019310       move zeros         to tbl-count(the-idx)                                                                     
023200                             tbl-domestic-or-fgn(the-idx)                                                           
036000      end-perform.                                                                                                  
036000
015300    move low-values to cal-key of tps-calen-rec.
015400    move f-prime to file-key.
015500    move f-start to file-action.
015600    call tpsio018 using file-request tps-calen-rec.
015700    if no-record-was-found                                                                                          
019310       go to display-oboyle-places                                                                                  
016300     end-if.                                                                                                        
015800    if not a-successful-operation
015900       move ' calen' to file-name
016000       move 'seecalen-sbr' to file-text
016100       perform file-error thru file-error-exit
016200       go to seecalen-common-exit                                                                                   
016300     end-if.                                                                                                        
016300
016400 read-all-oboyle-records.                                                                                           
016500    move f-prime to file-key.
016600    move f-read-next to file-action.
016700    call tpsio018 using file-request tps-calen-rec.
016800    if end-of-file-was-reached                                                                                      
019310       go to display-oboyle-places                                                                                  
016300     end-if.                                                                                                        
016900    if not a-successful-operation
017000       move ' calen' to file-name
017100       move 'seecalen-brn' to file-text
017200       perform file-error thru file-error-exit
016200       go to seecalen-common-exit                                                                                   
016300     end-if.                                                                                                        
017400
019212      if cal-key-acct-no not = '0101001071'
019300         go to read-all-oboyle-records                                                                              
019310
019310      if not cal-event-rec                                                                                          
019300         go to read-all-oboyle-records
             end-if.
019310
023200      if cal-appt-appoint-data(1:6) = 'Event:'                                                                      
019310         go to its-boyle-event                                                                                      
019310        else
019300         go to read-all-oboyle-records                                                                              
019310       end-if.                                                                                                      
019310
019310
019310 its-boyle-event.                                                                                                   
023200      if cal-appt-appoint-data(11:4) = ' in '                                                                       
019310         continue                                                                                                   
019310        else
019300         go to read-all-oboyle-records                                                                              
019310       end-if.                                                                                                      
019310
023200      move cal-appt-appoint-data(8:3)   to oboyle-name.                                                             
023200      move cal-appt-appoint-data(15:35) to oboyle-place.                                                            
019310
016500      move f-prime to file-key.                                                                                     
016600      move f-read-next to file-action.                                                                              
016700      call tpsio018 using file-request tps-calen-rec.                                                               
016800      if end-of-file-was-reached                                                                                    
019310         go to display-oboyle-places                                                                                
016300       end-if.                                                                                                      
016900      if not a-successful-operation                                                                                 
017000         move ' calen' to file-name                                                                                 
017100         move 'seecalen-brn' to file-text                                                                           
017200         perform file-error thru file-error-exit                                                                    
016200         go to seecalen-common-exit                                                                                 
016300       end-if.                                                                                                      
017400
019212      if cal-key-acct-no not = '0101001071'                                                                         
019300         go to read-all-oboyle-records                                                                              
016300       end-if.                                                                                                      
019310                                                                                                                    
023200      if cal-appt-appoint-data(1:5) = 'Date:'                                                                       
019310         continue
019310        else
019300         go to read-all-oboyle-records                                                                              
019310       end-if.                                                                                                      
019310
019310      perform varying the-idx from 1 by 1
019310                until tbl-name(the-idx) = high-values
023200        if oboyle-name = tbl-name(the-idx)                                                                          
023200           if oboyle-place = tbl-place(the-idx)                                                                     
019310              go to add-to-table
019310            end-if
019310         end-if                                                                                                     
019310        end-perform.                                                                                                
019310
023200     move oboyle-name     to tbl-name(the-idx).                                                                     
023200     move oboyle-place    to tbl-place(the-idx).                                                                    
023200     if oboyle-place(3:2) = '  '                                                                                    
023200        move '0'          to tbl-domestic-or-fgn(the-idx)                                                           
             else
023200        move '1'          to tbl-domestic-or-fgn(the-idx)                                                           
            end-if.    
019310     move zeros           to tbl-count(the-idx).                                                                    
019310
019310 add-to-table.                                                                                                      
021500     move spaces             to prt-record.                                                                         
023200     if tbl-name(the-idx) = 'WOB'                                                                                   
023200        move "William O'Boyle"  to dtl-oboyle-name                                                                  
             else                                                                                                         
023200        move "Lily O'Boyle   "  to dtl-oboyle-name                                                                  
            end-if.                                                                                                       
013570     perform retrieve-dtl-state-name thru                                                                           
013570             retrieve-dtl-state-name-exit.
036000
023200      if cal-appt-appoint-data(18:8) = '00/00/00'                                                                   
023200         if cal-appt-appoint-data(13:2) not = active-year(3:2)                                                      
019300            go to read-all-oboyle-records                                                                           
019310          end-if                                                                                                    
019310         add 1           to tbl-count(the-idx)                                                                      
019310         move 1          to dtl-oboyle-num-days                                                                     
023200         move cal-appt-appoint-data(07:8)                                                                           
019310                         to dtl-oboyle-from-date                                                                    
032300         write prt-record                                                                                           
019300         go to read-all-oboyle-records                                                                              
019310       end-if.                                                                                                      
019310
023200      if cal-appt-appoint-data(07:8) =                                                                              
023200              cal-appt-appoint-data(18:8)                                                                           
023200         if cal-appt-appoint-data(13:2) not = active-year(3:2)                                                      
019300            go to read-all-oboyle-records                                                                           
019310          end-if                                                                                                    
019310         add 1           to tbl-count(the-idx)                                                                      
019310         move 1          to dtl-oboyle-num-days                                                                     
023200         move cal-appt-appoint-data(07:8)                                                                           
019310                         to dtl-oboyle-from-date                                                                    
032300         write prt-record                                                                                           
019300         go to read-all-oboyle-records                                                                              
019310       end-if.                                                                                                      
019310
017423      move 11                 to ws-date-param.                                                                     
017424      move spaces             to ws-date-extend.                                                                    
023200      move cal-appt-appoint-data(07:2)                                                                              
017426                              to ws-date-reform(1:2).                                                               
023200      move cal-appt-appoint-data(10:2)                                                                              
017426                              to ws-date-reform(3:2).                                                               
023200      move cal-appt-appoint-data(13:2)                                                                              
017426                              to ws-date-reform(5:2).                                                               
017428      call tpsdates using ws-date-request                                                                           
017429      move ws-date-reform-len08 to calc-from-date.                                                                  
013570
017423      move 11                 to ws-date-param.                                                                     
017424      move spaces             to ws-date-extend.                                                                    
023200      move cal-appt-appoint-data(18:2)                                                                              
017426                              to ws-date-reform(1:2).                                                               
023200      move cal-appt-appoint-data(21:2)                                                                              
017426                              to ws-date-reform(3:2).                                                               
023200      move cal-appt-appoint-data(24:2)                                                                              
017426                              to ws-date-reform(5:2).                                                               
017428      call tpsdates using ws-date-request                                                                           
017429      move ws-date-reform-len08 to calc-to-date.                                                                    
013570
017423      move 25                 to ws-date-param.                                                                     
017424      move spaces             to ws-date-extend.                                                                    
023200      move calc-from-date     to ws-time-parm1by8.                                                                  
023200      move calc-to-date       to ws-time-parm2by8.                                                                  
013536      move zeros              to ws-time-extndby8.                                                                  
017428      call tpsdates using ws-date-request                                                                           
013536      add  ws-time-extndby8   to tbl-count(the-idx).                                                                
013570
013536      move ws-time-extndby8   to dtl-oboyle-num-days.                                                               
023200      move cal-appt-appoint-data(07:8)                                                                              
019310                              to dtl-oboyle-from-date.                                                              
023200      move cal-appt-appoint-data(18:8)                                                                              
019310                              to dtl-oboyle-to-date.                                                                
032300      write prt-record.                                                                                             
019300      go to read-all-oboyle-records.                                                                                
019310
019310
019310 display-oboyle-places.
008100      sort tbl-stuff on ascending key                                                                               
023200                                  tbl-name                                                                          
023200                                  tbl-domestic-or-fgn                                                               
023200                                  tbl-place.                                                                        
019310
019310      write prt-record from form-feed.                                                                              
019310
021500      move spaces                  to prt-record.                                                                   
032300      write prt-record.                                                                                             
032300      write prt-record.                                                                                             
019310
019310      perform varying the-idx from 1 by 1
019310                until tbl-name(the-idx) = high-values
021500        move spaces                to prt-record                                                                    
019310        if the-idx = 1                                                                                              
023200           move tbl-name(the-idx)  to current-inits                                                                 
023200           move zeros              to current-count                                                                 
               end-if                                                                                                     
023200        if tbl-name(the-idx) not = current-inits                                                                    
032300           write prt-record from line-of-dashes                                                                     
021500           move spaces             to prt-record                                                                    
019310           move current-count      to prt-oboyle-num-days                                                           
032300           write prt-record                                                                                         
021500           move spaces             to prt-record                                                                    
032300           write prt-record                                                                                         
032300           write prt-record                                                                                         
023200           move tbl-name(the-idx)  to current-inits                                                                 
023200           move zeros              to current-count                                                                 
               end-if                                                                                                     
023200        if tbl-name(the-idx) = 'WOB'                                                                                
023200           move "William O'Boyle"  to prt-oboyle-name                                                               
                else                                                                                                      
023200           move "Lily O'Boyle   "  to prt-oboyle-name                                                               
               end-if                                                                                                     
013570        perform retrieve-state-name thru                                                                            
013570                retrieve-state-name-exit                                                                            
019310        move tbl-count(the-idx)    to prt-oboyle-num-days                                                           
019310        add tbl-count(the-idx)     to current-count                                                                 
032300        write prt-record                                                                                            
019310       end-perform.                                                                                                 
036000
032300      write prt-record from line-of-dashes.                                                                         
021500      move spaces             to prt-record.                                                                        
019310      move current-count      to prt-oboyle-num-days.                                                               
032300      write prt-record.                                                                                             
021500      move spaces             to prt-record.                                                                        
032300      write prt-record.                                                                                             
032300      write prt-record.                                                                                             
023200                                                                                                                    
013900 add-oboyle-places-exit. exit.
013570
013570
013570 retrieve-state-name.
023200        move tbl-place(the-idx)    to prt-oboyle-place                                                              
019310        perform varying state-idx from 1 by 1                                                                       
019310                  until state-abbrev(state-idx) = high-values                                                       
023200          if tbl-place(the-idx)                                                                                     
019310                      = state-abbrev(state-idx)                                                                     
023200             move spaces    to prt-oboyle-place                                                                     
019310             move state-name(state-idx)                                                                             
023200                            to prt-oboyle-place                                                                     
013570             go to retrieve-state-name-exit                                                                         
                 end-if                                                                                                   
019310         end-perform.
013570
013570 retrieve-state-name-exit. exit.
013570
013570
013570
013570 retrieve-dtl-state-name.                                                                                           
023200        move tbl-place(the-idx)    to dtl-oboyle-place                                                              
019310        perform varying state-idx from 1 by 1                                                                       
019310                  until state-abbrev(state-idx) = high-values                                                       
023200          if tbl-place(the-idx)                                                                                     
019310                      = state-abbrev(state-idx)                                                                     
023200             move spaces    to dtl-oboyle-place                                                                     
019310             move state-name(state-idx)                                                                             
023200                            to dtl-oboyle-place                                                                     
013570             go to retrieve-dtl-state-name-exit                                                                     
                 end-if                                                                                                   
019310         end-perform.
013570
013570 retrieve-dtl-state-name-exit. exit.                                                                                
036100
036100
036100
036100
036100
000000 show-the-dates.                                                                      00250600                      
506500      SET FR-OPEN-INPUT TO TRUE                                                      00251100
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
506700      IF NOT A-SUCCESSFUL-OPERATION                                                  00251300
506800         MOVE 'BRNCH' TO FILE-NAME                                                   00251400
506900         MOVE 'TPS000-OPEN' TO FILE-TEXT                                             00251500
507000*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00251600
507200         go to seecalen-common-exit                                                      00251800
507300      END-IF.                                                                        00251900
507300                                                                                     00252000
507400                                                                                     00252100
229600      MOVE SPACES     TO BRNCH-CONTROL-STATE.                                        00252200
229600      MOVE ZEROS      TO BRNCH-CONTROL-OFFICE                                        00252300
229600                         BRNCH-CONTROL-GROUP.                                        00252400
229700      MOVE F-PRIME TO FILE-KEY.                                                      00252500
229800      MOVE F-START TO FILE-ACTION.                                                   00252600
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
230300      IF NOT A-SUCCESSFUL-OPERATION                                                  00252800
230400         MOVE ' BRNCH  ' TO FILE-NAME                                                00252900
230500         MOVE 'TPS006-START' TO FILE-TEXT                                            00253000
230600*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00253100
230700         go to seecalen-common-exit                                                      00253200
230800       END-IF.                                                                       00253300
230900                                                                                     00253400
183100 show-each-branch.                                                                                                  
229700      MOVE F-PRIME TO FILE-KEY.                                                      00252500
016600      MOVE F-READ-NEXT TO FILE-ACTION.                                                                              
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
231400      IF END-OF-FILE-WAS-REACHED                                                     00253800
183100         GO TO FINISH-showing-ALL-branches                                                                          
182700       END-IF.                                                                       00254000
230300      IF NOT A-SUCCESSFUL-OPERATION                                                  00252800
230400         MOVE ' BRNCH  ' TO FILE-NAME                                                00252900
230500         MOVE 'TPS006-START' TO FILE-TEXT                                            00253000
230600*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00253100
230700         go to seecalen-common-exit                                                      00253200
230800       END-IF.

            move zeros                    to cal-key.                                      00254100
180700      MOVE BRNCH-CONTROL-OFFICE     TO CAL-KEY-ACCT-NO(1:2).                         00254200
180800      MOVE BRNCH-CONTROL-GROUP      TO CAL-KEY-ACCT-NO(3:2).                         00254300
                                                                                           00254400
189800      SET FR-READ TO TRUE                                                            00254500
189900      CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.                                00254600
190000      IF NOT A-SUCCESSFUL-OPERATION                                                  00254700
190100         MOVE 'CALEN' TO FILE-NAME                                                   00254800
190200         MOVE 'TPS000-RD4 ' TO FILE-TEXT                                             00254900
190300*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00255000
190500         go to seecalen-common-exit                                                      00255200
190600       END-IF.                                                                       00255300
190700                                                                                     00255400
036100
013570
013570      move spaces               to date-fix-report.                                                                 
032300      write prt-record from date-fix-report.                                                                        
013570
180700      move brnch-control-office                                                                                     
180700                      to prt-BRNCH-CONTROL-OFFICE.                                                                  
180800      move brnch-control-group                                                                                      
180800                      to prt-BRNCH-CONTROL-GROUP.                                                                   
002761      move 'CAL-ADM-PRINT-YRLY-DATE-CYMD'       to type-date.
002761      move  CAL-ADM-PRINT-YRLY-DATE-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002770      move 'CAL-ADM-PRINT-YRLY-DAYS-BEFORE'     to type-date.
002770      move spaces                               to prt-date.                                                        
002770      move  CAL-ADM-PRINT-YRLY-DAYS-BEFORE      to prt-date(1:2).                                                   
032300      write prt-record from date-fix-report.                                                                        
013570
002771      move 'CAL-ADM-PRINT-YRLY-FROM-CYMD'       to type-date.
002771      move  CAL-ADM-PRINT-YRLY-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002780      move 'CAL-ADM-PRINT-YRLY-TO-CYMD'         to type-date.
002780      move  CAL-ADM-PRINT-YRLY-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002789      move 'CAL-ADM-PRINT-MNTH-DATE-CYMD'       to type-date.
002789      move  CAL-ADM-PRINT-MNTH-DATE-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002798      move 'CAL-ADM-PRINT-MNTH-DAYS-BEFORE'     to type-date.
002798      move  CAL-ADM-PRINT-MNTH-DAYS-BEFORE      to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002799      move 'CAL-ADM-PRINT-MNTH-FROM-CYMD'       to type-date.
002799      move  CAL-ADM-PRINT-MNTH-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002808      move 'CAL-ADM-PRINT-MNTH-TO-CYMD'         to type-date.
002808      move  CAL-ADM-PRINT-MNTH-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002817      move 'CAL-ADM-APPNT-WKLY-FROM-CYMD'       to type-date.
002817      move  CAL-ADM-APPNT-WKLY-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002826      move 'CAL-ADM-APPNT-WKLY-TO-CYMD'         to type-date.
002826      move  CAL-ADM-APPNT-WKLY-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002835      move 'CAL-ADM-DIARY-BROADCAST-CYMD'       to type-date.
002835      move  CAL-ADM-DIARY-BROADCAST-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002842      move 'CAL-ADM-RECURRING-PRINT-DATE'       to type-date.
002842      move  CAL-ADM-RECURRING-PRINT-DATE        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002850      move 'CAL-ADM-SUMMARY-WHICH-QUARTER'      to type-date.
002770      move spaces                               to prt-date.                                                        
002850      move  CAL-ADM-SUMMARY-WHICH-QUARTER       to prt-date(1:1).                                                   
032300      write prt-record from date-fix-report.                                                                        
013570
002856      move 'CAL-ADM-SUMMARY-FROM-CYMD'          to type-date.
002856      move  CAL-ADM-SUMMARY-FROM-CYMD           to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002862      move 'CAL-ADM-SUMMARY-TO-CYMD'            to type-date.
002862      move  CAL-ADM-SUMMARY-TO-CYMD             to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002869      move 'CAL-ADM-INVOICE-SCHED-DATE'         to type-date.
002869      move  CAL-ADM-INVOICE-SCHED-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002870      move 'CAL-ADM-INVOICE-ACTUAL-DATE'        to type-date.
002870      move  CAL-ADM-INVOICE-ACTUAL-DATE         to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002871      move 'CAL-ADM-WKLY-ACTIVITY-DATE'         to type-date.
002871      move  CAL-ADM-WKLY-ACTIVITY-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002872      move 'CAL-ADM-MNTH-ACTIVITY-DATE'         to type-date.
002872      move  CAL-ADM-MNTH-ACTIVITY-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002875      move 'CAL-ADM-PRINT-CAL-MONTHLY-MNTH'     to type-date.
002875      move  CAL-ADM-PRINT-CAL-MONTHLY-MNTH      to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002876      move 'CAL-ADM-PRINT-CAL-MONTHLY-ON'       to type-date.
002876      move  CAL-ADM-PRINT-CAL-MONTHLY-ON        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
002877       
183100      go to show-each-branch.                                                                                       
192600                                                                                     00258100
192600                                                                                     00258200
183100 FINISH-showing-ALL-branches.                                                                                       
192700      SET FR-CLOSE TO TRUE                                                           00258400
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
192900      IF NOT A-SUCCESSFUL-OPERATION                                                  00258600
193000         MOVE 'BRNCH' TO FILE-NAME                                                   00258700
193100         MOVE 'TPS006-CLOSE' TO FILE-TEXT
193200*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00258900
193400         go to seecalen-common-exit                                                      00259100
193500       END-IF.                                                                       00259200
                                                                                           00248400
                                                         
000000 show-the-dates-exit. exit.                                                                      00250600           
036100
002879*****************************************************************
002880
036100
036100
000000 fix-the-dates.                                                                      00250600                       
506500      SET FR-OPEN-INPUT TO TRUE                                                      00251100
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
506700      IF NOT A-SUCCESSFUL-OPERATION                                                  00251300
506800         MOVE 'BRNCH' TO FILE-NAME                                                   00251400
506900         MOVE 'TPS000-OPEN' TO FILE-TEXT                                             00251500
507000*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00251600
507200         go to seecalen-common-exit                                                      00251800
507300      END-IF.                                                                        00251900
507300                                                                                     00252000
507400                                                                                     00252100
229600      MOVE SPACES     TO BRNCH-CONTROL-STATE.                                        00252200
229600      MOVE ZEROS      TO BRNCH-CONTROL-OFFICE                                        00252300
229600                         BRNCH-CONTROL-GROUP.                                        00252400
229700      MOVE F-PRIME TO FILE-KEY.                                                      00252500
229800      MOVE F-START TO FILE-ACTION.                                                   00252600
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
230300      IF NOT A-SUCCESSFUL-OPERATION                                                  00252800
230400         MOVE ' BRNCH  ' TO FILE-NAME                                                00252900
230500         MOVE 'TPS006-START' TO FILE-TEXT                                            00253000
230600*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00253100
230700         go to seecalen-common-exit                                                      00253200
230800       END-IF.                                                                       00253300
230900                                                                                     00253400
183100 fix-each-branch.                                                                                                   
229700      MOVE F-PRIME TO FILE-KEY.                                                      00252500
016600      MOVE F-READ-NEXT TO FILE-ACTION.                                                                              
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
231400      IF END-OF-FILE-WAS-REACHED                                                     00253800
183100         GO TO FINISH-fixing-ALL-branches                                                                           
182700       END-IF.                                                                       00254000
230300      IF NOT A-SUCCESSFUL-OPERATION                                                  00252800
230400         MOVE ' BRNCH  ' TO FILE-NAME                                                00252900
230500         MOVE 'TPS006-START' TO FILE-TEXT                                            00253000
230600*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00253100
230700         go to seecalen-common-exit                                                      00253200
230800       END-IF.

            move zeros                    to cal-key.                                      00254100
180700      MOVE BRNCH-CONTROL-OFFICE     TO CAL-KEY-ACCT-NO(1:2).                         00254200
180800      MOVE BRNCH-CONTROL-GROUP      TO CAL-KEY-ACCT-NO(3:2).                         00254300
                                                                                           00254400
189800      SET FR-READ TO TRUE                                                            00254500
189900      CALL TPSIO018 USING FILE-REQUEST TPS-CALEN-REC.                                00254600
190000      IF NOT A-SUCCESSFUL-OPERATION                                                  00254700
190100         MOVE 'CALEN' TO FILE-NAME                                                   00254800
190200         MOVE 'TPS000-RD4 ' TO FILE-TEXT                                             00254900
190300         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00255000
190500         go to seecalen-common-exit                                                      00255200
190600       END-IF.                                                                       00255300
190700************************************************************                                                        
190700************************************************************                                                        
190700************************************************************                                                        
002761*     move                  to CAL-ADM-PRINT-YRLY-DATE-CYMD.                                                        
002770*     move                  to CAL-ADM-PRINT-YRLY-DAYS-BEFORE.                                                      
002771*     move                  to CAL-ADM-PRINT-YRLY-FROM-CYMD.                                                        
002780*     move                  to CAL-ADM-PRINT-YRLY-TO-CYMD.                                                          
013570
002789      move '20061101'       to CAL-ADM-PRINT-MNTH-DATE-CYMD.                                                        
002798      move '03'             to CAL-ADM-PRINT-MNTH-DAYS-BEFORE.                                                      
002799      move '20061101'       to CAL-ADM-PRINT-MNTH-FROM-CYMD.                                                        
002808      move '20061131'       to CAL-ADM-PRINT-MNTH-TO-CYMD.                                                          
013570
002817      move '20061008'       to CAL-ADM-APPNT-WKLY-FROM-CYMD.                                                        
002826      move '20061014'       to CAL-ADM-APPNT-WKLY-TO-CYMD.                                                          
013570
002835*     move                  to CAL-ADM-DIARY-BROADCAST-CYMD.                                                        
013570
002842      move '20061031'       to CAL-ADM-RECURRING-PRINT-DATE.                                                        
013570
002850      move '02'             to CAL-ADM-SUMMARY-WHICH-QUARTER.                                                       
002856      move '20060401'       to CAL-ADM-SUMMARY-FROM-CYMD.                                                           
002862      move '20060630'       to CAL-ADM-SUMMARY-TO-CYMD.                                                             
013570
002869*     move                  to CAL-ADM-INVOICE-SCHED-DATE.                                                          
002870*     move                  to CAL-ADM-INVOICE-ACTUAL-DATE.                                                         
013570
002871      move '20061008'       to CAL-ADM-WKLY-ACTIVITY-DATE.                                                          
002872      move '20061101'       to CAL-ADM-MNTH-ACTIVITY-DATE.                                                          
013570
002875      move '20061101'       to CAL-ADM-PRINT-CAL-MONTHLY-MNTH.                                                      
002876      move '20061031'       to CAL-ADM-PRINT-CAL-MONTHLY-ON.                                                        
013570
190700************************************************************                                                        
190700************************************************************                                                        
190700************************************************************                                                        
013570      move spaces               to date-fix-report.                                                                 
032300      write prt-record from date-fix-report.                                                                        
013570
180700      move brnch-control-office                                                                                     
180700                      to prt-BRNCH-CONTROL-OFFICE.                                                                  
180800      move brnch-control-group                                                                                      
180800                      to prt-BRNCH-CONTROL-GROUP.                                                                   
002761      move 'CAL-ADM-PRINT-YRLY-DATE-CYMD'       to type-date.
002761      move  CAL-ADM-PRINT-YRLY-DATE-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002770      move 'CAL-ADM-PRINT-YRLY-DAYS-BEFORE'     to type-date.
002770      move spaces                               to prt-date.                                                        
002770      move  CAL-ADM-PRINT-YRLY-DAYS-BEFORE      to prt-date(1:2).                                                   
032300      write prt-record from date-fix-report.                                                                        
013570
002771      move 'CAL-ADM-PRINT-YRLY-FROM-CYMD'       to type-date.
002771      move  CAL-ADM-PRINT-YRLY-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002780      move 'CAL-ADM-PRINT-YRLY-TO-CYMD'         to type-date.
002780      move  CAL-ADM-PRINT-YRLY-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002789      move 'CAL-ADM-PRINT-MNTH-DATE-CYMD'       to type-date.
002789      move  CAL-ADM-PRINT-MNTH-DATE-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002798      move 'CAL-ADM-PRINT-MNTH-DAYS-BEFORE'     to type-date.
002798      move  CAL-ADM-PRINT-MNTH-DAYS-BEFORE      to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002799      move 'CAL-ADM-PRINT-MNTH-FROM-CYMD'       to type-date.
002799      move  CAL-ADM-PRINT-MNTH-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002808      move 'CAL-ADM-PRINT-MNTH-TO-CYMD'         to type-date.
002808      move  CAL-ADM-PRINT-MNTH-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002817      move 'CAL-ADM-APPNT-WKLY-FROM-CYMD'       to type-date.
002817      move  CAL-ADM-APPNT-WKLY-FROM-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002826      move 'CAL-ADM-APPNT-WKLY-TO-CYMD'         to type-date.
002826      move  CAL-ADM-APPNT-WKLY-TO-CYMD          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002835      move 'CAL-ADM-DIARY-BROADCAST-CYMD'       to type-date.
002835      move  CAL-ADM-DIARY-BROADCAST-CYMD        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002842      move 'CAL-ADM-RECURRING-PRINT-DATE'       to type-date.
002842      move  CAL-ADM-RECURRING-PRINT-DATE        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002850      move 'CAL-ADM-SUMMARY-WHICH-QUARTER'      to type-date.
002770      move spaces                               to prt-date.                                                        
002850      move  CAL-ADM-SUMMARY-WHICH-QUARTER       to prt-date(1:1).                                                   
032300      write prt-record from date-fix-report.                                                                        
013570
002856      move 'CAL-ADM-SUMMARY-FROM-CYMD'          to type-date.
002856      move  CAL-ADM-SUMMARY-FROM-CYMD           to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002862      move 'CAL-ADM-SUMMARY-TO-CYMD'            to type-date.
002862      move  CAL-ADM-SUMMARY-TO-CYMD             to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002869      move 'CAL-ADM-INVOICE-SCHED-DATE'         to type-date.
002869      move  CAL-ADM-INVOICE-SCHED-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002870      move 'CAL-ADM-INVOICE-ACTUAL-DATE'        to type-date.
002870      move  CAL-ADM-INVOICE-ACTUAL-DATE         to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002871      move 'CAL-ADM-WKLY-ACTIVITY-DATE'         to type-date.
002871      move  CAL-ADM-WKLY-ACTIVITY-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002872      move 'CAL-ADM-MNTH-ACTIVITY-DATE'         to type-date.
002872      move  CAL-ADM-MNTH-ACTIVITY-DATE          to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002875      move 'CAL-ADM-PRINT-CAL-MONTHLY-MNTH'     to type-date.
002875      move  CAL-ADM-PRINT-CAL-MONTHLY-MNTH      to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570
002876      move 'CAL-ADM-PRINT-CAL-MONTHLY-ON'       to type-date.
002876      move  CAL-ADM-PRINT-CAL-MONTHLY-ON        to prt-date.                                                        
032300      write prt-record from date-fix-report.                                                                        
013570      move spaces        to date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
032300      write prt-record from date-fix-report.                                                                        
035920                                                                                                                    
035920      perform REWRITE-CALEN-RECORD thru                                                                             
035993              REWRITE-CALEN-RECORD-EXIT.                                                                            
002877       
183100      go to fix-each-branch.                                                                                        
036100
192600                                                                                     00258200
183100 FINISH-fixing-ALL-branches.                                                                                        
192700      SET FR-CLOSE TO TRUE                                                           00258400
506600      CALL TPSIO003 USING FILE-REQUEST tps-brnch-rec.                                00252700
192900      IF NOT A-SUCCESSFUL-OPERATION                                                  00258600
193000         MOVE 'BRNCH' TO FILE-NAME                                                   00258700
193100         MOVE 'TPS006-CLOSE' TO FILE-TEXT
193200*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                     00258900
193400         go to seecalen-common-exit                                                      00259100
193500       END-IF.                                                                       00259200
                                                                                           00248400
                                                         
000000 fix-the-dates-exit. exit.                                                                                          
036100
036100
036100
036100
036100
002880
036100
036100
036100
036100
036100
036200
