000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEEBILLS.
000300 AUTHOR. T S.
000400***************************************************************
000500*    LIST OF CLIENT BILLING/CONTRACT DATABASE                 *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEEBILLS.TXT"         00001000
001310***  SELECT PRT-FILE  ASSIGN TO "\TPS\TEST\SOURCE\SEEBILLS.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000*    RECORD CONTAINS 200 CHARACTERS.                              00001800
002000     RECORD CONTAINS 420 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002101        05  PRT-ACCT                          PIC  X(10).
002102        05  FILLER                            PIC  X(01).
002112        05  PRT-record-type                   PIC  X(02).
002113        05  FILLER                            PIC  X(01).
002112        05  PRT-SCHEDULE-FROM-DATE            PIC  X(08).
002113        05  FILLER                            PIC  X(01).
002114        05  PRT-SCHEDULE-TO-DATE              PIC  X(08).
002113        05  FILLER                            PIC  X(01).
002126        05  PRT-SCHEDULE-CODE                 PIC  X(03).                                                         
002127        05  FILLER                            PIC  X(01).                                                         
002128        05  PRT-SCHEDULE-VERSION              PIC  X(03).                                                         
002115        05  FILLER                            PIC  X(01).
002122        05  PRT-FIXED-FEE                     PIC  $,$$$,$$$.99.
002119        05  FILLER                            PIC  X(03).
002120        05  PRT-DESCRIPTION                   PIC  X(36).
002111        05  FILLER                            PIC  X(01).
017902        05  PRT-bill-contract-from-date       PIC  X(08).
002140        05  FILLER                            PIC  X(01).
017902        05  PRT-bill-contract-to-date         PIC  X(08).
002140        05  FILLER                            PIC  X(01).
002120*       05  PRT-first-NAME                    PIC  X(15).
002111*       05  FILLER                            PIC  X(01).
002112*       05  PRT-DISCOUNT-FROM-DATE            PIC  X(08).
002113*       05  FILLER                            PIC  X(01).
002114*       05  PRT-DISCOUNT-TO-DATE              PIC  X(08).
002113*       05  FILLER                            PIC  X(01).
002114*       05  PRT-DISCOUNT-AMOUNT               PIC  99.99.
002115*       05  FILLER                            PIC  X(01).
002103*       05  PRT-SUB-ACCT                      PIC  X(02).
002104*       05  FILLER                            PIC  X(01).
002107*       05  PRT-L50-COLLECT-1                 PIC  X(02).
002111*       05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-SETUP-AMT         PIC  $$,$$$.99.
002111        05  FILLER                            PIC  X(01).
002107*       05  PRT-L50-COLLECT-SETUP-DATE        PIC  X(08).
002111*       05  FILLER                            PIC  X(01).
002107*       05  PRT-L50-COLLECT-2                 PIC  X(02).
002111*       05  FILLER                            PIC  X(01).
002107*       05  PRT-L50-COLLECT-PAYROL-AMT        PIC  $$,$$$.99.
002111*       05  FILLER                            PIC  X(01).
002107*       05  PRT-L50-COLLECT-PAYROL-DATE       PIC  X(08).
002121        05  FILLER                            PIC  X(01).
002122*       05  PRT-MISC-AMOUNT                   PIC  $,$$$,$$$.99.
002111        05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
017703        05  PRT-BILL-INVOICE-FROM-DATE        PIC  X(08).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002116*       05  PRT-CHANGE-PASSWORD               PIC  X(10).
002117*       05  FILLER                            PIC  X(01).
002118*       05  PRT-CHANGE-DATE                   PIC  X(08).
002123*       05  FILLER                            PIC  X(01).
002124*       05  PRT-VARI-FIELD                    PIC  X(07).
002129*       05  FILLER REDEFINES PRT-VARI-FIELD.
002130*           10 PRT-STATE-CODE                 PIC  X(02).
002131*           10 FILLER                         PIC  X(01).
002132*           10 PRT-OFFICE-CODE                PIC  X(02).
002133*           10 PRT-GROUP-CODE                 PIC  X(02).
002134*       05  FILLER                            PIC  X(01).
002135*       05  PRT-TIE-BREAKER                   PIC  X(02).
002136*       05  FILLER                            PIC  X(01).
002137*       05  PRT-MISC-SUB-RECORD               PIC  X(02).
002138*       05  FILLER-pointer                   PIC X(01) value '>'.
002139*       05  PRT-PROCESSED-ON-DATE             PIC  X(08).
002140*       05  FILLER                            PIC  X(01).
002150*       05  PRT-MISC-DESCRIPTION              PIC  X(75).
003900        05  FILLER                            PIC  X(132).
009500
009600
009700 WORKING-STORAGE SECTION.
009800     COPY "TPSFILES.CPY".
009900     COPY "KEYVALUE.CPY".
010000 01  TPS-PROFL-REC.
010100     COPY "TPSPROFL.CPY".
010110 01  TPS-BILLS-REC.
010120     COPY "TPSBILLS.CPY".
010200 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
010210 01  TPSIO030                      PIC X(08) VALUE 'TPSIO030'.
010220
010221 01  UPDATE-CONTRACT-FLAG     PIC  9(01) VALUE 0.
010222     88 UPDATE-CONTRACT                  VALUE 1.
010230
010231 01  SAVE-THE-KEY             PIC  X(40).
010230
010231 01 PRINT-00-RECORD.
017902    05 PRT-ACCT-00                PIC X(10).
002111    05 FILLER                     PIC X(01).
017600    05 PRT-SCH-FROM-DATE          PIC X(08).
002111    05 FILLER                     PIC X(01).
015000    05 PRT-SCH-TO-DATE            PIC X(08).
002111    05 FILLER                     PIC X(01).
015000    05 PRT-CON-FROM-DATE          PIC X(08).
002111    05 FILLER                     PIC X(01).
014800    05 PRT-CON-TO-DATE            PIC X(08).
002111    05 FILLER                     PIC X(01).
017500    05 PRT-INV-FROM-DATE          PIC X(08).
002111    05 FILLER                     PIC X(01).
017500    05 PRT-INV-TO-DATE            PIC X(08).
002111    05 FILLER                     PIC X(01).
017703    05 PRT-PROCES-DATE            PIC X(08).
002111    05 FILLER                     PIC X(01).
010220
010230 01 PRINT-11-RECORD.
017902    05 PRT-ACCT-11                PIC X(08).
002111    05 FILLER                     PIC X(01).
017600    05 PRT-POSTAGE                PIC 9(03)V9(03) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
015000    05 PRT-CHK-COST               PIC 9(03)V9(03) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
015000    05 PRT-ENV-COST               PIC 9(03)V9(03) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
014800    05 PRT-METER                  PIC 9(03)V9(03) VALUE ZERO.
010230
010230 01 PRINT-50-RECORD.
017902    05 PRT-ACCT-50                PIC X(10).
002111    05 FILLER                     PIC X(01).
002107    05 PRT-SETUP-AMT              PIC S9(05)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
002114    05 PRT-DISCOUNT               PIC 9(02)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
002122    05 PRT-MISC-AMOUNT            PIC 9(03)V9(02)  VALUE ZERO.
010230
010230 01 PRINT-70-RECORD.
017902    05 PRT-ACCT-70                PIC X(10).
002111    05 FILLER                     PIC X(01).
017902    05 PRT-TYPE-70                PIC X(02).
002111    05 FILLER                     PIC X(01).
017500    05 PRT-70INV-FROM-DATE        PIC X(08).
002111    05 FILLER                     PIC X(01).
017500    05 PRT-70INV-TO-DATE          PIC X(08).
002111    05 FILLER                     PIC X(01).
017600    05 PRT-INV-TOTAL              PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
015000    05 PRT-A-COUNT                PIC 9(05) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
015000    05 PRT-A-COST                 PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
014800    05 PRT-B-COUNT                PIC 9(05) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
017500    05 PRT-B-COST                 PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
017500    05 PRT-DIRECT-COST            PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
017500    05 PRT-INDIRECT-COST          PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
017703    05 PRT-SETUP-FEE              PIC S9(07)V9(02) VALUE ZERO.
002111    05 FILLER                     PIC X(01).
010230
017550 01  INVOICE-TOTALS-COUNT           PIC  9(05) VALUE ZEROS.                                                       
017550 01  INVOICE-TOTALS-AMOUNT          PIC S9(07)V9(02) VALUE ZEROS.                                                 
010230
010240
010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010400  10 TPSdates    PIC X(08) VALUE 'TPSdates'.
010500  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010600 01  TPS-FILE-STATUS                       PIC XX.
010700     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
010800                                                                                                                  
010800                                                                                                                  
010800 01 THE-IDX                 PIC S9(04) COMP.                                                                      
010800 01 THE-TABLE               PIC  X(40) OCCURS 200 TIMES.                                                          
000000                                                                                     00008480
070400  01  WS-DATE-REQUEST.                                                               00008490
070500      05  WS-DATE-PARAM          PIC  9(02).                                         00008500
070600      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00008510
070700      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008520
070800          10  WS-DATE-REFORM         PIC  X(06).                                     00008530
070900          10  WS-DATE-EXTEND         PIC  X(04).                                     00008540
071000          10  FILLER                 PIC  X(10).                                     00008550
071100      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008560
071200          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00008570
071300          10  FILLER                 PIC  X(14).                                     00008580
071400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008590
071500          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00008600
071600          10  FILLER                 PIC  X(12).                                     00008610
071700      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008620
071800          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00008630
071900          10  FILLER                 PIC  X(10).                                     00008640
072000      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008650
072100          10  WS-TIME-PARM1          PIC  X(06).                                     00008660
072200          10  WS-TIME-PARM2          PIC  X(06).                                     00008670
072300          10  WS-TIME-EXTEND         PIC  X(08).                                     00008680
072400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008690
072500          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00008700
072600          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00008710
072700          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00008720
072800                                                            
010800                                                                                                                  
010800                                                                                                                  
010800 LINKAGE SECTION.
010900 01 TPS-PARAMETER.
011000    05 TPS-PARAMETER-VALUE PIC XX.
011100
011200 PROCEDURE DIVISION USING
011300                          TPS-PARAMETER.
011400 SEEBILLS-BEGIN.
011500    PERFORM OPEN-THE-FILES
011600       THRU OPEN-THE-FILES-EXIT.
026299    MOVE SPACES           TO PRT-RECORD.
011630
011700    PERFORM READ-THE-BILLS
011800       THRU READ-THE-BILLS-EXIT.
011601
011630 SEEBILLS-COMMON-EXIT.
011630
012000    PERFORM CLOSE-THE-FILES
012100       THRU CLOSE-THE-FILES-EXIT.
012200    GOBACK.                                                                                                       
012200    STOP RUN.
012300
012400 READ-THE-BILLS.
012300
012500    INITIALIZE TPS-BILLS-REC.
012300
012300
012511*   MOVE '0101000255'          TO BILL-ACCT-NO.
012512    MOVE '0101000651'          TO BILL-ACCT-NO.
012513    MOVE '00'                  TO BILL-SUB-ACCT.
012514    MOVE '70'                  TO BILL-RECORD-TYPE.
012553    MOVE ZEROS                 TO BILL-TIE-BREAKER
          MOVE 20151001              TO BILL-SCHEDULE-FROM-DATE
      *   MOVE '0101000800'           TO BILL-ACCT-NO
      *                                  THE-ACCOUNT.
012555
012600    MOVE F-PRIME TO FILE-KEY.
012700    MOVE F-START TO FILE-ACTION.
012800    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
012900    IF NO-RECORD-WAS-FOUND GO TO READ-THE-BILLS-EXIT.
013000    IF NOT A-SUCCESSFUL-OPERATION
013100       MOVE ' BILLS' TO FILE-NAME
013200       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
013300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
013400       GO TO READ-THE-BILLS-EXIT.
013500
013600 READ-ALL-BILLS-RECORDS.
013700    MOVE F-PRIME TO FILE-KEY.
013800    MOVE F-READ-NEXT TO FILE-ACTION.

013900    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
014000    IF END-OF-FILE-WAS-REACHED GO TO
                                READ-THE-BILLS-EXIT.
014100    IF NOT A-SUCCESSFUL-OPERATION
014200       MOVE ' BILLS' TO FILE-NAME
014300       MOVE 'SEEBILLS-BRN' TO FILE-TEXT
014400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014500       GO TO READ-THE-BILLS-EXIT.
014600
017500
014700    IF BILL-RECORD-TYPE = '00'
017902       MOVE BILL-ACCT-NO             TO PRT-ACCT-00
017600       MOVE BILL-SCHEDULE-FROM-DATE  TO PRT-SCH-FROM-DATE
015000       MOVE BILL-SCHEDULE-TO-DATE    TO PRT-SCH-TO-DATE
015000       MOVE BILL-CONTRACT-FROM-DATE  TO PRT-CON-FROM-DATE
014800       MOVE BILL-CONTRACT-TO-DATE    TO PRT-CON-TO-DATE
017500       MOVE BILL-INVOICE-FROM-DATE   TO PRT-INV-FROM-DATE
017500       MOVE BILL-INVOICE-TO-DATE     TO PRT-INV-TO-DATE
017703       MOVE BILL-PROCESSED-ON-DATE   TO PRT-PROCES-DATE
026100       WRITE PRT-RECORD FROM PRINT-00-RECORD
026101       MOVE SPACES                TO PRT-RECORD
014800       GO TO READ-ALL-BILLS-RECORDS.
017703
014700    IF BILL-RECORD-TYPE = '11'
017902       MOVE BILL-ACCT-NO             TO PRT-ACCT-11
017600       MOVE BILL-L11-CHECK-POSTAGE    TO PRT-POSTAGE
015000       MOVE BILL-L11-CHECK-STOCK-COST TO PRT-CHK-COST
015000       MOVE BILL-L11-CHECK-ENVELOPE-COST TO PRT-ENV-COST
014800       MOVE BILL-L11-CHECK-METER-USAGE   TO PRT-METER
026100       WRITE PRT-RECORD FROM PRINT-11-RECORD
026101       MOVE SPACES                TO PRT-RECORD
014800       GO TO READ-ALL-BILLS-RECORDS.
017500
014700    IF BILL-RECORD-TYPE = '50'
017902       MOVE BILL-ACCT-NO             TO PRT-ACCT-50
002107       MOVE BILL-L50-COLLECT-SETUP-AMOUNT
002107                                     TO PRT-SETUP-AMT
017902       MOVE BILL-L50-SET-UP-DISCOUNT
002114                                     TO PRT-DISCOUNT
002107       MOVE BILL-L50-MISC-HOURLY-RATE
002122                                     TO PRT-MISC-AMOUNT
026100       WRITE PRT-RECORD FROM PRINT-50-RECORD
026101       MOVE SPACES                TO PRT-RECORD
014800       GO TO READ-ALL-BILLS-RECORDS.
012511
017500
014700    IF BILL-RECORD-TYPE = '70'
017902       MOVE BILL-ACCT-NO             TO PRT-ACCT-70
017902       MOVE BILL-RECORD-TYPE         TO PRT-TYPE-70
017500       MOVE BILL-INVOICE-FROM-DATE   TO PRT-70INV-FROM-DATE
017500       MOVE BILL-INVOICE-TO-DATE     TO PRT-70INV-TO-DATE
017600       MOVE BILL-L70-INVOICE-TOTAL   TO PRT-INV-TOTAL
015000       MOVE BILL-L70-CAT-A-COUNT     TO PRT-A-COUNT
015000       MOVE BILL-L70-CAT-A-COST      TO PRT-A-COST
014800       MOVE BILL-L70-CAT-B-COUNT     TO PRT-B-COUNT
017500       MOVE BILL-L70-CAT-B-COST      TO PRT-B-COST
017500       MOVE BILL-L70-DIRECT-COST     TO PRT-DIRECT-COST
017500       MOVE BILL-L70-INDIRECT-COST   TO PRT-INDIRECT-COST
017703       MOVE BILL-L70-SET-UP-FEE      TO PRT-SETUP-FEE
026100       WRITE PRT-RECORD FROM PRINT-70-RECORD
026101       MOVE SPACES                TO PRT-RECORD
014800       GO TO READ-ALL-BILLS-RECORDS.
017703
017500
017500
017703*   IF BILL-ACCT-NO NOT = THE-ACCOUNT
012511*      GO TO READ-THE-BILLS-EXIT
017703*   ELSE
012511*      MOVE BILL-ACCT-NO  TO THE-ACCOUNT.
017921*   IF BILL-SCHEDULE-FROM-DATE = 20151001
017922*      CONTINUE.
017500
017903*   IF BILL-RECORD-TYPE = '70'
      *      PERFORM  PRINT-THE-RECORD THRU PRINT-THE-RECORD-EXIT
010800*     else
014800*      go to read-all-bills-records
010800*    end-if.
017703
014800     GO TO READ-ALL-BILLS-RECORDS.
017903

017550
017550
017550
017600 PRINT-THE-RECORD.
017700    MOVE SPACES                TO PRT-RECORD.                                                                     
017500*   IF BILL-CONTROL
      *        MOVE '>' TO FILLER-POINTER
      *        MOVE '>' TO FILLER-POINTER2
      *        end-if.
      *   go to skip-the-name.

014700*   IF bill-control
      *      go to skip-the-name
      *      continue
      *     else
014800*      go to read-all-bills-records                                                                               
014700*   IF THE-RECORD-TYPE < '50'
      *     end-if
      *    end-if.
                                                                                                                        
014602*   IF THE-ACCOUNT = ZEROS
017701*      PERFORM READ-THE-PROFL THRU
017702*              READ-THE-PROFL-EXIT
017703*      IF BILL-ACCT-NO = ZEROS
017704*         MOVE BILL-ACCT-NO  TO PRT-LAST-NAME
017705*        ELSE
017706*         MOVE CLNT-PROFILE-LAST-NAME
017707*                            TO PRT-LAST-NAME
017706*         MOVE CLNT-PROFILE-first-NAME
002120*                            to PRT-first-NAME
017710*       END-IF
017710*     ELSE
017704*      MOVE SPACES        TO PRT-LAST-NAME
017710*    END-IF.
017711 
017712*      IF BILL-RECORD-TYPE > '69'
017720*         MOVE BILL-L72-MAIL-PAC-CHARGE
017730*            TO  PRT-MISC-AMOUNT
017740*       END-IF.
017800
       skip-the-name.
017810       MOVE BILL-ACCT-NO
017900          TO  PRT-ACCT.
017901*      MOVE BILL-SUB-ACCT
017902*         TO  PRT-SUB-ACCT.
017903       IF BILL-RECORD-TYPE = '50'
017902*         MOVE bill-L50-SET-UP-DISC-FROM
002112*              TO PRT-DISCOUNT-FROM-DATE
017902*         MOVE bill-L50-SET-UP-DISC-TO
002114*              TO PRT-DISCOUNT-TO-DATE
017902*         MOVE bill-L50-SET-UP-DISCOUNT
002114*              TO PRT-DISCOUNT-AMOUNT
002107*         MOVE BILL-L50-misc-hourly-rate
002122*              TO PRT-MISC-AMOUNT
002107*         MOVE BILL-L50-COLLECT-SETUP
002107*              TO PRT-L50-COLLECT-1
002107*         MOVE BILL-L50-COLLECT-SETUP-ON
002107*              TO PRT-L50-COLLECT-SETUP-DATE
002107          MOVE BILL-L50-COLLECT-SETUP-AMOUNT
002107               TO PRT-L50-COLLECT-SETUP-AMT
017902*
002107*         MOVE BILL-L50-COLLECT-PAYROL
002107*              TO PRT-L50-COLLECT-2
002107*         MOVE BILL-L50-COLLECT-PAYROL-ON
002107*              TO PRT-L50-COLLECT-PAYROL-DATE
002107*         MOVE BILL-L50-COLLECT-PAYROL-AMOUNT
002107*              TO PRT-L50-COLLECT-PAYROL-AMT
017920*       END-IF.
017902       MOVE BILL-INVOICE-FROM-DATE TO PRT-BILL-INVOICE-FROM-DATE.
017903       MOVE BILL-RECORD-TYPE
017904          TO  PRT-RECORD-TYPE.
017905*      IF BILL-CONTROL
017906*         MOVE BILL-CONTROL-STATE-CODE
017910*           TO PRT-STATE-CODE
017911*         MOVE BILL-CONTROL-OFFICE-CODE
017912*           TO PRT-OFFICE-CODE
017913*         MOVE BILL-CONTROL-GROUP-CODE
017914*           TO PRT-GROUP-CODE
017915*        ELSE
017916*         MOVE BILL-SCHEDULE-CODE
017917*           TO PRT-SCHEDULE-CODE
017918*         MOVE BILL-SCHEDULE-VERSION
017919*           TO PRT-SCHEDULE-VERSION
017920
      *       END-IF.
017921
             MOVE BILL-CONTRACT-FROM-DATE
017922          TO  PRT-BILL-CONTRACT-FROM-DATE.
017923       MOVE BILL-CONTRACT-TO-DATE
017924          TO  PRT-BILL-CONTRACT-TO-DATE.
017921
017902       MOVE BILL-L01-SCHEDULE-DESCRIPTION
002114               TO PRT-DESCRIPTION.
017902       MOVE BILL-L01-FIXED-FEE
002114               TO PRT-FIXED-FEE.
017921       MOVE BILL-SCHEDULE-FROM-DATE
017922          TO  PRT-SCHEDULE-FROM-DATE.
017923       MOVE BILL-SCHEDULE-TO-DATE
017924          TO  PRT-SCHEDULE-TO-DATE.
017925
      *      MOVE BILL-TIE-BREAKER
017926*         TO  PRT-TIE-BREAKER.
017927*      MOVE BILL-MISCELLANEOUS-SUB-REC
017928*         TO  PRT-MISC-SUB-RECORD.
858533* fyi check process date (cym only) to see if all done.........
858534*     IF BILL-PROCESSED-ON-DATE(1:6) = TODAY-CYMD(1:6)                               00101480
858535*        GO TO SEARCH-FOR-CONTROL-RECORDS                                            00101490
017929*      MOVE BILL-PROCESSED-ON-DATE
017930*         TO  PRT-PROCESSED-ON-DATE.
017940*      MOVE BILL-CHANGE-PASSWORD
017950*         TO  PRT-CHANGE-PASSWORD.
017960*      MOVE BILL-CHANGE-DATE
017970*         TO  PRT-CHANGE-DATE.
026000
026001*     IF BILL-MISCELLANEOUS-CHARGE
026003*        MOVE BILL-L76-MISC-DESCRIP-LINE01
026004*               TO PRT-MISC-DESCRIPTION
026005*      END-IF.
026010
026100       WRITE PRT-RECORD.
026101       MOVE SPACES                TO PRT-RECORD.
017600 PRINT-THE-RECORD-EXIT. EXIT.

026310 READ-THE-BILLS-EXIT. EXIT.
026102
026560
026600 FILE-ERROR.
026700     CALL TPSIOERR USING FILE-REQUEST.
026800     CANCEL TPSIOERR.
026900 FILE-ERROR-EXIT. EXIT.
027000
027100
027200 OPEN-THE-FILES.
027300    OPEN OUTPUT PRT-FILE.
027400    MOVE F-PRIME    TO FILE-KEY.
027500    MOVE F-OPEN-I-O TO FILE-ACTION.
027600    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
027700    IF FILE-STATUS NOT = '00' AND '05'
027800       MOVE ' BILLS' TO FILE-NAME
027900       MOVE 'SEEBILLS-ORC' TO FILE-TEXT
028000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028100       GO TO SEEBILLS-COMMON-EXIT.
028110    MOVE F-PRIME    TO FILE-KEY.
028120    MOVE F-OPEN-I-O TO FILE-ACTION.
028130    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
028140    IF FILE-STATUS NOT = '00' AND '05'
028150       MOVE ' BILLS' TO FILE-NAME
028160       MOVE 'SEEBILLS-ORC' TO FILE-TEXT
028170       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028180       GO TO SEEBILLS-COMMON-EXIT.
028200 OPEN-THE-FILES-EXIT. EXIT.
028300
028301
028304
028310 READ-THE-PROFL.
028313    MOVE BILL-ACCT-NO     TO CLNT-PROFILE-ACCT-NO.
028314    MOVE BILL-SUB-ACCT    TO CLNT-PROFILE-SUB-ACCT.
028315    MOVE F-PRIME TO FILE-KEY.
028316    MOVE F-READ  TO FILE-ACTION.
028317    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028318    IF NO-RECORD-WAS-FOUND
028319       MOVE ZEROS         TO CLNT-PROFILE-ACCT-NO
028320                             CLNT-PROFILE-SUB-ACCT
028321       MOVE '?????????'   TO CLNT-PROFILE-LAST-NAME
028322       GO TO READ-THE-PROFL-EXIT
028323     END-IF.
028324    IF NOT A-SUCCESSFUL-OPERATION
028325       MOVE ' BILLS' TO FILE-NAME
028326       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
028327       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028328       GO TO SEEBILLS-COMMON-EXIT.
028329
028338 READ-THE-PROFL-EXIT. EXIT.
028339
028340
028341
028350
028400 CLOSE-THE-FILES.
028500    CLOSE PRT-FILE.
028600      MOVE F-PRIME TO FILE-KEY.
028700      MOVE F-CLOSE TO FILE-ACTION.
028810      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028900      IF NOT A-SUCCESSFUL-OPERATION
029000         MOVE ' BILLS' TO FILE-NAME
029100         MOVE 'SEEBILLS-CCK' TO FILE-TEXT
029200         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029300      END-IF.
029310      MOVE F-PRIME TO FILE-KEY.
029320      MOVE F-CLOSE TO FILE-ACTION.
029330      CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
029340      IF NOT A-SUCCESSFUL-OPERATION
029350         MOVE ' BILLS' TO FILE-NAME
029360         MOVE 'SEEBILLS-CCK' TO FILE-TEXT
029370         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029380      END-IF.
029400
029500 CLOSE-THE-FILES-EXIT. EXIT.
029600
029700
029710 DELETE-THE-RECORD.
029720    MOVE F-PRIME TO FILE-KEY.
029730    MOVE F-DELET TO FILE-ACTION.
029740    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
029760    IF NOT A-SUCCESSFUL-OPERATION
029770       MOVE ' BILLS' TO FILE-NAME
029780       MOVE 'SEEBILLS-DEL' TO FILE-TEXT
029790       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029791       GO TO SEEBILLS-COMMON-EXIT.
029792
029793    GO TO READ-ALL-BILLS-RECORDS.
029800
029800
075300
075300
075300
075300
075300
