000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEEBILLS.
000300 AUTHOR. T S.
000400***************************************************************
000500*    LIST OF CLIENT BILLING/CONTRACT DATABASE                 *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001200***  SELECT PRT-FILE  ASSIGN TO EXTERNAL LISTFILE                 00001000
001300     SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\SEEBILLS.TXT"         00001000
001310***  SELECT PRT-FILE  ASSIGN TO "\TPS\TEST\SOURCE\SEEBILLS.TXT"
001400         ORGANIZATION IS LINE SEQUENTIAL                          00001100
001500         FILE STATUS IS TPS-FILE-STATUS.
001600 DATA DIVISION.
001700 FILE SECTION.
001800 FD  PRT-FILE                                                     00001600
001900     LABEL RECORDS ARE OMITTED                                    00001700
002000*    RECORD CONTAINS 200 CHARACTERS.                              00001800
002000     RECORD CONTAINS 420 CHARACTERS.                              00001800
002100 01  PRT-RECORD.
002101        05  PRT-ACCT                          PIC  X(10).
002102*       05  FILLER                            PIC  X(01).
002138        05  FILLER-pointer2                  PIC X(01) value '>'.
002112        05  PRT-record-type                   PIC  X(02).
002113        05  FILLER                            PIC  X(01).
002112        05  PRT-SCHEDULE-FROM-DATE            PIC  X(08).
002113        05  FILLER                            PIC  X(01).
002114        05  PRT-SCHEDULE-TO-DATE              PIC  X(08).
002113        05  FILLER                            PIC  X(01).
002126        05  PRT-SCHEDULE-CODE                 PIC  X(03).                                                         
002127        05  FILLER                            PIC  X(01).                                                         
002128        05  PRT-SCHEDULE-VERSION              PIC  X(03).                                                         
002115        05  FILLER                            PIC  X(01).
002120        05  PRT-LAST-NAME                     PIC  X(20).
002111        05  FILLER                            PIC  X(01).
002120        05  PRT-first-NAME                    PIC  X(15).                                                         
002111        05  FILLER                            PIC  X(01).
002112        05  PRT-DISCOUNT-FROM-DATE            PIC  X(08).                                                         
002113        05  FILLER                            PIC  X(01).
002114        05  PRT-DISCOUNT-TO-DATE              PIC  X(08).
002113        05  FILLER                            PIC  X(01).
002114        05  PRT-DISCOUNT-AMOUNT               PIC  99.99.
002115        05  FILLER                            PIC  X(01).
002103*       05  PRT-SUB-ACCT                      PIC  X(02).
002104*       05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-1                 PIC  X(02).
002111        05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-SETUP-AMT         PIC  $$,$$$.99.                                                     
002111        05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-SETUP-DATE        PIC  X(08).                                                         
002111        05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-2                 PIC  X(02).
002111        05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-PAYROL-AMT        PIC  $$,$$$.99.                                                     
002111        05  FILLER                            PIC  X(01).
002107        05  PRT-L50-COLLECT-PAYROL-DATE       PIC  X(08).                                                         
002121        05  FILLER                            PIC  X(01).
002122        05  PRT-MISC-AMOUNT                   PIC  $,$$$,$$$.99.                                                  
002119*       05  FILLER                            PIC  X(03).
002111        05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
017703        05  PRT-BILL-INVOICE-FROM-DATE        PIC  X(08).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111*       05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002111        05  FILLER                            PIC  X(01).
002116        05  PRT-CHANGE-PASSWORD               PIC  X(10).
002117        05  FILLER                            PIC  X(01).
002118        05  PRT-CHANGE-DATE                   PIC  X(08).
002123        05  FILLER                            PIC  X(01).
002124        05  PRT-VARI-FIELD                    PIC  X(07).
002129        05  FILLER REDEFINES PRT-VARI-FIELD.
002130            10 PRT-STATE-CODE                 PIC  X(02).
002131            10 FILLER                         PIC  X(01).
002132            10 PRT-OFFICE-CODE                PIC  X(02).
002133            10 PRT-GROUP-CODE                 PIC  X(02).
002134        05  FILLER                            PIC  X(01).
002135        05  PRT-TIE-BREAKER                   PIC  X(02).
002136        05  FILLER                            PIC  X(01).
002137        05  PRT-MISC-SUB-RECORD               PIC  X(02).
002138        05  FILLER-pointer                   PIC X(01) value '>'.
002139        05  PRT-PROCESSED-ON-DATE             PIC  X(08).
002140        05  FILLER                            PIC  X(01).
002150        05  PRT-MISC-DESCRIPTION              PIC  X(75).
002140        05  FILLER                            PIC  X(01).
017902        05  PRT-bill-contract-from-date       PIC  X(08).
002140        05  FILLER                            PIC  X(01).
017902        05  PRT-bill-contract-to-date         PIC  X(08).
003900        05  FILLER                            PIC  X(132).
009500
009600
009700 WORKING-STORAGE SECTION.
009800     COPY "TPSFILES.CPY".
009900     COPY "KEYVALUE.CPY".
010000 01  TPS-PROFL-REC.
010100     COPY "TPSPROFL.CPY".
010110 01  TPS-BILLS-REC.
010120     COPY "TPSBILLS.CPY".
010200 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
010210 01  TPSIO030                      PIC X(08) VALUE 'TPSIO030'.
010220
010221 01  UPDATE-CONTRACT-FLAG     PIC  9(01) VALUE 0.
010222     88 UPDATE-CONTRACT                  VALUE 1.
010230
010231 01  SAVE-THE-KEY             PIC  X(40).
010230
010231 01  SAVE-THE-bill            PIC  X(420).                                                                          
010230
010230
010230
010230***** '1234567890123456789012345678901234567890'.
010230 01 kramer-misc-descrip-line-1.
010230    05 filler                pic  x(40) value
010230      'Obtain wire transfer instructions and co'.
010230    05 filler                pic  x(35) value
010230      'nfirm balances for all open items. '.                                                                        
010230 01 kramer-misc-descrip-line-2.
010230    05 filler                pic  x(40) value
010230      'Forward information via e-mail.         '.
010230    05 filler                pic  x(35) value
010230      '                                   '.                                                                        
010230 01 kramer-misc-descrip-line-3.
010230    05 filler                pic  x(40) value
010230      '                                        '.
010230    05 filler                pic  x(35) value
010230      '                                   '.                                                                        
010230
010230
010230
010230 01 test-amount          pic  s9(07)v9(02) value 3.25.                                                              
010230
010230
010230
010230 01 test-edit           pic  $$,$$$,$$9.99.                                                                         
010230
010230
010230
010230
017550 01  INVOICE-TOTALS-COUNT           PIC  9(05) VALUE ZEROS.                                                       
017550 01  INVOICE-TOTALS-AMOUNT          PIC S9(07)V9(02) VALUE ZEROS.                                                 
010230
010240
010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010400  10 TPSdates    PIC X(08) VALUE 'TPSdates'.
010500  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010600 01  TPS-FILE-STATUS                       PIC XX.
010700     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
010800                                                                                                                  
010800                                                                                                                  
010800 01 THE-IDX                 PIC S9(04) COMP.                                                                      
010800 01 THE-TABLE               PIC  X(40) OCCURS 200 TIMES.                                                          
000000                                                                                     00008480
070400  01  WS-DATE-REQUEST.                                                               00008490
070500      05  WS-DATE-PARAM          PIC  9(02).                                         00008500
070600      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00008510
070700      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008520
070800          10  WS-DATE-REFORM         PIC  X(06).                                     00008530
070900          10  WS-DATE-EXTEND         PIC  X(04).                                     00008540
071000          10  FILLER                 PIC  X(10).                                     00008550
071100      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008560
071200          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00008570
071300          10  FILLER                 PIC  X(14).                                     00008580
071400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008590
071500          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00008600
071600          10  FILLER                 PIC  X(12).                                     00008610
071700      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008620
071800          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00008630
071900          10  FILLER                 PIC  X(10).                                     00008640
072000      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008650
072100          10  WS-TIME-PARM1          PIC  X(06).                                     00008660
072200          10  WS-TIME-PARM2          PIC  X(06).                                     00008670
072300          10  WS-TIME-EXTEND         PIC  X(08).                                     00008680
072400      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00008690
072500          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00008700
072600          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00008710
072700          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00008720
072800                                                            
010800                                                                                                                  
010230
010230
012511*01  the-account              PIC  9(10) VALUE ZEROS.
012511*01  the-account              PIC  9(10) VALUE 0103000030.                                                        
012511*01  the-account              PIC  9(10) VALUE 0106000078.                                                        
012511 01  the-account              PIC  9(10) VALUE 0106000177.
012511
       01  the-record-type          PIC  9(02) VALUE 00.
      *01  the-record-type          PIC  9(02) VALUE 01.
      *01  the-record-type          PIC  9(02) VALUE 11.                                                                
      *01  the-record-type          PIC  9(02) VALUE 50.
      *01  the-record-type          PIC  9(02) VALUE 55.                                                                
012511*01  the-record-type          PIC  9(02) VALUE 70.                                                                
012511*01  the-record-type          PIC  9(02) VALUE 76.                                                                
010230
014600 01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 00.
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 01.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 03.
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 04.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 05.
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 06.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 07.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 08.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 09.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 10.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 11.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 12.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 13.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 14.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 15.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 16.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 17.                                                            
014600*01  WE-BE-REPAIRIN-THE-BILLS-FLAG  PIC  9(02) VALUE 18.                                                            
014600     88 WE-BE-REPAIRIN-THE-BILLS               VALUE 01.                                                            
014600     88 WE-BE-COUNTING-THE-BILLS               VALUE 02.                                                            
014600     88 WE-BE-UPDATING-CONTRACTS               VALUE 03.                                                            
014600     88 we-be-updating-indirect                value 04.                                                            
014600     88 we-be-updating-schedules               value 05.                                                            
014600     88 we-be-creating-a-bill                  value 06.                                                            
014600     88 we-be-repairin-kramer                  value 07.                                                            
014600     88 we-be-deleting-contract                value 08.                                                            
014600     88 we-be-repairin-kairos                  value 09.                                                            
014600     88 we-be-fixing-expired                   value 10.                                                            
014600     88 we-be-fixing-control                   value 11.                                                            
014600     88 we-be-repairin-spilker                 value 12.                                                            
014600     88 we-be-repairin-yarbrough               value 13.                                                            
014600     88 we-be-deleting-bill                    value 14.                                                            
014600     88 we-be-repairin-contract                value 15.                                                            
014600     88 we-be-creating-a-contract              value 16.                                                            
014600     88 we-be-repairin-sinclair                value 17.                                                            
011601     88 we-be-adding-new-contract-rate         value 18.                                                                      
010230
010800                                                                                                                  
010800 LINKAGE SECTION.
010900 01 TPS-PARAMETER.
011000    05 TPS-PARAMETER-VALUE PIC XX.
011100
011200 PROCEDURE DIVISION USING
011300                          TPS-PARAMETER.
011400 SEEBILLS-BEGIN.
011500    PERFORM OPEN-THE-FILES
011600       THRU OPEN-THE-FILES-EXIT.
026299    MOVE SPACES           TO PRT-RECORD.
011630
011700    PERFORM READ-THE-BILLS
011800       THRU READ-THE-BILLS-EXIT.
       go to SEEBILLS-COMMON-EXIT.
011601    if we-be-adding-new-contract-rate                                                                                         
011601       perform add-new-contract-rate thru                                                                                     
011601               add-new-contract-rate-exit                                                                                     
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
011601
014600    if we-be-creating-a-contract                                                                                    
011601       perform create-one-contract thru                                                                             
011601               create-one-contract-exit                                                                             
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
011601
014600    if we-be-repairin-contract                                                                                      
011601       perform repair-contract-to-date thru                                                                         
011601               repair-contract-to-date-exit                                                                         
011900*****  go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-deleting-bill                                                                                          
011601       perform delete-1-bill thru                                                                                   
011601               delete-1-bill-exit                                                                                   
011900*****  go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-repairin-yarbrough                                                                                     
011601       perform delete-3-create-2 thru                                                                               
011601               delete-3-create-2-exit                                                                               
011900*****  go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-repairin-spilker                                                                                       
011601       perform delete-2-create-1 thru                                                                               
011601               delete-2-create-1-exit                                                                               
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-repairin-sinclair                                                                                      
011601       perform delete-1-create-1 thru                                                                               
011601               delete-1-create-1-exit                                                                               
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-fixing-control                                                                                         
011601       perform alter-the-control-rec thru                                                                           
011601               alter-the-control-rec-exit                                                                           
011900**     go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-fixing-expired                                                                                         
011601       perform generate-new-contracts thru                                                                          
011601               generate-new-contracts-exit                                                                          
010800     end-if.                                                                                                      
011601
014600    if we-be-deleting-contract                                                                                      
011601       perform delete-1-contract thru                                                                               
011601               delete-1-contract-exit                                                                               
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    IF WE-BE-UPDATING-CONTRACTS                                                                                   
011601       PERFORM VARYING THE-IDX FROM 1 BY 1                                                                        
011601                 UNTIL THE-IDX > 200                                                                              
010800           MOVE HIGH-VALUES       TO THE-TABLE(THE-IDX)                                                           
010800         END-PERFORM                                                                                              
011601       MOVE ZEROS                 TO THE-IDX                                                                      
010800     END-IF.                                                                                                      
011601
014600    if we-be-updating-schedules                                                                                   
011601       perform varying the-idx from 1 by 1                                                                        
011601                 until the-idx > 200                                                                              
010800           move high-values       to the-table(the-idx)                                                           
010800         end-perform                                                                                              
011601       move zeros                 to the-idx                                                                      
010800     end-if.                                                                                                      
011601
014600    if we-be-repairin-kramer                                                                                        
011601       perform fix-kramers-stuff thru                                                                               
011601               fix-kramers-stuff-exit                                                                               
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
014600    if we-be-repairin-kairos                                                                                        
011601       perform fix-kairos-stuff thru                                                                                
011601               fix-kairos-stuff-exit                                                                                
011900       go to seebills-common-exit                                                                                   
010800     end-if.                                                                                                      
011601
011610 INITIALIZE-THE-BILLS-REC.                                                                                        
026299    MOVE SPACES           TO PRT-RECORD.                                                                          
011610    INITIALIZE TPS-BILLS-REC.
011620*** MOVE '1'              TO UPDATE-CONTRACT-FLAG.
011630
011700    PERFORM READ-THE-BILLS
011800       THRU READ-THE-BILLS-EXIT.
011630
014600    IF WE-BE-REPAIRIN-THE-BILLS                                                                                   
014600       MOVE '0'            TO WE-BE-REPAIRIN-THE-BILLS-FLAG                                                       
011610       GO TO INITIALIZE-THE-BILLS-REC                                                                             
014604     END-IF.                                                                                                      
011630
014600    IF WE-BE-COUNTING-THE-BILLS                                                                                   
017550       MOVE INVOICE-TOTALS-AMOUNT                                                                                 
002122            TO PRT-MISC-AMOUNT                                                                                    
026298       WRITE PRT-RECORD

026299       MOVE SPACES           TO PRT-RECORD                                                                        
014604     END-IF.                                                                                                      
011630
011900 SEEBILLS-COMMON-EXIT.
014600    IF WE-BE-UpDATING-CONTRACTS
014600       PERFORM create-new-CONTRACTS THRU
014600               create-new-CONTRACTS-EXIT
014600       MOVE '0'            TO WE-BE-REPAIRIN-THE-BILLS-FLAG                                                       
011610       GO TO INITIALIZE-THE-BILLS-REC                                                                             
014604     END-IF.                                                                                                      
011630
014600    if we-be-updating-schedules                                                                                   
014600       perform create-new-schedules thru
014600               create-new-schedules-exit
014600       move '0'            to we-be-repairin-the-bills-flag                                                       
011610       go to initialize-the-bills-rec                                                                             
014604     end-if.                                                                                                      
011630
011630
012000    PERFORM CLOSE-THE-FILES
012100       THRU CLOSE-THE-FILES-EXIT.
012200    GOBACK.                                                                                                       
012200    STOP RUN.
012300
012400 READ-THE-BILLS.
012500    INITIALIZE TPS-BILLS-REC.
012300
014600*   IF WE-BE-COUNTING-THE-BILLS
012511*      MOVE ZEROS                 TO the-account
012511*      MOVE '70'                  TO the-record-type
      *    END-IF.
012300
012300
012511*   MOVE '0101000255'          TO BILL-ACCT-NO.
012512*   MOVE '0101000867'          TO BILL-ACCT-NO.
012513    MOVE '00'                  TO BILL-SUB-ACCT.
012514*   MOVE '70'                  TO BILL-RECORD-TYPE.
012553*   MOVE ZEROS                 TO BILL-TIE-BREAKER
012554*                                 BILL-MISCELLANEOUS-SUB-REC.
          MOVE the-account           TO BILL-ACCT-NO.
      *   MOVE '0101000255'           TO BILL-ACCT-NO.

012511    MOVE the-record-type       TO BILL-RECORD-TYPE.
012555
012600    MOVE F-PRIME TO FILE-KEY.
012700    MOVE F-START TO FILE-ACTION.
012800    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
012900    IF NO-RECORD-WAS-FOUND GO TO READ-THE-BILLS-EXIT.
013000    IF NOT A-SUCCESSFUL-OPERATION
013100       MOVE ' BILLS' TO FILE-NAME
013200       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
013300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
013400       GO TO SEEBILLS-COMMON-EXIT.
013500
013600 READ-ALL-BILLS-RECORDS.
013700    MOVE F-PRIME TO FILE-KEY.
013800    MOVE F-READ-NEXT TO FILE-ACTION.

013900    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
014000    IF END-OF-FILE-WAS-REACHED GO TO
                                READ-THE-BILLS-EXIT.
014100    IF NOT A-SUCCESSFUL-OPERATION
014200       MOVE ' BILLS' TO FILE-NAME
014300       MOVE 'SEEBILLS-BRN' TO FILE-TEXT
014400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014500       GO TO SEEBILLS-COMMON-EXIT.
014600
017600*****************    GO TO PRINT-THE-RECORD.                                                                      
017500
014700*   IF BILL-RECORD-TYPE = '50'
017902*      if bill-contract-from-date = '20020701'
017600*         GO TO PRINT-THE-RECORD
015000*       END-IF
015000*    END-IF.
014800*   GO TO READ-ALL-BILLS-RECORDS.
             PERFORM  PRINT-THE-RECORD THRU PRINT-THE-RECORD-EXIT.
017500
014800     GO TO READ-ALL-BILLS-RECORDS.
017500
017903    IF BILL-RECORD-TYPE = '00'
             PERFORM  PRINT-THE-RECORD THRU PRINT-THE-RECORD-EXIT

017600*      go to print-the-record                                                                                       
010800      else
014800       go to read-all-bills-records
010800     end-if.
017703*   IF BILL-ACCT-NO  = the-account AND
017903*       BILL-RECORD-TYPE = '50'
      *      CONTINUE
      *   else
014800*          GO TO READ-ALL-BILLS-RECORDS.
017600
      *      GO TO  PRINT-THE-RECORD.

017902*       MOVE 20130501         TO BILL-CONTRACT-FROM-DATE.
      *                                  BILL-SCHEDULE-FROM-DATE.
017902*       MOVE 20150630         TO BILL-CONTRACT-TO-DATE.
      *                                  BILL-SCHEDULE-TO-DATE.
026529*       MOVE F-PRIME  TO FILE-KEY
026530*       MOVE F-REWRITE  TO FILE-ACTION
026531*       CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC
026533*       IF NOT A-SUCCESSFUL-OPERATION
026534*          MOVE ' BILLS' TO FILE-NAME
026535*          MOVE 'SEEBILLS-wri' TO FILE-TEXT
026536*          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026537*          GO TO SEEBILLS-COMMON-EXIT
017920*        END-IF
      *    if bill-control then
      *    PERFORM  PRINT-THE-RECORD THRU PRINT-THE-RECORD-EXIT.
014800     GO TO READ-ALL-BILLS-RECORDS.

017703*       IF BILL-ACCT-NO(1:4) NOT  = '0101'
012511*   if the-account not = BILL-ACCT-NO
017500
014600*      IF BILL-INVOICE-FROM-DATE(1:4)  not = '2014'
014800*         GO TO READ-ALL-BILLS-RECORDS
      *        END-IF.
017701*      PERFORM READ-THE-PROFL THRU
017702*              READ-THE-PROFL-EXIT
026298*      WRITE PRT-RECORD  FROM TPS-BILLS-REC.
017703
017902
017903*       IF BILL-RECORD-TYPE = '50'
017902*          IF bill-l50-set-up-disc-from = '20010630'
017902*             move '20010701'   to bill-l50-set-up-disc-from
017902*             move '20020630'   to bill-l50-set-up-disc-to
010800*           END-IF
010800*        END-IF
017902
026529        MOVE F-PRIME  TO FILE-KEY
026530        MOVE F-REWRITE  TO FILE-ACTION
026531        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC
026533        IF NOT A-SUCCESSFUL-OPERATION
026534           MOVE ' BILLS' TO FILE-NAME
026535           MOVE 'SEEBILLS-wri' TO FILE-TEXT
026536           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026537           GO TO SEEBILLS-COMMON-EXIT
017920         END-IF


             IF BILL-ACCT-NO = ZEROS
017704          MOVE BILL-ACCT-NO  TO PRT-LAST-NAME
017705         ELSE
017703        IF BILL-ACCT-NO(1:4) = '0101'
017706*         MOVE CLNT-PROFILE-LAST-NAME
017706*         MOVE CLNT-PROFILE-MDDL-INIT
017706          MOVE CLNT-PROFILE-FIRST-NAME
017707                         TO PRT-LAST-NAME
017705         ELSE
017706          MOVE CLNT-PROFILE-LAST-NAME
017707                         TO PRT-LAST-NAME
017710         END-IF
017710        END-IF.
017810       MOVE BILL-ACCT-NO  to PRT-ACCT.

             PERFORM  PRINT-THE-RECORD THRU PRINT-THE-RECORD-EXIT.
026298*      WRITE PRT-RECORD  FROM TPS-BILLS-REC
026298*      WRITE PRT-RECORD
026299*      MOVE SPACES           TO PRT-RECORD
014800       GO TO READ-ALL-BILLS-RECORDS.
011601**************************************************************
014600    if we-be-creating-a-bill                                                                                        
012511       if bill-acct-no not = the-account                                                                            
014800          go to read-all-bills-records                                                                              
014604        end-if                                                                                                      
012511       if bill-record-type not = the-record-type                                                                    
014800          go to read-all-bills-records                                                                              
014604        end-if                                                                                                      
017902       if bill-invoice-to-date not = '20031130'                                                                     
014800          go to read-all-bills-records                                                                              
014604        end-if                                                                                                      
011601       go to build-a-billing-record                                                                                 
014604     end-if.                                                                                                        
017500
017500
017500
017500
017903*   IF BILL-RECORD-TYPE = '55' or '56'                                                                              
011601*      go to build-a-billing-record
010800*    end-if.                                                                                                        
011601
011601
017500
014600    if we-be-updating-indirect                                                                                    
014600       perform we-be-fixin-indirect thru                                                                          
014600               we-be-fixin-indirect-exit                                                                          
014800       go to read-all-bills-records
014604     end-if.                                                                                                      
014600
017500
017500
014600    IF WE-BE-REPAIRIN-THE-BILLS                                                                                   
014600       PERFORM WE-BE-FIXIN-THE-BILLS THRU                                                                         
014600               WE-BE-FIXIN-THE-BILLS-EXIT                                                                         
014800       GO TO READ-ALL-BILLS-RECORDS
014604     END-IF.                                                                                                      
014600
014600    IF WE-BE-UPDATING-CONTRACTS                                                                                   
017903*orig  IF BILL-RECORD-TYPE = '50'                                                                                 
017903       IF BILL-RECORD-TYPE = '55' or '56'                                                                         
017902          if bill-contract-to-date = '20010630'                                                                   
011601             set THE-IDX up by 1                                                                                  
010800             MOVE bill-key       TO THE-TABLE(THE-IDX)                                                            
014604            END-IF                                                                                                
014800           GO TO READ-ALL-BILLS-RECORDS                                                                           
014604        END-IF                                                                                                    
014604     END-IF.                                                                                                      
014600
014600
014600    if we-be-updating-schedules                                                                                   
017903       if bill-record-type = '01'                                                                                 
017902***       if bill-schedule-to-date = '20020630'                                                                   
017902***       if bill-schedule-to-date = '20020731'                                                                   
017902          if bill-schedule-to-date = '20101231'                                                                   
011601             set the-idx up by 1                                                                                  
010800             move bill-key       to the-table(the-idx)                                                            
014604            end-if                                                                                                
014800           go to read-all-bills-records                                                                           
014604        end-if                                                                                                    
014604     end-if.                                                                                                      
014600
014600
017903*   if bill-record-type = '01'                                                                                                
017903*   if bill-record-type = '50'
      *****  go to skip-the-name
017600       go to print-the-record                                                                                                 
014600*     else
014800*      go to read-all-bills-records
014604*    end-if.
014600
014600
014600
014602    IF THE-ACCOUNT = ZEROS                                                                                        
             CONTINUE
            ELSE                                                                                                        
014602    IF BILL-ACCT-NO NOT = THE-ACCOUNT 
014800       GO TO READ-ALL-BILLS-RECORDS
014604      END-IF                                                                                                      
014604     END-IF.
014610
014700    IF THE-RECORD-TYPE = ZEROS                                                                                    
             CONTINUE
            ELSE                                                                                                        
014700    IF BILL-RECORD-TYPE NOT = THE-RECORD-TYPE                                                                     
014800       GO TO READ-ALL-BILLS-RECORDS
014604      END-IF                                                                                                      
015000     END-IF.
017500
017500
014602*   if bill-acct-no(1:4) not = '0106'                                                                               
014800*      go to read-all-bills-records
014604*     end-if.                                                                                                       
498200*     if bill-mail-pac-charge-bulk                                                   00062610
498300*        continue                                                                    00062620
498400*       else                                                                         00062630
498500*     if bill-mail-pac-charge-single                                                 00062640
498600*        continue                                                                    00062650
498700*       else                                                                         00062660
498500*     if bill-miscellaneous-charge                                                                                  
498600*        continue                                                                    00062650
498700*       else                                                                         00062660
014800*        go to read-all-bills-records                                                                               
498900*        end-if                                                                       00062680                      
498900*       end-if                                                                       00062680
499000*      end-if.      
017500
017500*   if bill-processed-on-date(1:6) not = '200901'                                                                   
014800*      go to read-all-bills-records
014604*     else                                                                                                          
017500*      move zeros          to bill-processed-on-date                                                                
029720*      move f-prime to file-key                                                                                     
026517*      move f-rewrite to file-action                                                                                
029740*      call tpsio030 using file-request tps-bills-rec                                                               
029760*      if not a-successful-operation                                                                                
029770*         move ' bills' to file-name                                                                                
029780*         move 'seebills-rew' to file-text                                                                          
029790*         perform file-error thru file-error-exit                                                                   
029791*         go to seebills-common-exit                                                                                
014604*       end-if                                                                                                      
029720*      move f-prime to file-key                                                                                     
012700*      move f-start to file-action                                                                                  
029740*      call tpsio030 using file-request tps-bills-rec                                                               
029760*      if not a-successful-operation                                                                                
029770*         move ' bills' to file-name                                                                                
029780*         move 'seebills-rew' to file-text                                                                          
029790*         perform file-error thru file-error-exit                                                                   
029791*         go to seebills-common-exit                                                                                
014604*       end-if                                                                                                      
014800*      go to read-all-bills-records
014604*    end-if.                                                                                                        
017500
017500
017500
017500
014602*   if bill-acct-no(1:4) not = '0106'                                                                               
014800*      go to read-all-bills-records
014604*     end-if.                                                                                                       
014700*   if the-record-type not = '70'                                                                                   
014800*      go to read-all-bills-records
014604*     end-if.                                                                                                       
017500*   if bill-invoice-from-date(1:6) not = '200812'                                                                   
014800*      go to read-all-bills-records
014604*     else                                                                                                          
029720*      move f-prime to file-key                                                                                     
029730*      move f-delet to file-action                                                                                  
029740*      call tpsio030 using file-request tps-bills-rec                                                               
029760*      if not a-successful-operation                                                                                
029770*         move ' bills' to file-name                                                                                
029780*         move 'seebills-del' to file-text                                                                          
029790*         perform file-error thru file-error-exit                                                                   
029791*         go to seebills-common-exit                                                                                
014604*       end-if                                                                                                      
014800*      go to read-all-bills-records
014604*    end-if.                                                                                                        
017500
017500
017500
017500
017500
017500
017500
017500
017500*   IF BILL-CONTROL                                                                                               
017500*      IF BILL-PROCESSED-ON-DATE = '20010405'                                                                     
017500*         IF BILL-L00-CHECK-ISSUANCE-DATE NOT NUMERIC                                                             
017500*            MOVE ZEROS        TO BILL-L00-CHECK-ISSUANCE-DATE                                                    
014604*          END-IF                                                                                                 
017500*         IF BILL-L00-CHECK-ISSUANCE-DATE = ZEROS                                                                 
017500*            MOVE '20010415'   TO BILL-L00-CHECK-ISSUANCE-DATE                                                    
026513*            MOVE 'NYTHSCA   '            TO BILL-CHANGE-PASSWORD                                                 
026514*            MOVE '20010424'              TO BILL-CHANGE-DATE                                                     
026516*            MOVE F-PRIME TO FILE-KEY                                                                             
026517*            MOVE F-REWRITE TO FILE-ACTION                                                                        
026518*            CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                       
026519*            IF NOT A-SUCCESSFUL-OPERATION                                                                        
026520*               MOVE ' BILLS' TO FILE-NAME                                                                        
029780*               MOVE 'SEEBILLS-REW' TO FILE-TEXT                                                                  
026522*               PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                           
026523*               GO TO SEEBILLS-COMMON-EXIT                                                                        
014604*             END-IF                                                                                              
012400*             GO TO READ-THE-BILLS                                                                                
014604*           END-IF                                                                                                
014604*       END-IF                                                                                                    
015000*     ELSE                                                                                                        
014800*      GO TO READ-ALL-BILLS-RECORDS                                                                               
014604*    END-IF.                                                                                                      
017500
017500
017500
014700*   IF THE-RECORD-TYPE = '50'                                                                                     
017500*      if bill-l50-set-up-discount(1:2) = '99'
017500*         continue
      *        else
014800*         GO TO READ-ALL-BILLS-RECORDS                                                                            
014604*     END-IF                                                                                                      
015000*    END-IF.
017500
014700*   IF THE-RECORD-TYPE = '76'                                                                                     
017500*      if bill-l76-repeat-this-expense
017500*         continue
      *        else
014800*         GO TO READ-ALL-BILLS-RECORDS                                                                            
014604*     END-IF                                                                                                      
015000*    END-IF.
017500
017500
014600    IF WE-BE-COUNTING-THE-BILLS                                                                                   
014600       IF BILL-INVOICE-FROM-DATE(1:6) NOT = '200101'                                                              
014800          GO TO READ-ALL-BILLS-RECORDS                                                                            
               END-IF                                                                                                   
017701       PERFORM READ-THE-PROFL THRU                                                                                
017702               READ-THE-PROFL-EXIT                                                                                
017703       IF BILL-ACCT-NO = ZEROS                                                                                    
017704          MOVE BILL-ACCT-NO  TO PRT-LAST-NAME                                                                     
017705         ELSE                                                                                                     
017703       IF BILL-ACCT-NO(1:4) = '0150'                                                                              
017706*         MOVE CLNT-PROFILE-LAST-NAME                                                                             
017706*         MOVE CLNT-PROFILE-MDDL-INIT                                                                             
017706          MOVE CLNT-PROFILE-FIRST-NAME                                                                            
017707                         TO PRT-LAST-NAME                                                                         
017705         ELSE                                                                                                     
017706          MOVE CLNT-PROFILE-LAST-NAME                                                                             
017707                         TO PRT-LAST-NAME                                                                         
017710         END-IF                                                                                                   
017710        END-IF                                                                                                    
017550       IF BILL-L70-INVOICE-TOTAL <  .00                                                                           
017705          CONTINUE                                                                                                
017710        END-IF                                                                                                    
017550       ADD 1                       TO INVOICE-TOTALS-COUNT                                                        
017550       ADD BILL-L70-INVOICE-TOTAL  TO INVOICE-TOTALS-AMOUNT                                                       
017810       MOVE BILL-ACCT-NO                                                                                          
017900               TO PRT-ACCT                                                                                        
017550       MOVE BILL-L70-INVOICE-TOTAL                                                                                
002122               TO PRT-MISC-AMOUNT                                                                                 
026298       WRITE PRT-RECORD                                                                                           
026299       MOVE SPACES           TO PRT-RECORD                                                                        
014800       GO TO READ-ALL-BILLS-RECORDS                                                                               
015000     END-IF.
017550
017550
017550*   if bill-l50-misc-hourly-rate = zeros                                                                          
017550*      continue                                                                                                   
015000*     else                                                                                                        
017550*   if bill-l50-misc-hourly-rate not numeric                                                                      
017550*      continue                                                                                                   
015000*    END-IF.
017550
017550
017550
017600 PRINT-THE-RECORD.
017700    MOVE SPACES                TO PRT-RECORD.                                                                     
017500    IF BILL-CONTROL
               MOVE '>' TO FILLER-POINTER
               MOVE '>' TO FILLER-POINTER2
               end-if.
          go to skip-the-name.

014700*   IF bill-control
      *      go to skip-the-name
      *      continue
      *     else
014800*      go to read-all-bills-records                                                                               
014700*   IF THE-RECORD-TYPE < '50'
      *     end-if
      *    end-if.
                                                                                                                        
014602    IF THE-ACCOUNT = ZEROS                                                                                        
017701       PERFORM READ-THE-PROFL THRU                                                                                
017702               READ-THE-PROFL-EXIT                                                                                
017703       IF BILL-ACCT-NO = ZEROS
017704          MOVE BILL-ACCT-NO  TO PRT-LAST-NAME
017705         ELSE
017706          MOVE CLNT-PROFILE-LAST-NAME
017707                             TO PRT-LAST-NAME
017706          MOVE CLNT-PROFILE-first-NAME                                                                            
002120                             to PRT-first-NAME                                                                    
017710        END-IF                                                                                                    
017710      ELSE                                                                                                        
017704       MOVE SPACES        TO PRT-LAST-NAME                                                                        
017710     END-IF.                                                                                                      
017711 
017712*      IF BILL-RECORD-TYPE > '69'
017720*         MOVE BILL-L72-MAIL-PAC-CHARGE
017730*            TO  PRT-MISC-AMOUNT
017740*       END-IF.
017800
       skip-the-name.
017810       MOVE BILL-ACCT-NO
017900          TO  PRT-ACCT.
017901*      MOVE BILL-SUB-ACCT
017902*         TO  PRT-SUB-ACCT.
017903       IF BILL-RECORD-TYPE = '50'                                                                                 
017902          MOVE bill-L50-SET-UP-DISC-FROM                                                                          
002112               TO PRT-DISCOUNT-FROM-DATE                                                                          
017902          MOVE bill-L50-SET-UP-DISC-TO                                                                            
002114               TO PRT-DISCOUNT-TO-DATE                                                                            
017902          MOVE bill-L50-SET-UP-DISCOUNT                                                                           
002114               TO PRT-DISCOUNT-AMOUNT                                                                             
002107          MOVE BILL-L50-misc-hourly-rate                                                                          
002122               TO PRT-MISC-AMOUNT                                                                                 
002107          MOVE BILL-L50-COLLECT-SETUP                                                                             
002107               TO PRT-L50-COLLECT-1                                                                               
002107          MOVE BILL-L50-COLLECT-SETUP-ON                                                                          
002107               TO PRT-L50-COLLECT-SETUP-DATE                                                                      
002107          MOVE BILL-L50-COLLECT-SETUP-AMOUNT                                                                      
002107               TO PRT-L50-COLLECT-SETUP-AMT                                                                       
017902                                                                                                                  
002107          MOVE BILL-L50-COLLECT-PAYROL                                                                            
002107               TO PRT-L50-COLLECT-2                                                                               
002107          MOVE BILL-L50-COLLECT-PAYROL-ON                                                                         
002107               TO PRT-L50-COLLECT-PAYROL-DATE                                                                     
002107          MOVE BILL-L50-COLLECT-PAYROL-AMOUNT                                                                     
002107               TO PRT-L50-COLLECT-PAYROL-AMT                                                                      
017920        END-IF.
017902       MOVE BILL-INVOICE-FROM-DATE TO PRT-BILL-INVOICE-FROM-DATE.
017903       MOVE BILL-RECORD-TYPE
017904          TO  PRT-RECORD-TYPE.
017905       IF BILL-CONTROL
017906          MOVE BILL-CONTROL-STATE-CODE
017910            TO PRT-STATE-CODE
017911          MOVE BILL-CONTROL-OFFICE-CODE
017912            TO PRT-OFFICE-CODE
017913          MOVE BILL-CONTROL-GROUP-CODE
017914            TO PRT-GROUP-CODE
017915         ELSE
017916          MOVE BILL-SCHEDULE-CODE
017917            TO PRT-SCHEDULE-CODE
017918          MOVE BILL-SCHEDULE-VERSION
017919            TO PRT-SCHEDULE-VERSION
017920
              END-IF.
017921
             MOVE BILL-CONTRACT-FROM-DATE
017922          TO  PRT-BILL-CONTRACT-FROM-DATE.
017923       MOVE BILL-CONTRACT-TO-DATE
017924          TO  PRT-BILL-CONTRACT-TO-DATE.
017921
             MOVE BILL-SCHEDULE-FROM-DATE
017922          TO  PRT-SCHEDULE-FROM-DATE.
017923       MOVE BILL-SCHEDULE-TO-DATE
017924          TO  PRT-SCHEDULE-TO-DATE.
017925
             MOVE BILL-TIE-BREAKER
017926          TO  PRT-TIE-BREAKER.
017927       MOVE BILL-MISCELLANEOUS-SUB-REC
017928          TO  PRT-MISC-SUB-RECORD.
858533* fyi check process date (cym only) to see if all done.........
858534*     IF BILL-PROCESSED-ON-DATE(1:6) = TODAY-CYMD(1:6)                               00101480
858535*        GO TO SEARCH-FOR-CONTROL-RECORDS                                            00101490
017929       MOVE BILL-PROCESSED-ON-DATE
017930          TO  PRT-PROCESSED-ON-DATE.
017940       MOVE BILL-CHANGE-PASSWORD
017950          TO  PRT-CHANGE-PASSWORD.
017960       MOVE BILL-CHANGE-DATE
017970          TO  PRT-CHANGE-DATE.
017550       MOVE BILL-L70-INVOICE-TOTAL
002122               TO PRT-MISC-AMOUNT
026000
026001      IF BILL-MISCELLANEOUS-CHARGE
026003         MOVE BILL-L76-MISC-DESCRIP-LINE01
026004                TO PRT-MISC-DESCRIPTION
026005       END-IF.
026010
026100       WRITE PRT-RECORD.
026101       MOVE SPACES                TO PRT-RECORD.
017600 PRINT-THE-RECORD-EXIT. EXIT.

026310 READ-THE-BILLS-EXIT. EXIT.
013400       GO TO SEEBILLS-COMMON-EXIT.
026102
026110      IF NOT BILL-MISCELLANEOUS-CHARGE
026200         GO TO READ-ALL-BILLS-RECORDS
026210       END-IF.
026220
026240      IF BILL-L76-MISC-DESCRIP-LINE02 = SPACES
026241         GO TO READ-ALL-BILLS-RECORDS
026242        ELSE
026243         MOVE BILL-L76-MISC-DESCRIP-LINE02
026250                TO PRT-MISC-DESCRIPTION
026280         WRITE PRT-RECORD
026290         MOVE SPACES           TO PRT-RECORD
026291       END-IF.
026292
026293      IF BILL-L76-MISC-DESCRIP-LINE03 = SPACES
026294         GO TO READ-ALL-BILLS-RECORDS
026295        ELSE
026296         MOVE BILL-L76-MISC-DESCRIP-LINE03
026297                TO PRT-MISC-DESCRIPTION
026298         WRITE PRT-RECORD
026299         MOVE SPACES           TO PRT-RECORD
026300       END-IF.
026301

        GO TO READ-ALL-BILLS-RECORDS.
026302
026400
026410
026420
026430
026441 EXAMINE-FOR-UPDATE.
026442     IF BILL-CONTRACT-TO-DATE NOT = '20000630'
026443        GO TO READ-ALL-BILLS-RECORDS
026450      END-IF.
026470
026472     MOVE BILL-KEY                TO SAVE-THE-KEY.
026494     MOVE '20000701'              TO BILL-CONTRACT-FROM-DATE.
026495     MOVE '20010630'              TO BILL-CONTRACT-TO-DATE.
026496
026513     MOVE 'NYTHSCA   '            TO BILL-CHANGE-PASSWORD.
026514     MOVE '20000718'              TO BILL-CHANGE-DATE.
026515
026516     MOVE F-PRIME TO FILE-KEY.
026517     MOVE F-WRITE TO FILE-ACTION.
026518     CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026519     IF NOT A-SUCCESSFUL-OPERATION
026520        MOVE ' BILLS' TO FILE-NAME
026521        MOVE 'SEEBILLS-DEL' TO FILE-TEXT
026522        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026523        GO TO SEEBILLS-COMMON-EXIT.
026525
026527     MOVE SAVE-THE-KEY            TO BILL-KEY.
026528
026529    MOVE F-PRIME TO FILE-KEY.
026530    MOVE F-START TO FILE-ACTION.
026531    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026533    IF NOT A-SUCCESSFUL-OPERATION
026534       MOVE ' BILLS' TO FILE-NAME
026535       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
026536       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026537       GO TO SEEBILLS-COMMON-EXIT.
026538
026540    MOVE F-PRIME TO FILE-KEY.
026541    MOVE F-READ-NEXT TO FILE-ACTION.
026542    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026544    IF NOT A-SUCCESSFUL-OPERATION
026545       MOVE ' BILLS' TO FILE-NAME
026546       MOVE 'SEEBILLS-BRN' TO FILE-TEXT
026547       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026548       GO TO SEEBILLS-COMMON-EXIT.
026549
026550     GO TO READ-ALL-BILLS-RECORDS.
026552
026553
026554
026555
026556
026557
026558
026559
026560
026600 FILE-ERROR.
026700     CALL TPSIOERR USING FILE-REQUEST.
026800     CANCEL TPSIOERR.
026900 FILE-ERROR-EXIT. EXIT.
027000
027100
027200 OPEN-THE-FILES.
027300    OPEN OUTPUT PRT-FILE.
027400    MOVE F-PRIME    TO FILE-KEY.
027500    MOVE F-OPEN-I-O TO FILE-ACTION.
027600    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
027700    IF FILE-STATUS NOT = '00' AND '05'
027800       MOVE ' BILLS' TO FILE-NAME
027900       MOVE 'SEEBILLS-ORC' TO FILE-TEXT
028000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028100       GO TO SEEBILLS-COMMON-EXIT.
028110    MOVE F-PRIME    TO FILE-KEY.
028120    MOVE F-OPEN-I-O TO FILE-ACTION.
028130    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
028140    IF FILE-STATUS NOT = '00' AND '05'
028150       MOVE ' BILLS' TO FILE-NAME
028160       MOVE 'SEEBILLS-ORC' TO FILE-TEXT
028170       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028180       GO TO SEEBILLS-COMMON-EXIT.
028200 OPEN-THE-FILES-EXIT. EXIT.
028300
028301
028304
028310 READ-THE-PROFL.
028313    MOVE BILL-ACCT-NO     TO CLNT-PROFILE-ACCT-NO.
028314    MOVE BILL-SUB-ACCT    TO CLNT-PROFILE-SUB-ACCT.
028315    MOVE F-PRIME TO FILE-KEY.
028316    MOVE F-READ  TO FILE-ACTION.
028317    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028318    IF NO-RECORD-WAS-FOUND
028319       MOVE ZEROS         TO CLNT-PROFILE-ACCT-NO
028320                             CLNT-PROFILE-SUB-ACCT
028321       MOVE '?????????'   TO CLNT-PROFILE-LAST-NAME
028322       GO TO READ-THE-PROFL-EXIT
028323     END-IF.
028324    IF NOT A-SUCCESSFUL-OPERATION
028325       MOVE ' BILLS' TO FILE-NAME
028326       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
028327       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
028328       GO TO SEEBILLS-COMMON-EXIT.
028329
028338 READ-THE-PROFL-EXIT. EXIT.
028339
028340
028341
028350
028400 CLOSE-THE-FILES.
028500    CLOSE PRT-FILE.
028600      MOVE F-PRIME TO FILE-KEY.
028700      MOVE F-CLOSE TO FILE-ACTION.
028810      CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.
028900      IF NOT A-SUCCESSFUL-OPERATION
029000         MOVE ' BILLS' TO FILE-NAME
029100         MOVE 'SEEBILLS-CCK' TO FILE-TEXT
029200         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029300      END-IF.
029310      MOVE F-PRIME TO FILE-KEY.
029320      MOVE F-CLOSE TO FILE-ACTION.
029330      CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
029340      IF NOT A-SUCCESSFUL-OPERATION
029350         MOVE ' BILLS' TO FILE-NAME
029360         MOVE 'SEEBILLS-CCK' TO FILE-TEXT
029370         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029380      END-IF.
029400
029500 CLOSE-THE-FILES-EXIT. EXIT.
029600
029700
029710 DELETE-THE-RECORD.
029720    MOVE F-PRIME TO FILE-KEY.
029730    MOVE F-DELET TO FILE-ACTION.
029740    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
029760    IF NOT A-SUCCESSFUL-OPERATION
029770       MOVE ' BILLS' TO FILE-NAME
029780       MOVE 'SEEBILLS-DEL' TO FILE-TEXT
029790       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
029791       GO TO SEEBILLS-COMMON-EXIT.
029792
029793    GO TO READ-ALL-BILLS-RECORDS.
029800
029800
029800
014600 we-be-fixin-indirect.                                                                                            
017903    if bill-record-type = '11'                                                                                    
014600       continue                                                                                                   
            else
014600       go to we-be-fixin-indirect-exit                                                                            
017920     end-if.                                                                                                      
017902                                                                                                                  
017902    if bill-contract-from-date = '20050101'                                                                       
017902       if bill-contract-to-date = '20101231'                                                                      
026472          move bill-key                to save-the-key                                                            
026495          move '20070531'              to bill-contract-to-date                                                   
026516          move f-prime to file-key                                                                                
026517          move f-write to file-action                                                                             
026518          call tpsio030 using file-request tps-bills-rec                                                          
026519          if not a-successful-operation                                                                           
026520             move ' bills' to file-name                                                                           
026521             move 'seebills-del' to file-text                                                                     
026522             perform file-error thru file-error-exit                                                              
026523             go to seebills-common-exit                                                                           
017920           end-if                                                                                                 
026527          move save-the-key            to bill-key                                                                
026516          move f-prime to file-key                                                                                
026517          move f-read  to file-action                                                                             
026518          call tpsio030 using file-request tps-bills-rec                                                          
026519          if not a-successful-operation                                                                           
026520             move ' bills' to file-name                                                                           
026521             move 'seebills-rd ' to file-text                                                                     
026522             perform file-error thru file-error-exit                                                              
026523             go to seebills-common-exit                                                                           
017920           end-if                                                                                                 
026529          move f-prime  to file-key                                                                               
026530          move f-delet  to file-action                                                                            
026531          call tpsio030 using file-request tps-bills-rec                                                          
026533          if not a-successful-operation                                                                           
026534             move ' bills' to file-name                                                                           
026535             move 'seebills-del' to file-text                                                                     
026536             perform file-error thru file-error-exit                                                              
026537             go to seebills-common-exit                                                                           
017920           end-if                                                                                                 
011900          go to seebills-common-exit                                                                              
017920        end-if                                                                                                    
017920     end-if.                                                                                                      
013500
017902                                                                                                                  
014600 we-be-fixin-indirect-exit. exit.                                                                                 
029900
029900
029900
014700                                                                                                                    
014600 WE-BE-FIXIN-THE-BILLS.                                                                                           
017903*   IF BILL-RECORD-TYPE = '50'
014600*      continue
017920*     else
017903    IF BILL-RECORD-TYPE = '55'
014600       continue                                                                                                   
017920      else                                                                                                        
014600       go to we-be-fixin-the-bills-exit                                                                           
017920*     END-IF
017920     END-IF.                                                                                                      
017902                                                                                                                  
014602    if bill-acct-no not = the-account 
014600       go to we-be-fixin-the-bills-exit                                                                           
           end-if.
017920
017902                                                                                                                  
017902*   if bill-contract-from-date = '20061001'                                                                       
026529*      MOVE F-PRIME  TO FILE-KEY                                                                                  
026530*      MOVE F-delet  TO FILE-ACTION
026531*      CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                             
026533*      IF NOT A-SUCCESSFUL-OPERATION                                                                              
026534*         MOVE ' BILLS' TO FILE-NAME                                                                              
026535*         MOVE 'SEEBILLS-del' TO FILE-TEXT                                                                        
026536*         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                 
026537*         GO TO SEEBILLS-COMMON-EXIT                                                                              
017920*       END-IF                                                                                                    
012400*      go to READ-THE-BILLS                                                                                       
017920*    END-IF.                                                                                                      
017902                                                                                                                  
017902    if bill-contract-from-date = '20060901'
017902       if bill-contract-to-date = '20070930'                                                                      
026472          move bill-key                to save-the-key                                                            
026495          move '20071001'              to bill-contract-from-date                                                   
026495          move '20080930'              to bill-contract-to-date                                                   
026516          move f-prime to file-key                                                                                
026517          move f-write to file-action                                                                             
026518          call tpsio030 using file-request tps-bills-rec                                                          
026519          if not a-successful-operation                                                                           
026520             move ' bills' to file-name                                                                           
026521             move 'seebills-del' to file-text                                                                     
026522             perform file-error thru file-error-exit                                                              
026523             go to seebills-common-exit                                                                           
017920           end-if                                                                                                 
026527*         move save-the-key            to bill-key                                                                
026516*         move f-prime to file-key                                                                                
026517*         move f-read  to file-action                                                                             
026518*         call tpsio030 using file-request tps-bills-rec                                                          
026519*         if not a-successful-operation                                                                           
026520*            move ' bills' to file-name                                                                           
026521*            move 'seebills-rd ' to file-text                                                                     
026522*            perform file-error thru file-error-exit                                                              
026523*            go to seebills-common-exit                                                                           
017920*          end-if                                                                                                 
026529*         move f-prime  to file-key                                                                               
026530*         move f-delet  to file-action                                                                            
026531*         call tpsio030 using file-request tps-bills-rec                                                          
026533*         if not a-successful-operation                                                                           
026534*            move ' bills' to file-name                                                                           
026535*            move 'seebills-del' to file-text                                                                     
026536*            perform file-error thru file-error-exit                                                              
026537*            go to seebills-common-exit                                                                           
017920*          end-if                                                                                                 
012400*         go to read-the-bills                                                                                    
017920        end-if                                                                                                    
017920     end-if.                                                                                                      
013500
014600    go to we-be-fixin-the-bills-exit.                                                                             
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
002107*   MOVE 060.00                TO BILL-L50-misc-hourly-rate.                                                      
029720*   GO TO REWRITE-THE-BILL-RECORD.                                                                                
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
002107    IF BILL-L50-COLLECT-SETUP-AMOUNT NOT NUMERIC                                                                  
002107       MOVE ZEROS              TO BILL-L50-COLLECT-SETUP-AMOUNT                                                   
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0101000644' OR                                                                             
012511                      '0101000677' OR                                                                             
012511                      '0101000685' OR                                                                             
012511                      '0101000719' OR                                                                             
012511                      '0101000743'                                                                                
002107       MOVE 125.00             TO BILL-L50-COLLECT-SETUP-AMOUNT                                                   
017920      ELSE                                                                                                        
002107       MOVE 250.00             TO BILL-L50-COLLECT-SETUP-AMOUNT                                                   
017920     END-IF.                                                                                                      
017902                                                                                                                  
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0101000750'                                                                                
012511       GO TO BILL-ACCT-NO-0101000750                                                                              
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0120000112'                                                                                
029720       GO TO REWRITE-THE-BILL-RECORD                                                                              
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0120000120'                                                                                
029720       GO TO REWRITE-THE-BILL-RECORD                                                                              
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0120000138'                                                                                
029720       GO TO REWRITE-THE-BILL-RECORD                                                                              
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0120000146'                                                                                
029720       GO TO REWRITE-THE-BILL-RECORD                                                                              
017920     END-IF.                                                                                                      
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
002107    IF BILL-L50-COLLECT-SETUP-ON NOT NUMERIC                                                                      
002107       MOVE ZEROS        TO BILL-L50-COLLECT-SETUP-ON                                                             
017920     END-IF.                                                                                                      
002107    IF BILL-L50-COLLECT-PAYROL-ON NOT NUMERIC                                                                     
002107       MOVE ZEROS        TO BILL-L50-COLLECT-PAYROL-ON                                                            
017920     END-IF.                                                                                                      
017902                                                                                                                  
017902                                                                                                                  
002107    IF BILL-L50-COLLECT-PAYROL-ON = ZEROS                                                                         
002107       MOVE 'N'                TO BILL-L50-COLLECT-PAYROL                                                         
017920      ELSE                                                                                                        
002107    IF BILL-L50-COLLECT-PAYROL = 'Y'                                                                              
002107       MOVE 'D'                TO BILL-L50-COLLECT-PAYROL                                                         
017920      END-IF                                                                                                      
017920     END-IF.                                                                                                      
017902                                                                                                                  
012511    IF BILL-ACCT-NO = '0101000602'                                                                                
002107       IF BILL-L50-COLLECT-SETUP-ON(1:2) = '20'                                                                   
002107          MOVE 'N'               TO BILL-L50-COLLECT-SETUP                                                        
002107          MOVE ZEROS             TO BILL-L50-COLLECT-SETUP-ON                                                     
002107          MOVE 'N'               TO BILL-L50-COLLECT-PAYROL                                                       
002107          MOVE ZEROS             TO BILL-L50-COLLECT-PAYROL-ON                                                    
017920        END-IF                                                                                                    
017920     END-IF.                                                                                                      
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
002107    IF BILL-L50-COLLECT-SETUP-ON = ZEROS                                                                          
002107       MOVE 'N'                TO BILL-L50-COLLECT-SETUP                                                          
017920      ELSE                                                                                                        
002107    IF BILL-L50-COLLECT-SETUP = 'Y'                                                                               
002107       MOVE 'D'                TO BILL-L50-COLLECT-SETUP                                                          
017920      END-IF                                                                                                      
017920     END-IF.                                                                                                      
017902                                                                                                                  
029720    GO TO REWRITE-THE-BILL-RECORD.                                                                                
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
012511 BILL-ACCT-NO-0101000750.                                                                                         
002107    MOVE '20010131'                TO BILL-L50-COLLECT-SETUP-ON.                                                  
029720    GO TO REWRITE-THE-BILL-RECORD.                                                                                
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
029720 REWRITE-THE-BILL-RECORD.                                                                                         
026472     MOVE BILL-KEY                TO SAVE-THE-KEY.
026496
026513     MOVE 'NYTHSCA   '            TO BILL-CHANGE-PASSWORD.
026514     MOVE '20010319'              TO BILL-CHANGE-DATE.                                                            
026515
026516     MOVE F-PRIME TO FILE-KEY.
026517     MOVE F-REWRITE TO FILE-ACTION.
026518     CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026519     IF NOT A-SUCCESSFUL-OPERATION
026520        MOVE ' BILLS' TO FILE-NAME
029780        MOVE 'SEEBILLS-REW' TO FILE-TEXT                                                                          
026522        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026523        GO TO SEEBILLS-COMMON-EXIT.
026525
026527     MOVE SAVE-THE-KEY            TO BILL-KEY.
026528
026529    MOVE F-PRIME TO FILE-KEY.
026530    MOVE F-START TO FILE-ACTION.
026531    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026533    IF NOT A-SUCCESSFUL-OPERATION
026534       MOVE ' BILLS' TO FILE-NAME
026535       MOVE 'SEEBILLS-SBR' TO FILE-TEXT
026536       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026537       GO TO SEEBILLS-COMMON-EXIT.
026538
026540    MOVE F-PRIME TO FILE-KEY.
026541    MOVE F-READ-NEXT TO FILE-ACTION.
026542    CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC.
026544    IF NOT A-SUCCESSFUL-OPERATION
026545       MOVE ' BILLS' TO FILE-NAME
026546       MOVE 'SEEBILLS-BRN' TO FILE-TEXT
026547       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
026548       GO TO SEEBILLS-COMMON-EXIT.
026549
013500
014600 WE-BE-FIXIN-THE-BILLS-EXIT. exit.
030000
030000
030000
030000
014600 WE-BE-FIXIN-CONTRACTS.                                                                                           
026514     IF BILL-CHANGE-DATE = '20010530'                                                                             
026550        GO TO READ-ALL-BILLS-RECORDS                                                                              
017920      END-IF.                                                                                                     
013500***************************************************************                                                   
011601     PERFORM VARYING THE-IDX FROM 1 BY 1                                                                          
010800              UNTIL THE-TABLE(THE-IDX) = HIGH-VALUES                                                              
010800         if bill-key = the-table(the-idx)                                                                         
026550            go to read-all-bills-records                                                                          
017920          end-if                                                                                                  
010800       end-perform.                                                                                               
013500***************************************************************                                                   
012511     IF BILL-ACCT-NO = '0101000552'                                                                               
017902        if bill-contract-to-date = '20010430'                                                                     
026527           perform table-the-key thru
026527                   table-the-key-exit                                                                             
026527           MOVE BILL-KEY            TO SAVE-THE-KEY                                                               
017902           move '20010501'          to bill-contract-from-date                                                    
017902           move '20021231'          to bill-contract-to-date                                                      
026513           MOVE 'NYTHSCA   '        TO BILL-CHANGE-PASSWORD                                                       
026514           MOVE '20010530'          TO BILL-CHANGE-DATE                                                           
026516           MOVE F-PRIME TO FILE-KEY                                                                               
026517           MOVE F-WRITE TO FILE-ACTION                                                                            
026518           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
026519           IF NOT A-SUCCESSFUL-OPERATION                                                                          
026520              MOVE ' BILLS' TO FILE-NAME                                                                          
026521              MOVE 'SEEBILLS-DEL' TO FILE-TEXT                                                                    
026522              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
026523              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
012500           INITIALIZE TPS-BILLS-REC                                                                               
026527           MOVE SAVE-THE-KEY   to bill-key                                                                        
012513           MOVE '00'           TO BILL-SUB-ACCT                                                                   
012514           MOVE '00'           TO BILL-RECORD-TYPE                                                                
012553           MOVE ZEROS          TO BILL-TIE-BREAKER                                                                
012554                                  BILL-MISCELLANEOUS-SUB-REC                                                      
017902                                  bill-contract-from-date                                                         
017902                                  bill-contract-to-date                                                           
012600           MOVE F-PRIME TO FILE-KEY                                                                               
012700           MOVE F-START TO FILE-ACTION                                                                            
012800           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
013000           IF NOT A-SUCCESSFUL-OPERATION                                                                          
013100              MOVE ' BILLS' TO FILE-NAME                                                                          
013200              MOVE 'SEEBILLS-SBR' TO FILE-TEXT                                                                    
013300              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
013400              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
013600           go to READ-ALL-BILLS-RECORDS                                                                           
017920         END-IF                                                                                                   
017920      END-IF.                                                                                                     
013500***************************************************************                                                   
012511     IF BILL-ACCT-NO = '0101000651'                                                                               
017902        if bill-contract-to-date = '20010524'                                                                     
026527           perform table-the-key thru
026527                   table-the-key-exit                                                                             
026527           MOVE BILL-KEY            TO SAVE-THE-KEY                                                               
017902           move '20010501'          to bill-contract-from-date                                                    
017902           move '20021231'          to bill-contract-to-date                                                      
026513           MOVE 'NYTHSCA   '        TO BILL-CHANGE-PASSWORD                                                       
026514           MOVE '20010530'          TO BILL-CHANGE-DATE                                                           
026516           MOVE F-PRIME TO FILE-KEY                                                                               
026517           MOVE F-WRITE TO FILE-ACTION                                                                            
026518           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
026519           IF NOT A-SUCCESSFUL-OPERATION                                                                          
026520              MOVE ' BILLS' TO FILE-NAME                                                                          
026521              MOVE 'SEEBILLS-DEL' TO FILE-TEXT                                                                    
026522              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
026523              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
017902           move '20000524'          to bill-contract-from-date                                                    
017902           move '20010430'          to bill-contract-to-date                                                      
026513           MOVE 'NYTHSCA   '        TO BILL-CHANGE-PASSWORD                                                       
026514           MOVE '20010530'          TO BILL-CHANGE-DATE                                                           
026516           MOVE F-PRIME TO FILE-KEY                                                                               
026517           MOVE F-WRITE TO FILE-ACTION                                                                            
026518           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
026519           IF NOT A-SUCCESSFUL-OPERATION                                                                          
026520              MOVE ' BILLS' TO FILE-NAME                                                                          
026521              MOVE 'SEEBILLS-DEL' TO FILE-TEXT                                                                    
026522              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
026523              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
026527           MOVE SAVE-THE-KEY        to bill-key                                                                   
026529           MOVE F-PRIME  TO FILE-KEY                                                                              
026530           MOVE F-delet  TO FILE-ACTION                                                                           
026531           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
026533           IF NOT A-SUCCESSFUL-OPERATION                                                                          
026534              MOVE ' BILLS' TO FILE-NAME                                                                          
026535              MOVE 'SEEBILLS-del' TO FILE-TEXT                                                                    
026536              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
026537              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
012500           INITIALIZE TPS-BILLS-REC                                                                               
026527           MOVE SAVE-THE-KEY   to bill-key                                                                        
012513           MOVE '00'           TO BILL-SUB-ACCT                                                                   
012514           MOVE '00'           TO BILL-RECORD-TYPE                                                                
012553           MOVE ZEROS          TO BILL-TIE-BREAKER                                                                
012554                                  BILL-MISCELLANEOUS-SUB-REC                                                      
017902                                  bill-contract-from-date                                                         
017902                                  bill-contract-to-date                                                           
012600           MOVE F-PRIME TO FILE-KEY                                                                               
012700           MOVE F-START TO FILE-ACTION                                                                            
012800           CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                         
013000           IF NOT A-SUCCESSFUL-OPERATION                                                                          
013100              MOVE ' BILLS' TO FILE-NAME                                                                          
013200              MOVE 'SEEBILLS-SBR' TO FILE-TEXT                                                                    
013300              PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                             
013400              GO TO SEEBILLS-COMMON-EXIT                                                                          
017920            END-IF                                                                                                
013600           go to READ-ALL-BILLS-RECORDS                                                                           
017920         END-IF                                                                                                   
017920      END-IF.                                                                                                     
013500***************************************************************                                                   
013500                                                                                                                  
013600     go to READ-ALL-BILLS-RECORDS.                                                                                
013500                                                                                                                  
013500***************************************************************                                                   
017902     if bill-contract-to-date = '20010630'                                                                        
026527        perform table-the-key thru                                                                                
026527                table-the-key-exit                                                                                
026527        MOVE BILL-KEY            TO SAVE-THE-KEY                                                                  
017902        move '20010701'          to bill-contract-from-date                                                       
017902        move '20021231'          to bill-contract-to-date                                                         
026513        MOVE 'NYTHSCA   '        TO BILL-CHANGE-PASSWORD                                                          
026514        MOVE '20010530'          TO BILL-CHANGE-DATE                                                              
026516        MOVE F-PRIME TO FILE-KEY                                                                                  
026517        MOVE F-WRITE TO FILE-ACTION                                                                               
026518        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026519        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026520           MOVE ' BILLS' TO FILE-NAME                                                                             
026521           MOVE 'SEEBILLS-DEL' TO FILE-TEXT                                                                       
026522           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026523           GO TO SEEBILLS-COMMON-EXIT                                                                             
017920         END-IF                                                                                                   
012500        INITIALIZE TPS-BILLS-REC                                                                                  
026527        MOVE SAVE-THE-KEY   to bill-key                                                                           
012513        MOVE '00'           TO BILL-SUB-ACCT                                                                      
012514        MOVE '00'           TO BILL-RECORD-TYPE                                                                   
012553        MOVE ZEROS          TO BILL-TIE-BREAKER                                                                   
012554                               BILL-MISCELLANEOUS-SUB-REC                                                         
017902                               bill-contract-from-date                                                            
017902                               bill-contract-to-date                                                              
012600        MOVE F-PRIME TO FILE-KEY                                                                                  
012700        MOVE F-START TO FILE-ACTION                                                                               
012800        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
013000        IF NOT A-SUCCESSFUL-OPERATION                                                                             
013100           MOVE ' BILLS' TO FILE-NAME                                                                             
013200           MOVE 'SEEBILLS-SBR' TO FILE-TEXT                                                                       
013300           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
013400           GO TO SEEBILLS-COMMON-EXIT                                                                             
017920         END-IF                                                                                                   
013600        go to READ-ALL-BILLS-RECORDS                                                                              
017920      END-IF.                                                                                                     
013500***************************************************************                                                   
                             
013600     go to READ-ALL-BILLS-RECORDS.                                                                                
012300
013500***************************************************************                                                   
012300
012300
026527 table-the-key.                                                                                                   
011601    PERFORM VARYING THE-IDX FROM 1 BY 1                                                                           
010800              UNTIL THE-TABLE(THE-IDX) = HIGH-VALUES                                                              
010800      end-perform.                                                                                                
010800    MOVE bill-key             TO the-table(the-idx).                                                              
026527 table-the-key-exit. exit.                                                                                        
012300
012300
012300
014600 create-new-CONTRACTS.
011601    PERFORM VARYING THE-IDX FROM 1 BY 1                                                                           
010800              UNTIL THE-TABLE(THE-IDX) = HIGH-VALUES                                                              
010800        MOVE THE-TABLE(THE-IDX)   TO BILL-KEY                                                                     
026540        MOVE F-PRIME TO FILE-KEY                                                                                  
026541        MOVE F-READ  TO FILE-ACTION
026542        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026544        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026545           MOVE ' BILLS' TO FILE-NAME                                                                             
026546           MOVE 'SEEBILLS-BRN' TO FILE-TEXT                                                                       
026547           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026548           GO TO SEEBILLS-COMMON-EXIT                                                                             
010800         END-IF                                                                                                   
017902                                                                                                                  
017902        move '20010701'         to bill-contract-from-date                                                        
017902        move '20020630'         to bill-contract-to-date                                                          
017902                                                                                                                  
017903        IF BILL-RECORD-TYPE = '50'                                                                                
017902           IF bill-l50-set-up-disc-from = '20010630'                                                              
017902              move '20010701'   to bill-l50-set-up-disc-from                                                      
017902              move '20020630'   to bill-l50-set-up-disc-to                                                        
010800            END-IF                                                                                                
010800         END-IF                                                                                                   
017902                                                                                                                  
026529        MOVE F-PRIME  TO FILE-KEY                                                                                 
026530        MOVE F-write  TO FILE-ACTION                                                                              
026531        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026533        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026534           MOVE ' BILLS' TO FILE-NAME                                                                             
026535           MOVE 'SEEBILLS-wri' TO FILE-TEXT                                                                       
026536           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026537           GO TO SEEBILLS-COMMON-EXIT                                                                             
017920         END-IF                                                                                                   
010800      END-PERFORM.                                                                                                
014600 create-new-CONTRACTS-EXIT. exit.                                                                                 
012300
012300
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
014600 DELETE-OLD-CONTRACTS.                                                                                            
011601    PERFORM VARYING THE-IDX FROM 1 BY 1                                                                           
010800              UNTIL THE-TABLE(THE-IDX) = HIGH-VALUES                                                              
010800        MOVE THE-TABLE(THE-IDX)   TO BILL-KEY                                                                     
026540        MOVE F-PRIME TO FILE-KEY                                                                                  
026541        MOVE F-READ  TO FILE-ACTION
026542        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026544        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026545           MOVE ' BILLS' TO FILE-NAME                                                                             
026546           MOVE 'SEEBILLS-BRN' TO FILE-TEXT                                                                       
026547           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026548           GO TO SEEBILLS-COMMON-EXIT                                                                             
010800         END-IF                                                                                                   
026529        MOVE F-PRIME  TO FILE-KEY                                                                                 
026530        MOVE F-delet  TO FILE-ACTION                                                                              
026531        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026533        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026534           MOVE ' BILLS' TO FILE-NAME                                                                             
026535           MOVE 'SEEBILLS-del' TO FILE-TEXT                                                                       
026536           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026537           GO TO SEEBILLS-COMMON-EXIT                                                                             
017920         END-IF                                                                                                   
010800      END-PERFORM.                                                                                                
014600 DELETE-OLD-CONTRACTS-EXIT. exit.                                                                                 
075300
075300
075300
075300
075300
075300
075300
075300
014600 create-new-schedules.                                                                                            
011601    PERFORM VARYING THE-IDX FROM 1 BY 1                                                                           
010800              UNTIL THE-TABLE(THE-IDX) = HIGH-VALUES                                                              
010800        MOVE THE-TABLE(THE-IDX)   TO BILL-KEY                                                                     
026540        MOVE F-PRIME TO FILE-KEY                                                                                  
026541        MOVE F-READ  TO FILE-ACTION
026542        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
026544        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026545           MOVE ' BILLS' TO FILE-NAME                                                                             
026546           MOVE 'SEEBILLS-BRN' TO FILE-TEXT                                                                       
026547           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026548           GO TO SEEBILLS-COMMON-EXIT                                                                             
010800         END-IF                                                                                                   
017902                                                                                                                  
017902        move '20110101'         to bill-schedule-from-date
017902        move '20151231'         to bill-schedule-to-date
017902                                                                                                                  
026529        MOVE F-PRIME  TO FILE-KEY                                                                                 
026530        MOVE F-write  TO FILE-ACTION                                                                              
026531        CALL TPSIO030 USING FILE-REQUEST TPS-BILLS-REC                                                            
              if it-was-a-duplicate-key                                                                                             
                 continue
017920          else                                                                                                                
026533        IF NOT A-SUCCESSFUL-OPERATION                                                                             
026534           MOVE ' BILLS' TO FILE-NAME                                                                             
026535           MOVE 'SEEBILLS-wri' TO FILE-TEXT                                                                       
026536           PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                                                
026537           GO TO SEEBILLS-COMMON-EXIT                                                                             
017920          end-if                                                                                                              
017920         END-IF                                                                                                   
010800      END-PERFORM.                                                                                                
014600 create-new-schedules-exit. exit.                                                                                 
012300
017902                                                                                                                  
017902                                                                                                                  
011601 build-a-billing-record.                                                                                            
017902    move '20031001'         to bill-invoice-from-date                                                               
017902    move '20031031'         to bill-invoice-to-date                                                                 
017902    move '20031117'         to bill-processed-on-date.                                                              
017902    move '20031117'         to bill-change-date.                                                                    
012554                                                                                                                    
017902    move '20031117'         to bill-l70-receive-date.                                                               
017902    move '00010'            to bill-l70-receive-number.                                                             
012555
017902    move 437.49             to bill-l70-invoice-total.                                                              
017902    move 31                 to bill-l70-cat-a-count.                                                                
017902    move 336.00             to bill-l70-cat-a-cost.                                                                 
017902    move 70                 to bill-l70-cat-b-count.                                                                
017902    move 62.35              to bill-l70-cat-b-cost.                                                                 
017902    move 9                  to bill-l70-junk-mail-count.                                                            
017902    move 1.35               to bill-l70-junk-mail-cost.                                                             
017902    move 0                  to bill-l70-mail-pac-count.                                                             
017902    move .00                to bill-l70-mail-pac-cost.                                                              
017902    move 19.22              to bill-l70-direct-cost.                                                                
017902    move 19.92              to bill-l70-indirect-cost.                                                              
012555
012600    move f-prime to file-key.
012700    move f-write to file-action.                                                                                    
012800    call tpsio030 using file-request tps-bills-rec.
013000    if not a-successful-operation
013100       move ' bills' to file-name
013200       move 'seebills-wri' to file-text
013300       perform file-error thru file-error-exit
013400       go to seebills-common-exit.
013500
014500    go to seebills-common-exit.                                                                                     
014600
075300
075300
075300
075300
011601 fix-kramers-stuff.                                                                                                 
026527    move '0101000438'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '70'                  to bill-record-type
          move '013001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20040201'            to bill-contract-from-date.                                                        
017902    move '20040229'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move 723.80             to bill-l70-invoice-total.                                                              
017902    move 1                  to bill-l70-misc-debit-count.
017902    move 187.50             to bill-l70-misc-debit-cost.
017902    move 0                  to bill-l70-misc-credit-count.
017902    move 0.00               to bill-l70-misc-credit-cost.
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-rewrite to file-action.                                                                                  
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-rew' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
026525****************************************************************                                                    
026527    move '0101000438'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct.
012514    move '90'                  to bill-record-type.
          move '013001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20040229'            to bill-miscellaneous-from-date.
017902    move '20040229'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026525****************************************************************                                                    
012514    move '76'                  to bill-record-type                                                                  
075300
          move 187.50                 to bill-l76-miscellaneous-charge.                                                   
          move '00'                   to bill-l76-misc-start-time(1:2).                                                   
          move '00'                   to bill-l76-misc-start-time(3:2).                                                   
          move '  '                   to bill-l76-misc-start-time-am-pm.                                                  
          move '00'                   to bill-l76-misc-stop-time(1:2).                                                    
          move '00'                   to bill-l76-misc-stop-time(3:2).                                                    
          move '  '                   to bill-l76-misc-stop-time-am-pm.                                                   
          move '00'                   to bill-l76-misc-elapsed-time-hh.                                                   
          move '00'                   to bill-l76-misc-elapsed-time-mm.                                                   
          move zeros                  to bill-l76-misc-hourly-rate                                                        
                                         bill-l76-misc-hourly-cost.                                                       
fld006    move ' '                    to bill-l76-repeat-expense.                                                       
008200                                                                                                                    
          move '0010'                 to bill-l76-misc-chart-lvl-1.                                                       
          move '00'                   to bill-l76-misc-chart-lvl-1-sub.                                                   
          move '0001'                 to bill-l76-misc-chart-lvl-2.                                                       
          move '0001'                 to bill-l76-misc-chart-lvl-3.                                                       
          move '0000'                 to bill-l76-misc-chart-lvl-4.                                                       
010230    move kramer-misc-descrip-line-1                                                                                 
                                      to bill-l76-misc-descrip-line01.                                                    
010230    move kramer-misc-descrip-line-2                                                                                 
                                      to bill-l76-misc-descrip-line02.                                                    
010230    move kramer-misc-descrip-line-3                                                                                 
                                      to bill-l76-misc-descrip-line03.                                                    
046100    move spaces                 to bill-l76-expand.                                                                 
                                                                                                                        
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-write to file-action.
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-rew' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026525****************************************************************                                                    
026527    move '0101000438'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct.
012514    move '90'                  to bill-record-type.
          move '013001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20040229'            to bill-miscellaneous-from-date.
017902    move '20040229'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-delet to file-action.                                                                                    
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-del' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 fix-kramers-stuff-exit. exit.                                                                                      
075300
075300
075300
011601 delete-1-contract.                                                                                                 
026527    move '0101001071'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct.
012514    move '50'                  to bill-record-type.
          move '019001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20040501'            to bill-miscellaneous-from-date.
017902    move '20040501'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-delet to file-action.                                                                                    
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-del' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 delete-1-contract-exit. exit.                                                                                      
075300
075300
075300
011601 fix-kairos-stuff.                                                                                                  
026527    move '0101001485'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '50'                  to bill-record-type
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20051101'            to bill-contract-from-date.                                                        
017902    move '20061031'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move zeros              to bill-l50-collect-setup-on.                                                           
017902    move 0.00               to bill-l50-collect-setup-amount.                                                       
017902    move 'N'                to bill-l50-collect-setup.      
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-rewrite to file-action.                                                                                  
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-rew' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
026527    move '0101001485'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '70'                  to bill-record-type
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20051101'            to bill-contract-from-date.                                                        
017902    move '20051130'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move 294.98             to bill-l70-invoice-total.                                                              
017902    move 0.00               to bill-l70-set-up-fee.         
075300
026516    move f-prime to file-key.                                                                                       
026517    move f-rewrite to file-action.                                                                                  
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-rew' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 fix-kairos-stuff-exit. exit.                                                                                       
075300
075300
075300
011601 generate-new-contracts.                                                                                            
026527**scott sinclair                                                                                                    
026527    move '0101002160'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct.
012514    move '50'                  to bill-record-type.
          move '027001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20091123'            to bill-miscellaneous-from-date.
017902    move '20100131'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rfx' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902**  move '20060101'            to bill-miscellaneous-from-date.
017902    move '20101031'            to bill-miscellaneous-to-date.
026516    move f-prime to file-key.                                                                                       
026517    move f-write to file-action.                                                                                    
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-wrx' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
017902    move '20100131'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-del' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 generate-new-contracts-exit. exit.                                                                                 
075300
075300
011601 create-one-contract.                                                                                               
026527    move '0106000151'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct.
012514    move '50'                  to bill-record-type.
          move '019001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20081101'            to bill-miscellaneous-from-date.
017902    move '20091031'            to bill-miscellaneous-to-date.
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rfx' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026527    move '0106000417'          to bill-acct-no.
017902    move '20090901'            to bill-miscellaneous-from-date.
017902    move '20100831'            to bill-miscellaneous-to-date.
026516    move f-prime to file-key.                                                                                       
026517    move f-write to file-action.                                                                                    
026518    call tpsio030 using file-request tps-bills-rec.                                                                 
026519    if not a-successful-operation                                                                                   
026520       move ' bills' to file-name                                                                                   
029780       move 'seebills-wrx' to file-text                                                                             
026522       perform file-error thru file-error-exit                                                                      
026523       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 create-one-contract-exit. exit.                                                                                    
075300
075300
075300
011601 alter-the-control-rec.                                                                                             
134800      initialize tps-bills-rec.                                                                                   
134900      move zeros                to bill-acct-no                                                                   
135000                                   bill-sub-acct                                                                  
135100                                   bill-record-type                                                               
135200                                   bill-contract-from-date                                                        
135300                                   bill-contract-to-date                                                          
135400                                   bill-tie-breaker                                                               
135500                                   bill-miscellaneous-sub-rec.                                                    
135600                                                                                                                  
135700      move 'NY'                 to bill-control-state-code.                                                       
135800      move '01'                 to bill-control-office-code.                                                        
135900      move '06'                 to bill-control-group-code.
136000                                                                                                                  
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
136000                                                                                                                  
649200      move bill-l00-scheduled-run-date-5                                             00078010
649300                              to bill-l00-scheduled-run-date-6.                      00078020
649400      move bill-l00-actual-run-date-5                                                00078030
649500                              to bill-l00-actual-run-date-6.                         00078040
649600      move bill-l00-scheduled-from-date-5                                            00078050
649700                              to bill-l00-scheduled-from-date-6.                     00078060
649800      move bill-l00-scheduled-to-date-5                                              00078070
649900                              to bill-l00-scheduled-to-date-6.                       00078080
650000                                                                                     00078090
650100      move bill-l00-scheduled-run-date-4                                             00078100
650200                              to bill-l00-scheduled-run-date-5.                      00078110
650300      move bill-l00-actual-run-date-4                                                00078120
650400                              to bill-l00-actual-run-date-5.                         00078130
650500      move bill-l00-scheduled-from-date-4                                            00078140
650600                              to bill-l00-scheduled-from-date-5.                     00078150
650700      move bill-l00-scheduled-to-date-4                                              00078160
650800                              to bill-l00-scheduled-to-date-5.                       00078170
650900                                                                                     00078180
651000      move bill-l00-scheduled-run-date-3                                             00078190
651100                              to bill-l00-scheduled-run-date-4.                      00078200
651200      move bill-l00-actual-run-date-3                                                00078210
651300                              to bill-l00-actual-run-date-4.                         00078220
651400      move bill-l00-scheduled-from-date-3                                            00078230
651500                              to bill-l00-scheduled-from-date-4.                     00078240
651600      move bill-l00-scheduled-to-date-3                                              00078250
651700                              to bill-l00-scheduled-to-date-4.                       00078260
651800                                                                                     00078270
651900      move bill-l00-scheduled-run-date-2                                             00078280
652000                              to bill-l00-scheduled-run-date-3.                      00078290
652100      move bill-l00-actual-run-date-2                                                00078300
652200                              to bill-l00-actual-run-date-3.                         00078310
652300      move bill-l00-scheduled-from-date-2                                            00078320
652400                              to bill-l00-scheduled-from-date-3.                     00078330
652500      move bill-l00-scheduled-to-date-2                                              00078340
652600                              to bill-l00-scheduled-to-date-3.                       00078350
652700                                                                                     00078360
652800      move bill-l00-scheduled-run-date-1                                             00078370
652900                              to bill-l00-scheduled-run-date-2.                      00078380
653000      move bill-l00-actual-run-date-1                                                00078390
653100                              to bill-l00-actual-run-date-2.                         00078400
653200      move bill-l00-scheduled-from-date-1                                            00078410
653300                              to bill-l00-scheduled-from-date-2.                     00078420
653400      move bill-l00-scheduled-to-date-1                                              00078430
653500                              to bill-l00-scheduled-to-date-2.                       00078440
653600                                                                                     00078450
653700      move bill-l00-scheduled-run-date                                               00078460
653800                              to bill-l00-scheduled-run-date-1.                      00078470
653900      move '20080320'         to bill-l00-actual-run-date-1.                         00078480
654000      move bill-l00-scheduled-from-date                                              00078490
654100                              to bill-l00-scheduled-from-date-1.                     00078500
654200      move bill-l00-scheduled-to-date                                                00078510
654300                              to bill-l00-scheduled-to-date-1.                       00078520
654400                                                                                                                  
655200      move zeros            to bill-l00-actual-run-date.                                                            
654600      move '20090101'       to bill-l00-scheduled-run-date.                          00078550                     
655900      move '20081201'       to bill-l00-scheduled-from-date.                                                        
656600      move '20081231'       to bill-l00-scheduled-to-date.                                                          
656700                                                                                     00078760
656800      move '20090115'         to bill-processed-on-date.                             00078770
656900      move spaces             to bill-base-expand-12.                                00078780
657000      move 'NYTHSCA   '       to bill-change-password.                               00078790
657100      move '20090115'         to bill-change-date.                                   00078800
657200                                                                                                                  
019800      move '20090115'         to bill-l00-post-for-peach-tree.
657200                                                                                                                    
142000      move '20090115'         to bill-l00-check-issuance-date.                                                      
142100                                                                                                                  
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-rewrite to file-action.
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
657600                                                 
657600                                                 
      **** if bill-l00-actual-run-date-1 = '20080320'                                                                     
656800     if bill-processed-on-date = '20090115'                                                                         
011601        go to alter-the-control-rec-exit                                                                            
790400      end-if.                                                                                                       
790400                                                                                                                  
790400                                                                                                                  
790400                                                                                                                  
790400                                                                                                                  
134800      initialize tps-bills-rec.                                                                                   
134900      move zeros                to bill-acct-no                                                                   
135000                                   bill-sub-acct                                                                  
135100                                   bill-record-type                                                               
135200                                   bill-contract-from-date                                                        
135300                                   bill-contract-to-date                                                          
135400                                   bill-tie-breaker                                                               
135500                                   bill-miscellaneous-sub-rec.                                                    
135600                                                                                                                  
135700      move 'NY'                 to bill-control-state-code.                                                       
135800      move '01'                 to bill-control-office-code.                                                        
135900      move '20'                 to bill-control-group-code.
136000                                                                                                                  
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
136000                                                                                                                  
649200      move bill-l00-scheduled-run-date-5                                             00078010
649300                              to bill-l00-scheduled-run-date-6.                      00078020
649400      move bill-l00-actual-run-date-5                                                00078030
649500                              to bill-l00-actual-run-date-6.                         00078040
649600      move bill-l00-scheduled-from-date-5                                            00078050
649700                              to bill-l00-scheduled-from-date-6.                     00078060
649800      move bill-l00-scheduled-to-date-5                                              00078070
649900                              to bill-l00-scheduled-to-date-6.                       00078080
650000                                                                                     00078090
650100      move bill-l00-scheduled-run-date-4                                             00078100
650200                              to bill-l00-scheduled-run-date-5.                      00078110
650300      move bill-l00-actual-run-date-4                                                00078120
650400                              to bill-l00-actual-run-date-5.                         00078130
650500      move bill-l00-scheduled-from-date-4                                            00078140
650600                              to bill-l00-scheduled-from-date-5.                     00078150
650700      move bill-l00-scheduled-to-date-4                                              00078160
650800                              to bill-l00-scheduled-to-date-5.                       00078170
650900                                                                                     00078180
651000      move bill-l00-scheduled-run-date-3                                             00078190
651100                              to bill-l00-scheduled-run-date-4.                      00078200
651200      move bill-l00-actual-run-date-3                                                00078210
651300                              to bill-l00-actual-run-date-4.                         00078220
651400      move bill-l00-scheduled-from-date-3                                            00078230
651500                              to bill-l00-scheduled-from-date-4.                     00078240
651600      move bill-l00-scheduled-to-date-3                                              00078250
651700                              to bill-l00-scheduled-to-date-4.                       00078260
651800                                                                                     00078270
651900      move bill-l00-scheduled-run-date-2                                             00078280
652000                              to bill-l00-scheduled-run-date-3.                      00078290
652100      move bill-l00-actual-run-date-2                                                00078300
652200                              to bill-l00-actual-run-date-3.                         00078310
652300      move bill-l00-scheduled-from-date-2                                            00078320
652400                              to bill-l00-scheduled-from-date-3.                     00078330
652500      move bill-l00-scheduled-to-date-2                                              00078340
652600                              to bill-l00-scheduled-to-date-3.                       00078350
652700                                                                                     00078360
652800      move bill-l00-scheduled-run-date-1                                             00078370
652900                              to bill-l00-scheduled-run-date-2.                      00078380
653000      move bill-l00-actual-run-date-1                                                00078390
653100                              to bill-l00-actual-run-date-2.                         00078400
653200      move bill-l00-scheduled-from-date-1                                            00078410
653300                              to bill-l00-scheduled-from-date-2.                     00078420
653400      move bill-l00-scheduled-to-date-1                                              00078430
653500                              to bill-l00-scheduled-to-date-2.                       00078440
653600                                                                                     00078450
653700      move bill-l00-scheduled-run-date                                               00078460
653800                              to bill-l00-scheduled-run-date-1.                      00078470
653900      move '20080320'         to bill-l00-actual-run-date-1.                         00078480
654000      move bill-l00-scheduled-from-date                                              00078490
654100                              to bill-l00-scheduled-from-date-1.                     00078500
654200      move bill-l00-scheduled-to-date                                                00078510
654300                              to bill-l00-scheduled-to-date-1.                       00078520
654400                                                                                                                  
655200      move zeros            to bill-l00-actual-run-date.                                                            
654600      move '20080401'       to bill-l00-scheduled-run-date.                          00078550                     
655900      move '20080301'       to bill-l00-scheduled-from-date.                                                        
656600      move '20080331'       to bill-l00-scheduled-to-date.                                                          
656700                                                                                     00078760
656800      move '20080320'         to bill-processed-on-date.                             00078770
656900      move spaces             to bill-base-expand-12.                                00078780
657000      move 'NYTHSCA   '       to bill-change-password.                               00078790
657100      move '20080320'         to bill-change-date.                                   00078800
657200                                                                                                                  
019800      move '20080320'         to bill-l00-post-for-peach-tree.
657200                                                                                                                    
142000      move '20080324'         to bill-l00-check-issuance-date.                                                      
142100                                                                                                                  
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-rewrite to file-action.
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
657600                                                 
           if bill-l00-actual-run-date-1 = '20080320'                                                                     
011601        go to alter-the-control-rec-exit                                                                            
790400      end-if.                                                                                                       
790400                                                                                                                  
790400                                                                                                                  
790400                                                                                                                  
790400                                                                                                                  
134800      initialize tps-bills-rec.                                                                                   
134900      move zeros                to bill-acct-no                                                                   
135000                                   bill-sub-acct                                                                  
135100                                   bill-record-type                                                               
135200                                   bill-contract-from-date                                                        
135300                                   bill-contract-to-date                                                          
135400                                   bill-tie-breaker                                                               
135500                                   bill-miscellaneous-sub-rec.                                                    
135600                                                                                                                  
135700      move 'NY'                 to bill-control-state-code.                                                       
135800      move '01'                 to bill-control-office-code.                                                        
135900      move '07'                 to bill-control-group-code.                                                         
136000                                                                                                                  
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
142100                                                                                                                  
649200      move bill-l00-scheduled-run-date-5                                             00078010
649300                              to bill-l00-scheduled-run-date-6.                      00078020
649400      move bill-l00-actual-run-date-5                                                00078030
649500                              to bill-l00-actual-run-date-6.                         00078040
649600      move bill-l00-scheduled-from-date-5                                            00078050
649700                              to bill-l00-scheduled-from-date-6.                     00078060
649800      move bill-l00-scheduled-to-date-5                                              00078070
649900                              to bill-l00-scheduled-to-date-6.                       00078080
650000                                                                                     00078090
650100      move bill-l00-scheduled-run-date-4                                             00078100
650200                              to bill-l00-scheduled-run-date-5.                      00078110
650300      move bill-l00-actual-run-date-4                                                00078120
650400                              to bill-l00-actual-run-date-5.                         00078130
650500      move bill-l00-scheduled-from-date-4                                            00078140
650600                              to bill-l00-scheduled-from-date-5.                     00078150
650700      move bill-l00-scheduled-to-date-4                                              00078160
650800                              to bill-l00-scheduled-to-date-5.                       00078170
650900                                                                                     00078180
651000      move bill-l00-scheduled-run-date-3                                             00078190
651100                              to bill-l00-scheduled-run-date-4.                      00078200
651200      move bill-l00-actual-run-date-3                                                00078210
651300                              to bill-l00-actual-run-date-4.                         00078220
651400      move bill-l00-scheduled-from-date-3                                            00078230
651500                              to bill-l00-scheduled-from-date-4.                     00078240
651600      move bill-l00-scheduled-to-date-3                                              00078250
651700                              to bill-l00-scheduled-to-date-4.                       00078260
651800                                                                                     00078270
651900      move bill-l00-scheduled-run-date-2                                             00078280
652000                              to bill-l00-scheduled-run-date-3.                      00078290
652100      move bill-l00-actual-run-date-2                                                00078300
652200                              to bill-l00-actual-run-date-3.                         00078310
652300      move bill-l00-scheduled-from-date-2                                            00078320
652400                              to bill-l00-scheduled-from-date-3.                     00078330
652500      move bill-l00-scheduled-to-date-2                                              00078340
652600                              to bill-l00-scheduled-to-date-3.                       00078350
652700                                                                                     00078360
652800      move bill-l00-scheduled-run-date-1                                             00078370
652900                              to bill-l00-scheduled-run-date-2.                      00078380
653000      move bill-l00-actual-run-date-1                                                00078390
653100                              to bill-l00-actual-run-date-2.                         00078400
653200      move bill-l00-scheduled-from-date-1                                            00078410
653300                              to bill-l00-scheduled-from-date-2.                     00078420
653400      move bill-l00-scheduled-to-date-1                                              00078430
653500                              to bill-l00-scheduled-to-date-2.                       00078440
653600                                                                                     00078450
653700      move bill-l00-scheduled-run-date                                               00078460
653800                              to bill-l00-scheduled-run-date-1.                      00078470
653900      move '20060115'         to bill-l00-actual-run-date-1.                         00078480
654000      move bill-l00-scheduled-from-date                                              00078490
654100                              to bill-l00-scheduled-from-date-1.                     00078500
654200      move bill-l00-scheduled-to-date                                                00078510
654300                              to bill-l00-scheduled-to-date-1.                       00078520
654400                                                                                                                  
655200      move zeros            to bill-l00-actual-run-date.                                                            
654600      move '20060301'       to bill-l00-scheduled-run-date.                          00078550                     
655900      move '20060201'       to bill-l00-scheduled-from-date.                                                        
656600      move '20060228'       to bill-l00-scheduled-to-date.                                                          
656700                                                                                     00078760
656800      move '20060324'         to bill-processed-on-date.                             00078770
656900      move spaces             to bill-base-expand-12.                                00078780
657000      move 'NYTHSCA   '       to bill-change-password.                               00078790
657100      move '20060324'         to bill-change-date.                                   00078800
657200                                                                                                                  
019800      move '20060101'         to bill-l00-post-for-peach-tree.                                                    
657200                                                                                                                    
142000      move '20060324'         to bill-l00-check-issuance-date.                                                      
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-rewrite to file-action.
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
657600                                                 
790400                                                                                                                  
729100      initialize tps-bills-rec.                                                      00086550
729200      move '01'                       to bill-record-type.                           00086560
729300      move '035'                      to bill-schedule-code.                         00086570
729400      move '001'                      to bill-schedule-version.                      00086580
729400      move '20050101'                 to bill-schedule-from-date.                    00086580
729400      move '20101231'                 to bill-schedule-to-date.                    00086580                         
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
142100                                                                                                                  
729300      move '036'                      to bill-schedule-code.                         00086570
729300      move '20060324'                 to bill-change-date.                           00086570
729300      move spaces              to bill-l01-schedule-description.
729300      move 'Fixed $1,125.00 V.1    '                                                                                
729300                               to bill-l01-schedule-description.
729300      move 1125.00             to bill-l01-fixed-fee.                                                               
654300                                                                                                                    
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-write to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
657600                                                 
011601 alter-the-control-rec-exit. exit.                                                                                  
075300
017902                                                                                                                  
657600                                                 
790400                                                                                                                  
011601 add-new-contract-rate.                                                                                                       
729100      initialize tps-bills-rec.                                                      00086550
729200      move '01'                       to bill-record-type.                           00086560
729300      move '035'                      to bill-schedule-code.                         00086570
729400      move '001'                      to bill-schedule-version.                      00086580
729400      move '20050101'                 to bill-schedule-from-date.                    00086580
729400      move '20101231'                 to bill-schedule-to-date.                    00086580                         
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
142100                                                                                                                  
729300      move '040'                      to bill-schedule-code.                         00086570
729300      move '20110101'                 to bill-change-date.                           00086570
729300      move spaces              to bill-l01-schedule-description.
729300      move 'Fixed $525.00 V.1      '                                                                                
729300                               to bill-l01-schedule-description.
729300      move  525.00             to bill-l01-fixed-fee.                                                               
729400      move '20110101'                 to bill-schedule-from-date.                    00086580
729400      move '20151231'                 to bill-schedule-to-date.                    00086580                         
654300                                                                                                                    
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-write to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
011601 add-new-contract-rate-exit. exit.                                                                                            
657600                                                 
075300
011601 delete-1-create-1.                                                                                                 
026527    move '0101002178'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '50'                  to bill-record-type
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20091124'            to bill-contract-from-date.                                                        
017902    move '20091130'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move '20100101'            to bill-contract-from-date.                                                        
017902    move '20101130'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-write               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902*   move '20060526'            to bill-contract-from-date.                                                        
017902*   move '20060525'            to bill-contract-to-date.                                                          
026529*   move f-prime               to file-key.                                                                         
026530*   move f-delet               to file-action.                                                                      
026531*   call tpsio030 using file-request tps-bills-rec.                                                                 
026533*   if not a-successful-operation                                                                                   
026534*      move ' bills' to file-name                                                                                   
026535*      move 'seebills-rk1' to file-text                                                                             
026536*      perform file-error thru file-error-exit                                                                      
026537*      go to seebills-common-exit                                                                                   
017920*    end-if.                                                                                                        
075300
011601 delete-1-create-1-exit. exit.                                                                                      
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
017902                                                                                                                  
011601 delete-2-create-1.                                                                                                 
026527    move '0106000078'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '50'                  to bill-record-type
          move '019001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20060526'            to bill-contract-from-date.                                                        
017902    move '20060525'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move '20060601'            to bill-contract-from-date.                                                        
017902    move '20070630'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-write               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move '20060526'            to bill-contract-from-date.                                                        
017902    move '20060525'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
017902    move '20060601'            to bill-contract-from-date.                                                        
017902    move '20060525'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 delete-2-create-1-exit. exit.                                                                                      
017902                                                                                                                  
017902                                                                                                                  
011601 delete-3-create-2.                                                                                                 
026527    move '0105000053'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '50'                  to bill-record-type
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20070309'            to bill-contract-from-date.                                                        
017902    move '20080331'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  make new contract
          move '019001'              to bill-miscellaneous-code.
          move '20070630'            to bill-l50-billing-start-date.                                                      
026529    move f-prime               to file-key.                                                                         
026530    move f-write               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  delete old contract                                                                              
          move '012001'              to bill-miscellaneous-code.
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  read old invoice 
026527    move '0105000053'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '70'                  to bill-record-type
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20070501'            to bill-contract-from-date.                                                        
017902    move '20070531'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  create new invoice                                                                               
          move '019001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move 250.00                to bill-l70-invoice-total.                                                         
017902    move zeros                 to bill-l70-mail-pac-count                                                         
017902                                  bill-l70-mail-pac-cost                                                            
017902                                  bill-l70-direct-cost                                                              
017902                                  bill-l70-indirect-cost.                                                           
026529    move f-prime               to file-key.                                                                         
026530    move f-write               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  delete old invoice                                                                               
          move '012001'              to bill-miscellaneous-code.
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300*****************  delete old postage                                                                               
026527    move '0105000053'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '72'                  to bill-record-type
          move '000000'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20070531'            to bill-contract-from-date.
017902    move '20070531'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
017902                                                                                                                  
011601 delete-3-create-2-exit. exit.                                                                                      
075300
075300
075300
011601 delete-1-bill.                                                                                                     
026527    move '0103000030'          to bill-acct-no.
012513    move '00'                  to bill-sub-acct                                                                     
012514    move '70'                  to bill-record-type
          move '000000'              to bill-miscellaneous-code.
          move '012001'              to bill-miscellaneous-code.
012553    move zeros                 to bill-tie-breaker                                                                  
012554                                  bill-miscellaneous-sub-rec.                                                     
017902    move '20070801'            to bill-contract-from-date.
017902    move '20070831'            to bill-contract-to-date.                                                          
026529    move f-prime               to file-key.                                                                         
026530    move f-read                to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
026529    move f-prime               to file-key.                                                                         
026530    move f-delet               to file-action.                                                                      
026531    call tpsio030 using file-request tps-bills-rec.                                                                 
026533    if not a-successful-operation                                                                                   
026534       move ' bills' to file-name                                                                                   
026535       move 'seebills-rk1' to file-text                                                                             
026536       perform file-error thru file-error-exit                                                                      
026537       go to seebills-common-exit                                                                                   
017920     end-if.                                                                                                        
075300
011601 delete-1-bill-exit. exit.                                                                                          
075300
075300
075300
011601 repair-contract-to-date.                                                                                           
729100      initialize tps-bills-rec.                                                      00086550
729200      move '01'                       to bill-record-type.                           00086560
729300      move '038'                      to bill-schedule-code.                         00086570
729400      move '001'                      to bill-schedule-version.                      00086580
729400      move '20080101'                 to bill-schedule-from-date.                    00086580
729400      move '19201231'                 to bill-schedule-to-date.                    00086580                         
026516     move f-prime to file-key.
026517     move f-read  to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rd ' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
142100                                                                                                                  
010231      move tps-bills-rec              to save-the-bill.                                                             
654300                                                                                                                    
729400      move '20101231'                 to bill-schedule-to-date.                    00086580                         
142100                                                                                                                  
026516     move f-prime to file-key.
026517     move f-write to file-action.                                                                                   
026518     call tpsio030 using file-request tps-bills-rec.
026519     if not a-successful-operation
026520        move ' billx' to file-name
029780        move 'seebills-rew' to file-text                                                                          
026522        perform file-error thru file-error-exit
026523        go to seebills-common-exit.
657600                                                 
010231     move save-the-bill         to tps-bills-rec.                                                                   
657600                                                 
026529     move f-prime               to file-key.                                                                        
026530     move f-delet               to file-action.                                                                     
026531     call tpsio030 using file-request tps-bills-rec.                                                                
026533     if not a-successful-operation                                                                                  
026534        move ' bills' to file-name                                                                                  
026535        move 'seebills-rk1' to file-text                                                                            
026536        perform file-error thru file-error-exit                                                                     
026537        go to seebills-common-exit                                                                                  
017920      end-if.                                                                                                       
657600                                                 
011601 repair-contract-to-date-exit. exit.                                                                                
075300
075300
075300
075300
075300
075300
