000100*$CALL
000200 IDENTIFICATION DIVISION.
000300 PROGRAM-ID. NEWIOCON.
000400***********************************************************
000500*                                                         * 
000600*     I/O PROGRAM FOR NEW RECON FILE WITH LARGER AMOUNTS  *
000700*                                                         *
000800***********************************************************
001100 ENVIRONMENT DIVISION.
001200*
001300 CONFIGURATION SECTION.
001400 SOURCE-COMPUTER. IBM-PC.
001500 OBJECT-COMPUTER. IBM-PC.
001600 SPECIAL-NAMES.
001700     ENVIRONMENT-VALUE IS ENV-VALUE
001800     ENVIRONMENT-NAME IS ENV-NAME.
001900*
002000 INPUT-OUTPUT SECTION.
002100 FILE-CONTROL.
002200*
002500    SELECT RECON-FILE ASSIGN TO DYNAMIC FILESPEC
002600        ORGANIZATION IS INDEXED
                   LOCK MODE IS AUTOMATIC
002700        ACCESS MODE IS DYNAMIC
002800        RECORD KEY IS RECON-KEY
002900        FILE STATUS IS FILE-STATUS-LOCAL.
003100*
003200 DATA DIVISION.
003300*
003400 FILE SECTION.
003500*
003600 FD  RECON-FILE
003700        RECORD CONTAINS 200 CHARACTERS
003800        LABEL RECORDS STANDARD.
003900 01  RECON-REC.
004000      05  RECON-KEY                PIC  X(28).
004100      05  FILLER                   PIC  X(172).
004300*
004400 WORKING-STORAGE SECTION.
004500*
004600 01  WS.
004700      COPY NEWRECON.CPY.
004900*
005000      05  WS-ACCOUNT-NUMBER         PIC  9(10).
005100      05  WS-ACCOUNT-BREAK-DOWN REDEFINES WS-ACCOUNT-NUMBER.
005200           10  WS-BRANCH-NUMBER     PIC  9(02).
005300           10  WS-ADMIN-NUMBER      PIC  9(02).
005400           10  WS-CLIENT-NUMBER     PIC  9(05).
005500           10  WS-CHECK-DIGIT       PIC  9(01).
005700*
005800 01  FILESPEC                    PIC X(80) VALUE
005900        'C:\TPS\PROD\FILES\NEWRECON.DAT'.
006000*
006100 01  TPS-PATHSPEC                PIC X(80).
006200 01  TPS-FILENAME                PIC X(08) VALUE 'TPSRECON'.
006300 01  TPS-SYSTEM-CODE             PIC X(03) VALUE 'TPS'.
006400*
006500 01  ENV-STR-NAME                PIC X(121).
006600 01  ENV-STR-VALUE               PIC X(121).
006700*
006800 01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
006900*
007200 01  NEXT-KEY-RECORD.
007300    05  FILLER                   PIC X(52) VALUE HIGH-VALUE.
007400    05  NEXT-KEY-NUMBER          PIC S9(9) COMP-4 VALUE 1.
007500    05  FILLER                   PIC X(167) VALUE LOW-VALUE.
007600*
007700 01  OPENED-FLAG                 PIC X.
007800*
009500*
009600 LINKAGE SECTION.
009800      COPY TPSFILES.CPY.
010000 01  LS.
010100      COPY NEWRECON.CPY.
010300*
010400 PROCEDURE DIVISION USING FILE-REQUEST LS.
010600*
010700 0001-STARTUP.
010710*     IF FILESPEC = SPACES
010720*        DISPLAY 'TPSRECONCILEFILE' UPON ENVIRONMENT-NAME
010730*        ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
010800*
010900    MOVE NEW-MONTHEND-KEY OF LS       TO RECON-KEY.
011000    MOVE '00'            TO FILE-STATUS-LOCAL FILE-STATUS.
011200*
011300    GO TO
011400******  0000-FR-CREATE
011500        0001-FR-OPEN-INPUT
011600        0002-FR-OPEN-I-O
011700        0003-FR-CLOSE
011800        0004-FR-WRITE
011900        0005-FR-REWRITE
012000        0006-FR-DELETE
012100        0007-FR-START
012200        0008-FR-GENERIC-START
012300        0009-FR-START-HIGH
012400        0010-FR-GENERIC-START-HIGH
012500        0011-FR-READ
012600        0012-FR-READ-NEXT
012700        0013-FR-READ-PREVIOUS
012800        DEPENDING
012900        ON FILE-ACTION.
013200*
013300 0000-FR-CREATE.
013500*
013600    GO TO 0017-RETURN.
013700*
014000 0001-FR-OPEN-INPUT.
014200      IF OPENED-FLAG = 'Y'
014300          GO TO 0017-RETURN.
014400*
014500      OPEN INPUT RECON-FILE
014600        IF FILE-STATUS-LOCAL = '00' or '05'
014700           MOVE 'Y' TO OPENED-FLAG.
014800        GO TO 0017-RETURN.
014900*
015400 0002-FR-OPEN-I-O.
015600      IF OPENED-FLAG = 'Y'
015700          GO TO 0017-RETURN.
015800*
015900      OPEN I-O RECON-FILE
016000        IF FILE-STATUS-LOCAL = '00' or '05'
016100           MOVE 'Y' TO OPENED-FLAG.
016200        GO TO 0017-RETURN.
016600*
016700 0003-FR-CLOSE.
017000    IF OPENED-FLAG = 'Y'
017100      CLOSE RECON-FILE
017200      MOVE 'N' TO OPENED-FLAG.
017400    GO TO 0017-RETURN.
017700*
017800 0004-FR-WRITE.
018000    WRITE RECON-REC FROM LS.
018300    GO TO 0017-RETURN.
018600*
018700 0005-FR-REWRITE.
019000    REWRITE RECON-REC FROM LS.
019200    GO TO 0017-RETURN.
019300* -====-
019400 0006-FR-DELETE.
019700    DELETE RECON-FILE RECORD.
019900    GO TO 0017-RETURN.
020200*
020300 0007-FR-START.
020500      START RECON-FILE KEY NOT LESS THAN RECON-KEY.
020700    GO TO 0017-RETURN.
021000*
021100 0008-FR-GENERIC-START.
021300*
021400    GO TO 0017-RETURN.
021700*
021800 0009-FR-START-HIGH.
021900*
022000    GO TO 0017-RETURN.
022100*
022400 0010-FR-GENERIC-START-HIGH.
022500*
          MOVE HIGH-VALUES TO RECON-KEY.
          START RECON-FILE KEY LESS THAN RECON-KEY.
022600    GO TO 0017-RETURN.
022700*
023000 0011-FR-READ.
023200    READ RECON-FILE INTO LS.
023400    GO TO 0017-RETURN.
023700*
023800 0012-FR-READ-NEXT.
024000      READ RECON-FILE
024100      NEXT RECORD INTO LS.
024400
024500      GO TO 0017-RETURN.
025300*
025400 0013-FR-READ-PREVIOUS.
025700
025700      READ RECON-FILE
025800      PREVIOUS RECORD INTO LS
025900    GO TO 0017-RETURN.
026200*
026300 0014-SAVE-GENERIC-KEY.
026400*
026500* -====-
026600*
029100*
029200 0017-RETURN.
029300*
029400    MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
029500*
029600    GOBACK.
029700*
