       IDENTIFICATION DIVISION.
       PROGRAM-ID. NEWIOCHK.
      ******************************************************************
      *    CREATE NEW CHECK FILE WITH LARGER AMOUNTS.                  *
      ******************************************************************

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PC.
       OBJECT-COMPUTER. IBM-PC.
       SPECIAL-NAMES.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT CHECK-FILE ASSIGN TO DYNAMIC FILESPEC
               ORGANIZATION IS INDEXED
*******************LOCK MODE IS AUTOMATIC
                   LOCK MODE IS MANUAL
                   WITH LOCK ON MULTIPLE RECORDS
               ACCESS MODE IS DYNAMIC
               RECORD KEY IS NEW-KEY OF FS
***************ALTERNATE RECORD KEY IS CHECK-KEY OF FS WITH DUPLICATES
               FILE STATUS IS FILE-STATUS-LOCAL.
       DATA DIVISION.
       FILE SECTION.
       FD  CHECK-FILE
               LABEL RECORDS STANDARD.
       01  FS.
           COPY "NEWCHECK.CPY".
		   
       WORKING-STORAGE SECTION.
       01  FILESPEC                    PIC X(80) VALUE 
	          "C:\TPS\PROD\FILES\NEWCHECK.DAT".
       01  FILE-STATUS-LOCAL           PIC XX VALUE ZERO.
      *
      *                         :---------------------------------------
      * ------------------------: Save next available key so we can
      *                         : automatically assign prime keys.
      *                         :---------------------------------------
       01  NEXT-KEY-RECORD.
           05  FILLER                  PIC X(52) VALUE HIGH-VALUE.
           05  NEXT-KEY-NUMBER         PIC S9(9) COMP-4 VALUE 1.
           05  FILLER                  PIC X(167) VALUE LOW-VALUE.
       01  OPENED-FLAG                 PIC X.
       01  GENERIC-FLAG                PIC X.
       01  GENERIC-KEY-LENGTH-LV       PIC S9(4) COMP-5.
       01  GENERIC-KEY-LENGTH          PIC S9(4) COMP-5.
       01  GENERIC-KEY.
           05  GENERIC-KEY-BYTE OCCURS 50 INDEXED BY GKDEX
                                       PIC X.
       01  GENERIC-TEST.
           05  GENERIC-TEST-BYTE OCCURS 50 INDEXED BY GTDEX
                                       PIC X.
      *
      *                         :---------------------------------------
      * ------------------------: Table to pass back clear text
      *                         : message following file operations.
      *                         :---------------------------------------
      *
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       LINKAGE SECTION.
      *
               COPY TPSFILES.CPY.
       01 LS.
               COPY "NEWCHECK.CPY".
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       PROCEDURE DIVISION USING FILE-REQUEST LS.
      *%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      *
       0001-STARTUP.
      *                         :---------------------------------------
      * ------------------------: Load the keys, initialize variables.
      *                         :---------------------------------------
      *
      *    IF FILESPEC = SPACES
      *     DISPLAY "TPSCHECKFILE" UPON ENVIRONMENT-NAME
      *     ACCEPT FILESPEC FROM ENVIRONMENT-VALUE.
      *    MOVE '00' TO FILE-STATUS-LOCAL FILE-STATUS.
      *
      *                         :---------------------------------------
      * ------------------------: Perform the requested operation.
      *                         :---------------------------------------
      *

          IF FR-READ-WITH-LOCK
             GO TO 0014-FR-READ-WITH-LOCK
          END-IF.

          IF FR-UNLOCK
             GO TO UNLOCK-THE-FILE
          END-IF.

           GO TO
               0003-FR-OPEN-INPUT
               0004-FR-OPEN-I-O
               0005-FR-CLOSE
               0006-FR-WRITE
               0007-FR-REWRITE
               0008-FR-DELETE
               0009-FR-START
               0009-FR-START
               0010-FR-START-HIGH
               0010-FR-START-HIGH
               0011-FR-READ
               0012-FR-READ-NEXT
               0013-FR-READ-PREVIOUS
               0014-FR-READ-WITH-LOCK
               0015-FR-OPEN-WITH-LOCK
               0016-FR-UNLOCK
               0017-FR-START-LOW
               DEPENDING
               ON FILE-ACTION.
      * -====-
       0002-FR-CREATE.
      *                         :---------------------------------------
      * ------------------------: Create the file & then open it I/O.
      *                         : If not a CREATE request,
      *                         :   return 'Invalid function' status.
      *                         :---------------------------------------
      *
           IF FR-CREATE

             OPEN OUTPUT CHECK-FILE
             IF FILE-STATUS-LOCAL = '00'
                   OR '41'
               WRITE FS FROM
                   NEXT-KEY-RECORD
                   INVALID KEY
                 CONTINUE
               END-WRITE
               IF FILE-STATUS-LOCAL = '00'
                 CLOSE CHECK-FILE
                 IF FILE-STATUS-LOCAL = '00'
                   OPEN I-O CHECK-FILE
                   IF FILE-STATUS-LOCAL = '00'
                     MOVE 'Y' TO OPENED-FLAG
                   END-IF
                 END-IF
               END-IF
             END-IF
           ELSE
             MOVE 'ZZ' TO FILE-STATUS-LOCAL.
      *
           GO TO 0020-RETURN.
      * -====-
       0003-FR-OPEN-INPUT.
      *                         :---------------------------------------
      * ------------------------: Open the file INPUT.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN INPUT CHECK-FILE
             MOVE 'Y' TO OPENED-FLAG.
      *
           GO TO 0020-RETURN.
      * -====-
       0004-FR-OPEN-I-O.
      *                         :---------------------------------------
      * ------------------------: Open the file I/O and get highest key.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG NOT = 'Y'
             OPEN I-O CHECK-FILE.
      *
           GO TO 0020-RETURN.
      * -====-
       0005-FR-CLOSE.
      *                         :---------------------------------------
      * ------------------------: Close the file.
      *                         :---------------------------------------
      *
           IF OPENED-FLAG = 'Y'
             CLOSE CHECK-FILE
             MOVE 'N' TO OPENED-FLAG.
      *
           GO TO 0020-RETURN.
      * -====-
       0006-FR-WRITE.
      *                         :---------------------------------------
      * ------------------------: Write a new record.
      *                         :---------------------------------------
      *
           WRITE FS FROM LS.
      *
           GO TO 0020-RETURN.
      * -====-
       0007-FR-REWRITE.
      *                         :---------------------------------------
      * ------------------------: Rewrite the record.
      *                         :---------------------------------------
      *
           REWRITE FS FROM LS.
      *
           GO TO 0020-RETURN.
      * -====-
       0008-FR-DELETE.
      *                         :---------------------------------------
      * ------------------------: Delete the record.
      *                         :---------------------------------------
      *
           DELETE CHECK-FILE RECORD.
      *
           GO TO 0020-RETURN.
      * -====-
       0009-FR-START.
      *                         :---------------------------------------
      * ------------------------: Set sequential for browsing.
      *                         :
      *                         : If a generic start,
      *                         :   save the portion of the key that
      *                         :   was provided for later testing.
      *                         :
      *                         :---------------------------------------
      *
           IF FR-PRIME
             MOVE NEW-KEY OF LS TO NEW-KEY OF FS
             MOVE NEW-KEY OF FS TO GENERIC-KEY
             START CHECK-FILE KEY NOT LESS THAN NEW-KEY OF FS
                 INVALID KEY
               CONTINUE.
      *
           IF FR-GENERIC-START
             PERFORM 0014-SAVE-GENERIC-KEY.
      *
           GO TO 0020-RETURN.
      * -====-
       0010-FR-START-HIGH.
      *                         :---------------------------------------
      * ------------------------: Set sequential to the end of file.
      *                         :
      *                         : If a generic start,
      *                         :   save the portion of the key that
      *                         :   was provided for later testing.
      *                         :
      *                         :---------------------------------------
      *
           IF FR-PRIME
             MOVE NEW-KEY OF FS TO GENERIC-KEY
             MOVE HIGH-VALUE TO NEW-KEY OF FS
             START CHECK-FILE KEY EQUAL NEW-KEY OF FS
                 INVALID KEY
               CONTINUE.
      *
           IF FR-GENERIC-START
             PERFORM 0014-SAVE-GENERIC-KEY.
      * -====-
       0011-FR-READ.
      *                         :---------------------------------------
      * ------------------------: Read the record directly on prime key.
      *                         : We do business this way to eliminate
      *                         : problems that can occur when you try
      *                         : to read using an alternate key that
      *                         : duplicates allowed.  The prime key
      *                         : NEVER allows duplicates.
      *                         :---------------------------------------
      *
           MOVE NEW-KEY OF LS TO NEW-KEY OF FS.
           READ CHECK-FILE INTO LS
               KEY IS NEW-KEY OF FS
               INVALID KEY
             MOVE LOW-VALUES TO LS.
      *
           GO TO 0020-RETURN.
      * -====-
       0012-FR-READ-NEXT.
      *                         :---------------------------------------
      * ------------------------: Browse (read sequential) the file.
      *                         :---------------------------------------
      *
           READ CHECK-FILE
           NEXT RECORD INTO LS
          IGNORE LOCK
           AT END
             MOVE 'N' TO GENERIC-FLAG.
      *
           PERFORM 0015-EOF-TEST.
      *
           GO TO 0020-RETURN.
      * -====-
       0013-FR-READ-PREVIOUS.
      *                         :---------------------------------------
      * ------------------------: Browse a file backwards.
      *                         :---------------------------------------
      *
           READ CHECK-FILE
               PREVIOUS RECORD INTO LS
           AT END
             MOVE 'N' TO GENERIC-FLAG.
      *
           PERFORM 0015-EOF-TEST.
      *
           GO TO 0020-RETURN.

       0014-FR-READ-WITH-LOCK.
           MOVE NEW-KEY OF LS TO NEW-KEY OF FS.
          READ CHECK-FILE INTO LS WITH KEPT LOCK.
          GO TO 0020-RETURN.

       UNLOCK-THE-FILE.
          UNLOCK CHECK-FILE.
          GO TO 0020-RETURN.

       0014-SAVE-GENERIC-KEY.
      *                         :---------------------------------------
      * ------------------------: A generic browse will return records
      *                         : that match the portion of the key
      *                         : provided to start the browse.  For
      *                         : example, if the starting key was 'AB',
      *                         : the routine will only return records
      *                         : that have 'AB' in the first two bytes
      *                         : of key.
      *                         :---------------------------------------
      *
           MOVE 0 TO GENERIC-KEY-LENGTH GENERIC-KEY-LENGTH-LV.
      *
           INSPECT GENERIC-KEY
               TALLYING GENERIC-KEY-LENGTH-LV
               FOR CHARACTERS BEFORE INITIAL LOW-VALUE.
      *
           INSPECT GENERIC-KEY
               TALLYING GENERIC-KEY-LENGTH
               FOR CHARACTERS BEFORE INITIAL SPACE.
      *
           IF GENERIC-KEY-LENGTH > GENERIC-KEY-LENGTH-LV
             MOVE GENERIC-KEY-LENGTH-LV TO GENERIC-KEY-LENGTH.
      *
           IF GENERIC-KEY-LENGTH > 0
             MOVE 'Y' TO GENERIC-FLAG
           ELSE
             MOVE 'N' TO GENERIC-FLAG.
      * -====-
018500*
018400 0015-FR-OPEN-WITH-LOCK.
018200    GO TO 0020-RETURN.
018500*
018400 0016-FR-UNLOCK.
018200    GO TO 0020-RETURN.
018500*
018400 0017-FR-START-LOW.
015700
          IF FR-PRIME
             MOVE NEW-KEY OF LS TO NEW-KEY OF FS
             START CHECK-FILE KEY NOT GREATER THAN NEW-KEY OF FS
018200    GO TO 0020-RETURN.
018700*
       0015-EOF-TEST.
      *                        :---------------------------------------
      * ------------------------: Generic browse termination routine.
      *                         :
      *                         : Forces an end-of-file status if
      *                         : the key of the record no longer
      *                         : matches the key originally used to
      *                         : START the browse.
      *                         :
      *                         : Also stop browse if we hit the next
      *                         : key record (prime key = high-value).
      *                         :---------------------------------------
      *
           IF NEW-KEY OF FS = HIGH-VALUES
             MOVE '10' TO FILE-STATUS-LOCAL.
      *
      * -====-
       0020-RETURN.
           MOVE FILE-STATUS-LOCAL TO FILE-STATUS.
           GOBACK.
