       IDENTIFICATION DIVISION.
       PROGRAM-ID. MISSMAIL.
       AUTHOR. JIM MONAGHAN.
      ***************************************************************
      *    RECURRING MAIL CONTROL LOG (MISSING MAIL REPORT)         *
      *    READ INPUT RECURRING FILE, IF CYCLE EVENT IS MONTHLY     *
      *    BI-MONTHLY OR QUARTERLY ETC. SEE IF MAIL WAS RECEIVED IN *
      *    THE TIME FRAME ALLOTTED. IF NOT PRINT INFO ON THE REPORT *
      ***************************************************************
      *                   MAINTENANCE LOG                           *
      * 08/14/17 Changed bat assignment to point to R drive      AC*    
      * 06/15/17 CHANGED GUI                                     AC *   
      * 11/23/15 Moved Bat file to L:\BAT\MISSMAIL.BAT           AC *
      * 11/17/14-CHANGE ACCT-DELETE TABLE TO 400 TIMES.          JM *
      * 12/29/10-CHANGE TBL-IND & PANEL-IND TO 4 NUMERICS.       JM *
      * 04/06/08-add donation letter processing to end of report JM *
      * 10/25/07-modified to also show payee name when reporting    *                                                   
      *    ts    missing mail...                                    *                                                   
      * 11/03/05-modified to send report to \tps\prod\files\tpsreprt*                                                   
      *    ts    and display on screen (bypass printing)......      *                                                   
      * 07/16/01 ADD DUPLEX PRINTING.                            JM *
      * 01/24/01-VARIOUS CHANGES TO PROCESS NEW RECURRING CODES FOR *                                                   
      *    TS    WEEKLY AND BI-WEEKLY PAYMENT CYCLE (06 & 07)...... *                                                   
      *         -ADDED CODE TO CHECK FOR BI-ANNUAL, PROGRAM WAS NOT *                                                   
      *          CHECKING FOR PAYMENT CYCLE '5'.......              *                                                   
      * 01/26/00 PRINT ALL GROUPS & CLIENTS TOGETHER.            JM *
      * 12/14/99 AT 700-CONTINUE, ENSURE THAT INDEX WS-TAB HAS A    *                                                   
      *    TS    VALUE OF 1, BETWEEN 2 SORTS RESET WS-HOLD-CYCLE '9'*
      *          AT END, COMMENT OUT CLOSE & CANCEL OF TPSIO004.....*
      * 01/22/99 FIX YEAR END CALCULATION.                       JM *
      * 12/30/98 ADD CHECK FOR EXPIRATION DATE.                  JM *
      * 10/06/97 CHANGE 'AA' LOOKUP USE CUURENT LOGON NAME TO MAKE  *
      *    JM    PROCESS RUN FASTER.                                *
      * 02/13/97 WHEN CHECKING THE MAIL DAYS, IT MUST BE < 7000     *
      *    JM    BECAUSE AT YR END THE # JUMPS > 8000.              *
      * 10/21/96 ADD CHECK FOR RECUR-CHART-ACCT-01 = 02         JM  *
      * 02/29/96 SORT BY PA & AA, ADD TEMPORARY CODE TO FILL        *
      *          RECUR-ADMIN-LOGON WITH 'NYLEZUT   ' AA NAME.       *
      ***************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER. IBM-PS2.
       OBJECT-COMPUTER. IBM-PS2.
       FILE-CONTROL.
      *11/03/05                                                                                                           
002600     select bat-file  assign to batch-assignment
002700            file status is tps-file-status                                                                          
002800            organization is line sequential.                                                                        

           SELECT PRT-FILE
           ASSIGN TO DYNAMIC FILESPEC
           ORGANIZATION IS LINE SEQUENTIAL.

       SELECT SORT-FILE ASSIGN TO 'C:\TPS\APP\SORTFILE.DAT'.
       SELECT SORTWORK  ASSIGN TO 'C:\TPS\APP\SORTWORK.DAT'.
003300

       DATA DIVISION.
       FILE SECTION.
      *11/03/05                                                                                                           
004000 fd  bat-file
004100     label records are omitted
004200     record contains 80 characters.                                                                                 
004300 01  bat-record pic x(80).                                                                                          
004800

       FD  PRT-FILE
           LABEL RECORDS ARE OMITTED
           RECORD CONTAINS 200 CHARACTERS.
       01  PRT-RECORD                     PIC X(200).

       FD  SORTWORK
           RECORD CONTAINS 150 CHARACTERS.
       01  SW-RECORD.
            05 SW-SORT-KEY                PIC X(65).
            05 SW-SORT-REC                PIC X(85).

       SD  SORT-FILE
           RECORD CONTAINS 150 CHARACTERS.
       01  SORT-RECORD.
            05 SORT-KEY                   PIC X(65).
            05 SORT-REC                   PIC X(85).


       WORKING-STORAGE SECTION.

***************** WINFORMS SCREEN DEFINITION ********** 

       01 PROCESS-RPTS type TPS000.PROCESS_RPTSForm.

       01 PROCESS-RPTS-DISPLAY-FLAG PIC 9(01) VALUE 0.

       01 SCREEN-NAME PIC x(10).

       01 WS-CURRENT-X                            PIC 9(04).
       01 WS-CURRENT-Y                            PIC 9(04).
       01 WS-CURRENT-XY-PARM.
          05 WS-X-PARM                            PIC 9(04).
          05 WS-Y-PARM                            PIC 9(04).

       COPY "ds-cntrl.v1".


********************************************************

       01  GUISCREEN               PIC x(08) VALUE 'GS      '.
       01  PROGRAM-NAMES.
      * 10 SCREENIO    PIC X(08) VALUE 'SCRNIO'.
        10 TPSIOREC    PIC X(08) VALUE 'TPSIOREC'.
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
        10 TPSIORCR    PIC X(08) VALUE 'TPSIORCR'.
        10 TPSIO001    PIC X(08) VALUE 'TPSIO001'.
        10 TPSIO004    PIC X(08) VALUE 'TPSIO004'.
        10 TPSDEDIT    PIC X(08) VALUE 'TPSDEDIT'.
        10 TPSVEDIT    PIC X(08) VALUE 'TPSVEDIT'.
        10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
        10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
        10 FLOATIT     PIC X(08) VALUE 'FLOATIT'.



       01  FILESPEC                    PIC X(80) VALUE SPACES.
           COPY "TPSFILES.CPY".
           COPY "KEYVALUE.CPY".
           COPY "PCLVALUE.CPY".
           COPY "PCL5VALU.CPY".
           COPY "TPSKEYS.CPY".

       01  TPSLOGON-FLAG              PIC 9(01) VALUE 0.
           88 TPSLOGON-OPEN                     VALUE 1.
       01  TPSRECUR-FLAG              PIC 9(01) VALUE 0.
           88 TPSRECUR-OPEN                     VALUE 1.
       01  TPSMAIL-FLAG               PIC 9(01) VALUE 0.
           88 TPSMAIL-OPEN                      VALUE 1.
       01  TPSPROFL-FLAG              PIC 9(01) VALUE 0.
           88 TPSPROFL-OPEN                     VALUE 1.

       01  DIR-COMMAND.
           05 FILLER                  PIC  X(13) VALUE 'IF NOT EXIST '.
           05 DIR-COMMAND-1           PIC  X(15).
           05 DIR-COMMAND-2           PIC  X(09).
           05 FILLER                  PIC  X(04) VALUE '\*.*'.
           05 FILLER                  PIC  X(04) VALUE ' MD '.
           05 DIR-COMMAND-3           PIC  X(15).
           05 DIR-COMMAND-4           PIC  X(09).
       01  PRT-COMMAND-1.
           05 PRT-COMMAND-P           PIC  X(08) VALUE 'COPY /B '.
           05 PRT-COMMAND-PATH        PIC  X(50).
           05 FILLER                  PIC  X(12) VALUE '/A PRN > NUL'.
       01  RESULT                     PIC  99 COMP-X.
       01  FUNCTION-35                PIC  99 COMP-X VALUE 35.
       01  NULL-PARAMETER.
            05  FILLER                PIC  99 COMP-X VALUE 0.
            05  FILLER                PIC  X.

       01 CLIENT-DIRECTORY.
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH.
             20 PRT-PATH-NAME               PIC X(08).
          10 FILLER                         PIC X(01) VALUE '\'.
          10 PRT-PATH-REPORT.
             20 PRT-PATH-RPT-TYPE           PIC X(08).
          10 FILLER                         PIC X(01) VALUE '.'.
          10 PRT-PATH-EXT.
             20 PRT-PATH-RPT-NO             PIC X(03).


       01 NEW-PAGE              PIC X VALUE X'0C'.
       01 BLANK-LINE.
          10 FILLER PIC X     VALUE X'1B'.
          10 FILLER PIC X(10) VALUE '*p+0010y0X'.
       01 DRAW-VARIABLE-COLUMN.
      **********DRAW FIRST LINE DOWN THE PAGE.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(12) VALUE '*p0400y3050X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*c0005a'.
                10 PAGE-ENDING-1    PIC 9(04).
                10 FILLER PIC X(03) VALUE 'b0P'.
      **********DRAW SECOND LINE DOWN THE PAGE.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(12) VALUE '*p0400y3175X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*c0005a'.
                10 PAGE-ENDING-2    PIC 9(04).
                10 FILLER PIC X(03) VALUE 'b0P'.
       01 SHADE-CLIENT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(17) VALUE '*c1000a0060b11g2P'.
       01  THIN-LINE.
      **********DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.
      **********MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.
       01 DISP-LINE.
      **********DRAW A THIN BLACK LINE FROM LEFT MARGIN TO RIGHT.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(07) VALUE '*p0100X'.
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(14) VALUE '*c4000a0005b0P'.
      **********MOVE DOWN AND OVER TO THE LEFT MARGIN
                10 FILLER PIC X     VALUE X'1B'.
                10 FILLER PIC X(10) VALUE '*p-0005y0X'.
       01  AMOUNT-PROPORTIONAL.
           30 FILLER PIC X(01) VALUE X'1B'.
           30 FILLER PIC X(04) VALUE  '(s1p'.
           30 FILLER PIC X(13) VALUE  '12v0s0b4101T'.
       01  AMOUNT-MONOSPACE.
           30 FILLER PIC X(01) VALUE X'1B'.
           30 FILLER PIC X(04) VALUE  '(s0p'.
           30 FILLER PIC X(13) VALUE  '10h0s1b4101T'.

       01 HEADING-1.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1050'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'RECURRING MAIL CONTROL LOG'.
       01 HEADING-1-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 PRT-RPT-DATE     PIC X(20).
       01 HEADING-2-A.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER           PIC X(04) VALUE 'Page'.
          10 PRT-PAGE         PIC X(03).
          10 FILLER           PIC X(04) VALUE ' of '.
          10 PRT-TOTAL-PAGE   PIC X(03).
       01 HEADING-2.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0100'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1150'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'TPS Administrative Group LLC'.
       01 HEADING-3.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 Y-AXIS PIC X(04) VALUE  '0150'.
          10 FILLER PIC X(01) VALUE  'y'.
          10 X-AXIS PIC X(04) VALUE  '1000'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(51) VALUE
               '"Taking Care of Your Personal Business...Privately"'.

       01 PA-NAME.
          10 FILLER                  PIC X(05) VALUE 'PA - '.
          10 RPT-PA-NAME             PIC X(100).

       01 AA-NAME.
          10 FILLER                  PIC X(05) VALUE 'AA - '.
          10 RPT-AA-NAME             PIC X(100).

       01 WS-CLIENT                  PIC X(08) VALUE 'CLIENT: '.
       01 RPT-CLIENT.
      *   10 FILLER                  PIC X(01) VALUE x'1B'.
      *   10 FILLER                  PIC X(07) VALUE '*p1000X'.
          10 RPT-CLIENT-NAME         PIC X(150).

       01 RPT-SECTION-HDR1.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0075X'.
          10 FILLER                  PIC X(09) VALUE
                 'DATE LAST'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p3060X'.
          10 FILLER                  PIC X(04) VALUE
                 'APP'.

       01 RPT-SECTION-HDR2.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0075X'.
          10 FILLER                  PIC X(08) VALUE
                 'RECEIVED'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0500X'.
          10 FILLER                  PIC X(09) VALUE
                 'FOR      '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1450X'.
          10 FILLER                  PIC X(09) VALUE
                 'FROM     '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 FILLER                  PIC X(07) VALUE
                 'ACCOUNT'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p3060X'.
          10 FILLER                  PIC X(04) VALUE
                 'INIT'.

       01 RPT-SECTION-HDR3.
          10 RPT-SECTION-NME         PIC X(24).
          10 FILLER                  PIC X(01) VALUE SPACE.
          10 FILLER                  PIC X(23) VALUE
                 'Total recurring mail = '.
          10 RPT-SECTION-TOTAL       PIC X(04).
          10 FILLER                  PIC X(03) VALUE SPACE.
          10 FILLER                  PIC X(16) VALUE
                 'Reported mail = '.
          10 RPT-SECTION-RPTD        PIC X(04).

       01 PRINT-DATA.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0050X'.
          10 PRT-AUTO                PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 PRT-REC-DATE            PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0375X'.
          10 PRT-FROM-NAME           PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1300X'.
          10 PRT-FOR-NAME            PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2500X'.
          10 PRT-ACCOUNT-NO          PIC X(22).
      **  10 FILLER                  PIC X(01) VALUE x'1B'.
      **  10 FILLER                  PIC X(07) VALUE '*p3075X'.
      **  10 FILLER                  PIC X(04) VALUE '____'.

       01 PRINT-DISP.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 FILLER                  PIC X(12) VALUE 'Disposition:'.

       01 PAGE-END.
          10 FILLER                  PIC X(03) VALUE SPACES.
          10 FILLER                  PIC X(21) VALUE
                '* = automatic payment'.

       01 RPT-LAST-LINE.
          10 FILLER                  PIC X(03) VALUE SPACES.
          10 FILLER                  PIC X(21) VALUE
                '* = automatic payment'.
          10 FILLER                  PIC X(64) VALUE SPACES.
          10 FILLER                  PIC X(15) VALUE
                'End of Report'.


       01 LAST-LINE.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(04) VALUE '*p0x'.
          10 LAST-LINE-NO            PIC 9(04).
          10 FILLER                  PIC X(01) VALUE 'Y'.

       01 CONFIDENTIAL-LINE-1.
          10 FILLER                  PIC X(43) VALUE
             'Any and all information concerning clients '.
          10 FILLER                  PIC X(36) VALUE
             'is deemed by TPS to be confidential.'.
       01 CONFIDENTIAL-LINE-2.
          10 FILLER                  PIC X(41) VALUE
             'Employees are prohibited from copying or '.
          10 FILLER                  PIC X(36) VALUE
             'disclosing confidential information.'.

       01 PAGES-PRINTED      PIC  9(03) VALUE 00.
       01 PAGES-PRINTED-MASK PIC  ZZZ.
       01 LINES-PRINTED      PIC  9(03) VALUE 50.
       01 MAIL-MASK          PIC  ZZZZ.


       01  WS-SORT-RECORD.
           05 WS-SORT-KEY.
              10 WS-SORT-ACCT-BRANCH          PIC  X(02).
              10 WS-SORT-ACCT-ADMIN           PIC  X(02).
              10 WS-SORT-ACCESS-LEVEL         PIC  X(02).
              10 WS-SORT-ACCT-LOGON           PIC  X(10).
              10 WS-SORT-ACCT-NO              PIC  9(10).
              10 WS-SORT-SUB-ACCT             PIC  9(02).
              10 WS-SORT-CYCLE                PIC  9(01).
              10 WS-SORT-FOR-NAME             PIC  X(36).
           05 WS-SORT-RECV-DATE               PIC  9(08).
           05 WS-SORT-FROM-NAME               PIC  X(36).
           05 WS-SORT-BILL-ACCT               PIC  X(22).
           05 ws-sort-payee-name              pic  x(36).                                                                 
           05 WS-SORT-NOT-FND                 PIC  X(01).
           05 FILLER                          PIC  X(18).

       01  WS-CLIENT-TABLE.
           05 CLIENT-TABLE-NAMES OCCURS 1 TO 1000 TIMES
                                 DEPENDING ON WS-SUB.
              10 TABLE-ACCT-NO              PIC  9(10).
              10 TABLE-SUB-ACCT             PIC  9(02).
              10 TABLE-LAST-NAME            PIC  X(20).
              10 TABLE-FIRST-NAME           PIC  X(15).
              10 TABLE-MDDL-INIT            PIC  X(01).
              10 TABLE-TOT-MTH-MAIL         PIC  9(04).
              10 TABLE-TOT-BMTH-MAIL        PIC  9(04).
              10 TABLE-TOT-QRTR-MAIL        PIC  9(04).
              10 TABLE-TOT-SANL-MAIL        PIC  9(04).
              10 TABLE-TOT-ANUL-MAIL        PIC  9(04).
      *01/24/01                                                                                                         
              10 TABLE-TOT-BIAN-MAIL        PIC  9(04).
              10 TABLE-TOT-WKLY-MAIL        PIC  9(04).                                                                 
              10 TABLE-TOT-BIWK-MAIL        PIC  9(04).                                                                 
              10 TABLE-PRT-MTH-MAIL         PIC  9(04).
              10 TABLE-PRT-BMTH-MAIL        PIC  9(04).
              10 TABLE-PRT-QRTR-MAIL        PIC  9(04).
              10 TABLE-PRT-SANL-MAIL        PIC  9(04).
              10 TABLE-PRT-ANUL-MAIL        PIC  9(04).
      *01/24/01                                                                                                         
              10 TABLE-PRT-BIAN-MAIL        PIC  9(04).
              10 TABLE-PRT-WKLY-MAIL        PIC  9(04).                                                                 
              10 TABLE-PRT-BIWK-MAIL        PIC  9(04).                                                                 

       01  WS-ACCT-DEL-TABLE.
      *11/17/14 change table size from 200 to 400
           05 acct-del-table occurs 1 to 400 times
                                 DEPENDING ON DEL-SUB.
              10 DELETE-ACCT-NO             PIC  9(10).

       01  WS-FLIP-PAY-DATE.
           05 WS-FLIP-YY                    PIC  9(02).
           05 WS-FLIP-MM                    PIC  9(02).
           05 WS-FLIP-DD                    PIC  9(02).

       01  WS-FLOAT-DATA.
           05  WS-FLOAT-PARMS               PIC  X(101).
           05  FILLER REDEFINES WS-FLOAT-PARMS.
               10  WS-FLOAT-COUNT           PIC  X(01).
               10  WS-FLOAT-1               PIC  X(25).
               10  WS-FLOAT-2               PIC  X(25).
               10  WS-FLOAT-3               PIC  X(25).
               10  FILLER REDEFINES WS-FLOAT-3.
                   15  WS-FLOAT-3-A         PIC  X(22).
                   15  WS-FLOAT-3-B         PIC  X(03).
               10  WS-FLOAT-4               PIC  X(25).

       01  BG-FLOAT-DATA.
           05  BG-FLOAT-PARMS               PIC  X(161).
           05  FILLER REDEFINES BG-FLOAT-PARMS.
               10  BG-FLOAT-COUNT           PIC  X(01).
               10  BG-FLOAT-1               PIC  X(40).
               10  BG-FLOAT-2               PIC  X(40).
               10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
                   15  BG-FLOAT-2-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-3               PIC  X(40).
               10  FILLER REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-A         PIC  X(37).
                   15  BG-FLOAT-3-B         PIC  X(03).
               10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
                   15  BG-FLOAT-3-I         PIC  X(01) OCCURS 40 TIMES.
               10  BG-FLOAT-4               PIC  X(40).
016400*
000100 01 CONVERT-TO-CAPITALS         PIC X(01) VALUE 'Y'.
000100 01 WS-ADDRESOR-NAME            PIC X(36).
000100 01 WS-ADDRESEE-NAME            PIC X(36).
000100 01 LENGTH-36                   PIC 999   VALUE 36.
000100 01 CHECK-ACCT-NUM              PIC X(01) VALUE 'N'.
000100 01 WS-HOLD-ACCT-NO             PIC 9(10) VALUE 0.
000100 01 WS-HOLD-CYCLE               PIC 9(01) VALUE 9.
000100 01 FIRST-SORT-REC              PIC X(01) VALUE 'Y'.
000100 01 WS-SUB                      PIC 9(04) VALUE 0.
000100 01 DEL-SUB                     PIC 9(03) VALUE 0.
000100 01 TAB-SUB                     PIC 9(03) VALUE 0.
000100 01 WS-TAB                      PIC 9(04) VALUE 0.
000100 01 NO-MAIL                     PIC X(01) VALUE 'N'.
000100 01 MAIL-DAYS                   PIC 9(05) VALUE 0.
000100 01 WS-ACCT-NO                  PIC 9(10) VALUE 0.
000100 01 ACCT-DELETED                PIC X(01) VALUE 'N'.
000100 01 LOGREC-RETURN-KEY           PIC X(10).
000100
000100 01 HOLD-ACCT-BRANCH            PIC 9(02) VALUE 01.
000100 01 HOLD-ACCT-ADMIN             PIC 9(02) VALUE 01.
000100 01 HOLD-ACCT-LOGON             PIC X(10) VALUE 'NYJALEV   '.
006000
037200 01 TODAYS-DATE-YMD.
037200    05 WS-TODAYS-DATE-YY       PIC  9(02).
037200    05 WS-TODAYS-DATE-MM       PIC  9(02).
037200    05 WS-TODAYS-DATE-DD       PIC  9(02).
006000
037200 01 TODAYS-DATE-CYMD.
037200    05 TODAYS-DATE-CC          PIC  9(02).
037200    05 TODAYS-DATE-YY          PIC  9(02).
037200    05 TODAYS-DATE-MM          PIC  9(02).
037200    05 TODAYS-DATE-DD          PIC  9(02).
006000
037200 01 WORK-DATE                  PIC  9(08).
037210*
037220  01  WS-TODAYS-DATE-ENGLISH     PIC  X(20).
037300*
037500  01  WS-REPORT-DATE             PIC  X(20).
037700
037800  01  WS-DATE-REQUEST.
037900      05  WS-DATE-PARAM          PIC  9(02).
038000
038100      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.
038200      05  FILLER REDEFINES WS-DATE-TENBYTES.
038300          10  WS-DATE-REFORM         PIC  X(06).
038400          10  WS-DATE-EXTEND         PIC  X(04).
038500          10  FILLER                 PIC  X(10).
038600      05  FILLER REDEFINES WS-DATE-TENBYTES.
038700          10  WS-DATE-REFORM-LEN06   PIC  X(06).
038800          10  FILLER                 PIC  X(14).
038900      05  FILLER REDEFINES WS-DATE-TENBYTES.
039000          10  WS-DATE-REFORM-LEN08   PIC  X(08).
039100          10  FILLER                 PIC  X(12).
039200      05  FILLER REDEFINES WS-DATE-TENBYTES.
039300          10  WS-DATE-REFORM-LEN10   PIC  X(10).
039400          10  FILLER                 PIC  X(10).
039500      05  FILLER REDEFINES WS-DATE-TENBYTES.
039600          10  WS-TIME-PARM1          PIC  X(06).
039700          10  WS-TIME-PARM2          PIC  X(06).
039800          10  WS-TIME-EXTEND         PIC  X(08).
039900      05  FILLER REDEFINES WS-DATE-TENBYTES.
040000          10  WS-TIME-PARM1BY8       PIC  X(08).
040100          10  WS-TIME-PARM2BY8       PIC  X(08).
040200          10  WS-TIME-EXTNDBY8       PIC  X(04).
040300
005500 01  PRT-ERROR.                                                                      00005600
005500     05 PRT-FILE-NAME          PIC X(20).                                            00005600
005500     05 PRT-STATUS             PIC X(10).                                            00005600
005960
005500 01  TPS-FILE-STATUS.                                                                00005600
005500     05 SK1                    PIC X.                                                00005600
005500     05 SK2                    PIC X.                                                00005600
005500     05  STAT-BIN REDEFINES SK2 PIC 9(02) COMP-X.                                    00005600
005500 01  DISPLAY-STATUS.                                                                 00005600
005500     05 SK1-DISPL              PIC X.                                                00005600
005500     05 FILLER                 PIC X(03).                                            00005600
005500     05 SK2-DISPLPIC           PIC 999.                                              00005600

       01 TPS-LOGON.
           COPY "TPSLOGON.CPY".
       01 TPS-PROFL.
           COPY "TPSPROFL.CPY".
       01 TPS-RECUR.
           COPY "TPSRECUR.CPY".
       01 TPS-MAIL.
           COPY "TPSMAIL.CPY".

000000 
101400                                                                                                                    
      *11/03/05                                                                                                           
000000 01 dos-command                          pic  x(80) value spaces.                                                   
028500 
      *08/14/17                                                                                                           
000000 01 batch-assignment.
          05 filler                            pic  x(80) value
010500       'L:\BAT\MISSMAIL.BAT'.

       01 what-drive-assignment            pic  x(01) value spaces.                                                       
       01 what-drive-status                pic  x(02) comp-5.                                                             
000000                                                                                                                  
       01 jetpcl2tif-bat-rec-01.                                                                                          
          05 filler                            pic x(80) value                                                            
             '@c:'.                                                                                                       
       01 jetpcl2tif-bat-rec-02.                                                                                          
          05 filler                            pic x(80) value                                                          
             '@cd\jetpcl'.                                                                                                
       01 jetpcl2tif-bat-rec-03.                                                                                          
          05 filler                            pic x(08) value                                                          
             '@jetpcl '.                                                                                                  
          05 jetrpt-dr-lttr                    pic x(01) value                                                            
             'c'.                                                                                                         
          05 filler                            pic x(71) value                                                            
010500       ':\tps\prod\files\tpsreprt\missmail.pcl -otif > nul'.                                                        
       01 jetpcl2tif-bat-rec-04.                                                                                          
          05 filler                            pic x(80) value                                                          
             '@cd\'.                                                                                                    
       01 jetpcl2tif-bat-rec-05.                                                                                          
          05 filler                            pic x(80) value                                                          
             '@cls'.                                                                                                      
       01 jetpcl2tif-bat-rec-06.                                                                                          
          05 filler                            pic x(80) value                                                          
             '@exit'.                                                                                                     
          
      *10/25/07
       01 two-bytes                  pic  x(02).

      *04/06/08 changes start here
       01  FGN-CHECK-REC.
           COPY "TPSFGNCK.CPY".
       01  TPS-CHECK-REC.
           COPY "TPSCHECK.CPY".
       01 TPSIOCHK    PIC X(08) VALUE 'TPSIOCHK'.
       01 TPSIO026    PIC X(08) VALUE 'TPSIO026'.
036245
036245 01 COURIER-56-N    PIC X(17) VALUE '(s1p12v0s0b4101T'.
050100
050200 01 DON-WORK-DATE.
026500    05 WORK-MM                        PIC 9(02).
026500    05 FILLER                         PIC X(01) VALUE '/'.
026500    05 WORK-DD                        PIC 9(02).
026500    05 FILLER                         PIC X(01) VALUE '/'.
026500    05 WORK-YY                        PIC 9(02).

       01 OLD-DATE                         PIC 9(08).
050200*12/29/10 *** CHANGE TBL-IND & PANEL-IND TO 4 NUMERICS *********
       01 TBL-IND                          PIC 9(04) VALUE ZERO.
       01 PANEL-IND                        PIC 9(04) VALUE ZERO.
050100
050200 01 CHECK-TABLE OCCURS 1 TO 5000 TIMES DEPENDING ON TBL-IND.
026500    05 TBL-ACCT-NO                    PIC 9(10).
026500    05 TBL-SUB-ACCT                   PIC 9(02).
026500    05 TBL-CHK-TYPE                   PIC X(01).
026500    05 TBL-CHK-DATE                   PIC 9(08).
026500    05 TBL-CHK-NO                     PIC 9(05).
026500    05 TBL-CHK-AMT                    PIC S9(07)V9(02).
026500    05 TBL-RECV-DATE                  PIC 9(08).
026500    05 TBL-RECV-NO                    PIC 9(05).
026500    05 TBL-PAYEE-NAME                 PIC X(36).
026500    05 TBL-MEMO                       PIC X(40).
026500    05 TBL-FGN-CHK-AC-NO              PIC 9(02).
026500    05 TBL-FGN-CHK-TRANS-CODE         PIC X(01).
026500    05 TBL-FGN-TIE-BREAKER            PIC 9(02).
026500    05 TBL-CHK-TRANSACTION-NO         PIC 9(05).
026500    05 TBL-ADDRESSEE-NAME             PIC X(36).

       01 DON-HEADING-1.
          10 FILLER PIC X(01) VALUE SPACE.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
      *   10 FILLER PIC X(04) VALUE  '0050'.
      *   10 FILLER PIC X(01) VALUE  'y'.
          10 FILLER PIC X(04) VALUE  '0050'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 PRT-DON-DATE     PIC X(20).
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 FILLER PIC X(04) VALUE  '1030'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(50) VALUE
                 'DONATION CHECKS MISSING THANK YOU LETTERS'.
          10 FILLER PIC X(01) VALUE X'1B'.
          10 FILLER PIC X(02) VALUE  '*p'.
          10 FILLER PIC X(04) VALUE  '2600'.
          10 FILLER PIC X(01) VALUE  'X'.
          10 FILLER PIC X(06) VALUE
                 'PAGE: '.
          10 PRT-DON-PAGE     PIC ZZZ9.

       01 DON-HEADING-2.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0010X'.
          10 FILLER                  PIC X(10) VALUE
                 'Check Date'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0300X'.
          10 FILLER                  PIC X(09) VALUE
                 'Check #  '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0630X'.
          10 FILLER                  PIC X(09) VALUE
                 'Amount   '.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1000X'.
          10 FILLER                  PIC X(08) VALUE
                 'Received'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1300X'.
          10 FILLER                  PIC X(14) VALUE
                 'Payee Name'.
      *   10 FILLER                  PIC X(01) VALUE x'1B'.
      *   10 FILLER                  PIC X(07) VALUE '*p1700X'.
      *   10 FILLER                  PIC X(10) VALUE
      *          'Addressor Name'.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2400X'.
          10 FILLER                  PIC X(04) VALUE
                 'Memo'.

       01 PRT-DON-DATA.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0010X'.
          10 PRT-CK-DATE             PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(02) VALUE '*p'.
          10 PRT-CK-NO-PCL           PIC X(04) VALUE '0300'.
          10 FILLER                  PIC X(01) VALUE 'X'.
          10 PRT-CK-NO               PIC ZZZZ9.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0450X'.
          10 PRT-CHK-TYPE            PIC X(01).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(02) VALUE '*p'.
          10 PRT-CK-AMT-PCL          PIC X(04) VALUE '0600'.
          10 FILLER                  PIC X(01) VALUE 'X'.
          10 PRT-CK-AMT              PIC $$,$$$,$$$.99.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1000X'.
          10 PRT-RECV-DATE           PIC X(08).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p1250X'.
          10 PRT-PAYEE-NAME          PIC X(36).
      *   10 FILLER                  PIC X(01) VALUE x'1B'.
      *   10 FILLER                  PIC X(07) VALUE '*p1600X'.
      *   10 PRT-ADDRESOR-NAME       PIC X(36).
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p2300X'.
          10 PRT-PAYEE-MEMO          PIC X(40).

       01 PRT-DON-END.
          10 FILLER                  PIC X(01) VALUE x'1B'.
          10 FILLER                  PIC X(07) VALUE '*p0100X'.
          10 FILLER                  PIC X(13) VALUE
                   'END OF REPORT'.


       LINKAGE SECTION.

       01 CURRENT-XY-PARAMETERS PIC 9(08).


       PROCEDURE DIVISION USING CURRENT-XY-PARAMETERS.

       001-MAIN-STREAM.
 
           INITIALIZE DS-CONTROL-BLOCK.
           INITIALIZE DS-INPUT-FIELDS.
           MOVE CURRENT-XY-PARAMETERS(1:4) TO WS-CURRENT-X
                                              WS-X-PARM.
           MOVE CURRENT-XY-PARAMETERS(5:4) TO WS-CURRENT-Y
                                              WS-Y-PARM.

           IF PROCESS-RPTS-DISPLAY-FLAG = 0
               SET PROCESS-RPTS TO NEW TPS000.PROCESS_RPTSForm
               MOVE 1 TO PROCESS-RPTS::MISS-FLAG
               SET PROCESS-RPTS::X-POINT TO WS-X-PARM
               SET PROCESS-RPTS::Y-POINT TO WS-Y-PARM
               INVOKE PROCESS-RPTS::Show
               MOVE 0 TO PROCESS-RPTS::MISS-FLAG
               MOVE 1 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.


          PERFORM 100-OPEN-FILES THRU 100-EXIT.

          ACCEPT TODAYS-DATE-YMD FROM DATE.
          MOVE TODAYS-DATE-YMD      TO TODAYS-DATE-CYMD(3:6).
          IF WS-TODAYS-DATE-YY > 94
             MOVE 19                TO TODAYS-DATE-CC
          ELSE
             MOVE 20                TO TODAYS-DATE-CC.

          MOVE 06                   TO WS-DATE-PARAM.
          MOVE TODAYS-DATE-YMD      TO WS-DATE-REFORM.
          MOVE SPACES               TO WS-DATE-EXTEND.
          CALL TPSDATES USING WS-DATE-REQUEST.
      *04/06/08
          MOVE WS-DATE-TENBYTES     TO PRT-RPT-DATE
                                       PRT-DON-DATE.

          PERFORM 050-LOAD-TABLES THRU 050-EXIT.

      ******* SET UP SORT RECORD *********

          PERFORM 200-PROCESS-DATA THRU 500-EXIT.
          CLOSE SORTWORK.

          SORT SORT-FILE
               ON ASCENDING SORT-KEY
               USING SORTWORK
               OUTPUT PROCEDURE IS 600-PRINT-THE-DATA THRU 900-EXIT.

      ****** CLOSE PRT-FILE SET UP TOTAL PAGES & RESET FLAGS ******
          MOVE PAGES-PRINTED           TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK      TO PRT-TOTAL-PAGE.
          MOVE ZERO                    TO PAGES-PRINTED
                                          WS-TAB
                                          LINES-PRINTED
                                          HOLD-ACCT-BRANCH
                                          HOLD-ACCT-ADMIN.
          MOVE '9'                     TO WS-HOLD-CYCLE.
          MOVE SPACES                  TO HOLD-ACCT-LOGON.
          MOVE 'Y'                     TO FIRST-SORT-REC.
          SORT SORT-FILE
               ON ASCENDING SORT-KEY
               USING SORTWORK
               OUTPUT PROCEDURE IS 600-PRINT-THE-DATA THRU 900-EXIT.

      *11/03/05                                                                                                           
      ******* PRINT REPORT *********
      **  DISPLAY PRT-COMMAND-1 UPON COMMAND-LINE
      **  CALL X'91' USING RESULT FUNCTION-35 NULL-PARAMETER.
078100*   call "pc_read_drive" using what-drive-assignment
      *                    returning what-drive-status.
078100* 11/23/15 Move bat file to L:\BAT\missmail.bat        AC
078100*   if what-drive-assignment = 'L' or 'l'
109300*      move 'L'         to jetrpt-dr-lttr
      *      move '@L:'       to jetpcl2tif-bat-rec-01(1:3)
005242*     else
078100*   if what-drive-assignment = 'M' or 'm'
109300*      move 'M'         to jetrpt-dr-lttr
      *      move '@L:'       to jetpcl2tif-bat-rec-01(1:3)
005242*     else
109300*      move 'C'         to jetrpt-dr-lttr
      *      move '@C:'       to jetpcl2tif-bat-rec-01(1:3)
005242*     end-if
005242*    end-if.


044200*   open output bat-file.
      *   write bat-record from jetpcl2tif-bat-rec-01.
      *   write bat-record from jetpcl2tif-bat-rec-02.
      *   write bat-record from jetpcl2tif-bat-rec-03.
      *   write bat-record from jetpcl2tif-bat-rec-04.
      *   write bat-record from jetpcl2tif-bat-rec-05.
      *   write bat-record from jetpcl2tif-bat-rec-06.
046100*   close bat-file.
                                                                                                                       
037400    move batch-assignment           to dos-command.                                                               
130600    display dos-command upon command-line.
130700    call x'91' using result function-35 null-parameter.                                                           
855577                                                                                                                  

          DELETE FILE SORTWORK.
          GO TO EXIT-THE-MODULE.
       001-EXIT.


       050-LOAD-TABLES.
          MOVE ZEROS                TO CLNT-PROFILE-KEY.
          MOVE F-PRIME TO FILE-KEY
          MOVE F-START TO FILE-ACTION
          CALL TPSIO004 USING FILE-REQUEST TPS-PROFL
             IF FILE-STATUS NOT = '00'
                MOVE 'PROFILE  ' TO FILE-NAME
                MOVE 'MISSMAIL-ST'  TO FILE-TEXT
                GO TO EXIT-THE-MODULE.
      *         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       050-CONTINUE.
          MOVE F-PRIME TO FILE-KEY
          MOVE F-READ-NEXT  TO FILE-ACTION
          CALL TPSIO004 USING FILE-REQUEST TPS-PROFL

          IF END-OF-FILE-WAS-REACHED
             GO TO 050-EXIT.

          IF FILE-STATUS NOT = '00'
             MOVE 'PROFILE  ' TO FILE-NAME
             MOVE 'MISSMAIL-RN'  TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          IF CLNT-PROFILE-SUB-ACCT NOT = ZERO
             GO TO 050-CONTINUE.

          IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9
             ADD 1                       TO DEL-SUB
             MOVE CLNT-PROFILE-ACCT-NO   TO DELETE-ACCT-NO(DEL-SUB)
             GO TO 050-CONTINUE.
      *JM01/00 ****** PRINT ALL GROUPS & CLIENTS ******
      *   IF PARM01-ACCOUNT-NUMBER(1:4) NOT =
      *                                  CLNT-PROFILE-ACCT-NO(1:4)
      *      ADD 1                       TO DEL-SUB
      *      MOVE CLNT-PROFILE-ACCT-NO   TO DELETE-ACCT-NO(DEL-SUB)
      *      GO TO 050-CONTINUE.

          ADD 1                         TO WS-SUB.
          MOVE CLNT-PROFILE-ACCT-NO     TO TABLE-ACCT-NO(WS-SUB).
          MOVE CLNT-PROFILE-SUB-ACCT    TO TABLE-SUB-ACCT(WS-SUB).
          MOVE CLNT-PROFILE-LAST-NAME   TO TABLE-LAST-NAME(WS-SUB).
          MOVE CLNT-PROFILE-FIRST-NAME  TO TABLE-FIRST-NAME(WS-SUB).
          MOVE CLNT-PROFILE-MDDL-INIT   TO TABLE-MDDL-INIT(WS-SUB).
          MOVE ZEROS                    TO TABLE-TOT-MTH-MAIL(WS-SUB)
                                           TABLE-TOT-BMTH-MAIL(WS-SUB)
                                           TABLE-TOT-QRTR-MAIL(WS-SUB)
                                           TABLE-TOT-SANL-MAIL(WS-SUB)
                                           TABLE-TOT-ANUL-MAIL(WS-SUB)
                                           TABLE-TOT-BIAN-MAIL(WS-SUB)
                                           TABLE-TOT-WKLY-MAIL(WS-SUB)
                                           TABLE-TOT-BIWK-MAIL(WS-SUB)
                                           TABLE-PRT-MTH-MAIL(WS-SUB)
                                           TABLE-PRT-BMTH-MAIL(WS-SUB)
                                           TABLE-PRT-QRTR-MAIL(WS-SUB)
                                           TABLE-PRT-SANL-MAIL(WS-SUB)
                                           TABLE-PRT-ANUL-MAIL(WS-SUB) 
                                           TABLE-PRT-BIAN-MAIL(WS-SUB) 
                                           TABLE-PRT-WKLY-MAIL(WS-SUB)
                                           TABLE-PRT-BIWK-MAIL(WS-SUB).

          GO TO 050-CONTINUE.
       050-EXIT.      EXIT.


       100-OPEN-FILES.
          OPEN OUTPUT SORTWORK.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-OPEN-INPUT TO FILE-ACTION.
          IF NOT TPSLOGON-OPEN
             MOVE 1                TO TPSLOGON-FLAG
             CALL TPSIO001 USING FILE-REQUEST TPS-LOGON
             IF FILE-STATUS NOT = '00'
                MOVE 'TPSLOGON' TO FILE-NAME
                MOVE 'MISSMAIL-OP' TO FILE-TEXT
      *         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
                GO TO EXIT-THE-MODULE.

          IF NOT TPSRECUR-OPEN
             MOVE 1                TO TPSRECUR-FLAG
             CALL TPSIORCR USING FILE-REQUEST TPS-RECUR
             IF FILE-STATUS NOT = '00'
                MOVE 'RECURRING' TO FILE-NAME
                MOVE 'MISSMAIL'  TO FILE-TEXT
      *         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
                GO TO EXIT-THE-MODULE.

          IF NOT TPSMAIL-OPEN
             MOVE 1                TO TPSMAIL-FLAG
             CALL TPSIOREC USING FILE-REQUEST TPS-MAIL
             IF FILE-STATUS NOT = '00'
                MOVE 'RECEIVE ' TO FILE-NAME
                MOVE 'MISSMAIL-OP' TO FILE-TEXT
      *         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
                GO TO EXIT-THE-MODULE.

          IF NOT TPSPROFL-OPEN
             MOVE 1                TO TPSPROFL-FLAG
             CALL TPSIO004 USING FILE-REQUEST TPS-PROFL
             IF FILE-STATUS NOT = '00'
                MOVE 'PROFILE  ' TO FILE-NAME
                MOVE 'MISSMAIL-OP'  TO FILE-TEXT
      *         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
                GO TO EXIT-THE-MODULE.
      *04/06/08
013500    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
013600    IF FILE-IS-ALREADY-OPEN
013700       CONTINUE
013700    ELSE
013600    IF FILE-STATUS NOT = '00'
013700       MOVE 'CHECK ' TO FILE-NAME
013800       MOVE 'MISSMAIL-OPN' TO FILE-TEXT
013900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014000       GO TO EXIT-THE-MODULE.
265500
265500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
013600    IF FILE-IS-ALREADY-OPEN
013700       CONTINUE
013700    ELSE
458100    IF NOT A-SUCCESSFUL-OPERATION
265700       MOVE ' FGNCK  '   TO FILE-NAME
265800       MOVE 'MISSMAIL-OPN' TO FILE-TEXT
265900       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080       GO TO EXIT-THE-MODULE.

       100-EXIT.


       200-PROCESS-DATA.
          MOVE LOW-VALUES              TO RECUR-KEY OF TPS-RECUR.
          ADD 1                        TO TAB-SUB.
          IF TAB-SUB > WS-SUB
             GO TO 500-EXIT.
          MOVE TABLE-ACCT-NO(TAB-SUB)  TO RECUR-ACCT-NO OF TPS-RECUR.
          MOVE TABLE-SUB-ACCT(TAB-SUB) TO RECUR-SUB-ACCT OF TPS-RECUR.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.

          IF NO-RECORD-WAS-FOUND
             GO TO 500-EXIT
          END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'MISSMAIL-SBR' TO FILE-TEXT
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE
          END-IF.

       200-BROWSE-THE-RECUR-FILE.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-NEXT TO FILE-ACTION.
          CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.

          IF END-OF-FILE-WAS-REACHED
             GO TO 500-EXIT
          END-IF.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECUR' TO FILE-NAME
             MOVE 'MISSMAIL-REN' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
      *      GO TO EXIT-THE-MODULE
      *   END-IF.
      ****** CHECK ACCOUNT NUMBER ********
          IF RECUR-ACCT-NO OF TPS-RECUR NOT NUMERIC
             GO TO 200-BROWSE-THE-RECUR-FILE.
          IF RECUR-ACCT-NO OF TPS-RECUR NOT = TABLE-ACCT-NO(TAB-SUB)
             GO TO 200-PROCESS-DATA.
      *JM01/00 ******* USE TABLE TO LOOK AT RECUR FILE *******
      *   IF RECUR-ACCT-NO OF TPS-RECUR NOT = WS-ACCT-NO
      *      MOVE RECUR-ACCT-NO OF TPS-RECUR  TO WS-ACCT-NO
      *      MOVE 'N'                         TO ACCT-DELETED
      *      PERFORM 250-CHECK-DEL-TABLE VARYING TAB-SUB FROM 1 BY 1
      *                                  UNTIL TAB-SUB > DEL-SUB
      *      IF ACCT-DELETED = 'Y'
      *         GO TO 200-BROWSE-THE-RECUR-FILE
      *      END-IF
      *      PERFORM VARYING TAB-SUB FROM 1 BY 1 UNTIL
      *          RECUR-ACCT-NO OF TPS-RECUR = TABLE-ACCT-NO(TAB-SUB)
      *         CONTINUE
      *      END-PERFORM.
      *      IF ACCT-DELETED = 'Y'
      *         GO TO 200-BROWSE-THE-RECUR-FILE.
      ****JM 10/21/96 ****** CHECK FOR BILLS ********
          IF RECUR-CHART-ACCT-01 OF TPS-RECUR(1:2) = '02' OR
                                                     '31' OR '33'
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR SCHEDULED OR AUTOMATIC EVENTS ********
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '1' OR '2'
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR MONTHLY BI-MONTHLY OR QUARTERLY EVENTS ******
      *01/24/01                                                                                                         
      *   IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0' OR '1' OR '2' OR
      *                                            '3' OR '4'
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0' OR '1' OR '2' OR
                                                   '3' OR '4' OR '5' OR
                                                   '6' OR '7'                                                           
             NEXT SENTENCE
          ELSE
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** CHECK FOR EXPIRED ACCOUNTS ********
          IF RECUR-EXPIRE-DATE OF TPS-RECUR > ZEROS
             IF RECUR-EXPIRE-DATE OF TPS-RECUR <= TODAYS-DATE-CYMD
                GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** DO NOT PROCESS PAYROLL RECORD *******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '1' AND
             RECUR-CYCLE-AMOUNT OF TPS-RECUR > ZERO
             GO TO 200-BROWSE-THE-RECUR-FILE.
      ****** ADD TOTAL PIECE COUNT TO CLIENT-TABLE ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             ADD 1                 TO TABLE-TOT-MTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             ADD 1                 TO TABLE-TOT-BMTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             ADD 1                 TO TABLE-TOT-QRTR-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             ADD 1                 TO TABLE-TOT-SANL-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4'
             ADD 1                 TO TABLE-TOT-ANUL-MAIL(TAB-SUB)                                                      
      *01/24/01                                                                                                         
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '5'
             ADD 1                 TO TABLE-TOT-BIAN-MAIL(TAB-SUB)                                                      
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '6'                                                                  
             ADD 1                 TO TABLE-TOT-WKLY-MAIL(TAB-SUB)                                                      
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '7'                                                                  
             ADD 1                 TO TABLE-TOT-BIWK-MAIL(TAB-SUB).                                                     
                                                                                                                        
      ***** SET UP ACCT NO. & NAMES FOR COMPARISIONS ********
          IF RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR > SPACES
             MOVE 'Y'              TO CHECK-ACCT-NUM
           CALL TPSDEDIT USING RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
          ELSE
             MOVE 'N'              TO CHECK-ACCT-NUM.

          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR   TO WS-ADDRESOR-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              WS-ADDRESOR-NAME.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR   TO WS-ADDRESEE-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              WS-ADDRESEE-NAME.

          PERFORM 300-FIND-LAST-PAYMENT THRU 300-EXIT

          GO TO 200-BROWSE-THE-RECUR-FILE.
       200-EXIT.  EXIT.


       250-CHECK-DEL-TABLE.
          IF RECUR-ACCT-NO OF TPS-RECUR = DELETE-ACCT-NO(TAB-SUB)
             MOVE 'Y'               TO ACCT-DELETED.
       250-EXIT.  EXIT.


       260-SETUP-MISSING-REC.
          MOVE RECUR-ACCT-NO OF TPS-RECUR  TO WS-SORT-ACCT-NO.
          MOVE RECUR-SUB-ACCT OF TPS-RECUR TO WS-SORT-SUB-ACCT.
          MOVE RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) TO WS-SORT-CYCLE.
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             ADD 1                 TO TABLE-TOT-MTH-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-MTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             ADD 1                 TO TABLE-TOT-BMTH-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-BMTH-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             ADD 1                 TO TABLE-TOT-QRTR-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-QRTR-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             ADD 1                 TO TABLE-TOT-SANL-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-SANL-MAIL(TAB-SUB)
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4'
             ADD 1                 TO TABLE-TOT-ANUL-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-ANUL-MAIL(TAB-SUB)                                                      
      *01/24/01
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '5'
             ADD 1                 TO TABLE-TOT-BIAN-MAIL(TAB-SUB)                                                      
             ADD 1                 TO TABLE-PRT-BIAN-MAIL(TAB-SUB)                                                      
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '6'
             ADD 1                 TO TABLE-TOT-WKLY-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-WKLY-MAIL(TAB-SUB)                                                      
          ELSE
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '7'
             ADD 1                 TO TABLE-TOT-BIWK-MAIL(TAB-SUB)
             ADD 1                 TO TABLE-PRT-BIWK-MAIL(TAB-SUB).

          IF RECUR-CYCLE-DATE OF TPS-RECUR NUMERIC
             MOVE RECUR-CYCLE-DATE OF TPS-RECUR TO WORK-DATE
             IF WORK-DATE(3:2) > 94
                MOVE 19            TO WORK-DATE(1:2)
             ELSE
                MOVE 20            TO WORK-DATE(1:2)
             END-IF
             MOVE WORK-DATE        TO WS-SORT-RECV-DATE
          ELSE
             MOVE ZEROS            TO WS-SORT-RECV-DATE
          END-IF.
      *JM10/97   IF RECUR-ADMIN-LOGON OF TPS-RECUR = SPACES
      *      MOVE 'NYLEZUT   ' TO RECUR-ADMIN-LOGON OF TPS-RECUR
      *   END-IF.
      *   MOVE RECUR-ADMIN-LOGON OF TPS-RECUR  TO LOGREC-KEY.
      *   PERFORM 450-READ-LOGON-FILE THRU 450-EXIT.
      *   MOVE LOGREC-ADMIN-ACCT-BRANCH TO WS-SORT-ACCT-BRANCH.
      *   MOVE LOGREC-ADMIN-ACCT-ADMIN  TO WS-SORT-ACCT-ADMIN.
      *   MOVE LOGREC-ACCESS-LEVEL      TO WS-SORT-ACCESS-LEVEL.
      *   MOVE LOGREC-KEY               TO WS-SORT-ACCT-LOGON.
      *JM04/00 **** DON'T READ LOGON FILE WHEN OVERNIGHT PROCESS ****
          MOVE HOLD-ACCT-BRANCH         TO WS-SORT-ACCT-BRANCH.
          MOVE HOLD-ACCT-ADMIN          TO WS-SORT-ACCT-ADMIN.
          MOVE 04                       TO WS-SORT-ACCESS-LEVEL.
          MOVE HOLD-ACCT-LOGON          TO WS-SORT-ACCT-LOGON.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR
                                   TO WS-SORT-FROM-NAME.
          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR
                                   TO WS-SORT-FOR-NAME.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
                                   TO WS-SORT-BILL-ACCT.
      *10/25/07                                                                                                           
          move spaces                   to ws-sort-payee-name.                                                            
          move recur-chart-acct-01 of tps-recur(1:2)                                                                      
                                        to two-bytes.                                                                     
          if two-bytes = '02' or '11' or '31'                                                                             
             move recur-payee-name of tps-recur
                                        to ws-sort-payee-name                                                             
           end-if.                                                                                                        
                                                                                                                          
          MOVE 'Y'                 TO WS-SORT-NOT-FND.
          WRITE SW-RECORD FROM WS-SORT-RECORD.
       260-EXIT.  EXIT.


       300-FIND-LAST-PAYMENT.
          MOVE RECUR-ACCT-NO OF TPS-RECUR  TO MAIL-ACCT-NO.
          MOVE RECUR-SUB-ACCT OF TPS-RECUR TO MAIL-SUB-ACCT.
          MOVE TODAYS-DATE-CYMD            TO MAIL-RECEIVE-DATE.
          MOVE 90                          TO MAIL-RECEIVE-NUMBER.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START-LOW TO FILE-ACTION.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.

          IF END-OF-FILE-WAS-REACHED
             MOVE ZERO                        TO FILE-STATUS
             PERFORM 260-SETUP-MISSING-REC THRU 260-EXIT
             GO TO 300-EXIT.

          MOVE F-PRIME TO FILE-KEY.
          MOVE F-READ-PREVIOUS TO FILE-ACTION.

       300-FIND-LAST-PAYMENT-LOOP.
          CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
          IF END-OF-FILE-WAS-REACHED OR
             MAIL-ACCT-NO NOT = RECUR-ACCT-NO OF TPS-RECUR OR
             MAIL-SUB-ACCT NOT = RECUR-SUB-ACCT OF TPS-RECUR
             MOVE ZERO                   TO FILE-STATUS
             PERFORM 260-SETUP-MISSING-REC THRU 260-EXIT
             GO TO 300-EXIT.

          IF NOT A-SUCCESSFUL-OPERATION
             MOVE ' RECEIVE' TO FILE-NAME
             MOVE 'MISSMAIL-READP' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
      *      GO TO EXIT-THE-MODULE.

      ***** CHECK IF PAYEE NAME IS STARTS WITH SAME LETTER ******
          IF MAIL-ADDRESOR-NAME(1:1) NOT = WS-ADDRESOR-NAME(1:1)
             GO TO 300-FIND-LAST-PAYMENT-LOOP.
      ***** SET UP ACCT NO. FOR COMPARISION ********
          IF CHECK-ACCT-NUM = 'Y'
             CALL TPSDEDIT USING
                      RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL
             IF RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL NOT =
                RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-RECUR
                GO TO 300-FIND-LAST-PAYMENT-LOOP.

      ***** SET UP NAMES FOR COMPARISIONS ********
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              MAIL-ADDRESOR-NAME.
          CALL TPSVEDIT USING CONVERT-TO-CAPITALS
                              LENGTH-36
                              MAIL-ADDRESEE-NAME.

          IF MAIL-ADDRESOR-NAME = WS-ADDRESOR-NAME AND
             MAIL-ADDRESEE-NAME = WS-ADDRESEE-NAME
             PERFORM 400-SEE-IF-LATE THRU 400-EXIT
             GO TO 300-EXIT.

          GO TO 300-FIND-LAST-PAYMENT-LOOP.
       300-EXIT.
           EXIT.


       400-SEE-IF-LATE.
      ****** CALCULATE NUMBER OF DAYS SINCE LAST MAIL RECEIVED ******
          MOVE TODAYS-DATE-CYMD      TO WORK-DATE.
          SUBTRACT MAIL-RECEIVE-DATE OF TPS-MAIL FROM WORK-DATE
                   GIVING MAIL-DAYS.

      ****** CHECK FOR MONTHLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '0'
             IF (MAIL-DAYS > 100 AND < 7000) OR MAIL-DAYS > 8900
                MOVE 0                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-MTH-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR BI-MONTHLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '1'
             IF (MAIL-DAYS > 200 AND < 7000) OR MAIL-DAYS > 9000
                MOVE 1                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-BMTH-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR QUARTERLY EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '2'
             IF (MAIL-DAYS > 300 AND < 7000) OR MAIL-DAYS > 9100
                MOVE 2                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-QRTR-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR SEMI-ANNUAL EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '3'
             IF (MAIL-DAYS > 600 AND < 7000) OR MAIL-DAYS > 9400
                MOVE 3                 TO WS-SORT-CYCLE
                ADD 1                  TO TABLE-PRT-SANL-MAIL(TAB-SUB)
                PERFORM 500-EXTRACT-DATA.
      ****** CHECK FOR ANNUAL EVENTS ******
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(2:1) = '4' AND
             MAIL-DAYS > 10000
             MOVE 4                 TO WS-SORT-CYCLE
             ADD 1                  TO TABLE-PRT-ANUL-MAIL(TAB-SUB)
             PERFORM 500-EXTRACT-DATA.
       400-EXIT.    EXIT.


       450-READ-LOGON-FILE.
          MOVE F-PRIME TO FILE-KEY.
          MOVE F-START TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'MISSMAIL-START' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       450-CONTINUE.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-READ-NEXT  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'MISSMAIL-REN ' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
       450-EXIT.    EXIT.


       500-EXTRACT-DATA.
      ***** THIS CODE IS TEMPORARY UNTIL RECUR UPDATE IS DONE *****
      *JM10/97 SKIP THIS CODE TO SPEED UP PROCESSING *************
      *JM10/97 USE LOGON FROM CURRENT LOGON          *************
      *JM10/97   IF RECUR-ADMIN-LOGON OF TPS-RECUR = SPACES
      *   MOVE 'NYLEZUT   '      TO RECUR-ADMIN-LOGON OF TPS-RECUR.
      *   MOVE RECUR-ADMIN-LOGON OF TPS-RECUR  TO LOGREC-KEY.
      *   PERFORM 450-READ-LOGON-FILE THRU 450-EXIT.
      *   MOVE LOGREC-ADMIN-ACCT-BRANCH TO WS-SORT-ACCT-BRANCH.
      *   MOVE LOGREC-ADMIN-ACCT-ADMIN  TO WS-SORT-ACCT-ADMIN.
      *   MOVE LOGREC-ACCESS-LEVEL      TO WS-SORT-ACCESS-LEVEL.
      *   MOVE LOGREC-KEY               TO WS-SORT-ACCT-LOGON.
      *JM04/00 **** DON'T READ LOGON FILE WHEN OVERNIGHT PROCESS ****
          MOVE HOLD-ACCT-BRANCH         TO WS-SORT-ACCT-BRANCH.
          MOVE HOLD-ACCT-ADMIN          TO WS-SORT-ACCT-ADMIN.
          MOVE 04                       TO WS-SORT-ACCESS-LEVEL.
          MOVE HOLD-ACCT-LOGON          TO WS-SORT-ACCT-LOGON.
          MOVE MAIL-ACCT-NO             TO WS-SORT-ACCT-NO.
          MOVE MAIL-SUB-ACCT            TO WS-SORT-SUB-ACCT.
          MOVE MAIL-RECEIVE-DATE        TO WS-SORT-RECV-DATE.
          MOVE RECUR-ADDRESEE-NAME OF TPS-RECUR
                                        TO WS-SORT-FROM-NAME.
          MOVE RECUR-ADDRESOR-NAME OF TPS-RECUR
                                        TO WS-SORT-FOR-NAME.
          MOVE RECUR-PAYEE-ACCOUNT-NUMBER OF TPS-MAIL
                                        TO WS-SORT-BILL-ACCT.
      *10/25/07                                                                                                           
          move spaces                   to ws-sort-payee-name.                                                            
          move recur-chart-acct-01 of tps-recur(1:2)                                                                      
                                        to two-bytes.                                                                     
          if two-bytes = '02' or '11' or '31'                                                                             
             move recur-payee-name of tps-recur
                                        to ws-sort-payee-name                                                             
           end-if.                                                                                                        
                                                                                                                          
      ***** WHEN AUTOMATIC PAYMENT MOVE 'A' **********
          IF RECUR-CYCLE-EVENT OF TPS-RECUR(1:1) = '2'
             MOVE 'A'                   TO WS-SORT-NOT-FND
          ELSE
             MOVE 'N'                   TO WS-SORT-NOT-FND.

          WRITE SW-RECORD FROM WS-SORT-RECORD.
       500-EXIT.      EXIT.


       600-PRINT-THE-DATA.
      ********* SET UP ARCHIVE DIRECTORY ***********
          MOVE 'TPSREPRT'                TO PRT-PATH-NAME.
          MOVE 'MISSMAIL'                TO PRT-PATH-RPT-TYPE.
      *** MOVE 'RPT'                     TO PRT-PATH-RPT-NO.
          MOVE 'pcl'                     TO PRT-PATH-RPT-NO.

           IF FILESPEC NOT > SPACES
               MOVE 'NUL' TO FILESPEC
           ELSE
               DISPLAY "TPSFCAL" UPON ENVIRONMENT-NAME
               ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
               MOVE '\tps\prod\files\financal.pcl' TO FILESPEC
      ********* MAKE A DIRECTORY ***********
               MOVE FILESPEC TO DIR-COMMAND-1
                 DIR-COMMAND-3
               MOVE CLIENT-DIRECTORY(1:9) TO DIR-COMMAND-2
                 DIR-COMMAND-4
               DISPLAY DIR-COMMAND UPON COMMAND-LINE
               CALL X'91' USING RESULT
                                FUNCTION-35
                                NULL-PARAMETER
      ********* OPEN NEW FILE IN DIRECTORY ********
               ACCEPT FILESPEC FROM ENVIRONMENT-VALUE
               MOVE '\tps\prod\files\financal.pcl' TO FILESPEC
               MOVE CLIENT-DIRECTORY TO FILESPEC(16:22)
               MOVE FILESPEC TO PRT-COMMAND-PATH
           END-IF.

          OPEN OUTPUT PRT-FILE.

       700-PRINT-DETAIL.
          RETURN SORT-FILE
             AT END
             GO TO 900-END-PRINT.

          INITIALIZE WS-SORT-RECORD.
          MOVE SORT-RECORD         TO WS-SORT-RECORD.

      ******* PRINT NEW PAGE ********
          IF LINES-PRINTED > 40
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-BRANCH NOT = HOLD-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  NOT = HOLD-ACCT-ADMIN
             MOVE WS-SORT-ACCT-BRANCH  TO HOLD-ACCT-BRANCH
             MOVE WS-SORT-ACCT-ADMIN   TO HOLD-ACCT-ADMIN
             PERFORM 750-READ-PA-REC   THRU 750-EXIT
             PERFORM 850-FLOAT-NAME    THRU 850-EXIT
             MOVE WS-FLOAT-1(1:100)    TO RPT-PA-NAME
             MOVE WS-SORT-ACCT-LOGON   TO LOGREC-KEY
                                          HOLD-ACCT-LOGON
             PERFORM 450-READ-LOGON-FILE THRU 450-EXIT
             PERFORM 850-FLOAT-NAME    THRU 850-EXIT
             MOVE WS-FLOAT-1(1:100)    TO RPT-AA-NAME
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-LOGON  NOT = HOLD-ACCT-LOGON
             MOVE WS-SORT-ACCT-LOGON   TO LOGREC-KEY
                                          HOLD-ACCT-LOGON
             PERFORM 450-READ-LOGON-FILE THRU 450-EXIT
             PERFORM 800-HEADING THRU 800-EXIT.

          IF WS-SORT-ACCT-NO = WS-HOLD-ACCT-NO
             GO TO 700-CONTINUE.
          MOVE 9                    TO WS-HOLD-CYCLE.
          MOVE WS-SORT-ACCT-NO      TO WS-HOLD-ACCT-NO.
          MOVE ZERO                 TO WS-TAB.

       710-TABLE-LOOKUP.
          ADD 1                             TO WS-TAB.
          IF WS-TAB > WS-SUB
             MOVE 'CLIENT NOT ON TABLE'     TO RPT-CLIENT-NAME
          ELSE
          IF TABLE-ACCT-NO(WS-TAB) = WS-SORT-ACCT-NO
             NEXT SENTENCE
          ELSE
             GO TO 710-TABLE-LOOKUP.

          MOVE SPACES                       TO WS-FLOAT-PARMS.
          IF TABLE-ACCT-NO(WS-TAB) = 0101000230 OR 0101000248
             MOVE 'CLIENT: '                TO WS-FLOAT-1(1:8)
             MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-1(9:20)
          ELSE
             MOVE '3'                        TO WS-FLOAT-COUNT
             MOVE WS-CLIENT                  TO WS-FLOAT-1
             MOVE TABLE-FIRST-NAME(WS-TAB)   TO WS-FLOAT-2
             IF TABLE-MDDL-INIT(WS-TAB) > SPACES
                MOVE '4'                       TO WS-FLOAT-COUNT
                MOVE TABLE-MDDL-INIT(WS-TAB)   TO WS-FLOAT-3(1:1)
                MOVE '.'                       TO WS-FLOAT-3(2:1)
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-4
             ELSE
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-3
             END-IF
             CALL FLOATIT USING WS-FLOAT-DATA
             CANCEL FLOATIT.

          MOVE WS-FLOAT-1(1:100)            TO RPT-CLIENT-NAME.
          IF LINES-PRINTED > 35
             PERFORM 800-HEADING THRU 800-EXIT.
          IF NO-MAIL = 'Y'
             MOVE '***No Recurring Mail***'  TO RPT-CLIENT-NAME(50:23)
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM SHADE-CLIENT AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM RPT-CLIENT AFTER ADVANCING 1 LINES
             ADD 2                           TO LINES-PRINTED
             GO TO 710-TABLE-LOOKUP
          ELSE
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM SHADE-CLIENT AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM RPT-CLIENT AFTER ADVANCING 1 LINES
             ADD 2                           TO LINES-PRINTED.

       700-CONTINUE.
          IF WS-SORT-CYCLE = WS-HOLD-CYCLE
             NEXT SENTENCE
          ELSE
000100*12/14/99                                                                                                         
             IF WS-TAB = 0                                                                                              
                MOVE 1                   TO WS-TAB                                                                      
              END-IF                                                                                                    
             MOVE WS-SORT-CYCLE          TO WS-HOLD-CYCLE
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             ADD 2                       TO LINES-PRINTED
             IF WS-SORT-CYCLE = 0
                MOVE 'Monthly Invoice Mail'      TO RPT-SECTION-NME
                MOVE TABLE-TOT-MTH-MAIL(WS-TAB)  TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-MTH-MAIL(WS-TAB)  TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 1
                MOVE 'Bi-Monthly Invoice Mail'   TO RPT-SECTION-NME
                MOVE TABLE-TOT-BMTH-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-BMTH-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 2
                MOVE 'Quarterly Invoice Mail'    TO RPT-SECTION-NME
                MOVE TABLE-TOT-QRTR-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-QRTR-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 3
                MOVE 'Semi-Annual Invoice Mail'  TO RPT-SECTION-NME
                MOVE TABLE-TOT-SANL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-SANL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE
             ELSE
             IF WS-SORT-CYCLE = 4
                MOVE 'Annual Invoice Mail'       TO RPT-SECTION-NME
                MOVE TABLE-TOT-ANUL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-ANUL-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE                                                               
      *01/24/01
             ELSE
             IF WS-SORT-CYCLE = 5
                MOVE 'Bi-Annual Invoice Mail'    TO RPT-SECTION-NME                                                     
                MOVE TABLE-TOT-BIAN-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-BIAN-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE                                                               
             ELSE
             IF WS-SORT-CYCLE = 6
                MOVE 'Weekly Invoice Mail'       TO RPT-SECTION-NME
                MOVE TABLE-TOT-WKLY-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-WKLY-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE                                                               
             ELSE
             IF WS-SORT-CYCLE = 7
                MOVE 'Bi-Weekly Invoice Mail'    TO RPT-SECTION-NME                                                     
                MOVE TABLE-TOT-BIWK-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-TOTAL
                MOVE TABLE-PRT-BIWK-MAIL(WS-TAB) TO MAIL-MASK
                MOVE MAIL-MASK                   TO RPT-SECTION-RPTD
                WRITE PRT-RECORD FROM RPT-SECTION-HDR3
                                   AFTER ADVANCING 1 LINE.

          IF WS-SORT-NOT-FND = 'A'
             MOVE '*'                       TO PRT-AUTO
          ELSE
             MOVE SPACES                    TO PRT-AUTO.
          MOVE WS-SORT-RECV-DATE(3:6)    TO WS-DATE-REFORM.
          MOVE 03                        TO WS-DATE-PARAM.
          MOVE SPACES                    TO WS-DATE-EXTEND.
          CALL TPSDATES USING WS-DATE-REQUEST.
          MOVE WS-DATE-TENBYTES          TO PRT-REC-DATE.
          MOVE WS-SORT-FROM-NAME         TO PRT-FROM-NAME.                                                                
      *10/25/07                                                                                                           
      **  MOVE WS-SORT-FOR-NAME          TO PRT-FOR-NAME.
          if ws-sort-payee-name = spaces                                                                                  
             move ws-sort-for-name       to prt-for-name                                                                  
            else                                                                                                          
             move spaces                 to ws-float-parms                                                                
             move '3'                    to ws-float-count                                                                
             move ws-sort-for-name       to ws-float-1                                                                    
             move '/'                    to ws-float-2                                                                    
             move ws-sort-payee-name     to ws-float-3                                                                    
             call floatit using ws-float-data                                                                             
             cancel floatit                                                                                               
             move ws-float-1(1:36)       to prt-for-name                                                                  
           end-if.                                                                                                        
                                                                                                                          
          IF WS-SORT-NOT-FND = 'Y'
             MOVE 'No previous mail found'  TO PRT-ACCOUNT-NO
             MOVE SPACES                    TO PRT-REC-DATE
          ELSE
             MOVE WS-SORT-BILL-ACCT         TO PRT-ACCOUNT-NO.
          WRITE PRT-RECORD FROM PS12-U-N-CGT AFTER ADVANCING 1 LINE.
          WRITE PRT-RECORD FROM PRINT-DATA AFTER ADVANCING 0 LINE.
          WRITE PRT-RECORD FROM PRINT-DISP AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM DISP-LINE AFTER ADVANCING 0 LINES.
          ADD 2                           TO LINES-PRINTED.

          GO TO 700-PRINT-DETAIL.
       700-EXIT.   EXIT.


       750-READ-PA-REC.
          MOVE LOW-VALUES   TO LOGREC-KEY.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-START      TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'MISSMAIL-START' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

       750-CONTINUE.
          MOVE F-PRIME      TO FILE-KEY.
          MOVE F-READ-NEXT  TO FILE-ACTION.
          CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
          IF END-OF-FILE-WAS-REACHED
             GO TO 750-EXIT.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'LOGON' TO FILE-NAME
             MOVE 'MISSMAIL-READN' TO FILE-TEXT.
      *      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

          IF WS-SORT-ACCT-BRANCH = LOGREC-ADMIN-ACCT-BRANCH AND
             WS-SORT-ACCT-ADMIN  = LOGREC-ADMIN-ACCT-ADMIN  AND
             LOGREC-ACCESS-LEVEL = '04' AND
             LOGREC-COVER-LETTER-OPTION = 'Y'
             GO TO 750-EXIT
          ELSE
             GO TO 750-CONTINUE.
       750-EXIT.    EXIT.


       800-HEADING.
          IF PAGES-PRINTED = 0
             MOVE PCL-RESET        TO PRT-RECORD(1:)
             MOVE PCL-LANDSCAPE    TO PRT-RECORD(10:)
             MOVE PCL5-DUPLEX-ON   TO PRT-RECORD(20:)
             WRITE PRT-RECORD      AFTER ADVANCING 0 LINES
          ELSE
             MOVE 0                       TO PAGE-ENDING-1
             MULTIPLY 40 BY LINES-PRINTED GIVING PAGE-ENDING-1
             ADD 50                       TO PAGE-ENDING-1
             MOVE PAGE-ENDING-1           TO PAGE-ENDING-2
                                             LAST-LINE-NO
             ADD 350                      TO LAST-LINE-NO
             WRITE PRT-RECORD FROM DRAW-VARIABLE-COLUMN
                                               AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM LAST-LINE AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES
             WRITE PRT-RECORD FROM PAGE-END AFTER ADVANCING 1 LINES
             WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES
          END-IF.

          IF PAGES-PRINTED > ZERO
           WRITE PRT-RECORD FROM NEW-PAGE    AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-1-A AFTER ADVANCING 0 LINES.
          ADD 1                             TO PAGES-PRINTED.
          MOVE PAGES-PRINTED                TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK           TO PRT-PAGE.
          WRITE PRT-RECORD FROM HEADING-2-A AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM COURIER-59  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM HEADING-2   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM HEADING-3   AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 2 LINES.
      *   WRITE PRT-RECORD FROM PA-NAME     AFTER ADVANCING 0 LINES.
      *   WRITE PRT-RECORD FROM AA-NAME     AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM PS12-U-N-CGT AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM CONFIDENTIAL-LINE-1
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM CONFIDENTIAL-LINE-2
                                            AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM RPT-SECTION-HDR1
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM RPT-SECTION-HDR2
                                            AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 0 LINES.
          MOVE 12                           TO LINES-PRINTED.
       800-EXIT.          EXIT.


       850-FLOAT-NAME.
          MOVE SPACES                       TO WS-FLOAT-PARMS.
          MOVE '2'                          TO WS-FLOAT-COUNT
          MOVE LOGREC-ADMIN-FIRST-NAME      TO WS-FLOAT-1
          MOVE LOGREC-ADMIN-LAST-NAME       TO WS-FLOAT-2
          CALL FLOATIT USING WS-FLOAT-DATA
          CANCEL FLOATIT.
       850-EXIT.       EXIT.


       900-END-PRINT.
          MOVE 0                       TO PAGE-ENDING-1.
          MULTIPLY 40 BY LINES-PRINTED GIVING PAGE-ENDING-1.
          ADD 50                       TO PAGE-ENDING-1.
          MOVE PAGE-ENDING-1           TO PAGE-ENDING-2
                                          LAST-LINE-NO.
          ADD 350                      TO LAST-LINE-NO.

          WRITE PRT-RECORD FROM COURIER-56 AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM LAST-LINE  AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM RPT-LAST-LINE AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM DRAW-VARIABLE-COLUMN
                                            AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM PCL-RESET   AFTER ADVANCING 0 LINES.

      *04/06/08 **** ADD DONATION REPORT ****
          IF FILESPEC = 'NUL'
             CONTINUE
          ELSE
             PERFORM 1000-DONATIONS THRU 1000-EXIT.

          CLOSE PRT-FILE.

       900-EXIT.       EXIT.

      *04/06/08
       1000-DONATIONS.

151000    MOVE 22                    TO WS-DATE-PARAM.
151100    MOVE TODAYS-DATE-CYMD      TO WS-DATE-REFORM-LEN08.
151100    MOVE '550'                 TO WS-DATE-TENBYTES(9:3).
151300    CALL TPSDATES USING WS-DATE-REQUEST.
151400    MOVE WS-DATE-REFORM-LEN08  TO OLD-DATE.
151400    MOVE ZERO                  TO TAB-SUB.
          INITIALIZE MAIL-KEY OF TPS-MAIL.
018000
018100 READ-THE-MAIL.
018000
          ADD 1                      TO TAB-SUB.
          IF TAB-SUB > WS-SUB
             GO TO READ-THE-MAIL-EXIT.
          MOVE TABLE-ACCT-NO(TAB-SUB)  TO MAIL-ACCT-NO OF TPS-MAIL.
          MOVE TABLE-SUB-ACCT(TAB-SUB) TO MAIL-SUB-ACCT OF TPS-MAIL.
021300    MOVE OLD-DATE     TO MAIL-RECEIVE-DATE OF TPS-MAIL.
          MOVE ZEROS        TO MAIL-RECEIVE-NUMBER OF TPS-MAIL.
018000
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'MISMAIL-ST' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO READ-THE-MAIL-EXIT.
026880
026880
022200 READ-NEXT-RECORD.
022300    MOVE F-PRIME TO FILE-KEY.
22400     MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'MISMAIL-RNX' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO READ-THE-MAIL-EXIT
023500     END-IF.
023610
026880    IF MAIL-ACCT-NO OF TPS-MAIL = TABLE-ACCT-NO(TAB-SUB) AND
026880       MAIL-SUB-ACCT OF TPS-MAIL = TABLE-SUB-ACCT(TAB-SUB)
026880          CONTINUE
026880    ELSE
026880          GO TO READ-THE-MAIL.
023610
026880    IF MAIL-CATEGORY-CODE OF TPS-MAIL NOT = '02'
026880       GO TO READ-NEXT-RECORD.
026880
287410    IF MAIL-DISPOSITION OF TPS-MAIL = '88'
026880       GO TO READ-NEXT-RECORD.
026880
023000    IF RECUR-CHART-ACCT-01 OF TPS-MAIL(1:2) = 02 AND
023000       RECUR-CHART-ACCT-02 OF TPS-MAIL(1:6) = 000002 AND
023000       MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL > ZEROS
023100        CONTINUE
023200    ELSE
023300       GO TO READ-NEXT-RECORD.
023500
      *
007100
007200 READ-THE-CHECKS.


026880    MOVE MAIL-ACCT-NO OF TPS-MAIL TO CHECK-ACCT-NO.
026880    MOVE MAIL-SUB-ACCT OF TPS-MAIL TO CHECK-SUB-ACCT.
026880    MOVE MAIL-CHECK-TRANSACTION-NO OF TPS-MAIL TO
026880                                      CHECK-TRANSACTION-NO.

007400    MOVE F-PRIME TO FILE-KEY.
007500    MOVE F-START TO FILE-ACTION.
007600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
007700    IF NO-RECORD-WAS-FOUND
009216       GO TO READ-NEXT-RECORD.
007800    IF NOT A-SUCCESSFUL-OPERATION
007900       MOVE ' CHECK' TO FILE-NAME
008000       MOVE 'DONLTR-SBR' TO FILE-TEXT
008100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO READ-NEXT-RECORD.
008300 READ-ALL-CHECK-NUMBERS.
008400    MOVE F-PRIME TO FILE-KEY.
008500    MOVE F-READ-NEXT TO FILE-ACTION.
008600    CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
008700    IF END-OF-FILE-WAS-REACHED
008700       GO TO READ-NEXT-RECORD.
008800    IF NOT A-SUCCESSFUL-OPERATION
008900       MOVE ' CHECK' TO FILE-NAME
009000       MOVE 'MISMAIL-RNX' TO FILE-TEXT
009100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO READ-NEXT-RECORD.
244500
009215    IF CHECK-ACCT-NO NOT = MAIL-ACCT-NO OF TPS-MAIL
009216       GO TO READ-NEXT-RECORD.
244500
244600    IF CHECK-NUMBER = ZEROS
023300       GO TO READ-NEXT-RECORD.
244500
244600    IF CHECK-DONATION-LETTER = 'Y'
023300       GO TO READ-NEXT-RECORD.
244500
009215    IF CHECK-ACCT-NO = MAIL-ACCT-NO OF TPS-MAIL AND
009216       CHECK-SUB-ACCT = MAIL-SUB-ACCT OF TPS-MAIL AND
009217       CHECK-RECEIVE-DATE = MAIL-RECEIVE-DATE OF TPS-MAIL
009218       AND
009219       CHECK-RECEIVE-NUMBER =
009219                   MAIL-RECEIVE-NUMBER OF TPS-MAIL
009219        CONTINUE
009219    ELSE
009219       GO TO READ-NEXT-RECORD.
009220
009220*START WITH CHECKS FROM 01/01/08
009230   IF CHECK-DATE > 20080101
009220      CONTINUE
009230   ELSE
009228      GO TO READ-NEXT-RECORD.
009220
009220*ADD RECORD TO TABLE
009230   ADD 1                    TO TBL-IND.
009220
009230   MOVE CHECK-ACCT-NO       TO TBL-ACCT-NO(TBL-IND).
009228   MOVE CHECK-SUB-ACCT      TO TBL-SUB-ACCT(TBL-IND).
005540   MOVE 'C'                 TO TBL-CHK-TYPE(TBL-IND).
005540   MOVE CHECK-DATE          TO TBL-CHK-DATE(TBL-IND).
009288   MOVE CHECK-NUMBER        TO TBL-CHK-NO(TBL-IND).
009289   MOVE CHECK-AMOUNT        TO TBL-CHK-AMT(TBL-IND).
009290   MOVE CHECK-RECEIVE-DATE  TO TBL-RECV-DATE(TBL-IND).
009288   MOVE CHECK-RECEIVE-NUMBER TO TBL-RECV-NO(TBL-IND).
009289   MOVE RECUR-PAYEE-NAME OF TPS-MAIL
009290                            TO TBL-PAYEE-NAME(TBL-IND).
009313   MOVE RECUR-PAYEE-MEMO-FIELD OF TPS-MAIL
009289                            TO TBL-MEMO(TBL-IND).
009290   MOVE CHECK-TRANSACTION-NO
009274                            TO TBL-CHK-TRANSACTION-NO(TBL-IND).
009289   MOVE MAIL-ADDRESEE-NAME OF TPS-MAIL
009290                            TO TBL-ADDRESSEE-NAME(TBL-IND).
009289   MOVE ZEROS               TO TBL-FGN-CHK-AC-NO(TBL-IND)
009290                               TBL-FGN-CHK-TRANS-CODE(TBL-IND)
009362                               TBL-FGN-TIE-BREAKER(TBL-IND).
009290
009219   GO TO READ-NEXT-RECORD.
009220
022700 READ-THE-MAIL-EXIT. EXIT.
007100
007200 READ-FGN-CHECKS.
005900
005900*   MOVE TPS-MAIL-HOLD    TO TPS-MAIL-REC.
022300*   MOVE MAIL-ADDRESOR-NAME OF TPS-MAIL-HOLD
022300*                           TO FGN-ADDRESOR-NAME.
      *   CALL TPSVEDIT USING CONVERT-TO-CAPITALS                                          00304700
      *                       LENGTH-36                                                    00304800
      *                       FGN-ADDRESOR-NAME.                                           00304900

026880    INITIALIZE FGN-CHECK-REC.
026880    MOVE 0101000016   TO FGN-CHECK-ACCT-NO.
026880    MOVE 00           TO FGN-CHECK-SUB-ACCT.
026880    MOVE 2            TO FGN-CHECK-CHECKING-AC-NO.
021300    MOVE OLD-DATE     TO FGN-CHECK-RECEIVE-DATE.
105700                                                                                     00109900
105800    MOVE F-PRIME TO FILE-KEY.                                                        00110000
105900    MOVE F-START TO FILE-ACTION.                                                     00110100
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.                                  00285500
106200    IF NOT A-SUCCESSFUL-OPERATION                                                    00110600
260800       GO TO READ-FGN-CHECKS-EXIT                                                    00290800
          END-IF.                                                                          00111100
106700 READ-NEXT-FGNCK-REC.                                                                00111300
259700    MOVE F-PRIME     TO FILE-KEY.                                                    00289700
259800    MOVE F-READ-NEXT TO FILE-ACTION.                                                 00289800
256500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.                                  00285500
260400    IF NOT A-SUCCESSFUL-OPERATION                                                    00290400
260800       GO TO READ-FGN-CHECKS-EXIT                                                    00290800
260900      END-IF.                                                                        00290900
260900                                                                                     00290900
260900*******  IGNORE SPECAIL DEBIT ACCTS FOR SUMMARY                                      00290900
003600    IF FGN-CHECK-CHECKING-AC-NO = 99 AND
004200       FGN-CHECK-RECEIVE-NUMBER = 11111
023100       GO TO READ-NEXT-FGNCK-REC
260900    END-IF.                                                                          00290900
023500
111700    IF FGN-CHECK-DATE < OLD-DATE
108700       GO TO READ-NEXT-FGNCK-REC.
111400                                                                                     00118300
009220*START WITH CHECKS FROM 01/01/08
009230   IF FGN-CHECK-DATE > 20080101
009220      CONTINUE
009230   ELSE
009228      GO TO READ-NEXT-FGNCK-REC.
026880
023000    IF FGN-CHART-ACCT-01(1:2) = 02 AND
023000       FGN-CHART-ACCT-02(1:6) = 000002 AND
023000       FGN-CHECK-AMOUNT > ZERO
023100        CONTINUE
023200    ELSE
023300       GO TO READ-NEXT-FGNCK-REC.
023500
111700    IF FGN-CHECK-REGULAR AND FGN-CHECK-AMOUNT > ZERO
108700       CONTINUE
111700    ELSE
108700       GO TO READ-NEXT-FGNCK-REC.
023500
111700    IF FGN-DONATION-LETTER = 'Y'
108700       GO TO READ-NEXT-FGNCK-REC.
108800
009220*ADD RECORD TO TABLE
009230    ADD 1                    TO TBL-IND.
009220
106700    MOVE FGN-CHECK-ACCT-NO   TO TBL-ACCT-NO(TBL-IND).
106700    MOVE FGN-CHECK-SUB-ACCT  TO TBL-SUB-ACCT(TBL-IND).
005540    MOVE 'F'                 TO TBL-CHK-TYPE(TBL-IND).
106700    MOVE FGN-CHECK-DATE      TO TBL-CHK-DATE(TBL-IND).
106700    MOVE FGN-CHECK-NUMBER    TO TBL-CHK-NO(TBL-IND).
108700    MOVE FGN-CHECK-AMOUNT    TO TBL-CHK-AMT(TBL-IND).
108800    MOVE FGN-CHECK-RECEIVE-DATE TO TBL-RECV-DATE(TBL-IND).
107900    MOVE FGN-CHECK-RECEIVE-NUMBER  TO TBL-RECV-NO(TBL-IND).
111700    MOVE FGN-CHECK-PAYEE-NAME TO TBL-PAYEE-NAME(TBL-IND).
111700    MOVE FGN-CHECK-MEMO-FIELD TO TBL-MEMO(TBL-IND).
009290    MOVE ZEROS              TO TBL-CHK-TRANSACTION-NO(TBL-IND).
009289    MOVE FGN-CHECK-CHECKING-AC-NO TO TBL-FGN-CHK-AC-NO(TBL-IND).
009290    MOVE FGN-CHECK-TRANSACTION-CODE
009290                            TO TBL-FGN-CHK-TRANS-CODE(TBL-IND).
009362    MOVE FGN-CHECK-TIE-BREAKER
009362                            TO TBL-FGN-TIE-BREAKER(TBL-IND).

          GO TO READ-NEXT-FGNCK-REC.
108800
007200 READ-FGN-CHECKS-EXIT.   EXIT.
022700
006500    SORT CHECK-TABLE ASCENDING TBL-ACCT-NO TBL-CHK-DATE
006600                               TBL-CHK-NO TBL-CHK-TYPE.
219400
          MOVE ZERO                         TO PAGES-PRINTED.
          MOVE 41                           TO LINES-PRINTED.
022700
006500 PRINT-DON-DETAIL.
219500
219600    ADD 1      TO PANEL-IND
219600    IF PANEL-IND > TBL-IND
219600       GO TO 1000-EXIT.
219500
          IF LINES-PRINTED > 40
             PERFORM PRT-DON-HEADER THRU PRT-DON-HEADER-EXIT.
219500
219600    IF TBL-ACCT-NO(PANEL-IND) NOT = WS-ACCT-NO
219600       MOVE TBL-ACCT-NO(PANEL-IND) TO WS-ACCT-NO
             MOVE ZERO                   TO WS-TAB
219500       PERFORM CLIENT-LOOKUP THRU CLIENT-LOOKUP-EXIT.
219600
219600    MOVE TBL-CHK-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-CHK-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE DON-WORK-DATE           TO PRT-CK-DATE.
219700    MOVE TBL-CHK-NO(PANEL-IND)   TO PRT-CK-NO.
219700    PERFORM CK-NO-PCL THRU
219700            CK-NO-PCL-EXIT.
005540    IF TBL-CHK-TYPE(PANEL-IND) = 'F'
005540       MOVE 'F'                 TO PRT-CHK-TYPE
005540    ELSE
005540       MOVE SPACES              TO PRT-CHK-TYPE.
219700    MOVE TBL-CHK-AMT(PANEL-IND)  TO PRT-CK-AMT.
219700    PERFORM CK-AMT-PCL THRU
219700            CK-AMT-PCL-EXIT.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(3:2) TO WORK-YY.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(5:2) TO WORK-MM.
219600    MOVE TBL-RECV-DATE(PANEL-IND)(7:2) TO WORK-DD.
219600    MOVE DON-WORK-DATE             TO PRT-RECV-DATE.
219800    MOVE TBL-PAYEE-NAME(PANEL-IND) TO PRT-PAYEE-NAME.
219800    MOVE TBL-MEMO(PANEL-IND)   TO PRT-PAYEE-MEMO.
          WRITE PRT-RECORD FROM PRT-DON-DATA AFTER ADVANCING 1 LINES.
          ADD 1                           TO LINES-PRINTED

          GO TO PRINT-DON-DETAIL.

       1000-EXIT.
          WRITE PRT-RECORD FROM PRT-DON-END AFTER ADVANCING 2 LINES.
       EXIT.

       PRT-DON-HEADER.

          IF PAGES-PRINTED = 0
             WRITE PRT-RECORD FROM PCL-LANDSCAPE AFTER 0 LINES
          ELSE
             WRITE PRT-RECORD FROM NEW-PAGE AFTER ADVANCING 0 LINES.                       00492000
          ADD 1                             TO PAGES-PRINTED.
          MOVE PAGES-PRINTED                TO PAGES-PRINTED-MASK.
          MOVE PAGES-PRINTED-MASK           TO PRT-DON-PAGE.
      *   WRITE PRT-RECORD FROM NEW-PAGE    AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM COURIER-56  AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM DON-HEADING-1 AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 2 LINES.
          WRITE PRT-RECORD FROM DON-HEADING-2 AFTER ADVANCING 1 LINES.
          WRITE PRT-RECORD FROM THIN-LINE   AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM COURIER-56-N  AFTER ADVANCING 0 LINES.
          MOVE 4                            TO LINES-PRINTED.

       PRT-DON-HEADER-EXIT.  EXIT.

                                                                                           00483600
       CK-NO-PCL.                                                                          00483500
          IF TBL-CHK-NO(PANEL-IND) > 9999                                                  00483700
             MOVE '0329'       TO PRT-CK-NO-PCL                                            00483800
             GO TO CK-NO-PCL-EXIT                                                          00483900
            ELSE                                                                           00484000
          IF TBL-CHK-NO(PANEL-IND) > 999                                                   00483700
             MOVE '0340'       TO PRT-CK-NO-PCL                                            00483800
             GO TO CK-NO-PCL-EXIT                                                          00483900
            ELSE                                                                           00484400
          IF TBL-CHK-NO(PANEL-IND) > 99                                                    00483700
             MOVE '0348'       TO PRT-CK-NO-PCL                                            00483800
             GO TO CK-NO-PCL-EXIT                                                          00483900
            ELSE                                                                           00484800
          IF TBL-CHK-NO(PANEL-IND) > 9                                                     00483700
             MOVE '0359'       TO PRT-CK-NO-PCL                                            00483800
             GO TO CK-NO-PCL-EXIT                                                          00483900
            ELSE                                                                           00484800
             MOVE '0368'       TO PRT-CK-NO-PCL.                                           00485000
       CK-NO-PCL-EXIT.  EXIT.                                                              00486200
                                                                                           00486300
                                                                                           00486400
       CK-AMT-PCL.                                                                         00486500
          IF TBL-CHK-AMT(PANEL-IND) > 999999.99                                            00483700
             MOVE '0555'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00486900
          IF TBL-CHK-AMT(PANEL-IND) > 99999.99                                             00483700
             MOVE '0569'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00486900
          IF TBL-CHK-AMT(PANEL-IND) > 9999.99                                              00483700
             MOVE '0581'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00487300
          IF TBL-CHK-AMT(PANEL-IND) > 999.99                                               00483700
             MOVE '0593'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00487700
          IF TBL-CHK-AMT(PANEL-IND) > 99.99                                                00483700
             MOVE '0607'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00488100
          IF TBL-CHK-AMT(PANEL-IND) > 9.99                                                 00483700
             MOVE '0620'       TO PRT-CK-AMT-PCL                                           00483800
             GO TO CK-AMT-PCL-EXIT                                                         00483900
            ELSE                                                                           00488500
             MOVE '0628'       TO PRT-CK-AMT-PCL.                                          00488600
       CK-AMT-PCL-EXIT.    EXIT.                                                           00488700

       CLIENT-LOOKUP.
          ADD 1                             TO WS-TAB.
          IF WS-TAB > WS-SUB
             MOVE 'CLIENT NOT ON TABLE'     TO RPT-CLIENT-NAME
             WRITE PRT-RECORD FROM SHADE-CLIENT AFTER  0 LINE
             WRITE PRT-RECORD FROM RPT-CLIENT AFTER 1 LINE
             ADD 2                           TO LINES-PRINTED
             GO TO CLIENT-LOOKUP-EXIT.

          IF TABLE-ACCT-NO(WS-TAB) = WS-ACCT-NO
             NEXT SENTENCE
          ELSE
             GO TO CLIENT-LOOKUP.

          MOVE SPACES                       TO WS-FLOAT-PARMS.
          IF TABLE-ACCT-NO(WS-TAB) = 0101000230 OR 0101000248
             MOVE 'CLIENT: '                TO WS-FLOAT-1(1:8)
             MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-1(9:20)
          ELSE
             MOVE '3'                        TO WS-FLOAT-COUNT
             MOVE WS-CLIENT                  TO WS-FLOAT-1
             MOVE TABLE-FIRST-NAME(WS-TAB)   TO WS-FLOAT-2
             IF TABLE-MDDL-INIT(WS-TAB) > SPACES
                MOVE '4'                       TO WS-FLOAT-COUNT
                MOVE TABLE-MDDL-INIT(WS-TAB)   TO WS-FLOAT-3(1:1)
                MOVE '.'                       TO WS-FLOAT-3(2:1)
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-4
             ELSE
                MOVE TABLE-LAST-NAME(WS-TAB)   TO WS-FLOAT-3
             END-IF
             CALL FLOATIT USING WS-FLOAT-DATA
             CANCEL FLOATIT.

          MOVE WS-FLOAT-1(1:100)          TO RPT-CLIENT-NAME.
          WRITE PRT-RECORD FROM SHADE-CLIENT AFTER ADVANCING 0 LINES.
          WRITE PRT-RECORD FROM RPT-CLIENT AFTER ADVANCING 1 LINES.
          ADD 2                           TO LINES-PRINTED.

       CLIENT-LOOKUP-EXIT.   EXIT.

       EXIT-THE-MODULE.
           MOVE F-PRIME      TO FILE-KEY.
           SET FR-CLOSE         TO TRUE
           CALL TPSIO001 USING FILE-REQUEST TPS-LOGON.
            IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'LOGON' TO FILE-NAME
                 MOVE 'MISSMAIL-CLOSE' TO FILE-TEXT.
      *          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

           CALL TPSIORCR USING FILE-REQUEST TPS-RECUR.
            IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'RECUR' TO FILE-NAME
                 MOVE 'MISSMAIL-CLOSE' TO FILE-TEXT.
      *          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

           CALL TPSIOREC USING FILE-REQUEST TPS-MAIL.
            IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'RECVE' TO FILE-NAME
                 MOVE 'MISSMAIL-CLOSE' TO FILE-TEXT.
      *          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.

           CALL TPSIO004 USING FILE-REQUEST TPS-PROFL.
           IF NOT A-SUCCESSFUL-OPERATION
                 MOVE 'PROFL' TO FILE-NAME
                 MOVE 'MISSMAIL-CLOSE' TO FILE-TEXT.
      *          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
014600*04/06/08
014700      CALL TPSIOCHK USING FILE-REQUEST TPS-CHECK-REC.
014800      IF NOT A-SUCCESSFUL-OPERATION
014900         MOVE 'CHECK ' TO FILE-NAME
015000         MOVE 'MISSMAIL-CLO' TO FILE-TEXT
015100*        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
015200      END-IF.
015300
265500    CALL TPSIO026 USING FILE-REQUEST FGN-CHECK-REC.
458100    IF NOT A-SUCCESSFUL-OPERATION
265700       MOVE ' FGNCK  '   TO FILE-NAME
265800       MOVE 'MISSMAIL-CLO' TO FILE-TEXT
265900*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
014080    END-IF.
266100

       END-OF-THE-LINE.
            CANCEL TPSDATES.
            CANCEL TPSIOERR.
            CANCEL TPSIO004.
            CANCEL TPSIOREC.
            CANCEL TPSIORCR.
            CANCEL TPSIOCHK.
            CANCEL TPSIO026.


           IF PROCESS-RPTS-DISPLAY-FLAG = 1
               invoke PROCESS-RPTS::Hide
               MOVE 0 TO PROCESS-RPTS-DISPLAY-FLAG
           END-IF.

           INITIALIZE CURRENT-XY-PARAMETERS.
           MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
           MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

               GOBACK GIVING CURRENT-XY-PARAMETERS.

       FILE-ERROR.
            CALL TPSIOERR USING FILE-REQUEST
                                WS-CURRENT-XY-PARM.
            CANCEL TPSIOERR.

            MOVE WS-CURRENT-XY-PARM(1:4) TO WS-CURRENT-X.
            MOVE WS-CURRENT-XY-PARM(5:4) TO WS-CURRENT-Y.

            INITIALIZE CURRENT-XY-PARAMETERS.
            MOVE WS-CURRENT-X TO CURRENT-XY-PARAMETERS(1:4).
            MOVE WS-CURRENT-Y TO CURRENT-XY-PARAMETERS(5:4).

       FILE-ERROR-EXIT. EXIT.


