000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. SEEMAIL.
000300 AUTHOR. JOHN CURRAN.
000400***************************************************************
000500*   PRINT CUSTOMIZED MAIL REPORTS                             *
000600***************************************************************
000700 ENVIRONMENT DIVISION.
000800 CONFIGURATION SECTION.
000900 SOURCE-COMPUTER. IBM-PS2.
001000 OBJECT-COMPUTER. IBM-PS2.
001100 FILE-CONTROL.
001600
           SELECT PRT-FILE ASSIGN TO PRINTER
           ORGANIZATION IS LINE SEQUENTIAL
               FILE STATUS IS TPS-FILE-STATUS.


001600
001700 DATA DIVISION.
001800 FILE SECTION.
001900 FD  PRT-FILE                                                     00001600
002000     LABEL RECORDS ARE OMITTED                                    00001700
002100     RECORD CONTAINS 200 CHARACTERS.                              00001800
002200 01  PRT-RECORD.
012000*    10 prt-chart-01       pic x(10).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-02       pic x(10).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-03       pic x(10).
002220*   10 FILLER             PIC X(02).
      *   10 PRT-ACCT-NO        PIC x(10).
      *    10 PRT-MAIL-SORT-NUM  PIC 9(02).
           10 FILLER             PIC X(05).
002300     10 PRT-ADDSEE-NAME    PIC X(35).
           10 FILLER             PIC X(03).
           10 PRT-TOT-PACS       PIC zz9.
           10 FILLER             PIC X(05).

002300*    10 PRT-RECV-NO        PIC X(05).
           10 PRT-MAIL-CNT       PIC ZZ9.

           10 FILLER             PIC X(02).
002300*    10 PRT-ADDSOR-NAME    PIC X(26).
      *    10 PRT-FWD-ADM        PIC 9(3).
016406*    10 prt-payee-name     pic x(36).
002220     10 FILLER             PIC X(02).
002300*    10 PRT-IMAGE-NUMBER   PIC ZZZZZZZZ.
002220     10 FILLER             PIC X(02).
002210*    10 PRT-ACCT-NO        PIC X(10).
002220     10 FILLER             PIC X(03).
002300*    10 PRT-first-init     PIC X(01).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-last-name      PIC X(20).
002220     10 FILLER             PIC X(01).
002300     10 PRT-RECV-DATE      PIC X(08).
002220     10 FILLER             PIC X(01).
002300*    10 PRT-RECV-NO        PIC X(05).
002220     10 FILLER             PIC X(02).
002300*    10 PRT-ADDSOR-NAME    PIC X(26).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-CHART-INFO     PIC X(30).
002220     10 FILLER             PIC X(01).
002220*    10 PRT-AMOUNT         PIC ZZZZ,ZZZ.ZZ.
002220     10 FILLER             PIC X(02).
012000*    10 PRT-PAYEE-ACCT     pic x(20).
002220     10 filler             pic x(70).
012000*    10 prt-chart-01       pic x(06).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-02       pic x(06).
002220*    10 filler             pic x(01).
012000*    10 prt-chart-03       pic x(06).
002220*    10 FILLER             PIC X(02).
002210*    10 PRT-sub-ACCT-NO    PIC X(02).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-IMAGE-NUMBER   PIC ZZZZZZZ9.
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-split-flag     PIC X(01).
002220     10 FILLER             PIC X(02).
002300*    10 PRT-ADDSEE-NAME    PIC X(20).
002220*    10 FILLER             PIC X(01).
002300*    10 PRT-CHECK-NUMBER   PIC X(10).
002220*    10 FILLER             PIC X(02).
002300*    10 PRT-CHECK-AMOUNT   PIC ZZ,ZZZ,ZZZ.99.
002220*    10 FILLER             PIC X(20).



001800
006000
009300
009400
009500 WORKING-STORAGE SECTION.

       01  FILESPEC                    PIC X(80) VALUE 'NUL'.
           88 ITS-THE-FIRST-PASS  VALUE 'NUL'.
           88 WE-NEED-A-FILE-NAME VALUE SPACES.





002200 01  strt-RECORD.
002300     10 strt-split-flag     PIC X(01).
002300
           COPY "PCL5VALU.CPY".
002220
027200     COPY "PCLVALUE.CPY".
009600     COPY "TPSFILES.CPY".
009700     COPY "KEYVALUE.CPY".
       01  TPS-EMAIL-REC.
           COPY "TPSEMAIL.CPY".
010000 01  TPS-MAIL-REC.
010100     COPY "TPSMAIL.CPY".
010000 01  TPS-MEMO-REC.
010100     COPY "TPSMEMO.CPY".
010120 01  TPS-INVOICE-REC.
010130     COPY "TPSINVC.CPY".
010110 01  TPS-PROFL-REC.
010111     COPY "TPSPROFL.CPY".
010120 01  TPS-LOGON-REC.
010130     COPY "TPSLOGON.CPY".
010120 01  tps-check-rec.
010130     copy "tpscheck.cpy".
       01  TPSIO033                      pic x(08) value 'tpsio033'.

010200 01  tpsiochk                      pic x(08) value 'tpsiochk'.
010200 01  TPSIOREC                      PIC X(08) VALUE 'TPSIOREC'.
010200 01  TPSIOMEM                      PIC X(08) VALUE 'TPSIOMEM'.
010200 01  TPSIO022                      PIC X(08) VALUE 'TPSIO022'.
010200 01  TPSIO004                      PIC X(08) VALUE 'TPSIO004'.
010300 01  PROGRAM-NAMES.
010400  10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.
010500  10 TPSCHART    PIC X(08) VALUE 'TPSCHART'.
010600  10 FLOATBIG    PIC X(08) VALUE 'FLOATBIG'.
010610  10 TPSDATES    PIC X(08) VALUE 'TPSDATES'.
010620  10 TPS124      PIC X(08) VALUE 'TPS124  '.
010620  10 tps1010g    PIC X(08) VALUE 'tps1010g'.
010700  10 FILLER      PIC X(08) VALUE HIGH-VALUES.
010800 01  REC-COUNT   PIC 9(05) VALUE ZEROS.
010810 01  ALL-MAIL    PIC 9(09) VALUE ZEROS.
010900 01  TPS-FILE-STATUS                       PIC XX.
011000     88  TPS-CARRIER-FILE-OK VALUE '00', '02'.
011100
044100                                                                                     00062900
044200 01  WS-TODAYS-DATE-YMD         PIC  9(06).                                          00063000
044300 01  FILLER REDEFINES WS-TODAYS-DATE-YMD.                                            00063100
044400     10  WS-TODAYS-DATE-YMD-YY  PIC  9(02).                                          00063200
044500     10  WS-TODAYS-DATE-YMD-MM  PIC  9(02).                                          00063300
044600     10  WS-TODAYS-DATE-YMD-DD  PIC  9(02).                                          00063400
011100
002200 01 WS-PAGE          PIC 9(02) VALUE ZERO.
002200 01 LINE-COUNT       PIC 9(02) VALUE ZERO.
      *----------------AC REPORT VARIABLES--------------------
       01 WS-MAIL-ACCT-TEMP    PIC 9(12).
       01 WS-MAIL-ACCT-TEMP2   PIC 9(10).
       01 WS-STR-1             PIC X(15) VALUE '002016020900001'.
      *01 WS-STR-1             PIC X(15).
       01 WS-STR-2             PIC X(2) VALUE '00'.
       01 WS-STR-RECEIVE-NUM   PIC 9(5) VALUE 00001.
       01 WS-STR-NEW-KEY       PIC X(25).
       01 WS-STR-NEW-PFL-KEY   PIC X(12).
       01 WS-DELETED-ACCT      PIC 9(12).
       01 WS-NO-MAIL-TEMP      PIC 9(10).




       01  WS-CURRENT-DATE-FIELDS.
           05  WS-CURRENT-DATE.
               10  WS-CURRENT-YEAR    PIC  9(4).
               10  WS-CURRENT-MONTH   PIC  9(2).
               10  WS-CURRENT-DAY     PIC  9(2).
           05  WS-CURRENT-TIME.
               10  WS-CURRENT-HOUR    PIC  9(2).
               10  WS-CURRENT-MINUTE  PIC  9(2).
               10  WS-CURRENT-SECOND  PIC  9(2).
               10  WS-CURRENT-MS      PIC  9(2).
           05  WS-DIFF-FROM-GMT       PIC S9(4).
       01 WS-PREVIOUS-FIELDS.
          05 WS-PREVIOUS-DATE.
             10 WS-PREVIOUS-YEAR         PIC 9(4).
             10 WS-PREVIOUS-MONTH        PIC 9(2).
             10 WS-PREVIOUS-DAY          PIC 9(2).

       01 WS-INTEGER                     PIC 9(8).
       01 WS-INTEGER-TEST                PIC 9(8).
       01 WS-CURRENT-DATE-DATA           PIC 9(8).
       01 WS-START-DATE                  PIC 9(8).
       01 WS-START-DATE-TEST             PIC 9(8).

      ***Variables for counters

       01 WS-MAIL-PAC-CNT               PIC 9(4) VALUE ZERO.
       01 WS-FORMAT-MAIL-PAC-CNT        PIC ZZ99.
       01 WS-ACCT-NO-CNT                PIC 9(10).
       01 WS-TEMP-PROFILE-KEY           PIC 9(10).
       01 WS-ADMIN-TOTAL                PIC 9(3) VALUE ZERO.
       01 WS-ADM-DEPOSIT                PIC 9(3) VALUE ZERO.
       01 WS-MED-SPECIALIST             PIC 9(3) VALUE ZERO.
       01 WS-ADM-FILED                  PIC 9(3) VALUE ZERO.
       01 WS-TOT-MAIL-CNT               PIC 9(4) VALUE ZERO.
       01 WS-MAIL-CNT                   PIC 9(3) VALUE ZERO.
       01 WS-MAIL-CNT-2                 PIC 9(3) VALUE ZERO.
       01 WS-NEXT-PRINT                 PIC 9(1) VALUE ZERO.
       01 WS-CLNT-MAIL-CNT              PIC 9(3) VALUE ZERO.
       01 WS-ACCT-TEMP-NAME             PIC X(20).
       01 WS-ACCT-TEMP-NO               PIC 9(10).
       01 WS-ACCT-TEMP-MAIL-CNT         PIC 9(3).
       01 WS-ACCT-TEMP-NAME-2             PIC X(20).
       01 WS-ACCT-TEMP-NO-2               PIC 9(10).
       01 WS-ACCT-TEMP-MAIL-CNT-2         PIC 9(3).
       01 WS-DO-ONCE                    PIC 9(3) VALUE ZEROS.
       01 WS-CLIENT-ADM-CNT             PIC 9(3) VALUE ZEROS.
       01 WS-TOT-STR-1                      PIC X(30).
       01 WS-TOT-STR-2                      PIC 9(3).
       01 WS-TOT-STR-3                      PIC X(30).
       01 WS-GRAND-TOTAL                    PIC 9(3).

      *------------------------------------------------
       01 HEADER-TITLE.
           10 FILLER             PIC X(30).
           10 FILLER             PIC X(48) VALUE
           'TOTAL PERSONAL SERVICES ADMINISTRATIVE GROUP LLC'.
026964
       01 FOOTER-LINE.
           10 FILLER            PIC X(50) VALUE'-'.

002200 01 HEADER-1.
           10 PRT-DATE           PIC X(30).
002220     10 FILLER             PIC X(20) VALUE SPACES.
002220     10 FILLER             PIC X(20) VALUE
002220        'TOTAL MAIL FORWARDED'.
002220     10 FILLER             PIC X(22) VALUE SPACES.
002220     10 FILLER             PIC X(05) VALUE 'Page '.
002220     10 PRT-PAGE           PIC ZZ.

026964 01 HEADER-SPACE.
           10 FILLER            PIC X(50).
002200 01 HEADER-2.
002220*    10 FILLER             PIC X(10) VALUE 'ACCT  #'.
002220     10 FILLER             PIC X(05) VALUE SPACES.
002220*    10 FILLER             PIC X(51) VALUE
002300*       '"Taking Care Of Your Persoanl Business...Privately"'.
002220     10 FILLER             PIC X(12) VALUE 'ACCOUNT NAME'.
002220     10 FILLER             PIC X(25) VALUE SPACE.
002220*    10 PRT-PAGE           PIC ZZ.
002220     10 FILLER             PIC X(24) VALUE
                                   '# OF ITEMS FWD TO CLIENT'.
002220*    10 PRT-TOT-PAGE       PIC ZZ.
      *    10 FILLER             PIC X(12) VALUE '# FWD TO ADM'.
026964
002200 01 HEADER-3.
002220     10 FILLER             PIC X(45) VALUE SPACES.
002220*    10 FILLER             PIC X(43) VALUE
002300*       'Mail Received and Imaged for the Account of'.
002220     10 FILLER             PIC X(01) VALUE SPACES.
002220     10 PRT-CLIENT-NAME    PIC x(36).
026964
002200*01 HEADER-4.
002220*    10 FILLER             PIC X(40) VALUE SPACES.
002220*    10 FILLER             PIC X(17) VALUE 'Print Report for '.
002300*    10 PRT-ACCT-NAME      PIC X(25).
002220*    10 FILLER             PIC X(01) VALUE SPACES.
002220*    10 FILLER             PIC X(11) VALUE 'Start Date '.
002300*    10 PRT-START-DATE     PIC X(10).
002220*    10 FILLER             PIC X(11) VALUE '  End Date '.
002220*    10 PRT-END-DATE       PIC x(10).

       01 HEADER-4.
           02  PRT-LINE                PIC X(45).



002200 01 HEADER-MAIN-PAGE.
002220*    10 FILLER             PIC X(10) VALUE 'ACCT  #'.
002220     10 FILLER             PIC X(05) VALUE SPACES.
002220*    10 FILLER             PIC X(51) VALUE
002300*       '"Taking Care Of Your Persoanl Business...Privately"'.
002220     10 FILLER             PIC X(09) VALUE 'ACCT NAME'.
002220     10 FILLER             PIC X(25) VALUE SPACE.
002220*    10 PRT-PAGE           PIC ZZ.
002220     10 FILLER             PIC X(24) VALUE
                                 '# OF ITEMS FWD TO CLIENT'.
002220*    10 PRT-TOT-PAGE       PIC ZZ.
      *    10 FILLER             PIC X(12) VALUE '# FWD TO ADM'.

026964 01 HEADER-5.
           10 FILLER             PIC X(40) VALUE SPACES.
002200 01  HDR-RECORD.
002220*    10 FILLER             PIC X(10) VALUE ' ACCT #   '.
002220*    10 FILLER             PIC X(10) VALUE ' IMAGE #  '.
002300*    10 FILLER             PIC X(01) VALUE SPACES.
002220*    10 FILLER             PIC X(14) VALUE ' RECV DATE & #'.
002300     10 FILLER             PIC X(05) VALUE SPACES.
002300     10 FILLER             PIC X(09) VALUE 'ACCT NAME'.
002220     10 FILLER             PIC X(25) VALUE SPACES.
002300*    10 FILLER             PIC X(10) VALUE 'CATEGORY'.
002300     10 FILLER             PIC X(24) VALUE
                                 '# OF ITEMS FWD TO CLIENT'.
002300*    10 FILLER             PIC X(06) VALUE 'AMOUNT'.
002220     10 FILLER             PIC X(04) VALUE SPACES.
002300*    10 FILLER             PIC X(12) VALUE '# FWD TO ADM'.
011101
       01 PRT-TOTAL-LINE.                                                                  00067400
011103    05 FILLER                 PIC X(17) VALUE
          'TOTALS MAIL PACS:'.
                                                                                           00067500
011103*   05 PRT-TOTAL               PIC  ZZZZZ.                                           00067500
011100    05 FILLER                  PIC X(3).
          05 PRT-TOTAL-MAIL-PACS     PIC 9(4).
          05 FILLER                  PIC X(30).
          05 FILLER                  PIC X(13) VALUE 'TOTAL ADMINS:'.
          05 FILLER                  PIC X(3).
          05 PRT-TOTALS-ADMIN        PIC 9(3).
          05 FILLER                  PIC 9(5).
          05 FILLER                  PIC X(14) VALUE 'TOTAL DEPOSITS'.
          05 PRT-ADM-DEPOSIT         PIC 9(3).
          05 FILLER                  PIC 9(3).
          05 FILLER                  PIC X(7) VALUE 'TOT MED'.
          05 PRT-MED-SPECIALIST      PIC 9(3).
          05 FILLER                  PIC X(18) VALUE
                                          'TOT MAIL FOR PACS'.
011101    05 PRT-TOT-MAIL-CNT         PIC 9(4).

       01 HEADER-6.
002220*    10 FILLER             PIC X(10) VALUE 'ACCT  #'.
002220     10 FILLER             PIC X(05) VALUE SPACES.
002220*    10 FILLER             PIC X(51) VALUE
002300*       '"Taking Care Of Your Persoanl Business...Privately"'.
002220     10 FILLER             PIC X(04) VALUE 'TEST'.
002220     10 FILLER             PIC X(25) VALUE SPACE.
002220*    10 PRT-PAGE           PIC ZZ.
002220     10 FILLER             PIC X(05) VALUE 'TEST2'.
002220*    10 PRT-TOT-PAGE       PIC ZZ.
      *    10 FILLER             PIC X(12) VALUE '# FWD TO ADM'.


011102 01  WS-DATE-REQUEST.                                                                00067400
011103      05  WS-DATE-PARAM          PIC  9(02).                                         00067500
011104      05  WS-DATE-TENBYTES       PIC  X(20) VALUE SPACES.                            00067600
011105      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00067700
011106          10  WS-DATE-REFORM         PIC  X(06).                                     00067800
011107          10  WS-DATE-EXTEND         PIC  X(04).                                     00067900
011108          10  FILLER                 PIC  X(10).                                     00068000
011109      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068100
011110          10  WS-DATE-REFORM-LEN06   PIC  X(06).                                     00068200
011111          10  FILLER                 PIC  X(14).                                     00068300
011112      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068400
011113          10  WS-DATE-REFORM-LEN08   PIC  X(08).                                     00068500
011114          10  FILLER                 PIC  X(12).                                     00068600
011115      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00068700
011116          10  WS-DATE-REFORM-LEN10   PIC  X(10).                                     00068800
011117          10  FILLER                 PIC  X(10).                                     00068900
011118      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00069000
011119          10  WS-TIME-PARM1          PIC  X(06).                                     00069100
011120          10  WS-TIME-PARM2          PIC  X(06).                                     00069200
011121          10  WS-TIME-EXTEND         PIC  X(08).                                     00069300
011122      05  FILLER REDEFINES WS-DATE-TENBYTES.                                         00069400
011123          10  WS-TIME-PARM1BY8       PIC  X(08).                                     00069500
011124          10  WS-TIME-PARM2BY8       PIC  X(08).                                     00069600
011125          10  WS-TIME-EXTNDBY8       PIC  X(04).                                     00069700
011126                                                                                     00069800
011200 01 WS-SAVE-ACCT-NO         PIC  9(10) VALUE ZEROS.
011130
011200 01  CURRENT-ACCT-NO        PIC  9(10) VALUE ZEROS.
011300 01  CURRENT-TOTAL          PIC S9(07)V9(02) VALUE ZEROS.
011400
011500 01  WS-PARMS.
011600     05  WS-ACTION-PARM               PIC  9(01) VALUE 3.
011700         88  WS-ACTION-NEW                       VALUE 1.
011800         88  WS-ACTION-EXISTING                  VALUE 2.
011900         88  WS-ACTION-ENGLISH                   VALUE 3.
012000     05  WS-ENGLISH-CHART-01          PIC  X(60).
012100     05  WS-ENGLISH-CHART-02          PIC  X(60).
012200     05  WS-ENGLISH-CHART-03          PIC  X(60).
012300     05  WS-ENGLISH-CHART-04          PIC  X(60).
012400     05  WS-ENGLISH-CHART-05          PIC  X(60).
012500     05  WS-ENGLISH-CHART-06          PIC  X(60).
012600     05  WS-ENGLISH-CHART-07          PIC  X(60).
012700     05  WS-ENGLISH-CHART-08          PIC  X(60).
012800     05  WS-TYPEIN-TEXT OCCURS 018 TIMES.
012900         10  WS-LINE-OF-TYPEIN        PIC  X(60).
014800  01  BG-FLOAT-DATA.
014900      05  BG-FLOAT-PARMS              PIC  X(161).
015000      05  FILLER REDEFINES BG-FLOAT-PARMS.
015100          10  BG-FLOAT-COUNT          PIC  X(01).
015200          10  BG-FLOAT-1              PIC  X(40).
015300          10  BG-FLOAT-2              PIC  X(40).
015400          10  BG-FLOAT-2-R REDEFINES BG-FLOAT-2.
015500              15  BG-FLOAT-2-I        PIC  X(01) OCCURS 40 TIMES.
015600          10  BG-FLOAT-3              PIC  X(40).
015700          10  FILLER REDEFINES BG-FLOAT-3.
015800              15  BG-FLOAT-3-A        PIC  X(37).
015900              15  BG-FLOAT-3-B        PIC  X(03).
016000          10  BG-FLOAT-3-R REDEFINES BG-FLOAT-3.
016100              15  BG-FLOAT-3-I        PIC  X(01) OCCURS 40 TIMES.
016200          10  BG-FLOAT-4              PIC  X(40).
016300
016461
026876
026964
005900 01 check-count-total      pic  9(05) value 0.
005900 01 check-amount-total     pic s9(07)v9(02) value 0.
026964
005900 01 mail-count-total       pic  9(07) value 0.
016461
016461
016461
016470
016500 LINKAGE SECTION.
016600*01 TPS-PARAMETER.
016700*   05 TPS-PARAMETER-VALUE PIC XX.
016800
016900 PROCEDURE DIVISION.
017000
017100 SEEMAIL-BEGIN.
017200    PERFORM OPEN-THE-FILES
017300       THRU OPEN-THE-FILES-EXIT.
084600                                                                                     00108200
084700      ACCEPT WS-TODAYS-DATE-YMD FROM DATE.                                           00111100
084800      MOVE 06                   TO WS-DATE-PARAM.                                    00111200
084900      MOVE WS-TODAYS-DATE-YMD   TO WS-DATE-REFORM.                                   00111300
085000      MOVE SPACES               TO WS-DATE-EXTEND.                                   00111400
085100      CALL TPSDATES USING WS-DATE-REQUEST.                                           00111500
085200      MOVE WS-DATE-TENBYTES TO PRT-DATE.                                             00111600

000200
000200
000200
017400    PERFORM READ-THE-MAIL
017500       THRU READ-THE-MAIL-EXIT.
016413*   PERFORM REPORT-THE-TOTALS THRU
016413*           REPORT-THE-TOTALS-EXIT.
       STOP RUN.
017600 SEEMAIL-COMMON-EXIT.
017400*   MOVE REC-COUNT      TO PRT-TOTAL.
      *   MOVE REPORT-HEADING-LINE TO PRINT-LINE.
017500*   MOVE PRT-TOTAL-LINE TO PRT-RECORD.
      *   MOVE BOTTOM-TOT     TO BOTTOM-HEADING-REC.

      *   MOVE WS-MAIL-PAC-CNT TO PRT-TOTAL-MAIL-PACS.
002200    WRITE PRT-RECORD AFTER 3.
      *   WRITE BOTTOM-HEADING-REC.
      *   WRITE PRINT-LINE AFTER 3.

017700    PERFORM CLOSE-THE-FILES
017800       THRU CLOSE-THE-FILES-EXIT.
017900    GOBACK.
018000
018000

018000
018000
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
026924* don't start tpsiorec before 01/01/2000, io mod can't handle it
018000
018000
018000*** 026800      if sf-acct-no = '0101001253' or '0101001261'


018000
018100 READ-THE-MAIL.

018200    MOVE LOW-VALUES TO MAIL-KEY OF TPS-MAIL-REC.
026924*   move '0150000057002011070100001' to mail-key.
026924*   move '0101000024002000010100001' to mail-key.
026924*   move '0101000024002016020900001' to mail-key.
      *   MOVE '010100002400'              TO CLNT-PROFILE-KEY.

          PERFORM GET-SYSTEM-DATE.

018000    PERFORM  START-PROFILE.


018000****** start with some value or io mod will read old receive file
018000
018000
026924*** MOVE '01030000140020020101' TO MAIL-KEY.
026924*** MOVE '01010000240020020101' TO MAIL-KEY.
026924*** MOVE '01010002970020010101' TO MAIL-KEY.
026924**  MOVE '0101000321002002102400001' TO MAIL-KEY.
026924**  MOVE '0101000461002005010100001' TO MAIL-KEY.

       GET-SYSTEM-DATE.
      * This routine gets the system date and then returnds the previous
      * date otherwise the receive file will not start on the right date
      *   MOVE FUNCTION CURRENT-DATE(1:6) TO WS-CURRENT-DATE-FIELDS.
          MOVE FUNCTION CURRENT-DATE(1:8) TO WS-CURRENT-DATE-DATA.


          COMPUTE WS-INTEGER = FUNCTION
          INTEGER-OF-DATE(WS-CURRENT-DATE-DATA).
          DISPLAY WS-INTEGER.


      *---- Test-----
          COMPUTE WS-INTEGER-TEST = FUNCTION
          INTEGER-OF-DATE(WS-CURRENT-DATE-DATA).
          DISPLAY WS-INTEGER-TEST.


          SUBTRACT 9 FROM WS-INTEGER-TEST.
          DISPLAY WS-INTEGER-TEST.
          COMPUTE WS-START-DATE-TEST
          = FUNCTION DATE-OF-INTEGER(WS-INTEGER-TEST).
          DISPLAY WS-START-DATE-TEST.

      *------------------------

      *--- Subtract 1 after test-------
          SUBTRACT 10 FROM WS-INTEGER.
          DISPLAY WS-INTEGER.

          COMPUTE WS-START-DATE = FUNCTION DATE-OF-INTEGER(WS-INTEGER).
          DISPLAY WS-START-DATE.

          STRING WS-STR-2 WS-START-DATE WS-STR-RECEIVE-NUM
                 DELIMITED BY SIZE
                 INTO            WS-STR-1.


229400 START-PROFILE.                                                                      00326700
229500**  MOVE LOW-VALUES TO CLNT-PROFILE-KEY.                                             00326800
229600*   MOVE ZEROS      TO CLNT-PROFILE-KEY.                                             00326900
229700    MOVE F-PRIME TO FILE-KEY.                                                        00327000
229800    MOVE F-START TO FILE-ACTION.                                                     00327100
229900    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.                                  00327200
230000    IF NO-RECORD-WAS-FOUND                                                           00327300
230100       GO TO READ-THE-MAIL-EXIT                                                      00327400
230200     END-IF.                                                                         00327500
230300    IF NOT A-SUCCESSFUL-OPERATION                                                    00327600
230400       MOVE ' PROFILE' TO FILE-NAME                                                  00327700
230500       MOVE 'TPS000-START' TO FILE-TEXT                                              00327800
230600       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00327900
022100       GO TO SEEMAIL-COMMON-EXIT
230800     END-IF.                                                                         00328100
         PERFORM READ-NEXT-PROFILE-RECORD.
231000 READ-NEXT-PROFILE-RECORD.                                                           00328300
231100    MOVE F-PRIME TO FILE-KEY.                                                        00328400
231200    MOVE F-READ-NEXT TO FILE-ACTION.                                                 00328500
231300    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.                                  00328600
231400    IF END-OF-FILE-WAS-REACHED                                                       00328700
231500       GO TO SEEMAIL-COMMON-EXIT                                                     00328800
231600     END-IF.                                                                         00328900
231700*** IF END-OF-FILE-WAS-REACHED GO TO CLOSE-SORTWORK.                                 00329000
231800    IF NOT A-SUCCESSFUL-OPERATION                                                    00329100
231900       MOVE 'PROFILE ' TO FILE-NAME                                                  00329200
232000       MOVE 'TPS000-BRN' TO FILE-TEXT                                                00329300
232100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00329400
022100       GO TO SEEMAIL-COMMON-EXIT
232300     END-IF.                                                                         00329600

          IF CLNT-PROFILE-KEY  = '010600007800'
             DISPLAY CLNT-PROFILE-KEY.


          PERFORM DELETED-ACCOUNT.



       DELETED-ACCOUNT.

          IF CLNT-PROFILE-ADD-DATE(1:1) = 8 OR 9
             MOVE CLNT-PROFILE-KEY TO WS-DELETED-ACCT
             PERFORM READ-NEXT-PROFILE-RECORD


          ELSE

             PERFORM CHECK-SUB-ACCOUNT
             MOVE CLNT-PROFILE-KEY TO WS-MAIL-ACCT-TEMP
             STRING WS-MAIL-ACCT-TEMP(1:10) WS-STR-1 DELIMITED BY SIZE
             INTO            WS-STR-NEW-KEY
             MOVE WS-STR-NEW-KEY TO MAIL-KEY
             PERFORM  START-THE-MAIL

         END-IF.
       NO-MAIL.



231100    MOVE F-PRIME TO FILE-KEY.                                                        00328400
231200    MOVE F-READ-NEXT TO FILE-ACTION.                                                 00328500
231300    CALL TPSIO004 USING FILE-REQUEST TPS-PROFL-REC.                                  00328600
231400    IF END-OF-FILE-WAS-REACHED                                                       00328700
231500       GO TO SEEMAIL-COMMON-EXIT                                                     00328800
231600     END-IF.                                                                         00328900
231800    IF NOT A-SUCCESSFUL-OPERATION                                                    00329100
231900       MOVE 'PROFILE ' TO FILE-NAME                                                  00329200
232000       MOVE 'TPS000-BRN' TO FILE-TEXT                                                00329300
232100       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00329400
022100       GO TO SEEMAIL-COMMON-EXIT
232300     END-IF.                                                                         00329600

         IF CLNT-PROFILE-KEY(1:10) = WS-MAIL-ACCT-TEMP (1:10)

           PERFORM NO-MAIL.

         PERFORM DELETED-ACCOUNT.

       CHECK-SUB-ACCOUNT.

          IF CLNT-PROFILE-KEY(1:10) = WS-DELETED-ACCT(1:10)
               PERFORM READ-NEXT-PROFILE-RECORD
          END-IF.


018000 NEXT-ACCOUNT.
          DISPLAY MAIL-ACCT-NO.
          DISPLAY MAIL-RECEIVE-DATE.
          IF MAIL-RECEIVE-DATE NOT = '20160205' or
             WS-MAIL-ACCT-TEMP NOT = MAIL-ACCT-NO

           MOVE    WS-STR-NEW-KEY TO MAIL-KEY.

          IF WS-MAIL-ACCT-TEMP2 = WS-MAIL-ACCT-TEMP
             PERFORM READ-ALL-RECEIVE-NUMBERS.

          PERFORM START-THE-MAIL.

       SET-NEW-KEY.

            IF WS-MAIL-ACCT-TEMP(1:10) NOT = MAIL-ACCT-NO

             STRING MAIL-ACCT-NO WS-STR-2 DELIMITED BY SIZE
             INTO            WS-STR-NEW-PFL-KEY
             MOVE WS-STR-NEW-PFL-KEY TO CLNT-PROFILE-KEY
             PERFORM START-PROFILE.

       START-EMAIL-FILE.
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIO033 USING FILE-REQUEST TPS-EMAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-EMAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
          GO TO READ-NEXT-EMAIL.
       READ-NEXT-EMAIL.
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIO033 USING FILE-REQUEST TPS-EMAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-EMAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
         GO TO PRINT-NON-EMAILED-REPORTS.
018100 START-THE-MAIL.
021300    MOVE F-PRIME TO FILE-KEY.
021400    MOVE F-START TO FILE-ACTION.
021500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
021600    IF NO-RECORD-WAS-FOUND GO TO READ-THE-MAIL-EXIT.
021700    IF NOT A-SUCCESSFUL-OPERATION
021800       MOVE ' RECEIVE' TO FILE-NAME
021900       MOVE 'SEEMAIL-SBR' TO FILE-TEXT
022000       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
022100       GO TO SEEMAIL-COMMON-EXIT.
026880
022200    go to READ-ALL-RECEIVE-NUMBERS.
026880*   MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO.
026880*
026880*   MOVE MAIL-ACCT-NO     TO clnt-profile-acct-no.
026880*   MOVE '00'             TO clnt-profile-sub-acct.
026880
022300*   MOVE F-PRIME TO FILE-KEY.
022400*   MOVE F-READ  TO FILE-ACTION.
022500*   CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC.
023000*   IF NOT A-SUCCESSFUL-OPERATION
023100*      MOVE ' profile' TO FILE-NAME
023200*      MOVE 'SEEMAIL-rd ' TO FILE-TEXT
023300**      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400*      GO TO SEEMAIL-COMMON-EXIT
023500*
      *
      * ADD CALL TO TPSDATES HERE TO SET UP START & END DATES
002200*   MOVE 'Kenneth and Nancy Akeson' TO PRT-CLIENT-NAME.
002200*   MOVE 'TPS Administrative Group, LLC'  to PRT-CLIENT-NAME.
002200*   MOVE '01/01/1994' TO PRT-START-DATE.
002200*   MOVE '08/24/2006' TO PRT-END-DATE.
002200*   MOVE '08/28/2006' TO PRT-END-DATE.
002200*   MOVE 'ITT HARTFORD' TO PRT-ACCT-NAME.
002200*   MOVE 'ITT HARTFORD' TO PRT-ACCT-NAME.
      * ADD CLIENT NAME & NAME OF ACCOUNT LOOK UP.
002200    MOVE 1           TO WS-PAGE.
002200    MOVE WS-PAGE     TO PRT-PAGE.
002200*   MOVE 21          TO PRT-TOT-PAGE.
002200    MOVE 6           TO LINE-COUNT.
002200    WRITE PRT-RECORD FROM PCL-LANDSCAPE.
002200    WRITE PRT-RECORD FROM COURIER-59.
002200    WRITE PRT-RECORD FROM HEADER-1.
          WRITE PRT-RECORD FROM HEADER-SPACE.
017500    WRITE PRT-RECORD FROM HEADER-2.
002200*   WRITE PRT-RECORD FROM HEADER-3.
017500*   WRITE PRT-RECORD FROM HEADER-4.
002200    WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE.
017500    WRITE PRT-RECORD FROM HEADER-4 AFTER 1 LINE.
017500*   WRITE PRT-RECORD FROM HEADER-5 AFTER 1 LINE.
002200    WRITE PRT-RECORD FROM COURIER-36 AFTER 1 LINE.
002200    WRITE PRT-RECORD FROM HDR-RECORD AFTER 1 LINE.
026880    PERFORM READ-ALL-RECEIVE-NUMBERS.
026880
026880 READ-PREVIOUS.


022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-PREVIOUS TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.

          IF CLNT-PROFILE-KEY ='015000005700'
             PERFORM WRITE-RECORDS.

          MOVE MAIL-ACCT-NO TO WS-MAIL-ACCT-TEMP2.

      *   GO TO REPORT-THE-RECORD.
      *   IF WS-MAIL-ACCT-TEMP2 NOT = WS-MAIL-ACCT-TEMP
      *        DISPLAY MAIL-ACCT-NO.

      *   IF WS-MAIL-ACCT-TEMP NOT = MAIL-ACCT-NO
      *      DISPLAY MAIL-ACCT-NO
      *      STRING WS-MAIL-ACCT-TEMP WS-STR-1 DELIMITED BY SIZE
      *      INTO            WS-STR-NEW-KEY
      *      PERFORM NEXT-ACCOUNT.


      *   PERFORM READ-NEXT.

       READ-NEXT.
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.



022200 READ-ALL-RECEIVE-NUMBERS.
022300    MOVE F-PRIME TO FILE-KEY.
022400    MOVE F-READ-NEXT TO FILE-ACTION.
022500    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
022600    IF END-OF-FILE-WAS-REACHED
022700       GO TO READ-THE-MAIL-EXIT
022800     END-IF.
022900
023000    IF NOT A-SUCCESSFUL-OPERATION
023100       MOVE ' RECEIVE' TO FILE-NAME
023200       MOVE 'SEEMAIL-BRN' TO FILE-TEXT
023300       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
023400       GO TO SEEMAIL-COMMON-EXIT
023500     END-IF.
023610

016561*   if we-b-looking-4-tps3054-problem
017600*      go to seeif-record-altered
000200*    end-if.
026924*   if mail-acct-no not = '0101000024'
026880*      if mail-receive-date < '20160201'
018200*         move low-values to mail-key of tps-mail-rec
026924*         move '0101000024002016020100001' to mail-key
018100*         go to start-the-mail
026886*       end-if
023400*      go to seemail-common-exit
026886*    end-if.

023610*------------------------------------

         IF MAIL-ACCT-NO(1:10) = '0150000057'
             GO TO WRITE-RECORDS.
         IF CLNT-PROFILE-KEY(1:10) NOT = MAIL-ACCT-NO
            MOVE CLNT-PROFILE-KEY TO WS-NO-MAIL-TEMP
            PERFORM NO-MAIL.

      *--REMOVE AFTER TEST AND UNCOMMENT NEXT BLOCK----------
          IF MAIL-KEY(13:8)NOT = WS-START-DATE-TEST
             PERFORM NO-MAIL.

          IF MAIL-RECEIVE-DATE NOT = WS-START-DATE-TEST
             GO TO READ-ALL-RECEIVE-NUMBERS.

026924    IF mail-receive-date = WS-START-DATE-TEST
             go to CHECK-DISPOSITION.

      *-------------------------------------------

      *   IF MAIL-KEY(13:8)NOT = WS-CURRENT-DATE-DATA
      *      PERFORM NO-MAIL.

      *   MOVE MAIL-ACCT-NO TO WS-MAIL-ACCT-TEMP2.


          DISPLAY MAIL-RECEIVE-DATE.

      *   IF MAIL-RECEIVE-DATE NOT = WS-CURRENT-DATE-DATA
026886*   else
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*   end-if.
023610
026880*   if mail-receive-date < '20091201'
z
023610
023610*   if RECUR-CATEGORY-CODE not =


026951*      recur-chart-acct-01(1:2)


002200*      go to report-the-record.


023610
023610
009600*   IF MAIL-CATEGORY-CODE not =


026951*      recur-chart-acct-01(1:2)


002200*      go to report-the-record.


023610
023610
026963*   GO TO READ-ALL-RECEIVE-NUMBERS.


023610
023610
023610***  if mail-receive-date < '20160201'
      *      GO TO SEEMAIL-COMMON-EXIT.
023610
023610
023610
023610
026880*   if mail-receive-date > '20100331'
023400*      GO TO SEEMAIL-COMMON-EXIT.
023610
026877*-----------------------------------------------------------
026878*-           GET RID OF VOIDS
026879*   IF MAIL-DISPOSITION = '88'
026880*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*    END-IF.
026876
002200*   go to report-the-record.
026963*** go to see-if-good-for-check.
026876
026876
026887*-----------------------------------------------------------
026876
026880*   IF MAIL-ADDRESOR-NAME(1:8) = 'HARTFORD' OR
026880*      MAIL-ADDRESOR-NAME(1:12) = 'ITT HARTFORD' OR
026880*      MAIL-ADDRESOR-NAME(1:12) = 'THE HARTFORD'
026880*   IF MAIL-ADDRESOR-NAME(1:11) = 'STEVE TESTA' OR
026880*      MA`L-ADDRESOR-NAME(1:13) = 'STEPHEN TESTA' OR
026880*      MAIL-ADDRESOR-NAME(1:16) = 'STEPHEN J. TESTA' OR
026880*      MAIL-ADDRESOR-NAME(1:5) = 'TESTA'
026880*      PERFORM GET-CHART-INFO THRU
026963*              GET-CHART-INFO-EXIT
026880*   ELSE
026963*      GO TO READ-ALL-RECEIVE-NUMBERS.
026880*   IF MAIL-ADDRESOR-NAME(1:12) NOT = 'ITT HARTFORD'
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026880*   ELSE
026880*   IF MAIL-ADDRESOR-NAME(1:12) NOT = 'THE HARTFORD'
026963*      GO TO READ-ALL-RECEIVE-NUMBERS.
023610
026924*   if mail-acct-no = '0101000461'
002200*      continue
      *     else
022700*      GO TO READ-THE-MAIL-EXIT
026886*    end-if.
023610
026924*   if mail-admin-xxxxxx = 'TPS4NSF '
002200*      go to report-the-record
      *     else
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*   end-if.
023610
026880*   if MAIL-SUB-ACCT not = '00'
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*    end-if.
026876
026924*   if mail-acct-no not = '0101000347'
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*    end-if.
026924*   if mail-receive-date > 20011231
022700*      GO TO READ-THE-MAIL-EXIT
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*    end-if.
009600*   IF (MAIL-CATEGORY-CODE = 31 OR 11) AND
026880*       MAIL-IMAGE-NUMBER > ZERO
002200*         go to report-the-record
026924*      ELSE
026963*         GO TO READ-ALL-RECEIVE-NUMBERS.
026876
016461*   if we-r-reporting-check-info
026963*      go to see-if-good-for-check
026886*    end-if.
026876
026876
016461*   if we-r-exporting-excel
026876*      go to excel-select
026886*    end-if.
026876
026876
016461*   if we-b-printing-splits
026924*      if mail-acct-no not = '0101000891'
022700*         go to read-the-mail-exit
026886*       end-if
026924*      if mail-split-record
002200*         go to report-the-record
026886*        else
026880*         go to read-all-receive-numbers
026886*       end-if
026876
026876
026880*   if mail-amount-to-pay = 344.03
026876*      continue
026876*     else
026880*      go to read-all-receive-numbers
026886*    end-if.
026876
026876
026951*   if recur-chart-acct-02(5:2) = '11'
026876*      continue
026876*     else
026880*      go to read-all-receive-numbers
026886*    end-if.
026876
026951*   if recur-chart-acct-02(7:2) = '04'
026876*      continue
026876*     else
026880*      go to read-all-receive-numbers
026886*    end-if.
026876
026876
026951*   if recur-chart-acct-02(5:2) = '11' and
026951*      recur-chart-acct-02(7:2) = '04'
026876*         continue
026876*     else
026951*   if recur-chart-acct-03(5:2) = '03' or '05' and
026951*      recur-chart-acct-03(7:2) = '04'
026876*      continue
026876*     else
026880*      go to read-all-receive-numbers
026886*     end-if
026886*    end-if.
026876
026876
026876
026876
026876
026877*-----------------------------------------------------------
026878*-           search for ups coded records
026879*   if mail-carrier-code not = '03'
026880*      go to read-all-receive-numbers
026886*    end-if.
026887*-----------------------------------------------------------
026876
026876
026876
026887***** read next client at start date *****
026924*   IF MAIL-ACCT-NO = WS-SAVE-ACCT-NO AND
026880*      MAIL-SUB-ACCT = '00'
026880*      CONTINUE
026886*   ELSE
026880*      MOVE MAIL-ACCT-NO     TO WS-SAVE-ACCT-NO
026880*      move '00'             to MAIL-SUB-ACCT
026880*      MOVE '20010701'       TO MAIL-RECEIVE-DATE
026880*      GO TO START-THE-MAIL.
026887*-----------------------------------------------------------
026924*   if mail-acct-no not = '0101000321'
048600*      go to READ-THE-MAIL-EXIT
026886*    end-if.
026924
026924*   if mail-admin-xxxxxx(1:7) not = 'TPS3059'
026924*   if mail-admin-xxxxxx(1:3) not = 'TPS'
026963*      GO TO READ-ALL-RECEIVE-NUMBERS
026886*    end-if.
026887*-----------------------------------------------------------

       CHECK-DISPOSITION.

      *----Print Only of coded forward-----------
026879    IF MAIL-DISPOSITION = '88'
026880       GO TO READ-ALL-RECEIVE-NUMBERS
026886     END-IF.
026876
          IF MAIL-DISPOSITION = '03' OR '06' OR '18' OR '22' OR '24' OR
                                '30' OR '34' OR '35' OR '36'
             IF RECUR-FORWARD < '13' OR
                RECUR-FORWARD = '99'
                GO TO CHECK-CATEGORY
      *         GO TO REPORT-THE-RECORD
             END-IF
          END-IF.

         IF MAIL-DISPOSITION = '03' OR
                               '07' OR '11' OR '12' OR '13' OR '14' OR
                               '18' OR '21' OR '23' OR '26'
                               OR '29' OR '33'

           GO TO FORWARD-TO-ADMIN.
      *   GO TO CHECK-CATEGORY.
          GO TO READ-ALL-RECEIVE-NUMBERS.


      *------------------------------

       CHECK-CATEGORY.


         IF MAIL-CATEGORY-CODE NOT = '90'
            GO TO REPORT-THE-RECORD
          END-IF.

         IF MAIL-CATEGORY-CODE  = '90'
            GO TO EMAILED-REPORTS
          END-IF.

      *  IF MAIL-ADDRESOR-DATA = 'Payment Calendar'
      *     GO TO REPORT-THE-RECORD
      *    END-IF.

      *  IF MAIL-ADDRESOR-DATA = 'Check Reconciliation'
      *     GO TO REPORT-THE-RECORD
      *    END-IF.

      *  IF MAIL-ADDRESOR-DATA = 'Checking A/C Summary'
      *     GO TO REPORT-THE-RECORD
      *  END-IF.

      *  IF MAIL-ADDRESOR-DATA = 'Mail Pac'
      *     GO TO READ-ALL-RECEIVE-NUMBERS
      *  END-IF.

       EMAILED-REPORTS.

         IF MAIL-ADDRESOR-DATA(1:20) = 'Check Reconciliation'
            GO TO REPORT-THE-RECORD
           END-IF.

         IF MAIL-ADDRESOR-DATA(1:20) = 'Checking A/C Summary'
            GO TO REPORT-THE-RECORD
         END-IF.


         IF MAIL-ADDRESOR-DATA = 'Mail Pac'
            GO TO READ-ALL-RECEIVE-NUMBERS
         END-IF.

         IF MAIL-ADDRESOR-DATA(1:20) = 'Communications Diary'
            GO TO READ-ALL-RECEIVE-NUMBERS
         END-IF.

         MOVE MAIL-KEY(1:12) TO EMAIL-KEY.

         IF MAIL-ADDRESOR-DATA(1:19) = 'Summary of Accounts'
            GO TO REPORT-THE-RECORD
         END-IF.


         GO TO START-EMAIL-FILE.

       PRINT-NON-EMAILED-REPORTS.

       DISPLAY EMAIL-PAYCAL-1-MEDIA-TYPE.

        IF EMAIL-PAYCAL-1-MEDIA-TYPE = '3'
           GO TO READ-ALL-RECEIVE-NUMBERS.

        IF EMAIL-PAYCAL-1-MEDIA-TYPE NOT = '3'
           GO TO REPORT-THE-RECORD.


       FORWARD-TO-ADMIN.

            IF RECUR-FORWARD = '98'
               ADD 1 TO WS-ADMIN-TOTAL
               ADD 1 TO WS-CLIENT-ADM-CNT
               MOVE WS-ADMIN-TOTAL TO PRT-TOTALS-ADMIN
               DISPLAY WS-ADMIN-TOTAL



            END-IF.

            IF RECUR-FORWARD = '20'
               ADD 1 TO WS-MED-SPECIALIST
               MOVE WS-MED-SPECIALIST TO PRT-MED-SPECIALIST
            END-IF.

            IF MAIL-DISPOSITION = '11'
               ADD 1 TO WS-ADM-DEPOSIT
               MOVE WS-ADM-DEPOSIT TO PRT-ADM-DEPOSIT
            END-IF.

            IF MAIL-DISPOSITION = '21'
               IF MAIL-IMAGE-NUMBER(1:1)> 2 AND
                  MAIL-CATEGORY-CODE NOT = '60'
               ADD 1 TO WS-ADM-FILED
            END-IF.


            GO TO READ-ALL-RECEIVE-NUMBERS.

002200 report-the-record.
002200*   INITIALIZE PRT-RECORD.
002200    MOVE SPACES TO PRT-RECORD.

          MOVE WS-TEMP-PROFILE-KEY TO WS-ACCT-NO-CNT.
          PERFORM MAIL-TOTALS.

       MAIL-TOTALS.


          IF CLNT-PROFILE-KEY >=  WS-ACCT-NO-CNT
              ADD 1 TO WS-TOT-MAIL-CNT
              MOVE WS-TOT-MAIL-CNT TO PRT-TOT-MAIL-CNT.

          IF CLNT-PROFILE-KEY(1:10) > WS-ACCT-NO-CNT(1:10)

             ADD 1 TO WS-MAIL-PAC-CNT

             MOVE WS-MAIL-PAC-CNT TO PRT-TOTAL-MAIL-PACS
             DISPLAY WS-MAIL-PAC-CNT
             DISPLAY WS-ACCT-NO-CNT(1:10).

          IF RECUR-FORWARD > '00' AND
             RECUR-FORWARD < '13'
             ADD 1 TO WS-MAIL-PAC-CNT.

        IF WS-ACCT-NO-CNT = SPACES OR
           WS-ACCT-NO-CNT = CLNT-PROFILE-KEY(1:10)
           ADD 1 TO WS-MAIL-CNT
        END-IF.

        IF WS-ACCT-NO-CNT NOT = SPACES AND
           CLNT-PROFILE-KEY(1:10) > WS-ACCT-NO-CNT
      *    MOVE 1 TO WS-MAIL-CNT
      *    ADD  1 TO WS-MAIL-CNT
           DISPLAY WS-MAIL-CNT
           MOVE 1 TO WS-MAIL-CNT



        END-IF.


      *   SUBTRACT 1 FROM WS-TEMP-PROFILE-KEY.
          DISPLAY WS-MAIL-ACCT-TEMP.

          GO TO PRINT-CLIENTS.

      *   MOVE ZERO TO WS-MAIL-PAC-CNT.


      *   IF CLNT-PROFILE-KEY(1:10) NOT = WS-MAIL-ACCT-TEMP2
      *      ADD 1 TO WS-MAIL-PAC-CNT

      *   END-IF.
012000*   move recur-payee-name
012000*        to prt-payee-name.
026951*   move recur-chart-acct-01
012000*        to prt-chart-01.
026951*   move recur-chart-acct-02
012000*        to prt-chart-02.
026951*   move recur-chart-acct-03
012000*        to prt-chart-03.

       PRINT-CLIENTS.

           DISPLAY WS-CLIENT-ADM-CNT
        IF CLNT-PROFILE-KEY(1:10) = WS-ACCT-NO-CNT(1:10)
026886     MOVE MAIL-ACCT-NO          TO WS-ACCT-TEMP-NO
           MOVE MAIL-ADDRESEE-DATA    TO WS-ACCT-TEMP-NAME
           MOVE WS-MAIL-CNT           TO WS-ACCT-TEMP-MAIL-CNT

           GO TO READ-ALL-RECEIVE-NUMBERS.

          MOVE CLNT-PROFILE-KEY(1:10) TO WS-TEMP-PROFILE-KEY.


        IF WS-ACCT-NO-CNT = SPACES
           PERFORM CURRENT-RECORD.


        IF CLNT-PROFILE-KEY(1:10) NOT = WS-ACCT-NO-CNT(1:10)
           MOVE WS-ACCT-TEMP-NO    TO WS-ACCT-TEMP-NO-2
           MOVE WS-ACCT-TEMP-NAME  TO WS-ACCT-TEMP-NAME-2
026886     MOVE MAIL-ACCT-NO       TO WS-ACCT-TEMP-NO
           MOVE MAIL-ADDRESEE-DATA TO WS-ACCT-TEMP-NAME
           MOVE WS-MAIL-CNT        TO WS-MAIL-CNT-2


      *    MOVE 1                  TO WS-MAIL-CNT
      *    MOVE WS-MAIL-CNT        TO WS-ACCT-TEMP-MAIL-CNT


           PERFORM CURRENT-RECORD.



        IF CLNT-PROFILE-KEY(1:10) NOT= WS-ACCT-NO-CNT

           PERFORM CURRENT-RECORD.


       CURRENT-RECORD.
002200     WRITE PRT-RECORD AFTER 1.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 2
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59

                 WRITE PRT-RECORD FROM PCL5-LANDSCAPE  AFTER 1 LINES
                 WRITE PRT-RECORD FROM HEADER-TITLE
002200           WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
                 WRITE PRT-RECORD FROM HEADER-SPACE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59

              WRITE PRT-RECORD FROM PCL5-LANDSCAPE  AFTER 1 LINES

              WRITE PRT-RECORD FROM HEADER-TITLE

002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
              WRITE PRT-RECORD FROM HEADER-SPACE

017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
        END-IF.


      *   IF CLNT-PROFILE-KEY(1:10) > WS-ACCT-NO-CNT(1:10)


026886*    MOVE WS-ACCT-TEMP-NO-2       TO PRT-ACCT-NO
           MOVE WS-ACCT-TEMP-NAME-2     TO PRT-ADDSEE-NAME
           MOVE WS-ACCT-TEMP-MAIL-CNT   TO PRT-MAIL-CNT
           MOVE WS-MAIL-CNT             TO WS-ACCT-TEMP-MAIL-CNT

           MOVE ZERO                    TO WS-CLIENT-ADM-CNT

012000
      *   PERFORM 015-CHECK THRU 015-EXIT.

          MOVE CLNT-PROFILE-KEY(1:10) TO WS-TEMP-PROFILE-KEY.

002200    WRITE PRT-RECORD AFTER 1.
002200    ADD 1            TO LINE-COUNT.
002200    IF LINE-COUNT = 1 OR
             LINE-COUNT > 43
002200       MOVE 6        TO LINE-COUNT
002200       ADD 1         TO WS-PAGE
002200       MOVE WS-PAGE  TO PRT-PAGE
002200*      WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*      WRITE PRT-RECORD FROM COURIER-59

             WRITE PRT-RECORD FROM PCL5-LANDSCAPE  AFTER 1 LINES

             WRITE PRT-RECORD FROM HEADER-SPACE
             WRITE PRT-RECORD FROM HEADER-TITLE

002200       WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
             WRITE PRT-RECORD FROM HEADER-SPACE
017500*      WRITE PRT-RECORD FROM HEADER-2
002200       WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
017500*      WRITE PRT-RECORD FROM HEADER-4 AFTER 1 LINE
017500*   WRITE PRT-RECORD FROM HEADER-5 AFTER 1 LINE.
002200*      WRITE PRT-RECORD FROM COURIER-36 AFTER 1 LINE
002200       WRITE PRT-RECORD FROM HDR-RECORD AFTER 1 LINE
026880
026964  END-IF.

           GO TO READ-ALL-RECEIVE-NUMBERS.

       WRITE-RECORDS.

           ADD 1 TO WS-DO-ONCE
           IF WS-DO-ONCE > 1
              GO TO READ-ALL-RECEIVE-NUMBERS.


      *    MOVE WS-ACCT-TEMP-NO TO PRT-ACCT-NO
           MOVE WS-ACCT-TEMP-NAME TO PRT-ADDSEE-NAME

002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.




      *************************




           MOVE SPACES TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.





           MOVE SPACES TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.


           MOVE SPACES TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.

           MOVE '--------------------' TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.




           MOVE 'TOTAL # OF MAIL PACS:' TO PRT-ADDSEE-NAME.
           MOVE WS-MAIL-PAC-CNT         TO PRT-TOT-PACS.
      *    MOVE WS-FORMAT-MAIL-PAC-CNT  TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).




002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.


           MOVE '--------------------' TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

           MOVE PRT-MAIL-CNT(1:)     TO PRT-TOT-PACS.


002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.

           MOVE 'TOTAL ITEMS FWD TO ADM:' TO PRT-ADDSEE-NAME.
           MOVE WS-ADMIN-TOTAL    TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).



002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.

           MOVE 'TOTAL ITEMS FWD FOR DEPOSIT:' TO PRT-ADDSEE-NAME.
           MOVE WS-ADM-DEPOSIT    TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).



002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.

           MOVE 'TOTAL ITEMS FWD TO MED SPECIALIST:' TO PRT-ADDSEE-NAME.
           MOVE WS-MED-SPECIALIST    TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).



002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.

           MOVE 'TOTAL MAIL FWD TO CLIENTS:' TO PRT-ADDSEE-NAME.
           MOVE WS-TOT-MAIL-CNT    TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).



002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.


           MOVE '--------------------' TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).

           MOVE PRT-MAIL-CNT(1:)     TO PRT-TOT-PACS.


002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.


           MOVE 'GRAND TOTAL OF ITEMS FWD:' TO PRT-ADDSEE-NAME.
           COMPUTE WS-GRAND-TOTAL = WS-ADMIN-TOTAL + WS-ADM-DEPOSIT +
                            WS-MED-SPECIALIST + WS-TOT-MAIL-CNT
           MOVE WS-GRAND-TOTAL    TO PRT-TOT-PACS.
           MOVE SPACES             TO PRT-MAIL-CNT(1:).



002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.





           MOVE SPACES TO PRT-ADDSEE-NAME.
           MOVE SPACES TO PRT-MAIL-CNT(1:).
           MOVE PRT-MAIL-CNT(1:)     TO PRT-TOT-PACS.


002200     WRITE PRT-RECORD AFTER 2.
002200     ADD 1            TO LINE-COUNT.
002200     IF LINE-COUNT = 1
               IF WS-PAGE = 1
                 WRITE PRT-RECORD AFTER 1
002200           MOVE 6        TO LINE-COUNT
002200           ADD 1         TO WS-PAGE
002200           MOVE WS-PAGE  TO PRT-PAGE
002200*          WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*          WRITE PRT-RECORD FROM COURIER-59
002200           WRITE PRT-RECORD FROM HEADER-2 AFTER 1 LINE
017500           WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200           WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
      *          WRITE PRT-RECORD FROM HEADER-5
              END-IF

002200        MOVE 6        TO LINE-COUNT
002200        ADD 1         TO WS-PAGE
002200        MOVE WS-PAGE  TO PRT-PAGE
002200*       WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*       WRITE PRT-RECORD FROM COURIER-59
002200        WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*       WRITE PRT-RECORD FROM HEADER-2
              WRITE PRT-RECORD FROM HEADER-MAIN-PAGE AFTER 1 LINE
002200        WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE

          END-IF.



      **************************************
002200*   WRITE PRT-RECORD AFTER 1.
002200*   ADD 1            TO LINE-COUNT.
002200*   IF LINE-COUNT = 1 OR
      *      LINE-COUNT > 35
002200*      MOVE 6        TO LINE-COUNT
002200*      ADD 1         TO WS-PAGE
002200*      MOVE WS-PAGE  TO PRT-PAGE
017500*      WRITE PRT-RECORD FROM HEADER-6

002200*      WRITE PRT-RECORD FROM PCL-EJECT-PAGE
002200*      WRITE PRT-RECORD FROM COURIER-59
002200*      WRITE PRT-RECORD FROM HEADER-1 AFTER 1 LINE
017500*      WRITE PRT-RECORD FROM HEADER-2
002200*      WRITE PRT-RECORD FROM HEADER-3 AFTER 1 LINE
017500*      WRITE PRT-RECORD FROM HEADER-4 AFTER 1 LINE
017500*   WRITE PRT-RECORD FROM HEADER-5 AFTER 1 LINE.
002200*      WRITE PRT-RECORD FROM COURIER-36 AFTER 1 LINE
002200*      WRITE PRT-RECORD FROM HDR-RECORD AFTER 1 LINE
026880
026964*  END-IF.



026963    GO TO READ-ALL-RECEIVE-NUMBERS.
026928
026949
026950*SEE-WHAT-IT-IS.
026951*   IF RECUR-CHART-ACCT-01(1:2) = '02' OR
026952*                                 '11' OR
026953*                                 '31' OR
026954*                                 '33'
026955*      GO TO ITS-A-BILL
026956*     ELSE
026957*   IF RECUR-CHART-ACCT-01(1:2) = '09' OR
026958*                                 '30' OR
026959*                                 '32'
026960*      GO TO ITS-A-REFUND
026961*     END-IF
026962*    END-IF.
026963    GO TO READ-ALL-RECEIVE-NUMBERS.
026972
028360
048600 READ-THE-MAIL-EXIT. EXIT.

       READ-PROFILE-EXIT. EXIT.
       READ-THE-EMAIL-EXIT. EXIT.
048700
048900
049000 FILE-ERROR.
049100     CALL TPSIOERR USING FILE-REQUEST.
049200     CANCEL TPSIOERR.
049300 FILE-ERROR-EXIT. EXIT.
049400
049500
049600 OPEN-THE-FILES.
049700    OPEN OUTPUT PRT-FILE.
049700*   OPEN OUTPUT xcl-FILE.
049800    MOVE F-PRIME    TO FILE-KEY.
049900*** MOVE F-OPEN-INPUT TO FILE-ACTION.
049900    MOVE F-OPEN-I-o   TO FILE-ACTION.
050000    CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
050100    IF FILE-STATUS NOT = '00' AND '05'
050200       MOVE 'RECEIVE ' TO FILE-NAME
050300       MOVE 'SEEMAIL-ORC' TO FILE-TEXT
050400       PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500       GO TO SEEMAIL-COMMON-EXIT.
050000*   CALL TPSIOMEM USING FILE-REQUEST TPS-MEMO-REC.
050100*   IF FILE-STATUS NOT = '00' AND '05'
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-OME' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500*      GO TO SEEMAIL-COMMON-EXIT.
459200*   CALL TPSIO022 USING FILE-REQUEST TPS-INVOICE-REC.
050100*   IF FILE-STATUS NOT = '00' AND '05'
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-OIV' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500*      GO TO SEEMAIL-COMMON-EXIT.
016561*    if we-b-looking-4-starter
459200       CALL TPSIO004 USING FILE-REQUEST TPS-profl-REC
050100       IF FILE-STATUS NOT = '00' AND '05'
050200          MOVE 'profl   ' TO FILE-NAME
050300          MOVE 'SEEMAIL-OIV' TO FILE-TEXT
050400          PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
050500          GO TO SEEMAIL-COMMON-EXIT
050600        end-if.
050600*    end-if.
050600

          move f-prime to file-key.
          move f-open-input  to file-action.
          call tpsio033 using file-request tps-email-rec.
          if not a-successful-operation
             move ' email  ' to file-name
             move 'tps1010p-open' to file-text
             perform file-error thru file-error-exit
             go to SEEMAIL-COMMON-EXIT
           end-if.




050600 OPEN-THE-FILES-EXIT. EXIT.
050600
050700 CLOSE-THE-FILES.
050800    CLOSE PRT-FILE.
050800*   CLOSE xcl-FILE.
050900      MOVE F-PRIME TO FILE-KEY.
051000      MOVE F-CLOSE TO FILE-ACTION.
051100
051200      CALL TPSIOREC USING FILE-REQUEST TPS-MAIL-REC.
051300      IF NOT A-SUCCESSFUL-OPERATION
051400         MOVE 'RECEIVE ' TO FILE-NAME
051500         MOVE 'SEEMAIL-CCK' TO FILE-TEXT
051600         PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
051700      END-IF.

228400     MOVE F-CLOSE    TO FILE-ACTION                                                   00325700
228500***  CALL TPSIO004 USING FILE-REQUEST TPS-LOGON
228500     call TPSIO004 using FILE-REQUEST TPS-PROFL-REC
075800     IF NOT A-SUCCESSFUL-OPERATION                                                    00155900
228700        MOVE 'PROFL' TO FILE-NAME                                                     00326000
069000        MOVE 'SEEMAIL-PROFILE' TO FILE-TEXT                                           00156100
228900        PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00326200
229000*       GO TO TPS2003-COMMON-EXIT                                                     00326300
229100     END-IF.                                                                          00326400

          move f-prime to file-key.
          move f-close to file-action.
          call tpsio033 using file-request tps-email-rec.
          if not a-successful-operation
             move ' email  ' to file-name
             move 'tps1010p-clos' to file-text
             perform file-error thru file-error-exit

           end-if.




050000*   CALL TPSIOMEM USING FILE-REQUEST TPS-MEMO-REC.
050100*   IF NOT A-SUCCESSFUL-OPERATION
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-CME' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
459200*   CALL TPSIO022 USING FILE-REQUEST TPS-INVOICE-REC.                                00658600
050100*   IF NOT A-SUCCESSFUL-OPERATION
050200*      MOVE 'MEMO    ' TO FILE-NAME
050300*      MOVE 'SEEMAIL-CIV' TO FILE-TEXT
050400*      PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.
050600*
016461*   if not we-r-reporting-check-info
050600*      go to close-the-files-exit
050600*    end-if.
050600*
051800
051900 CLOSE-THE-FILES-EXIT. EXIT.
701800**********************************************************
024010
026951








































