       IDENTIFICATION DIVISION.
       PROGRAM-ID. MOD10.
       AUTHOR. G MCGILVRAY
       INSTALLATION. TOPS.
       DATE-WRITTEN. AUGUST 1992.
       DATE-COMPILED.

      *****************************************************************
      * CALCULATE CHECK DIGIT FOR 7-POSITION SEQUENCE NUMBER          *
      *    MAKING A 8 DIGIT NUMBER                                    *
      *****************************************************************

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SOURCE-COMPUTER.
       OBJECT-COMPUTER.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       DATA DIVISION.
       FILE SECTION.
       WORKING-STORAGE SECTION.

       01  WORK-FIELDS.
           05  WF-FACTORS.
               10  WF-FACTOR-1         PIC 9(01)   VALUE 2.
               10  WF-FACTOR-2         PIC 9(01)   VALUE 1.
               10  WF-FACTOR-3         PIC 9(01)   VALUE 2.
               10  WF-FACTOR-4         PIC 9(01)   VALUE 1.
               10  WF-FACTOR-5         PIC 9(01)   VALUE 2.
               10  WF-FACTOR-6         PIC 9(01)   VALUE 1.
               10  WF-FACTOR-7         PIC 9(01)   VALUE 2.
               10  WF-FACTOR-8         PIC 9(01)   VALUE 1.
               10  WF-FACTOR-9         PIC 9(01)   VALUE 2.
           05  FILLER  REDEFINES  WF-FACTORS.
               10  WF-FACTOR           OCCURS 9 TIMES
                                       INDEXED BY WF-IDX
                                       PIC 9(01).
           05  WF-RESULT               PIC 9(02).
           05  FILLER  REDEFINES  WF-RESULT.
               10  WF-RESULT-1         PIC 9(01).
               10  WF-RESULT-2         PIC 9(01).
           05  WF-SUM                  PIC 9(02).
           05  FILLER  REDEFINES  WF-SUM.
               10  WF-SUM-1            PIC 9(01).
               10  WF-SUM-2            PIC 9(01).

       LINKAGE SECTION.

       01  COMM-AREA.
           05  CD-FIELD.
               10  CD-DIGITS.
                   15  CD-DIGIT-1      PIC 9(01).
                   15  CD-DIGIT-2      PIC 9(01).
                   15  CD-DIGIT-3      PIC 9(01).
                   15  CD-DIGIT-4      PIC 9(01).
                   15  CD-DIGIT-5      PIC 9(01).
                   15  CD-DIGIT-6      PIC 9(01).
                   15  CD-DIGIT-7      PIC 9(01).
                   15  CD-DIGIT-8      PIC 9(01).
                   15  CD-DIGIT-9      PIC 9(01).
               10  FILLER  REDEFINES  CD-DIGITS.
                   15  CD-DIGIT        OCCURS 9 TIMES
                                       INDEXED BY CD-IDX
                                       PIC 9(01).
           05  CD-CHECK-DIGIT          PIC 9(01).

       PROCEDURE DIVISION  USING  COMM-AREA.

       MAIN-PROGRAM.

           MOVE  ZERO                  TO  WF-SUM
           PERFORM BYTE-BY-BYTE
               VARYING CD-IDX
               FROM 1 BY 1
               UNTIL CD-IDX GREATER THAN 9.

           MOVE WF-SUM                 TO  WF-RESULT.
           ADD 1                       TO  WF-SUM-1.
           MOVE ZERO                   TO  WF-SUM-2.
           COMPUTE CD-CHECK-DIGIT =  WF-SUM  -  WF-RESULT.

           GOBACK.
       BYTE-BY-BYTE.
           SET WF-IDX                  TO CD-IDX.
           COMPUTE WF-RESULT = CD-DIGIT (CD-IDX) * WF-FACTOR (WF-IDX).
           ADD WF-RESULT-1             TO  WF-SUM.
           ADD WF-RESULT-2             TO  WF-SUM.
