   ***********************************
      ***AUTHOR: ALEX CASTRO
      ***DATE: 07/01/2015
      **THIS PROGRAM WILL ASK USER TO ENTER THE DATE THAT TPS WILL BE
      **CLOSED. IT WILL THEN GENERATE "CLOSED_DAY.txt" WHICH WILL BE
      **USED BY tps1010a
      *********************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. MENU01.
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

        SELECT TPS-HOLIDAY-RPT ASSIGN TO
                 "L:\TPS\PROD\FILES\CLOSED_DAY.txt"
      *          "C:\AlexCobol\HolidayProgram2\CLOSED-DAY.txt"
                 ORGANIZATION IS LINE SEQUENTIAL.




       DATA DIVISION.
       FILE SECTION.
       FD TPS-HOLIDAY-RPT.
       01 PRINT-LINE                   PIC X(80).
       WORKING-STORAGE SECTION.

       01 HEADING-1.
           02 PRT-CLOSED       PIC X(6) VALUE "CLOSED".
           02 FILLER           PIC X.
           02 PRT-CLOSE-DATE   PIC 9(8).
           02 FILLER           PIC X(2) VALUE " (".
           02 PRT-CLOSE-DAY    PIC X(3).
           02 FILLER           PIC X.
           02 PRT-CLOSE-MM     PIC 9(2).
           02 FILLER           PIC X VALUE "/".
           02 PRT-CLOSE-DD     PIC 9(2).
           02 FILLER           PIC X VALUE "/".
           02 PRT-CLOSE-YYYY   PIC 9(4).
           02 FILLER           PIC X VALUE ")".
           02 FILLER           PIC X.
           02 FILLER           PIC X(6) VALUE "NBDATE".
           02 FILLER           PIC X.
           02 PRT-OPEN-DATE    PIC 9(8).
           02 FILLER           PIC X.
           02 FILLER           PIC X(15) VALUE "DIARY-RPT-DAY#:".
           02 PRT-CLS-DAY-NUM     PIC 9(1).

       01 HEADING-2.
           02 FILLER           PIC X(6) VALUE "CLOSED".
           02 FILLER           PIC X.
           02 PRT-CLS-DATE     PIC 9(8).
           02 FILLER           PIC X VALUE ";".
           02 PRT-CLS-DATE-2   PIC 9(8).
           02 FILLER           PIC X(2) VALUE " (".
           02 PRT-CLOSE-DAY-2  PIC X(3).
           02 FILLER           PIC X.
           02 PRT-CLOSE-MM-2   PIC 9(2).
           02 FILLER           PIC X VALUE "/".
           02 PRT-CLOSE-DD-2   PIC 9(2).
           02 FILLER           PIC X VALUE "/".
           02 PRT-CLOSE-YYYY-2 PIC 9(4).
           02 FILLER           PIC X VALUE ")".
           02 FILLER           PIC X.
           02 FILLER           PIC X(6) VALUE "NBDATE".
           02 FILLER           PIC X.
           02 PRT-OPEN-DATE-2  PIC 9(8).
           02 FILLER           PIC X.
           02 FILLER           PIC X(15) VALUE "DIARY-RPT-DAY#:".
           02 PRT-OPEN-DAY-2   PIC 9(1).
           02 FILLER           PIC X.
           02 FILLER           PIC X(2) VALUE "OR".
           02 FILLER           PIC X.
           02 PRT-CLS-DAY-NUM-2 PIC 9.





       01 WS-THE-DAY-NUM               PIC 9.
       01 WS-THE-DAY-NUM-2             PIC 9.

       01 THE-WEEKDAY                  PIC X(3).

       01 WS-INT-DATE                  PIC 9(9).
       01 WS-DATE-1                       PIC 9(8).

       01 WS-INTEGER-VERSION-OF-DATE   PIC 9(7) VALUE ZEROS.
       01 WS-DATE-TO-CONVERT           PIC 9(8).
       01 WS-OPEN-DATE-TO-CONVERT      PIC 9(8).
       01 WS-OPEN-VERSION-DATE         PIC 9(7) VALUE ZEROS.

       01 WS-MMDDYY-FLD.
          03  YY-FLD      PIC 9(4).
          03  MM-FLD      PIC 99.
          03  DD-FLD      PIC 99.

      *******************************************************
       01 IN-DATE                   PIC 9(8).
       01 DAYS VALUE     "SunMonTueWedThuFriSat".
           03 DAY-NAME             PIC XXX OCCURS 7.


       01 NUM-OF-DAYS              PIC 9(2).

      *******************************************************
       01 WS-LOGO                 PIC X(41) VALUE
      *                  'C:\AlexCobol\HolidayProgram\tpswalpr1.bmp'.
                         'L:\TPS\Fonts\tpswalpr1.bmp'.

       01 SCREENIO      PICTURE X(08) VALUE 'GS     '.


       COPY SPLASH.COB.

       COPY MYMAIN.COB.


       PROCEDURE DIVISION.
       PROGRAM-BEGIN.
          PERFORM DISPLAY-SPLASH-PANEL .

       PROGRAM-DONE.
           STOP RUN.

       OPEN-ROUTINE.

           OPEN OUTPUT TPS-HOLIDAY-RPT.

       CLOSE-ROUTINE.

           CLOSE TPS-HOLIDAY-RPT.
       DISPLAY-SPLASH-PANEL.

           CALL SCREENIO USING SPLASH-1
                               SPLASH-2
                               SPLASH-3
                               SPLASH-4.
          PERFORM DISPLAY-MAIN-PANEL.

       DISPLAY-MAIN-PANEL.

            MOVE WS-LOGO TO PNL-LOGO.
            CALL SCREENIO USING MYMAIN-1
                                MYMAIN-2
                                MYMAIN-3
                                MYMAIN-4.

            EVALUATE TRUE

               WHEN MYMAIN-EVENT-CLOSE-AND-STOP
               GO TO EXIT-ROUTINE

               WHEN MYMAIN-EXIT
               GO TO EXIT-ROUTINE
            END-EVALUATE.

           PERFORM OPEN-ROUTINE.
           PERFORM SUBMIT-ROUTINE.
           PERFORM CLOSE-ROUTINE.

       SUBMIT-ROUTINE.

           EVALUATE TRUE

               WHEN MYMAIN-PNL-SUBMIT
               PERFORM ACCEPT-ENTRY-ROUTINE

           END-EVALUATE.

       ACCEPT-ENTRY-ROUTINE.

           MOVE PNL-FULL-DATE TO WS-DATE-1.
           MOVE PNL-NUM-DAYS  TO NUM-OF-DAYS.

           PERFORM CHECK-DAY-OF-WEEK.

       CHECK-DAY-OF-WEEK.

            MOVE PNL-FULL-DATE TO IN-DATE
             MOVE DAY-NAME(function mod(
                 function integer-of-date(IN-DATE) 7) + 1) TO
                 THE-WEEKDAY.
             DISPLAY THE-WEEKDAY.


            EVALUATE THE-WEEKDAY

               WHEN "Mon"
               MOVE "1" TO WS-THE-DAY-NUM
               MOVE "2" TO WS-THE-DAY-NUM-2
               PERFORM COMPUTE-CLOSING-DATE

               WHEN "Tue"
               MOVE "2" TO WS-THE-DAY-NUM
               MOVE "3" TO WS-THE-DAY-NUM-2
               PERFORM COMPUTE-CLOSING-DATE

               WHEN "Wed"
               MOVE "3" TO WS-THE-DAY-NUM
               MOVE "4" TO WS-THE-DAY-NUM-2
               PERFORM COMPUTE-CLOSING-DATE

               WHEN "Thu"
               MOVE "4" TO WS-THE-DAY-NUM
               MOVE "5" TO WS-THE-DAY-NUM-2
               PERFORM THURSDAY-ROUTINE

               WHEN "Fri"
               MOVE "5" TO WS-THE-DAY-NUM
               MOVE "1" TO WS-THE-DAY-NUM-2
               PERFORM FRIDAY-ROUTINE


            END-EVALUATE.



       COMPUTE-CLOSING-DATE.

      *** COMPUTES BASED ON NUMBER OF DAYS CLOSED******
          EVALUATE NUM-OF-DAYS

           WHEN 1
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE(WS-DATE-1)
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            DISPLAY "CLOSED ON: " WS-DATE-TO-CONVERT
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE

            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            PERFORM PRINT-HOLIDAY-RPT



           WHEN 2
            SUBTRACT 1 FROM NUM-OF-DAYS
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-INTEGER-VERSION-OF-DATE
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            ADD 1 TO NUM-OF-DAYS
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE
            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            DISPLAY "OPEN ON: " WS-OPEN-DATE-TO-CONVERT
            PERFORM PRINT-HOLIDAY-RPT-2

        END-EVALUATE.

       OPENING-DATE.

           COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1).
           ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE.
           COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE).
           DISPLAY "OPEN ON: " WS-OPEN-DATE-TO-CONVERT.

       THURSDAY-ROUTINE.

          EVALUATE NUM-OF-DAYS

           WHEN 1
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE (WS-DATE-1)
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE

            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            PERFORM PRINT-HOLIDAY-RPT


           WHEN 2
            SUBTRACT 1 FROM NUM-OF-DAYS
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-INTEGER-VERSION-OF-DATE
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            DISPLAY "CLOSED ON:" PNL-FULL-DATE " AND: "
                               WS-DATE-TO-CONVERT
            ADD 3 TO NUM-OF-DAYS
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE
            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            PERFORM PRINT-HOLIDAY-RPT-2

        END-EVALUATE.



       FRIDAY-ROUTINE.

        EVALUATE NUM-OF-DAYS

           WHEN 1
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE (WS-DATE-1)
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD 2 TO NUM-OF-DAYS
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE
            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            DISPLAY "OPEN ON: " WS-OPEN-DATE-TO-CONVERT
            PERFORM PRINT-HOLIDAY-RPT

           WHEN 2
            ADD 1 TO NUM-OF-DAYS
            COMPUTE WS-INTEGER-VERSION-OF-DATE =
                   FUNCTION INTEGER-OF-DATE (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-INTEGER-VERSION-OF-DATE
            COMPUTE WS-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-INTEGER-VERSION-OF-DATE)
            ADD 1 TO NUM-OF-DAYS
            COMPUTE WS-OPEN-VERSION-DATE = FUNCTION INTEGER-OF-DATE
                                                  (WS-DATE-1)
            ADD NUM-OF-DAYS TO WS-OPEN-VERSION-DATE

            COMPUTE WS-OPEN-DATE-TO-CONVERT = FUNCTION DATE-OF-INTEGER
                                   (WS-OPEN-VERSION-DATE)
            DISPLAY "OPEN ON: " WS-OPEN-DATE-TO-CONVERT
            PERFORM PRINT-HOLIDAY-RPT-2

         END-EVALUATE.




       PRINT-HOLIDAY-RPT.

               MOVE WS-DATE-TO-CONVERT TO PRT-CLOSE-DATE.
               MOVE THE-WEEKDAY TO PRT-CLOSE-DAY.
               MOVE PNL-FULL-DATE TO WS-MMDDYY-FLD.
               MOVE MM-FLD TO PRT-CLOSE-MM
               MOVE DD-FLD TO PRT-CLOSE-DD
               MOVE YY-FLD TO PRT-CLOSE-YYYY
               MOVE WS-OPEN-DATE-TO-CONVERT TO PRT-OPEN-DATE.
               MOVE WS-THE-DAY-NUM TO PRT-CLS-DAY-NUM.

               WRITE PRINT-LINE FROM HEADING-1.

       PRINT-HOLIDAY-RPT-2.
               MOVE PNL-FULL-DATE TO PRT-CLS-DATE.
               MOVE WS-DATE-TO-CONVERT TO PRT-CLS-DATE-2.
               MOVE THE-WEEKDAY TO PRT-CLOSE-DAY-2.
               MOVE PNL-FULL-DATE TO WS-MMDDYY-FLD.
               MOVE MM-FLD TO PRT-CLOSE-MM-2.
               MOVE DD-FLD TO PRT-CLOSE-DD-2.
               MOVE YY-FLD TO PRT-CLOSE-YYYY-2.
               MOVE WS-OPEN-DATE-TO-CONVERT TO PRT-OPEN-DATE-2
               MOVE WS-THE-DAY-NUM TO PRT-OPEN-DAY-2.
               MOVE WS-THE-DAY-NUM-2 TO PRT-CLS-DAY-NUM-2.

               WRITE PRINT-LINE FROM HEADING-2.


       EXIT-ROUTINE. EXIT.
