       IDENTIFICATION DIVISION.                                                            00002100
       PROGRAM-ID. CHKPRVEW.                                                               00002200
       AUTHOR. JIM MONAGHAN.                                                               00002300
      ***************************************************************                      00002400
      *  CREATE THE CHECK PREVIEW FILE (CHKPRVEW) WHEN CHANGES ARE  *                      00002500
      *  MADE TO ANY BILL THAT WILL BE PAID TODAY. READ THE FILE    *                      00002500
      *  AND PRINT THE LATEST PREVIEWS BEFORE THE CHECK RUN.        *                      00006000
      ***************************************************************                      00006000
      ***************************************************************                      00006000
      *                     MAINTENANCE LOG                         *
      *07/07/17 CHANGED GUI                                      AC *   
      ***************************************************************                      00006000
       ENVIRONMENT DIVISION.                                                               00006100
       CONFIGURATION SECTION.                                                              00006200
       SOURCE-COMPUTER. IBM-PS2.                                                           00006300
       OBJECT-COMPUTER. IBM-PS2.                                                           00006400
       FILE-CONTROL.                                                                       00006500
      *    SELECT IMPORT-FILE  ASSIGN TO DYNAMIC FILESPEC                                  00006600
      *        ORGANIZATION IS LINE SEQUENTIAL                                             00006800
      *        FILE STATUS IS FILE-STATUS.                                                 00006900
                                                                                           00007000
      *    SELECT PRT-FILE  ASSIGN TO PRINTER                                              00007000
      *    SELECT PRT-FILE  ASSIGN TO "C:\TPS\APP\IMGIMPORT.TXT"                           00007000
      *        ORGANIZATION IS LINE SEQUENTIAL.                                            00007100
                                                                                           00007200
      *DATA DIVISION.                                                                      00007300
      *FILE SECTION.                                                                       00007400
      *FD  IMPORT-FILE                                                                     00007500
      *    LABEL RECORDS ARE OMITTED                                                       00007600
      *    RECORD CONTAINS 500 CHARACTERS.                                                 00007700
      *01  IMP-LINE                      PIC X(500).                                       00007800
      *                                                                                    00007900
      *FD  PRT-FILE                                                                        00008000
      *    LABEL RECORDS ARE OMITTED                                                       00008100
      *    RECORD CONTAINS 200 CHARACTERS.                                                 00008200
      *01  PRT-LINE                      PIC X(200).                                       00008300
                                                                                           00008400
       WORKING-STORAGE SECTION.                                                            00008500
                                                                                           00008600
                                                                                           00008600
       01 FILESPEC             PIC X(28) VALUE                                             00008700
             '\TPS\PROD\FILES\CHKPRVEW.DAT'.                                               00008800
                                                                                           00008600
                                                                                           00009200
       01 TAB-IND                       PIC 9(03) VALUE 0.                                 00009300
       01 DIS-IND                       PIC 9(03) VALUE 0.                                 00009400
       01 PRT-IND                       PIC 9(03) VALUE 0.                                 00009400
       01 FILE-OPEN                     PIC X(01) VALUE 'N'.                               00009400
                                                                                           00023400
       01 WK-IND                        PIC 9(03) VALUE 0.                                 00010100
       01 WORK-DATA OCCURS 1 TO 500 TIMES                                                  00023500
               DEPENDING ON WK-IND.                                                        00023600
          10 WK-ACCT-NO                 PIC X(10).                                         00023700
          10 WK-SUB-ACCT                PIC X(02).                                         00023900
          10 WK-PRVEW-DATE              PIC X(08).                                         00024100
          10 WK-FIRST-NAME              PIC X(15).                                         00023900
          10 WK-LAST-NAME               PIC X(20).                                         00024100
          10 WK-MDDL-INIT               PIC X(01).                                         00024100
                                                                                           00059400
      ********** DISPLAY TPS PANEL ********
       COPY TPS1017.COB.
       01 DISPLAY-USER-FIELDS REDEFINES TPS1017-4.
               10 DISPLAY-LINES    OCCURS 15 TIMES.
                  20 DISPLAY-INDICATOR        PIC X(02).
                  20 DISPLAY-LAST-NAME        PIC X(15).
                  20 DISPLAY-FIRST-NAME       PIC X(10).
               10 DISPLAY-SELECTION           PIC X(02).
       01  GUISCREEN               PIC x(08) VALUE 'GS      '.                             00010500
       01  PROGRAM-NAMES.                                                                  00018300
        10 SCREENIO    PIC X(08) VALUE 'SCRNIO  '.                                         00018400
        10 TPSIOERR    PIC X(08) VALUE 'TPSIOERR'.                                         00018500
        10 TPS2003     PIC X(08) VALUE 'TPS2003 '.                                         00019100
        10 TPSIO037    PIC X(08) VALUE 'TPSIO037'.                                         00019200
        10 FILLER      PIC X(08) VALUE HIGH-VALUES.                                        00019300
                                                                                           00018200
      ********* COPY BOOKS ***********
           COPY "TPSFILES.CPY".                                                            00020500
           COPY "KEYVALUE.CPY".                                                            00020600
           COPY "PCL5VALU.CPY".                                                            00020700
                                                                                           00033300
       01 CHKPRVEW-REC.                                                                    00091900
           COPY "CHKPRVEW.CPY".                                                            00092000
       01 TPS-LOGON.                                                                       00091900
           COPY "TPSLOGON.CPY".                                                            00092000
       01 TPS-CLIENT-REC.                                                                  00092300
           COPY "TPSRESID.CPY".                                                            00092400
       01 TPS-PARAMETER.                                                                   00092700
          05 TPS-PARAMETER-VALUE PIC XX.                                                   00092800
             88 WERE-PRINTING-CHECKS            VALUE '00'.                                00092900
             88 WERE-DOING-CHECK-PREVIEW        VALUE '01'.                                00093000
             88 WERE-PRINTING-ALL-PREVIEWS      VALUE '02'.                                00092900
             88 WERE-DOING-SAMPLE-CHECKS        VALUE '03'.                                00093000
             88 WERE-PRINTING-SPECIAL-PREVIEWS  VALUE '04'.                                00093100
             88 WERE-PRINTING-CHANGED-PREVIEWS  VALUE '05'.                                00093100
       01 PREVIEW-DATE.                                                                    00093200
          05 PREVIEW-DATE-CC                PIC 9(02) VALUE ZEROS.                         00093300
          05 PREVIEW-DATE-YY                PIC 9(02) VALUE ZEROS.                         00093400
          05 PREVIEW-DATE-MM                PIC 9(02) VALUE ZEROS.                         00093500
          05 PREVIEW-DATE-DD                PIC 9(02) VALUE ZEROS.                         00093600
                                                                                           00093700
                                                                                           00043100
       LINKAGE SECTION.                                                                    00043200
                                                                                           00043300
       01 TPS-MAIL-REC.                                                                    00043400
           COPY "TPSMAIL.CPY".                                                             00043500
       01 TPS-PROFILE.                                                                     00043510
           COPY "TPSPROFL.CPY".                                                            00043520
                                                                                           00043600
       01 CHKPRVEW-PARM        PIC X(01).                                                  00043700
          88 CREATE-RECORDS      VALUE 'C'.                                                00043800
          88 DISPLAY-RECORDS     VALUE 'D'.                                                00043800
                                                                                           00043900
       PROCEDURE DIVISION USING TPS-MAIL-REC TPS-PROFILE                                   00044000
                                CHKPRVEW-PARM.                                             00044000
                                                                                           00044100
       0001-BEGIN.                                                                         00044200
                                                                                           00044300
         IF DISPLAY-RECORDS                                                                00453100
            GO TO 0050-DISPLAY-RECORDS.                                                    00453100
                                                                                           00054800
       0010-CREATE-RECORDS.                                                                00054900
                                                                                           00055000
      ***** WRITE NEW RECORD, IF RECORD ALREADY EXIST THATS OK *****                       00453100
                                                                                           00055000
         MOVE MAIL-ACCT-NO             TO CLNT-PRVEW-ACCT-NO.                              00453100
         MOVE MAIL-SUB-ACCT            TO CLNT-PRVEW-SUB-ACCT.                             00453100
         MOVE MAIL-RECEIVE-DATE        TO CLNT-PRVEW-DATE.
         MOVE CLNT-PROFILE-LAST-NAME   TO CLNT-PRVEW-LAST-NAME.
         MOVE CLNT-PROFILE-FIRST-NAME  TO CLNT-PRVEW-FIRST-NAME.
         MOVE CLNT-PROFILE-MDDL-INIT   TO CLNT-PRVEW-MDDL-INIT.

         PERFORM 0150-OPEN-THE-FILES THRU 0150-EXIT.
         PERFORM 0200-WRITE-RECORD THRU 0200-EXIT.
         GO TO EXIT-THE-MODULE.

       0010-EXIT.    EXIT.

       0050-DISPLAY-RECORDS.

         PERFORM 0150-OPEN-THE-FILES THRU 0150-EXIT.

          MOVE F-PRIME    TO FILE-KEY.
          MOVE F-START    TO FILE-ACTION.
          CALL TPSIO037 USING FILE-REQUEST CHKPRVEW-REC.
          IF NOT A-SUCCESSFUL-OPERATION
             MOVE 'CHKPRVEW' TO FILE-NAME
             MOVE 'START   ' TO FILE-TEXT
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT
             GO TO EXIT-THE-MODULE.

         PERFORM UNTIL END-OF-FILE-WAS-REACHED
            PERFORM 0250-READ-RECORDS THRU 0250-EXIT
            ADD 1                       TO WK-IND
            MOVE CLNT-PRVEW-ACCT-NO     TO WK-ACCT-NO(WK-IND)
            MOVE CLNT-PRVEW-SUB-ACCT    TO WK-SUB-ACCT(WK-IND)
            MOVE CLNT-PRVEW-DATE        TO WK-PRVEW-DATE(WK-IND)
            MOVE CLNT-PRVEW-FIRST-NAME  TO WK-FIRST-NAME(WK-IND)
            MOVE CLNT-PRVEW-LAST-NAME   TO WK-LAST-NAME(WK-IND)
            MOVE CLNT-PRVEW-MDDL-INIT   TO WK-MDDL-INIT(WK-IND)
         END-PERFORM.

         MOVE ZERO                TO WK-IND.
         MOVE ZERO                TO DIS-IND.

       DISPLAY-SCREEN.

         PERFORM 15 TIMES
            ADD 1                 TO TAB-IND, DIS-IND
            MOVE DIS-IND                TO DISPLAY-INDICATOR(DIS-IND)
            MOVE WK-FIRST-NAME(TAB-IND) TO DISPLAY-FIRST-NAME(DIS-IND)
            MOVE WK-LAST-NAME(TAB-IND)  TO DISPLAY-LAST-NAME(DIS-IND)
         END-PERFORM.

           SET TPS1017-MESSAGE-BAR-PERSIST TO TRUE.
           MOVE 'ENTER TO PROCESS, PAGE-UP, PAGE-DOWN, END TO GO BACK'
                                   TO TPS1017-MESSAGE-TEXT. 
           CALL GUISCREEN USING TPS1017-1
                                TPS1017-2
                                TPS1017-3
                                TPS1017-4.

           MOVE TPS1017-EVENT-ID TO EXIT-KEY-NAMES.

           IF THEY-HIT-END OR TPS1017-EVENT-CLOSE-AND-STOP
             GO TO EXIT-THE-MODULE
            END-IF.

      *    IF THEY-HIT-PAGE-UP
      *       GO TO 0340-PAGE-UP
      *     END-IF.

           IF THEY-HIT-PAGE-DOWN
              MOVE ZERO TO DIS-IND
              IF TAB-IND >= WK-IND
                 MOVE ZERO TO TAB-IND
              END-IF
              GO TO DISPLAY-SCREEN
            END-IF.

           IF TPS1017-SELECTION = 'P' OR 'p'
              GO TO 0100-PRINT-PREVIEWS
            END-IF.

           IF TPS1017-SELECTION = 'S' OR 's'
              MOVE 'S'         TO CHKPRVEW-PARM
              GO TO EXIT-THE-MODULE
            END-IF.

           IF TPS1017-SELECTION >= 01 AND <= 15
              MOVE TPS1017-SELECTION TO DIS-IND
           END-IF.

           INITIALIZE TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                         TPS-MAIL-REC TPS-PARAMETER PREVIEW-DATE.

           MOVE WK-ACCT-NO(DIS-IND)    TO CLNT-PROFILE-ACCT-NO
                                          MAIL-ACCT-NO.
           MOVE WK-SUB-ACCT(DIS-IND)   TO CLNT-PROFILE-SUB-ACCT
                                          MAIL-SUB-ACCT.
           MOVE WK-PRVEW-DATE(DIS-IND) TO MAIL-RECEIVE-DATE.
           MOVE WK-FIRST-NAME(DIS-IND) TO CLNT-PROFILE-FIRST-NAME.
           MOVE WK-LAST-NAME(DIS-IND)  TO CLNT-PROFILE-LAST-NAME.
           MOVE WK-MDDL-INIT(DIS-IND)  TO CLNT-PROFILE-MDDL-INIT.
           MOVE '01'          TO TPS-PARAMETER-VALUE.

           CALL TPS2003 USING TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                          TPS-MAIL-REC TPS-PARAMETER PREVIEW-DATE.
           CANCEL TPS2003.

           MOVE ZERO                TO WK-IND.
           MOVE ZERO                TO DIS-IND.
           GO TO DISPLAY-SCREEN.

       0050-EXIT.    EXIT.

       0100-PRINT-PREVIEWS.

      *********** PRINT CLIENT PREVIEWS ONE AT A TIME ***********
           ADD 1          TO PRT-IND.
           IF PRT-IND > WK-IND
              GO TO EXIT-THE-MODULE.

           INITIALIZE TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                         TPS-MAIL-REC TPS-PARAMETER PREVIEW-DATE.

           MOVE WK-ACCT-NO(PRT-IND)    TO CLNT-PROFILE-ACCT-NO
                                          MAIL-ACCT-NO.
           MOVE WK-SUB-ACCT(PRT-IND)   TO CLNT-PROFILE-SUB-ACCT
                                          MAIL-SUB-ACCT.
           MOVE WK-PRVEW-DATE(PRT-IND) TO MAIL-RECEIVE-DATE.
           MOVE WK-FIRST-NAME(PRT-IND) TO CLNT-PROFILE-FIRST-NAME.
           MOVE WK-LAST-NAME(PRT-IND)  TO CLNT-PROFILE-LAST-NAME.
           MOVE WK-MDDL-INIT(PRT-IND)  TO CLNT-PROFILE-MDDL-INIT.
           MOVE '05'          TO TPS-PARAMETER-VALUE.

           CALL TPS2003 USING TPS-LOGON TPS-PROFILE TPS-CLIENT-REC
                          TPS-MAIL-REC TPS-PARAMETER PREVIEW-DATE.
           CANCEL TPS2003.

           GO TO DISPLAY-SCREEN.

       0100-EXIT.    EXIT.

                                                                                           00051500
       0150-OPEN-THE-FILES.                                                                00051600
                                                                                           00051700
          MOVE F-PRIME    TO FILE-KEY.                                                     00688300
          MOVE F-OPEN-I-O TO FILE-ACTION.                                                  00688400
          CALL TPSIO037 USING FILE-REQUEST CHKPRVEW-REC.                                   00688500
          IF DISPLAY-RECORDS                                                               00688600
           IF FILE-STATUS NOT = '00' AND '05'                                              00688600
             MOVE 'CHKPRVEW' TO FILE-NAME                                                  00108200
             MOVE 'OPEN I-O' TO FILE-TEXT                                                  00108300
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00108400
             GO TO EXIT-THE-MODULE.                                                        00060600
                                                                                           00051700
          MOVE 'Y'           TO FILE-OPEN.                                                 00688300
                                                                                           00108500
       0150-EXIT. EXIT.                                                                    00054700
                                                                                           00051500
       0200-WRITE-RECORD.                                                                  00051600
                                                                                           00051700
          MOVE F-PRIME    TO FILE-KEY.                                                     00688300
          MOVE F-WRITE    TO FILE-ACTION.                                                  00688400
          CALL TPSIO037 USING FILE-REQUEST CHKPRVEW-REC.                                   00688500
      ***** IF DUPLICATE RECORD IGNORE ERROR *****                                         00154800
          IF IT-WAS-A-DUPLICATE-KEY                                                        00154800
             GO TO 0200-EXIT.                                                              00108200
          IF NOT A-SUCCESSFUL-OPERATION                                                    00154800
             MOVE 'CHKPRVEW' TO FILE-NAME                                                  00108200
             MOVE 'WRITE   ' TO FILE-TEXT                                                  00108300
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT                                       00108400
             GO TO EXIT-THE-MODULE.                                                        00060600
                                                                                           00108500
       0200-EXIT. EXIT.                                                                    00054700
                                                                                           00051500
       0250-READ-RECORDS.                                                                  00051600
                                                                                           00051700
          MOVE F-PRIME     TO FILE-KEY.                                                    00688300
          MOVE F-READ-NEXT TO FILE-ACTION.                                                 00688400
          CALL TPSIO037 USING FILE-REQUEST CHKPRVEW-REC.                                   00688500
          IF NOT A-SUCCESSFUL-OPERATION                                                    00154800
             MOVE 'CHKPRVEW' TO FILE-NAME                                                  00108200
             MOVE 'READ    ' TO FILE-TEXT                                                  00108300
             PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.                                      00108400
                                                                                           00108500
       0250-EXIT. EXIT.                                                                    00054700
                                                                                           00060500
       EXIT-THE-MODULE.                                                                    00060600
                                                                                           00051700
          IF FILE-OPEN = 'Y'                                                               00108500
             MOVE F-PRIME    TO FILE-KEY                                                   00688300
             MOVE F-CLOSE    TO FILE-ACTION                                                00688400
             CALL TPSIO037 USING FILE-REQUEST CHKPRVEW-REC                                 00688500
             IF NOT A-SUCCESSFUL-OPERATION                                                 00154800
                MOVE 'CHKPRVEW' TO FILE-NAME                                               00108200
                MOVE 'CLOSE   ' TO FILE-TEXT                                               00108300
                PERFORM FILE-ERROR THRU FILE-ERROR-EXIT.                                   00108400
                                                                                           00060600
                                                                                           00051500
         CANCEL  TPSIO037.
                                                                                           00060700
          GOBACK.                                                                          00060800
                                                                                           00061300
       EXIT-MODULE.                                                                        00061400
                                                                                           00142100
       FILE-ERROR.                                                                         00142200
           CALL TPSIOERR USING FILE-REQUEST.                                               00142300
           CANCEL TPSIOERR.                                                                00142400
       FILE-ERROR-EXIT. EXIT.                                                              00142500
                                                                                           00142600
                                                                                           00061500
