/*
 * ++Copyright++ 1980, 1983, 1988, 1993
 * -
 * Copyright (c) 1980, 1983, 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * -
 * Portions Copyright (c) 1993 by Digital Equipment Corporation.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Digital Equipment Corporation not be used in advertising or
 * publicity pertaining to distribution of the document or software without
 * specific, written prior permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * -
 * --Copyright--
 */

/*
 *      @(#)netdb.h	8.1 (Berkeley) 6/2/93
 *	$Id: netdb.h,v 8.9 1996/11/19 08:39:29 vixie Exp $
 */

#ifndef _NETDB_INCLUDED
#define _NETDB_INCLUDED



#include <sys/stdsyms.h>

#if defined(_INCLUDE_HPUX_SOURCE) || defined(_INCLUDE_XOPEN_SOURCE_520)
#include <sys/socket.h>
#endif /* _INCLUDE_HPUX_SOURCE or _INCLUDE_XOPEN_SOURCE_520 */

#ifndef _XOPEN_SOURCE_EXTENDED
#include <stdio.h>
#endif /* ! _XOPEN_SOURCE_EXTENDED */

#include <sys/types.h>
#include <netinet/in.h>

#ifdef _REENTRANT
#define _MAXALIASES     35
#define _MAXADDRS       35
#define _MAXLINELEN     1024
#endif



#ifdef _INCLUDE_XOPEN_SOURCE_EXTENDED

#define	_PATH_HEQUIV	"/etc/hosts.equiv"
#define	_PATH_HOSTS	"/etc/hosts"
#define	_PATH_NETWORKS	"/etc/networks"
#define	_PATH_PROTOCOLS	"/etc/protocols"
#define	_PATH_SERVICES	"/etc/services"
#if defined(_INCLUDE_HPUX_SOURCE) 
#  define	_PATH_IPNODES	"/etc/ipnodes"
#endif /* _INCLUDE_HPUX_SOURCE */

/*
 * Structures returned by network data base library.  All addresses are
 * supplied in host order, and returned in network order (suitable for
 * use in system calls).
 */
struct	hostent {
	char	*h_name;	/* official name of host */
	char	**h_aliases;	/* alias list */
	int	h_addrtype;	/* host address type */
	int	h_length;	/* length of address */
	char	**h_addr_list;	/* list of addresses from name server */
#define	h_addr	h_addr_list[0]	/* address, for backward compatiblity */
};

#ifndef _XOPEN_SOURCE_EXTENDED
#ifdef _REENTRANT
/*
 * The fields in the hostent_data structure are referenced by
 * entries in the hostent data structure after a successful
 * call to gethostent_r(), gethostbyname_r() or gethostbyaddr_r().
 * hostent_data also maintains state information between calls
 * to gethostent_r().  The contents of this structure should not
 * be referenced directly except to initialize the hostf field
 * to NULL.
 */

struct  hostent_data {
        struct in_addr host_addr;               /* host address */
        char    *h_addr_ptrs[_MAXADDRS + 1];    /* list of addresses */
        char    hostaddr[_MAXADDRS];            /* host address */
        char    hostbuf[BUFSIZ+1];              /* host info buffer */
        char    *host_aliases[_MAXALIASES];     /* list of aliases */
        char    *host_addrs[2];                 /* short list of addresses */
        FILE    *hostf;                         /* hosts file */
        short   _nsw_src;                       /* source of answer */
        short   _flags;                         /* internal flags */
        char    *current;                       /* current YP entry */
        int     currentlen;                     /* len of current YP entry */
};

#endif

#endif /* ! _XOPEN_SOURCE_EXTENDED */


/*
 * Assumption here is that a network number
 * fits in an unsigned long -- probably a poor one.
 */
struct	netent {
	char		*n_name;	/* official name of net */
	char		**n_aliases;	/* alias list */
	int		n_addrtype;	/* net address type */
	in_addr_t	n_net;		/* network # */
};

#ifndef _XOPEN_SOURCE_EXTENDED
#ifdef _REENTRANT
/*
 * netent_data structure for calls to getnetent_r(), getnetbyname_r()
 * or getnetbyaddr_r().  The contents of this structure should not
 * be referenced directly except to initialize the net_fp field
 * to NULL.
 */

struct  netent_data {
        FILE    *net_fp;
        char    line[_MAXLINELEN+1];
        char    *net_aliases[_MAXALIASES];
        short   _nsw_src;                       /* source of answer */
        short   _flags;                         /* internal flags */
        char    *current;                       /* current YP entry */
        int     currentlen;                     /* len of current YP entry */

};
#endif

#endif /* ! _XOPEN_SOURCE_EXTENDED */


struct	servent {
	char	*s_name;	/* official service name */
	char	**s_aliases;	/* alias list */
	int	s_port;		/* port # */
	char	*s_proto;	/* protocol to use */
};

#ifndef _XOPEN_SOURCE_EXTENDED
#ifdef _REENTRANT
/*
 * servent_data structure for calls to getservent_r(), getservbyname_r()
 * or getservbyport_r().  The contents of this structure should not
 * be referenced directly except to initialize the serv_fp field
 * to NULL.
 */
struct  servent_data {
        FILE    *serv_fp;
        char    line[_MAXLINELEN+1];
        char    *serv_aliases[_MAXALIASES];
        short   _nsw_src;                       /* source of answer */
        short   _flags;                         /* internal flags */
        char    *current;                       /* current YP entry */
        int     currentlen;                     /* len of current YP entry */
};
#endif

#endif /* ! _XOPEN_SOURCE_EXTENDED */


struct	protoent {
	char	*p_name;	/* official protocol name */
	char	**p_aliases;	/* alias list */
	int	p_proto;	/* protocol # */
};

#ifndef _XOPEN_SOURCE_EXTENDED
#ifdef _REENTRANT
/*
 * protoent_data structure for calls to getprotoent_r(), getprotobyname_r()
 * or getprotobynumber_r().  The contents of this structure should not
 * be referenced directly except to initialize the proto_fp field
 * to NULL.
 */
struct  protoent_data {
        FILE    *proto_fp;
        char    line[_MAXLINELEN+1];
        char    *proto_aliases[_MAXALIASES];
        short   _nsw_src;                       /* source of answer */
        short   _flags;                         /* internal flags */
        char    *current;                       /* current YP entry */
        int     currentlen;                     /* len of current YP entry */
};
#endif

struct rpcent {
	char	*r_name;	/* name of server for this rpc program */
	char	**r_aliases;	/* alias list */
	int	r_number;	/* rpc program number */
};


#ifdef _REENTRANT
/*
 * rpcent_data structure for calls to getrpcent_r(), getrpcbyname_r()
 * or getrpcbynumber_r().  The contents of this structure should not
 * be referenced directly except to initialize the rpc_fp field
 * to NULL.
 */
struct  rpcent_data {
        FILE    *rpc_fp;
        char    line[_MAXLINELEN+1];
        char    *rpc_aliases[_MAXALIASES];
        short   _nsw_src;                       /* source of answer */
        short   _flags;                         /* internal flags */
        char    *current;                       /* current YP entry */
        int     currentlen;                     /* len of current YP entry */
};
#endif

#endif /* ! _XOPEN_SOURCE_EXTENDED */


#if defined(_INCLUDE_HPUX_SOURCE) 
  struct addrinfo {
    int           ai_flags;               /* AI_PASSIVE, AI_CANONNAME */
    int           ai_family;              /* PF_xxx */
    int           ai_socktype;            /* SOCK_xxx */
    int           ai_protocol;            /* IPPROTO_xxx for IPv4 and IPv6 */
    socklen_t     ai_addrlen;             /* length of ai_addr */
    char          *ai_canonname;          /* canonical name for host */
    struct sockaddr      *ai_addr;       /* binary address */
    struct addrinfo       *ai_next;       /* next structure in linked list */
  };

                /* following for getaddrinfo() */

#  define AI_PASSIVE       1      /* socket is intended for bind() + listen() */
#  define AI_CANONNAME     2      /* return canonical name */
#  define AI_NUMERICHOST   4      /* hostname is numeric host address string */
#  define AI_NUMERICSERV   8      /* service name is numeric port */

                /* following for getnameinfo() */

#  define NI_MAXHOST        1025  /* max hostname returned */
#  define NI_MAXSERV          32  /* max service name returned */
#  define NI_NOFQDN            1  /* do not return FQDN */
#  define NI_NUMERICHOST       2  /* return numeric form of hostname */
#  define NI_NAMEREQD          4  /* return error if hostname not found */
#  define NI_NUMERICSERV       8  /* return numeric form of service name */
#  define NI_DGRAM            16  /* datagram service for getservbyname() */
#  define NI_NUMERICSCOPE     32 /*2553bis-00 user numeric scope for IPV6 addresses */

                /* error returns */

#  define EAI_ADDRFAMILY   1      /* address family for host not supported */
#  define EAI_AGAIN        2      /* temporary failure in name resolution */
#  define EAI_BADFLAGS     3      /* invalid value for ai_flags */
#  define EAI_FAIL         4      /* non-recoverable failure in name resolution */
#  define EAI_FAMILY       5      /* ai_family not supported */
#  define EAI_MEMORY       6      /* memory allocation failure */
#  define EAI_NODATA       7      /* no address associated with host */
#  define EAI_NONAME       8      /* host nor service provided, or not known */
#  define EAI_SERVICE      9      /* service not supported for ai_socktype */
#  define EAI_SOCKTYPE    10      /* ai_socktype not supported */
#  define EAI_SYSTEM      11      /* system error returned in errno */


		/* following for getipnodeYY() */
#  define AI_V4MAPPED     0x00000010
#  define AI_ALL          0x00000020
#  define AI_ADDRCONFIG   0x00000040
#  define AI_DEFAULT      (AI_V4MAPPED|AI_ADDRCONFIG)

#endif /* _INCLUDE_HPUX_SOURCE */

#ifdef _REENTRANT
/*
 * flags for data representation and boolean values in the reentrant state
 * data structure
 */
#define         _REENT_NETDB_FLG_STAYOPEN       0x0001
#endif

#ifdef _PROTOTYPES
#  ifdef __cplusplus
     extern "C" {
#  endif
	extern struct hostent *gethostbyname(const char *);
#  if defined(_INCLUDE_HPUX_SOURCE) 
	extern struct hostent *getipnodebyname(const char *, int, int, int *);
	extern struct hostent *getipnodebyaddr(const void *, size_t, int, int *);
        extern int getnameinfo(const struct sockaddr *, socklen_t, char *,size_t,
                       char *, size_t,  int);
	extern int getaddrinfo(const char *, const char *,
			 const struct addrinfo *, struct addrinfo **);
	extern void freeaddrinfo(struct addrinfo *);
	extern char *gai_strerror(int);
	extern void freehostent(struct hostent *);
#  endif /* _INCLUDE_HPUX_SOURCE */

#ifdef _XOPEN_SOURCE_EXTENDED
        extern struct hostent *gethostbyaddr(const void *, size_t, int);
        extern void sethostent(int);
        extern void endhostent(void);
#else
        extern struct hostent *gethostbyaddr(const char *, int, int);
        extern int sethostent(int);
        extern int endhostent(void);
#endif
	extern struct hostent *gethostent(void);
        extern struct netent *getnetbyname(const char *);

#ifdef _XOPEN_SOURCE_EXTENDED
        extern struct netent *getnetbyaddr(in_addr_t, int);
        extern void setnetent(int);
        extern void endnetent(void);
#else
        extern struct netent *getnetbyaddr(int, int);
        extern int setnetent(int);
        extern int endnetent(void);
#endif
        extern struct netent *getnetent(void);
        extern struct servent *getservbyname(const char *, const char *);
        extern struct servent *getservbyport(int, const char *);
        extern struct servent *getservent(void);

#ifdef _XOPEN_SOURCE_EXTENDED
        extern void setservent(int);
        extern void endservent(void);
#else
        extern int setservent(int);
        extern int endservent(void);
#endif

        extern struct protoent *getprotobyname(const char *);
        extern struct protoent *getprotobynumber(int);
        extern struct protoent *getprotoent(void);

#ifdef _XOPEN_SOURCE_EXTENDED
        extern void setprotoent(int);
        extern void endprotoent(void);
#else
        extern int setprotoent(int);
        extern int endprotoent(void);
#endif

#ifndef _XOPEN_SOURCE_EXTENDED
        extern struct rpcent *getrpcent(void);
        extern struct rpcent *getrpcbyname(const char *);
        extern struct rpcent *getrpcbynumber(int);
        extern int setrpcent(int);
        extern int endrpcent(void);
#endif /* !_XOPEN_SOURCE_EXTENDED */

#ifdef  _PTHREADS_DRAFT4 /* For DCE libd4r */
        extern int gethostbyname_r(const char *, struct hostent *,
                                               struct hostent_data *);
        extern int gethostbyaddr_r(const char *, int, int,
                                 struct hostent *, struct hostent_data *);
        extern int gethostent_r(struct hostent *, struct hostent_data *);
        extern int sethostent_r(int, struct hostent_data *);
        extern int endhostent_r(struct hostent_data *);
        extern int getnetbyname_r(const char *,
                                  struct netent *, struct netent_data *);
        extern int getnetbyaddr_r(int, int,
                                  struct netent *, struct netent_data *);
        extern int getnetent_r(struct netent *, struct netent_data *);
        extern int setnetent_r(int, struct netent_data *);
        extern int endnetent_r(struct netent_data *);
        extern int getservbyname_r(const char *, const char *,
                                  struct servent *, struct servent_data *);
        extern int getservbyport_r(int, const char *,
                                  struct servent *, struct servent_data *);
        extern int getservent_r(struct servent *, struct servent_data *);
        extern int setservent_r(int, struct servent_data *);
        extern int endservent_r(struct servent_data *);
        extern int getprotobyname_r(const char *,
                                  struct protoent *, struct protoent_data *);
        extern int getprotobynumber_r(int,
                                  struct protoent *, struct protoent_data *);
        extern int getprotoent_r(struct protoent *, struct protoent_data *);
        extern int setprotoent_r(int, struct protoent_data *);
        extern int endprotoent_r(struct protoent_data *);
        extern int getrpcent_r(struct rpcent *, struct rpcent_data *);
        extern int getrpcbyname_r(const char *, struct rpcent *,
                                        struct rpcent_data *);
        extern int getrpcbynumber_r(int, struct rpcent *,
                                        struct rpcent_data *);
        extern int setrpcent_r(int, struct rpcent_data *);
        extern int endrpcent_r(struct rpcent_data *);
#endif  /*_PTHREADS_DRAFT4 */

#  ifdef __cplusplus
     }
#  endif
#else /* not _PROTOTYPES */
        extern struct hostent *gethostbyname();
#  if defined(_INCLUDE_HPUX_SOURCE) 
        extern int getnameinfo();
	extern int getaddrinfo();
	extern void freeaddrinfo();
	extern char *gai_strerror();
	extern struct hostent *getipnodebyname();
	extern struct hostent *getipnodebyaddr();
	extern void freehostent();
#  endif /* _INCLUDE_HPUX_SOURCE */
	extern void herror ();
	extern char *hstrerror ();
	extern void sethostfile(); 
        extern struct hostent *gethostbyaddr();
        extern struct hostent *gethostent();
        extern int sethostent();
        extern int endhostent();
        extern struct netent *getnetbyname();
        extern struct netent *getnetbyaddr();
        extern struct netent *getnetent();
        extern int setnetent();
        extern int endnetent();
        extern struct servent *getservbyname();
        extern struct servent *getservbyport();
        extern struct servent *getservent();
        extern int setservent();
        extern int endservent();
        extern struct protoent *getprotobyname();
        extern struct protoent *getprotobynumber();
        extern struct protoent *getprotoent();
        extern int setprotoent();
        extern int endprotoent();
        extern struct rpcent *getrpcent();
        extern struct rpcent *getrpcbyname();
        extern struct rpcent *getrpcbynumber();
        extern int setrpcent();
        extern int endrpcent();



#ifdef  _PTHREADS_DRAFT4  /* For DCE libd4r */
        extern int gethostbyname_r();
        extern int gethostbyaddr_r();
        extern int gethostent_r();
        extern int sethostent_r();
        extern int endhostent_r();
        extern int getnetbyname_r();
        extern int getnetbyaddr_r();
        extern int getnetent_r();
        extern int setnetent_r();
        extern int endnetent_r();
        extern int getservbyname_r();
        extern int getservbyport_r();
        extern int getservent_r();
        extern int setservent_r();
        extern int endservent_r();
        extern int getprotobyname_r();
        extern int getprotobynumber_r();
        extern int getprotoent_r();
        extern int setprotoent_r();
        extern int endprotoent_r();
        extern int getrpcent_r();
        extern int getrpcbyname_r();
        extern int getrpcbynumber_r();
        extern int setrpcent_r();
        extern int endrpcent_r();
#endif  /*_PTHREADS_DRAFT4 */
#endif /* not _PROTOTYPES */

/*
 * Error return codes from gethostbyname() and gethostbyaddr()
 * (left in extern int h_errno).
 */

#define	h_NETDB_INTERNAL	-1	/* see errno */
#define	h_NETDB_SUCCESS	0	/* no problem */
#define	HOST_NOT_FOUND	1 /* Authoritative Answer Host not found */
#define	TRY_AGAIN	2 /* Non-Authoritive Host not found, or SERVERFAIL */
#define	NO_RECOVERY	3 /* Non recoverable errors, FORMERR, REFUSED, NOTIMP */
#define	NO_DATA		4 /* Valid name, no data record of requested type */
#define	NO_ADDRESS	NO_DATA		/* no address, look for MX record */

#endif /* _INCLUDE_XOPEN_SOURCE_EXTENDED */


#ifdef __cplusplus
extern "C" {
#endif
#ifndef h_ERRNO_KT_DEFINED
#define h_ERRNO_KT_DEFINED
#ifdef _REENTRANT
#ifdef _PROTOTYPES              /* 64 bit: add _PROTOTYPES */
extern int *__h_errno(void);    /* 64 bit: add _PROTOTYPES */
#else /* _PROTOTYPES */         /* 64 bit: add _PROTOTYPES */
extern int *__h_errno();
#endif /* _PROTOTYPES */        /* 64 bit: add _PROTOTYPES */
#define h_errno        (*__h_errno())
#else /* _REENTRANT */
extern int h_errno;
#endif /* REENTRANT */
#endif /* ! h_ERRNO_KT_DEFINED */
#ifdef __cplusplus
}
#endif /* cplusplus */

#endif /* !_NETDB_INCLUDE */
