#include "StdAfx.h"
#include "oleaccproxy.h"

extern "C" LRESULT _stdcall AccessibleObjectFromWindow(HWND hwnd, DWORD dwId, REFIID riid, void **ppvObject)
{
        COleaccProxy::Init();
        return COleaccProxy::m_pfnAccessibleObjectFromWindow ? COleaccProxy::m_pfnAccessibleObjectFromWindow(hwnd, dwId, riid, ppvObject) : 0;
}

extern "C" LRESULT _stdcall CreateStdAccessibleObject(HWND hwnd, LONG idObject, REFIID riid, void** ppvObject)
{
        COleaccProxy::Init();
        return COleaccProxy::m_pfnCreateStdAccessibleObject ? COleaccProxy::m_pfnCreateStdAccessibleObject(hwnd, idObject, riid, ppvObject) : 0;
}

extern "C" LRESULT _stdcall LresultFromObject(REFIID riid, WPARAM wParam, LPUNKNOWN punk)
{
        COleaccProxy::Init();
        return COleaccProxy::m_pfnLresultFromObject ? COleaccProxy::m_pfnLresultFromObject(riid, wParam, punk) : 0;
}

HMODULE COleaccProxy::m_hModule = NULL;
BOOL COleaccProxy::m_bFailed = FALSE;

pfnAccessibleObjectFromWindow COleaccProxy::m_pfnAccessibleObjectFromWindow = NULL;
pfnCreateStdAccessibleObject COleaccProxy::m_pfnCreateStdAccessibleObject = NULL;
pfnLresultFromObject COleaccProxy::m_pfnLresultFromObject = NULL;

COleaccProxy::COleaccProxy(void)
{
}

COleaccProxy::~COleaccProxy(void)
{
}

void COleaccProxy::Init(void)
{
        if (!m_hModule && !m_bFailed)
        {
                m_hModule = ::LoadLibrary(_T("oleacc.dll"));
                if (!m_hModule)
                {
                        m_bFailed = TRUE;
                        return;
                }

                m_pfnAccessibleObjectFromWindow = (pfnAccessibleObjectFromWindow)::GetProcAddress(m_hModule, _T("AccessibleObjectFromWindow"));
                m_pfnCreateStdAccessibleObject = (pfnCreateStdAccessibleObject)::GetProcAddress(m_hModule, _T("CreateStdAccessibleObject"));
                m_pfnLresultFromObject = (pfnLresultFromObject)::GetProcAddress(m_hModule, _T("LresultFromObject"));
        }
}
