// DlgTree.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgTree.h"
#include "DlgAccountAdd.h"

// Cuadro de dilogo de CDlgTree

IMPLEMENT_DYNAMIC(CDlgTree, CDialog)

CDlgTree::CDlgTree(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgTree::IDD, pParent)
{

}

CDlgTree::~CDlgTree()
{
}
BOOL CDlgTree::OnInitDialog()
{
        CDialog::OnInitDialog();
        pcashdlg->gridrefresh = FALSE;
        HkcTree.EnableWindow(FALSE);
        SetImgList();
        LoadTree();

        CRect Ancho;
        GetClientRect(Ancho);
        OnSize(SIZE_RESTORED, Ancho.Width(), Ancho.Height());
        return TRUE;
}
void CDlgTree::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_TREE, m_Tree);
        DDX_Control(pDX, IDC_HOTKEY1, HkcTree);
}

BEGIN_MESSAGE_MAP(CDlgTree, CDialog)
        ON_BN_CLICKED(IDC_ADDACCOUNT, OnBnClickedAddaccount)
        ON_BN_CLICKED(IDC_RENAMEACCOUNT, OnBnClickedRenameaccount)
        ON_BN_CLICKED(IDC_DELETE, OnBnClickedDelete)
        ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, OnTvnSelchangedTree)
        ON_WM_SIZE()
END_MESSAGE_MAP()



void CDlgTree::OnBnClickedAddaccount()
{
        CDlgAccountAdd dlg;
        dlg.db = db;
        Edit = FALSE;
        HTREEITEM Node = m_Tree.GetSelectedItem();
        if (Node == NULL)
                dlg.Name = "";
        else
                dlg.Name = m_Tree.GetItemText(Node);
        dlg.m_ptree = this;
        dlg.DoModal();
}
void CDlgTree::LoadTree()
{
        LoadNode(NULL);
}
void CDlgTree::LoadNode(HTREEITEM NodeParent)
{
        BOOL HasChild=FALSE;
        int parentid;

        if (NodeParent == NULL)
                parentid = 0;
        else
                parentid = m_Tree.GetItemData(NodeParent);

        CString strsql;
        strsql.Format("SELECT * FROM ACCOUNTS WHERE ID_PARENT = %d;", parentid);
        CppSQLite3Query q = db->execQuery(strsql);
        HTREEITEM NodeChild;
        while (!q.eof())
        {
                HasChild = TRUE;
                if (NodeParent == NULL)
                        NodeChild = m_Tree.InsertItem(q.getStringField("NAME"));
                else
                        NodeChild = m_Tree.InsertItem(q.getStringField("NAME"), NodeParent);                    
                m_Tree.SetItemData(NodeChild, q.getIntField("ID"));
                m_Tree.SetItemImage(NodeChild, 2,2);
                q.nextRow();
                LoadNode(NodeChild);            
                m_Tree.Expand(NodeChild,TVE_EXPAND);
        }
        q.finalize();

        if (HasChild && NodeParent != NULL)
                m_Tree.SetItemImage(NodeParent, 0,1);
        
}
void CDlgTree::OpAccount(CString Name, int Op /*0 is root, 1 is child*/, WORD Modifiers, WORD wVirtualKeyCode, CString strcur, int rplus, int rminus)
{
        CString strconv, strsql, stridcur;
        HTREEITEM Node = m_Tree.GetSelectedItem();

        CppSQLite3Query q = db->execQuery("SELECT * FROM CURRENCIES WHERE NAME = '" + strcur + "'");
        stridcur.Format("%d", q.getIntField("ID"));
        q.finalize();

        pcashdlg->gridrefresh = TRUE;
        if (Edit)
        {
                strconv.Format("%d", m_Tree.GetItemData(Node));
                strsql.Format("UPDATE ACCOUNTS SET NAME = '" + Name + "', SHORTCUT1=%d, SHORTCUT2=%d,RPLUS=%d,RMINUS=%d, ID_CUR=" + stridcur + " WHERE ID = " + strconv,Modifiers,wVirtualKeyCode,rplus,rminus);  
                db->execDML(strsql);
                
                m_Tree.SetItemText(Node, Name);
        }
        else
        {
                q = db->execQuery("SELECT MAX(ID) FROM ACCOUNTS");
                int maxid = q.getIntField(0);
                q.finalize();
                
                

                strconv.Format("%d", maxid + 1);
                if (!Op) //Root
                {
                        strsql.Format("INSERT INTO ACCOUNTS (ID_PARENT, ID, NAME, SHORTCUT1, SHORTCUT2,ID_CUR,RPLUS,RMINUS) VALUES (0," + strconv + ",'" + Name + "',%d,%d," + stridcur + ",%d,%d)", Modifiers, wVirtualKeyCode,rplus,rminus);
                        db->execDML(strsql);
                        HTREEITEM NodeChild = m_Tree.InsertItem(Name);
                        m_Tree.SetItemData(NodeChild, atoi(strconv));
                        m_Tree.SetItemImage(NodeChild, 2,2);
                }
                else
                {       
                        HTREEITEM Node = m_Tree.GetSelectedItem();
                        int idparent = m_Tree.GetItemData(Node);
                        m_Tree.SetItemImage(Node, 0,1);
                        CString strparent;
                        strparent.Format("%d", idparent);
                        strsql.Format("INSERT INTO ACCOUNTS (ID_PARENT, ID, NAME, SHORTCUT1, SHORTCUT2,ID_CUR,RPLUS,RMINUS) VALUES (" + strparent + "," + strconv + ",'" + Name + "',%d,%d," + stridcur + ",%d,%d)",Modifiers, wVirtualKeyCode,rplus,rminus);
                        db->execDML(strsql);
                        HTREEITEM NodeChild = m_Tree.InsertItem(Name, Node);
                        m_Tree.SetItemData(NodeChild, atoi(strconv));
                        m_Tree.SetItemImage(NodeChild, 2,2);
                        m_Tree.Expand(Node,TVE_EXPAND);
                }
        }
        pcashdlg->LoadKeys();
}
void CDlgTree::OnBnClickedRenameaccount()
{
        CString strid;
        HTREEITEM Node = m_Tree.GetSelectedItem();
        
        if (Node == NULL)
        {
                AfxMessageBox(LS(IDS_ACC_NO_SEL));      
        }
        else
        {
                DWORD idnode = m_Tree.GetItemData(Node);
                strid.Format("%d",idnode); 
                CppSQLite3Query q = db->execQuery("SELECT * FROM ACCOUNTS WHERE ID = " + strid);
                
                CDlgAccountAdd dlg;
                dlg.db = db;
                Edit = TRUE;
                dlg.NodeKey =idnode;
                dlg.Modifiers = q.getIntField("SHORTCUT1");
                dlg.wVirtualKeyCode = q.getIntField("SHORTCUT2");
                dlg.rplus = q.getIntField("RPLUS");
                dlg.rminus = q.getIntField("RMINUS");

                CppSQLite3Query q1 = db->execQuery("SELECT * FROM CURRENCIES WHERE ID = " + CString(q.getStringField("ID_CUR")));
                dlg.strcur = q1.getStringField("NAME");
                q1.finalize();

                q.finalize();
                dlg.m_ptree = this;
                dlg.Name = m_Tree.GetItemText(Node);
                dlg.DoModal();
        }
}

void CDlgTree::OnBnClickedDelete()
{
        CString stritem;
        HTREEITEM Node = m_Tree.GetSelectedItem();
        if (Node == NULL)
        {
                AfxMessageBox(LS(IDS_ROW_NOROW));       
                return;
        }
        if (AfxMessageBox(LS(IDS_ACC_DELETE_TREE), MB_YESNO) == IDNO)
                return;

        pcashdlg->gridrefresh = TRUE;

        stritem.Format("%d", m_Tree.GetItemData(Node));
        db->execDML("DELETE FROM ACCOUNTS WHERE ID = " + stritem);
        db->execDML("DELETE FROM CASHM WHERE ACCOUNT_FROM = " + stritem + " OR ACCOUNT_TO = " + stritem);
        
        if (m_Tree.ItemHasChildren(Node))
        {
                HTREEITEM hItem = m_Tree.GetChildItem(Node);
                while (hItem != NULL)
                {
                        stritem.Format("%d", m_Tree.GetItemData(hItem));
                        db->execDML("DELETE FROM ACCOUNTS WHERE ID = " + stritem);
                        db->execDML("DELETE FROM CASHM WHERE ACCOUNT_FROM = " + stritem + " OR ACCOUNT_TO = " + stritem);
                        hItem = m_Tree.GetNextSiblingItem(hItem);
                }
        }
        m_Tree.DeleteItem(Node);
}
void CDlgTree::SetImgList()
{
        CBitmap bmap;
        BITMAP bm;

        bmap.LoadBitmap(IDB_LIST);
        bmap.GetBitmap(&bm);
        m_pimagelist = new CImageList();
        if (m_pimagelist == NULL)
        {
                AfxMessageBox("Cannot initialize Image List: Not enough memory!");
                return;
        }
        m_pimagelist->Create(bm.bmWidth / 3, bm.bmHeight, ILC_COLORDDB|ILC_MASK, 2, 0);
        m_pimagelist->Add(&bmap, (COLORREF)RGB(255,255,255));
        bmap.DeleteObject();
        m_Tree.SetImageList(m_pimagelist, TVSIL_NORMAL);
}
void CDlgTree::OnTvnSelchangedTree(NMHDR *pNMHDR, LRESULT *pResult)
{
        LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
        HTREEITEM Node = m_Tree.GetSelectedItem();
        
        Citemkey* result = new Citemkey();
        if (Node != NULL)               
        {
                pcashdlg->SearchAccounts(result, m_Tree.GetItemData(Node));
                if (result)
                        HkcTree.SetHotKey(result->wVirtualKeyCode,result->Modifiers);
        }
        // TODO: Agregue aqu su cdigo de controlador de notificacin de control
        *pResult = 0;
}
void CDlgTree::OnSize(UINT nType, int cx, int cy)
{
        int shortcutw=70;

        if (cx <= 1 || cy <= 1 ) 
        return;
        if (!::IsWindow(m_Tree.m_hWnd))
                return;

        m_Tree.SetWindowPos(&wndTop, INTSEP,INTSEP , cx - INTSEP*2,cy - INTSEP * 3 - BHEIGHT, SWP_SHOWWINDOW);
        HkcTree.SetWindowPos(&wndTop, INTSEP,cy - INTSEP - BHEIGHT, shortcutw,THEIGHT, SWP_SHOWWINDOW);
        
        int lalign = INTSEP + shortcutw + INTSEP; 
        GetDlgItem(IDC_ADDACCOUNT)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);
        lalign+=BWIDTH+INTSEP;
        GetDlgItem(IDC_RENAMEACCOUNT)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);
        lalign+=BWIDTH+INTSEP;
        GetDlgItem(IDC_DELETE)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);

}
