// DlgStats.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgStats.h"
#include "XMLNodes.h"
// Cuadro de dilogo de CDlgStats

IMPLEMENT_DYNAMIC(CDlgStats, CDialog)

BOOL CDlgStats::OnInitDialog()
{
        CDialog::OnInitDialog();
        RefreshAccounts();
        ((CButton*)GetDlgItem(IDC_FTOTAL))->SetCheck(1);
        
        GridFormat();
        LoadCurs();
        return TRUE;
        //AfxMessageBox(lpszXML);
}
void CDlgStats::RefreshAccounts()
{
        CXMLNodes nodes;
        nodes.db = db;
        nodes.LoadAccountsXML();
        CboAccount.LoadString(nodes.lpszXML, IDB_LIST);
}
CDlgStats::CDlgStats(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgStats::IDD, pParent)
{

}

CDlgStats::~CDlgStats()
{
}
void CDlgStats::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_ACC, CboAccount);
        DDX_Control(pDX, IDC_FROM, EdtFrom);
        DDX_Control(pDX, IDC_TO, EdtTo);

        DDX_Control(pDX, IDC_GRID, m_Grid); 
        DDX_Control(pDX, IDC_CBOCUR, CboCurs); 
        
}


BEGIN_MESSAGE_MAP(CDlgStats, CDialog)
        ON_BN_CLICKED(IDADD, OnBnClickedAdd)
        ON_WM_SIZE()
END_MESSAGE_MAP()


// Controladores de mensajes de CDlgStats

void CDlgStats::OnBnClickedexit()
{
        OnCancel();
}
void CDlgStats::GridFormat()
{
        m_Grid.SetColumnCount(4);
        m_Grid.SetFixedRowCount(1);
        m_Grid.SetRowCount(2);
        m_Grid.EnableDragAndDrop(FALSE);
        m_Grid.SetEditable(FALSE);
        m_Grid.SetListMode(TRUE);
        m_Grid.SetSingleRowSelection(TRUE);
        m_Grid.SetFixedBkColor(RGB(100,130,209));
        m_Grid.GetDefaultCell(TRUE, FALSE)->SetTextClr(RGB(255,255,255));
        m_Grid.SetHeaderSort(TRUE);
        LOGFONT* fhead = m_Grid.GetDefaultCell(TRUE, FALSE)->GetFont();
        fhead->lfWeight = FW_BOLD;
        strcpy(fhead->lfFaceName,_T("Tahoma"));
        fhead->lfHeight = -11;
        m_Grid.GetDefaultCell(TRUE, FALSE)->SetFont(fhead);
        //Headers
        m_Grid.GetCell(0,0)->SetText(LS(IDS_STATS_GRID_DATES));
        m_Grid.GetCell(0,1)->SetText(LS(IDS_STATS_GRID_FROM));
        m_Grid.GetCell(0,2)->SetText(LS(IDS_STATS_GRID_TO));
        m_Grid.GetCell(0,3)->SetText(LS(IDS_STATS_GRID_TOTAL));
}
void CDlgStats::OnBnClickedAdd()
{
        CString AccError;
        AccError = GetAccError();
        if (AccError!= "")
        {
                AfxMessageBox(AccError);
                return;
        }
        CalcFactor();
        m_Grid.SetRedraw(FALSE);
        m_Grid.SetRowCount(1);
        AddItemGrid();
        SumGrid();
        m_Grid.SetRedraw(TRUE, TRUE);
}
void CDlgStats::CalcFactor()
{
        CString CurName;
        CboCurs.GetWindowTextA(CurName);
        CppSQLite3Query q = db->execQuery("SELECT * FROM CURRENCIES WHERE NAME = '" + CurName + "'");   
        factor = q.getFloatField("CONVERSION");
        q.finalize();
}
CString CDlgStats::getSQL()
{
        CString strdata, strfrom, strto;
        CString fromclause="", toclause="", strsql;
        
        InClause = "";
        CboAccount.GetWindowTextA(strdata);
        if (strdata!="")
        {
                CppSQLite3Query q = db->execQuery("SELECT ID FROM ACCOUNTS WHERE NAME = '" + strdata + "'");    
                int idacc = q.getIntField(0);
                q.finalize();
                
                InClause = " IN (";
                ProcessChilds(idacc);
                InClause = InClause.Left(InClause.GetLength() - 1) + ")";
                InClause = " AND (ACCOUNT_FROM " + InClause + " OR ACCOUNT_TO " + InClause + ")";
        }
        EdtFrom.GetWindowTextA(strfrom);
        EdtTo.GetWindowTextA(strto);
        strfrom = ::strconvdate(strfrom);
        strto = ::strconvdate(strto);
        
        if (strfrom != "")
                fromclause = " AND ID_DATE >= '" + strfrom + "'";
        
        if (strto != "")
                toclause = " AND ID_DATE <= '" + strto + "'";
        
        strsql = "SELECT * FROM CASHM WHERE 1=1 " + InClause + fromclause + toclause;
        return strsql;
}
CString CDlgStats::getGroupKey(CString strdate)
{
        if (((CButton*)GetDlgItem(IDC_FTOTAL))->GetCheck())
                return "";
        else if (((CButton*)GetDlgItem(IDC_FDAY))->GetCheck())
                return strdate;
        else if (((CButton*)GetDlgItem(IDC_FMONTH))->GetCheck())
                return strdate.Left(7);
        else if (((CButton*)GetDlgItem(IDC_FYEAR))->GetCheck())
                return strdate.Left(4);
        else
        {
                CString result;
                resultcounter++;
                result.Format("___%d", resultcounter);
                result = strdate + result;
                return result;
        }
}
void CDlgStats::AddItemGrid()
{
        CString groupkeyreg="", strsql;
        strsql = getSQL();
        CppSQLite3Query q = db->execQuery(strsql);
        Citemkey* resultfrom = new Citemkey();
        Citemkey* resultto = new Citemkey();
        resultcounter = 0;

        double fromsum=0, tosum=0, amount=0;
        int counter=0;

        while (!q.eof())
        {
                counter++;
                pdlgmain->SearchAccounts(resultfrom,q.getIntField("ACCOUNT_FROM"));
                pdlgmain->SearchAccounts(resultto,q.getIntField("ACCOUNT_TO"));

                groupkeyreg = getGroupKey(q.getStringField("ID_DATE"));

                amount = q.getFloatField("AMOUNT") * resultfrom->curconversion;

                if (InClause=="")
                {
                        if (resultfrom->RPlus)
                                tosum+=amount;
                        else if (resultto->RMinus)
                                fromsum+=amount;
                }
                else
                {
                        CString stracccfrom;
                        stracccfrom.Format("%d",resultfrom->Id);
                        if (InClause.Find(stracccfrom) >= 0)
                                fromsum += amount;
                        else
                                tosum += amount;
                }
                q.nextRow();
                if (q.eof())
                {
                        PrintGrid(fromsum,tosum,resultfrom,resultto,groupkeyreg);
                }
                else
                {
                        if (groupkeyreg != getGroupKey(q.getStringField("ID_DATE")))
                        {
                                PrintGrid(fromsum,tosum,resultfrom,resultto,groupkeyreg);
                                fromsum=0;
                                tosum=0;
                        }
                }
        }
        q.finalize();
        
//      AddGrid(strrange, strdata, valfrom, valto, FALSE);
        //strfrom = */

}
void CDlgStats::PrintGrid(double fromsum, double tosum, Citemkey* accfrom, Citemkey* accto, CString strgroup)
{
        int irow = m_Grid.GetRowCount();
        m_Grid.SetRowCount(irow + 1);
        CString strnum;

        if (strgroup=="") strgroup="TOTAL"; 
        if (strgroup.Find("__") >= 0)
                strgroup = strgroup.Left(10);
        
        fromsum /= factor;
        tosum /= factor;

        m_Grid.GetCell(irow,0)->SetText(strgroup);
        m_Grid.GetCell(irow,1)->SetText(NumberFormat(fromsum,2));
        m_Grid.GetCell(irow,2)->SetText(NumberFormat(tosum,2));
        m_Grid.GetCell(irow,3)->SetText(NumberFormat(tosum - fromsum,2));

        int format;
        for (int i=1;i<=m_Grid.GetColumnCount() - 1;i++)
        {
                format = m_Grid.GetCell(irow,i)->GetFormat();
                format+= DT_RIGHT;
                m_Grid.GetCell(irow,i)->SetFormat(format);
        }
}
void CDlgStats::SumGrid()
{
}
void CDlgStats::ProcessChilds(int idacc)
{
        //InClause.AppendFormat("%d,",idacc);
        CCashMDlg* pdlg;
        pdlg = (CCashMDlg*)pdlgmain;
        //for (int i=0;i<=pdlg->arraccounts.GetCount() - 1;i++)
        {
                //if (pdlg->arraccounts[i].IdParent == idacc)
                //        ProcessChilds(pdlg->arraccounts[i].Id);
        }
}
CString CDlgStats::GetAccError()
{
        CString strdata;
        EdtFrom.GetWindowTextA(strdata);
        if (strdata.GetLength() < 10 && strdata!="")
        {
                EdtFrom.SetFocus();
                return "The date from is not valid";
        }
        EdtTo.GetWindowTextA(strdata);
        if (strdata.GetLength() < 10 && strdata!="")
        {
                EdtTo.SetFocus();
                return "The date to is not valid";
        }
        return "";
}
void CDlgStats::OnSize(UINT nType, int cx, int cy)
{
        int datew=65, opcwith=50;
        if (cx <= 1 || cy <= 1 )
        return;
        if (!::IsWindow(m_Grid.m_hWnd))
                return;

        GetDlgItem(IDC_FRAME)->SetWindowPos(&wndTop, INTSEP, INTSEP, cx - 2*INTSEP,THEIGHT*2 + BHEIGHT + 4*INTSEP, SWP_SHOWWINDOW);
        GetDlgItem(IDC_LFROM)->SetWindowPos(&wndTop, INTSEP*2, INTSEP*3, 35,THEIGHT, SWP_SHOWWINDOW);
        int isep = INTSEP*2 + 35 + INTSEP;
        GetDlgItem(IDC_FROM)->SetWindowPos(&wndTop, isep, INTSEP*3, datew,THEIGHT, SWP_SHOWWINDOW);
        isep+=datew+INTSEP;
        GetDlgItem(IDC_LTO)->SetWindowPos(&wndTop, isep, INTSEP*3, 30,THEIGHT, SWP_SHOWWINDOW);
        isep+=30+INTSEP;
        GetDlgItem(IDC_TO)->SetWindowPos(&wndTop, isep, INTSEP*3, datew,THEIGHT, SWP_SHOWWINDOW);
        isep+=datew+INTSEP;
        GetDlgItem(IDC_LACC)->SetWindowPos(&wndTop, isep, INTSEP*3, 45,THEIGHT, SWP_SHOWWINDOW);
        isep+=45+INTSEP;
        
        CRect Accs;
        CboAccount.GetWindowRect(&Accs);
        CboAccount.SetWindowPos(&wndTop, isep, INTSEP*3, Accs.Width(),Accs.Height(), SWP_SHOWWINDOW);
        
        isep = INTSEP*2;
        GetDlgItem(IDC_FALL)->SetWindowPos(&wndTop, isep, INTSEP*4 + THEIGHT,opcwith,THEIGHT, SWP_SHOWWINDOW);
        isep+= INTSEP + opcwith;
        GetDlgItem(IDC_FDAY)->SetWindowPos(&wndTop, isep, INTSEP*4 + THEIGHT,opcwith,THEIGHT, SWP_SHOWWINDOW);
        isep+= INTSEP + opcwith;
        GetDlgItem(IDC_FMONTH)->SetWindowPos(&wndTop, isep, INTSEP*4 + THEIGHT,opcwith,THEIGHT, SWP_SHOWWINDOW);
        isep+= INTSEP + opcwith;
        GetDlgItem(IDC_FYEAR)->SetWindowPos(&wndTop, isep, INTSEP*4 + THEIGHT,opcwith,THEIGHT, SWP_SHOWWINDOW);
        isep+= INTSEP + opcwith;
        GetDlgItem(IDC_FTOTAL)->SetWindowPos(&wndTop, isep, INTSEP*4 + THEIGHT,opcwith,THEIGHT, SWP_SHOWWINDOW);

        isep = INTSEP*2;
        GetDlgItem(IDC_LCUR)->SetWindowPos(&wndTop, isep, INTSEP*6 + THEIGHT * 2,50,THEIGHT, SWP_SHOWWINDOW);
        isep+= INTSEP + 50;
        CboCurs.SetWindowPos(&wndTop, isep, INTSEP*6 + THEIGHT*2,135 ,THEIGHT, SWP_SHOWWINDOW);

        GetDlgItem(IDADD)->SetWindowPos(&wndTop, cx - INTSEP * 2 - 100, INTSEP*6 + THEIGHT * 2,100,THEIGHT, SWP_SHOWWINDOW);
        
        CRect FrameRect;
        GetDlgItem(IDC_FRAME)->GetWindowRect(&FrameRect);
        m_Grid.SetWindowPos(&wndTop, INTSEP, FrameRect.Height() + INTSEP * 2,cx - INTSEP * 2,cy - FrameRect.Height() - INTSEP*3, SWP_SHOWWINDOW);
}
void CDlgStats::LoadCurs()
{
        CString strname;
        CppSQLite3Query q = db->execQuery("SELECT * FROM CURRENCIES ORDER BY DEFAULT_CUR DESC");
        
        while (!q.eof())
        {
                CboCurs.AddString(q.getStringField("NAME"));
                q.nextRow();
        }
        if (CboCurs.GetCount() > 0)
                CboCurs.SetCurSel(0);
}