// DlgMain.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgMain.h"
#include "CashMDlg.h"
#include "DlgTree.h"
#include "DlgCurrencies.h"
#include "DlgStats.h"

// Cuadro de dilogo de CDlgMain

IMPLEMENT_DYNAMIC(CDlgMain, CDialog)

CDlgMain::CDlgMain(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgMain::IDD, pParent)
{
        m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

CDlgMain::~CDlgMain()
{
}

void CDlgMain::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_LIST_ID, LstOptions);
}


BEGIN_MESSAGE_MAP(CDlgMain, CDialog)

        ON_WM_PAINT()
        ON_WM_QUERYDRAGICON()

        ON_WM_SIZE()
        ON_WM_DESTROY()
        ON_WM_WINDOWPOSCHANGING()

        ON_LBN_SELCHANGE(IDC_LIST_ID, OnLbnSelchangeListId)
        ON_MESSAGE(WM_TRAY_NOTIFY, OnTrayNotify)
        ON_COMMAND(ID_TRAY_RESTORE, OnTrayRestore)
        ON_WM_SYSCOMMAND()
END_MESSAGE_MAP()

void CDlgMain::CreateImageList()
{
        BOOL    bRetValue = FALSE;
        HICON   hIcon = NULL;

        // Create image list
        bRetValue = m_ImageList.Create(32, 32, ILC_COLOR32 | ILC_MASK, 5, 1);
        ASSERT(bRetValue == TRUE);
        hIcon = AfxGetApp()->LoadIcon(IDI_TRANS);
        m_ImageList.Add(hIcon);
        hIcon = AfxGetApp()->LoadIcon(IDI_ACC);
        m_ImageList.Add(hIcon);
        hIcon = AfxGetApp()->LoadIcon(IDI_CUR);
        m_ImageList.Add(hIcon);
        hIcon = AfxGetApp()->LoadIcon(IDI_STATS);
        m_ImageList.Add(hIcon);
}

// Controladores de mensajes de CDlgMain

BOOL CDlgMain::OnInitDialog()
{
        CDialog::OnInitDialog();

        SetIcon(m_hIcon, TRUE);                 // Establecer icono grande
        SetIcon(m_hIcon, FALSE);                // Establecer icono pequeo
        PosBefore = -1;
        CreateImageList();
        this->SetWindowTextA(CString(MAKEINTRESOURCE(IDS_INIT_MAINTITLE)));
        LstOptions.SetImageList(&m_ImageList);
        
        //LstOptions.AddString("Transactions", 0);
        LstOptions.AddString(LS(IDS_INIT_TRANSAC), 0);
        LstOptions.AddString(LS(IDS_INIT_ACCOUNTS), 1);
        LstOptions.AddString(LS(IDS_INIT_CURRENCIES), 2);
        LstOptions.AddString(LS(IDS_INIT_STATS), 3);
        LstOptions.SelectString(-1, LS(IDS_INIT_TRANSAC));

        Dialogs[0] = new CCashMDlg;
        ((CCashMDlg*)Dialogs[0])->m_app = m_app;
        Dialogs[0]->Create(IDD_CASHM_DIALOG, this);

        Dialogs[1] = new CDlgTree;
        ((CDlgTree*)Dialogs[1])->db = &m_app->db;
        ((CDlgTree*)Dialogs[1])->pcashdlg = ((CCashMDlg*)Dialogs[0]);
        Dialogs[1]->Create(IDD_DLGTREE, this);

        Dialogs[2] = new CDlgCurrencies;
        ((CDlgCurrencies*)Dialogs[2])->db = &m_app->db;
        Dialogs[2]->Create(IDD_DLGCURRENCIES, this);

        Dialogs[3] = new CDlgStats;
        ((CDlgStats*)Dialogs[3])->db = &m_app->db;
        ((CDlgStats*)Dialogs[3])->pdlgmain= ((CCashMDlg*)Dialogs[0]);
        Dialogs[3]->Create(IDD_DLGSTATS, this);

        CRect Ancho;
        GetClientRect(Ancho);
        OnSize(SIZE_RESTORED, Ancho.Width(), Ancho.Height());

        Dialogs[0]->ShowWindow(SW_SHOW);

        for (int i=1;i<CDIAG;i++)
                Dialogs[i]->ShowWindow(SW_HIDE);
        OnHide();

        CString Cmd(GetCommandLineA());
        if (Cmd.Right(3) == "MIN")
                visible = FALSE;
        else
                visible = TRUE;
        
        return TRUE;
}
void CDlgMain::OnSize(UINT nType, int cx, int cy) 
{
        CRect BordePos;
        int lmargin=10, tmargin=10;

        if (cx <= WMIN || cy <= HMIN ) 
        return;
        if (!::IsWindow(LstOptions.m_hWnd))
                return;

        LstOptions.GetWindowRect(&BordePos);
        LstOptions.SetWindowPos(&wndTop, lmargin,tmargin, BordePos.Width(),cy - tmargin * 2, SWP_SHOWWINDOW);

        for (int i = 0;i<CDIAG ;i++)
        {
                Dialogs[i]->SetWindowPos(&wndTop, lmargin * 2 + BordePos.Width(), tmargin, cx - tmargin * 3 - BordePos.Width(), cy - tmargin * 2, SWP_SHOWWINDOW);
        }
        OnLbnSelchangeListId();
}
void CDlgMain::OnLbnSelchangeListId()
{
        int Pos = LstOptions.GetCurSel();
        for (int i=0;i<CDIAG;i++)
        {
                if (i==Pos)
                        Dialogs[i]->ShowWindow(SW_SHOW);
                else
                        Dialogs[i]->ShowWindow(SW_HIDE);
        }
        if (PosBefore == 1)
        {
                ((CCashMDlg*)Dialogs[0])->RefreshAccounts();
                if (((CCashMDlg*)Dialogs[0])->gridrefresh)
                        ((CDlgStats*)Dialogs[3])->RefreshAccounts();
                
        }
        if (PosBefore == 2)
        {
                if (((CDlgCurrencies*)Dialogs[2])->haschange)
                {
                        ((CCashMDlg*)Dialogs[0])->LoadKeys();
                        ((CDlgCurrencies*)Dialogs[2])->haschange = FALSE;
                }
        }
        if (PosBefore == 3)
                ((CDlgStats*)Dialogs[3])->CboAccount.HideDropDown();
        PosBefore = Pos;

}
LONG CDlgMain::OnTrayNotify ( WPARAM wParam, LPARAM lParam )
{
  switch (lParam)
  {
    case WM_RBUTTONDOWN:
    {
       CMenu menu ;
       // Load and Verify Menu
       VERIFY(menu.LoadMenu(IDR_TRAY));
       CMenu* pPopup = menu.GetSubMenu (0) ;
       ASSERT(pPopup != NULL);

       // Get the cursor position
       POINT pt ;
       GetCursorPos (&pt) ;

       // Fix Microsofts' BUG!!!!
       SetForegroundWindow();

       ///////////////////////////////////
       // Display The Menu
       pPopup->TrackPopupMenu(TPM_LEFTALIGN |
       TPM_RIGHTBUTTON,pt.x, pt.y, AfxGetMainWnd());
       break ;
    }
    case WM_LBUTTONDBLCLK:
       //////////////////////////////////
       // Unhide our Window
       if (m_bHidden)
           {
              visible = TRUE;
          ShowWindow (SW_SHOW);
                  CRect rectWindow;
                  GetWindowRect(&rectWindow);
                  SetWindowPos(&wndTopMost, rectWindow.left, rectWindow.top,
                  rectWindow.Width(), rectWindow.Height(), SWP_SHOWWINDOW); 
           }
       //OnUnHide() ;
       break ;
  }
  return (0) ;
}

void CDlgMain::OnDestroy() 
{
  CDialog::OnDestroy();

  // Remove Icon from Tray
  if (m_pTray)
  {
    delete m_pTray ;
    m_pTray = NULL ;
  } 
}

void CDlgMain::OnTrayRestore() 
{
  // UnHide Application
  if (m_bHidden)
  {
    visible = TRUE;
        ShowWindow (SW_SHOW) ;

    CRect rectWindow;
    GetWindowRect(&rectWindow);
    SetWindowPos(&wndTopMost, rectWindow.left, rectWindow.top,
      rectWindow.Width(), rectWindow.Height(), SWP_SHOWWINDOW); 

    //m_bHidden = FALSE ;
  }
}

void CDlgMain::OnHideapp() 
{
  //This will be the onclick for the hide button
  //in order to call that the app is minimised.
  theApp.HideApplication();

}
void CDlgMain::OnHide()
{
  // Load icon onto taskbar tray
  m_pTray = new CTrayNot (this,WM_TRAY_NOTIFY,
  NULL,theApp.m_pIconList);
  m_pTray->SetState(0);
  m_bHidden = TRUE;
}

void CDlgMain::OnUnHide()
{
  ShowWindow (SW_SHOW) ;
  CRect rectWindow;
    GetWindowRect(&rectWindow);
  SetWindowPos(&wndTopMost, rectWindow.left, rectWindow.top,
      rectWindow.Width(), rectWindow.Height(), SWP_SHOWWINDOW); 
  visible = TRUE;
  m_bHidden = FALSE ;
  /////////////////////////////////////
  // Remove icon from taskbar tray
  if (m_pTray)
  {
     delete m_pTray ;
     m_pTray = NULL ;
  }
}
void CDlgMain::OnSysCommand(UINT nID, LPARAM lParam)
{
        if ((nID & 0xFFF0) == SC_MINIMIZE)
                OnHideapp();            
        else
                CDialog::OnSysCommand(nID, lParam);     
}
void CDlgMain::OnPaint()
{
        if (IsIconic())
        {
                CPaintDC dc(this); // Contexto de dispositivo para dibujo

                SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

                // Centrar icono en el rectngulo de cliente
                int cxIcon = GetSystemMetrics(SM_CXICON);
                int cyIcon = GetSystemMetrics(SM_CYICON);
                CRect rect;
                GetClientRect(&rect);
                int x = (rect.Width() - cxIcon + 1) / 2;
                int y = (rect.Height() - cyIcon + 1) / 2;

                // Dibujar el icono
                dc.DrawIcon(x, y, m_hIcon);
        }
        else
        {
                CDialog::OnPaint();
        }
}

// El sistema llama a esta funcin para obtener el cursor que se muestra mientras el usuario arrastra
//  la ventana minimizada.
HCURSOR CDlgMain::OnQueryDragIcon()
{
        return static_cast<HCURSOR>(m_hIcon);
}
void CDlgMain::OnWindowPosChanging(WINDOWPOS FAR* lpwndpos) 
{
    if(!visible)
        lpwndpos->flags &= ~SWP_SHOWWINDOW;

    CDialog::OnWindowPosChanging(lpwndpos);
}
