// CDlgInfoAdd.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgInfoAdd.h"
#include "CashMDlg.h"
#include "XMLNodes.h"

// Cuadro de dilogo de CDlgInfoAdd

IMPLEMENT_DYNAMIC(CDlgInfoAdd, CDialog)

CDlgInfoAdd::CDlgInfoAdd(CWnd* pParent /*=NULL*/)
: CDialog(CDlgInfoAdd::IDD, pParent)
{
        pEdit = FALSE;
}

CDlgInfoAdd::~CDlgInfoAdd()
{
}
BOOL CDlgInfoAdd::OnInitDialog()
{
        CDialog::OnInitDialog();

        LoadKeys();
        LoadAccountsXML();
        if (pEdit)
                LoadFromTo();

        return TRUE;
        //AfxMessageBox(lpszXML);
}
void CDlgInfoAdd::LoadFromTo()
{
        if (pvarFrom !="")
        {
                CboFrom.FindItemByText(pvarFrom);
                CboFrom.GetEdit()->SetWindowTextA(pvarFrom);
        }
        if (pvarTo != "")
        {
                CboTo.FindItemByText(pvarTo);
                CboTo.GetEdit()->SetWindowTextA(pvarTo);
        }
        GetDlgItem(IDC_NAME)->SetWindowTextA(strdeconvdate(pvarDate));
        GetDlgItem(IDC_NAME2)->SetWindowTextA(pvarAmount);
        GetDlgItem(IDC_OBS)->SetWindowTextA(pvarObs);
}
void CDlgInfoAdd::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_NAME, EdtDate);
        DDX_Control(pDX, IDC_NAME2, EdtAmount);
        DDX_Control(pDX, IDC_ACCFROM, CboFrom);
        DDX_Control(pDX, IDC_ACCTO, CboTo);
}


BEGIN_MESSAGE_MAP(CDlgInfoAdd, CDialog)
        ON_BN_CLICKED(IDOK, OnBnClickedOK)
        ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
END_MESSAGE_MAP()

void CDlgInfoAdd::LoadAccountsXML()
{
        CXMLNodes nodes;
        nodes.db = db;
        
        nodes.LoadAccountsXML();
        
        CboFrom.LoadString(nodes.lpszXML, IDB_LIST);
        CboTo.LoadString(nodes.lpszXML, IDB_LIST);
}
int CDlgInfoAdd::OrderByShortCut(void* p1,void* p2)
{
        short n=0;
        Citemkey* a1 = (Citemkey*)p1;
        Citemkey* a2 = (Citemkey*)p2; 

        if(a1->Modifiers < a2->Modifiers)
                n=-1;
        else if(a1->Modifiers > a2->Modifiers)
                n=1;
        else if(a1->wVirtualKeyCode < a2->wVirtualKeyCode)
                n=-1;
        else if(a1->wVirtualKeyCode > a2->wVirtualKeyCode)
                n=1;

        return n;
}
BOOL CDlgInfoAdd::PreTranslateMessage(MSG* pMsg) 
{
        
        Citemkey* itemfind = new Citemkey();
        Citemkey* result = NULL;
        if (pMsg->message == WM_KEYDOWN)
        {
                itemfind->wVirtualKeyCode = pMsg->wParam;
                itemfind->Modifiers = 0;

                if (GetKeyState(VK_SHIFT)<0) itemfind->Modifiers+= HOTKEYF_SHIFT;
                if (GetKeyState(VK_CONTROL)<0) itemfind->Modifiers+= HOTKEYF_CONTROL;
                if (GetKeyState(VK_MENU)<0) itemfind->Modifiers+= HOTKEYF_ALT;
                
                result = (Citemkey*)bsearch(itemfind, (void*)&arrkeys[0], (size_t)arrkeys.GetSize(), 
                        sizeof(Citemkey), (int(*)(const void*,const void*))CDlgInfoAdd::OrderByShortCut);
                
                if (result != NULL)
                {
                        HWND csel = ::GetFocus();
                        int isel = ::GetDlgCtrlID(csel);
                
                        if (isel == IDC_TEXTCOMBO)
                        {
                                ::SetWindowTextA(csel,result->Name);
                        }
                }
        }
        return CDialog::PreTranslateMessage(pMsg);
}
void CDlgInfoAdd::LoadKeys()
{
        arrkeys.RemoveAll();
        CppSQLite3Query q = db->execQuery("SELECT * FROM ACCOUNTS ORDER BY SHORTCUT1, SHORTCUT2");      
        Citemkey item;
        while (!q.eof())
        {
                item.Id = q.getIntField("ID");
                item.Modifiers = q.getIntField("SHORTCUT1");
                item.wVirtualKeyCode = q.getIntField("SHORTCUT2");
                item.Name = q.getStringField("NAME");
                arrkeys.Add(item);
                q.nextRow();
        }
        q.finalize();
}
// Controladores de mensajes de CDlgInfoAdd
void CDlgInfoAdd::OnBnClickedOK()
{
        CString AccError;
        AccError = GetAccError();
        if (AccError!= "")
        {
                AfxMessageBox(AccError);
                return;
        }
        SaveInfo();
        pdlgmain->GetParent()->EnableWindow(TRUE);
        this->ShowWindow(SW_HIDE);
}
void CDlgInfoAdd::OnBnClickedCancel()
{
        pdlgmain->GetParent()->EnableWindow(TRUE);
        CboFrom.HideDropDown();
        CboTo.HideDropDown();
        this->ShowWindow(SW_HIDE);
}
void CDlgInfoAdd::EmptyForm()
{
        CString strdate;
        pvarFrom = "";
        pvarTo = "";
        CboFrom.FindItemByText("");
        CboTo.FindItemByText("");
        CboFrom.GetEdit()->SetWindowTextA("");
        CboTo.GetEdit()->SetWindowTextA("");

        SYSTEMTIME st;
        GetSystemTime(&st);
        CTime today(st);
        strdate.Format("%02d/%02d/%d", today.GetDay(), today.GetMonth(), today.GetYear());

        EdtDate.SetWindowTextA(strdate);
        EdtAmount.SetWindowTextA("");
        GetDlgItem(IDC_OBS)->SetWindowTextA("");
}
CString CDlgInfoAdd::GetAccError()
{
        CString strdata,strdata1;
        EdtDate.GetWindowTextA(strdata);
        if (strdata.GetLength() < 10)
        {
                EdtDate.SetFocus();
                return LS(IDS_INFO_DATE_VAL);
        }
        EdtAmount.GetWindowTextA(strdata);
        if (strdata.GetLength() == 0)
        {
                EdtAmount.SetFocus();
                return LS(IDS_INFO_NO_AMOUNT);
        }
        
        strdata.Format("%8.2f", EdtAmount.GetDouble());

        if (atof(strdata) == 0)
        {
                EdtAmount.SetFocus();
                return LS(IDS_INFO_AMOUNT_ZERO);
        }

        int fromstat=tnormal, tostat=tnormal;
        CppSQLite3Query q;

        CboFrom.GetWindowTextA(strdata);
        if (strdata.GetLength() == 0)
        {
                CboFrom.SetFocus();
                return LS(IDS_INFO_ACCOUNT_FROM);
        }
        q = db->execQuery("SELECT * FROM ACCOUNTS WHERE NAME = '" + strdata + "'");     
        if (q.getIntField("RPLUS"))
                fromstat = trplus;
        if (q.getIntField("RMINUS"))
                fromstat = trminus;
        q.finalize();

        CboTo.GetWindowTextA(strdata1);
        if (strdata1.GetLength() == 0)
        {
                CboTo.SetFocus();
                return LS(IDS_INFO_ACCOUNT_TO);
        }

        q = db->execQuery("SELECT * FROM ACCOUNTS WHERE NAME = '" + strdata1 + "'");    
        if (q.getIntField("RPLUS"))
                tostat = trplus;
        if (q.getIntField("RMINUS"))
                tostat = trminus;
        q.finalize();
        
        switch (fromstat)
        {
                case tnormal:
                        if (tostat==trplus)
                        {
                                CboTo.SetFocus();
                                return LS(IDS_INFO_DEST_RPLUS);
                        }
                        break;
                case trminus:
                        CboFrom.SetFocus();
                        return LS(IDS_INFO_SOURCE_RMINUS);
                case trplus:
                        if (tostat != tnormal)
                        {
                                CboTo.SetFocus();
                                return LS(IDS_INFO_DEST_NORMAL);
                        }
        }
        if (strdata1 == strdata)
        {
                CboTo.SetFocus();
                return LS(IDS_INFO_SAME_ACCOUNT);
        }
        
        return "";
}
void CDlgInfoAdd::SaveInfo()
{
        CString strdate, strfrom, strto, stramount, strobs, strid;
        CString idfrom, idto;
        double dvalue;

        EdtDate.GetWindowTextA(strdate);

        CboFrom.GetWindowTextA(strfrom);
        CboTo.GetWindowTextA(strto);

        stramount.Format("%8.2f", EdtAmount.GetDouble());
        
        GetDlgItem(IDC_OBS)->GetWindowTextA(strobs);
        CppSQLite3Query q;

        if (pEdit)
                strid = stridedit;
        else
        {
                q = db->execQuery("SELECT MAX(ID) FROM CASHM");
                int maxid = q.getIntField(0);
                q.finalize();
                strid.Format("%d", maxid + 1);
        }

        q = db->execQuery("SELECT ID FROM ACCOUNTS WHERE NAME = '" + strfrom + "'");    
        idfrom.Format("%d", q.getIntField(0));
        q.finalize();

        q = db->execQuery("SELECT ID FROM ACCOUNTS WHERE NAME = '" + strto + "'");      
        idto.Format("%d", q.getIntField(0));
        q.finalize();

        
        strdate = strconvdate(strdate);
        
        

        CString strsql;
        if (pEdit)
        {
        stramount.TrimLeft(stramount);
                strsql = "UPDATE CASHM SET ID_DATE = '" + strdate + "',ACCOUNT_FROM=" + idfrom + ",ACCOUNT_TO=" + idto
                + ",AMOUNT=" + stramount + ",OBS='" + strobs + "' WHERE ID = " + strid + ";";
        }
        else
        {
                strsql = "INSERT INTO CASHM (ID,ID_DATE,ACCOUNT_FROM,ACCOUNT_TO,AMOUNT,OBS) VALUES ("
                + strid + ",'" + strdate + "'," + idfrom + "," + idto + "," + stramount + ",'" + strobs + "')";
        }
        db->execDML(strsql);
        
        ((CCashMDlg*)pdlgmain)->GridAdd(strdate,strfrom,strto,NumberFormat(EdtAmount.GetDouble(),2),strobs,strid); 
}
void CDlgInfoAdd::InfoEdit(CString pDate, CString pFrom, CString pTo, CString Amount, CString Obs, CString id)
{
        pvarDate = pDate;
        pvarFrom = pFrom;
        pvarTo = pTo;
        pvarAmount = Amount;
        pvarObs = Obs;
        stridedit = id;
}