// DlgCurrencies.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgCurrencies.h"
#include "DlgCurAdd.h"


// Cuadro de dilogo de CDlgCurrencies

IMPLEMENT_DYNAMIC(CDlgCurrencies, CDialog)

CDlgCurrencies::CDlgCurrencies(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgCurrencies::IDD, pParent)
{

}

CDlgCurrencies::~CDlgCurrencies()
{
}

void CDlgCurrencies::DoDataExchange(CDataExchange* pDX)
{
        
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_GRID, m_Grid);
}


BEGIN_MESSAGE_MAP(CDlgCurrencies, CDialog)
        ON_BN_CLICKED(IDNEWCUR, OnBnClickedNewcur)
        ON_BN_CLICKED(IDEDITCUR, OnBnClickedEditcur)

        ON_NOTIFY(GVN_SELCHANGED, IDC_GRID, OnGridRowChange)
        ON_BN_CLICKED(IDDELETECUR, OnBnClickedDeletecur)
        ON_WM_SIZE()
END_MESSAGE_MAP()

BOOL CDlgCurrencies::OnInitDialog()
{
        CDialog::OnInitDialog();
        currow = 0;
        GridFormat();
        GridLoad();

        CRect Ancho;
        GetClientRect(Ancho);
        OnSize(SIZE_RESTORED, Ancho.Width(), Ancho.Height());

        return TRUE;
}
void CDlgCurrencies::GridLoad()
{
        m_Grid.SetRowCount(1);
        m_Grid.SetRedraw(FALSE,FALSE);
        CppSQLite3Query q = db->execQuery("SELECT * FROM CURRENCIES");
        
        while (!q.eof())
        {
                GridAdd(q.getStringField("NAME"),q.getStringField("ABR"),q.getIntField("DEFAULT_CUR"),q.getFloatField("CONVERSION"),q.getIntField("ID"));
                q.nextRow();
        }
        m_Grid.SetRedraw(TRUE,TRUE);
}
void CDlgCurrencies::GridFormat()
{
        m_Grid.SetColumnCount(5);
        m_Grid.SetFixedRowCount(1);
        m_Grid.EnableDragAndDrop(FALSE);
        m_Grid.SetEditable(FALSE);
        m_Grid.SetListMode(TRUE);
        m_Grid.SetSingleRowSelection(TRUE);
        m_Grid.SetFixedBkColor(RGB(100,130,209));
        m_Grid.GetDefaultCell(TRUE, FALSE)->SetTextClr(RGB(255,255,255));
        m_Grid.SetHeaderSort(TRUE);
        LOGFONT* fhead = m_Grid.GetDefaultCell(TRUE, FALSE)->GetFont();
        fhead->lfWeight = FW_BOLD;
        strcpy(fhead->lfFaceName,_T("Tahoma"));
        fhead->lfHeight = -11;
        m_Grid.GetDefaultCell(TRUE, FALSE)->SetFont(fhead);
        //Headers
        m_Grid.GetCell(0,0)->SetText(LS(IDS_CUR_GRID_NAME));
        m_Grid.GetCell(0,1)->SetText(LS(IDS_CUR_GRID_ABR));
        m_Grid.GetCell(0,2)->SetText(LS(IDS_CUR_GRID_DEFAULT));
        m_Grid.GetCell(0,3)->SetText(LS(IDS_CUR_GRID_CONV));
        m_Grid.GetCell(0,4)->SetText("ID");

        m_Grid.SetColumnWidth(4, 0);
        m_Grid.SetColumnWidth(0, 120);
}
// Controladores de mensajes de CDlgCurrencies
void CDlgCurrencies::GridAdd(CString Name, CString Abr, int isdefault, double conv, int id)
{
        CString strdata;
        int irowcount = m_Grid.GetRowCount();
        m_Grid.SetRowCount(irowcount + 1);

        m_Grid.GetCell(irowcount,0)->SetText(Name);
        m_Grid.GetCell(irowcount,1)->SetText(Abr);
        m_Grid.GetCell(irowcount,2)->SetText(isdefault?LS(IDS_CUR_GRID_YES):LS(IDS_CUR_GRID_NO));
        m_Grid.GetCell(irowcount,3)->SetText(NumberFormat(conv,4));
        strdata.Format("%d",id);
        m_Grid.GetCell(irowcount,4)->SetText(strdata);
}

void CDlgCurrencies::OnBnClickedNewcur()
{
        CDlgCurAdd dlgcuradd;
        dlgcuradd.iOper = 0;
        dlgcuradd.db = db;
        dlgcuradd.DoModal();
        GridLoad();
        haschange = TRUE;
}

void CDlgCurrencies::OnBnClickedEditcur()
{
        CDlgCurAdd dlgcuradd;

        if (currow <1)
        {
                AfxMessageBox(LS(IDS_ROW_NOROW));
                return;
        }

        dlgcuradd.iOper = 1;
        dlgcuradd.idcur = atoi(m_Grid.GetCell(currow,4)->GetText());
        dlgcuradd.db = db;
        dlgcuradd.DoModal();
        GridLoad();
        haschange = TRUE;
        // TODO: Agregue aqu su cdigo de controlador de notificacin de control
}
void CDlgCurrencies::OnGridRowChange(NMHDR *pNotifyStruct, LRESULT* /*pResult*/)
{
        NM_GRIDVIEW* pItem = (NM_GRIDVIEW*) pNotifyStruct;
        currow = pItem->iRow;
}
void CDlgCurrencies::OnBnClickedDeletecur()
{
        if (currow <1)
        {
                AfxMessageBox(LS(IDS_ROW_NOROW));
                return;
        }
        if (AfxMessageBox(LS(IDS_ROW_DELETE_ASK), MB_YESNO) == IDNO)
                return;

        db->execDML("DELETE FROM CURRENCIES WHERE ID = " + CString(m_Grid.GetCell(currow, 4)->GetText()) + ";");
        GridLoad();
        haschange = TRUE;
}
void CDlgCurrencies::OnSize(UINT nType, int cx, int cy)
{
        
        if (cx <= 1 || cy <= 1 )
        return;
        if (!::IsWindow(m_Grid.m_hWnd))
                return;

        m_Grid.SetWindowPos(&wndTop, INTSEP,INTSEP, cx - INTSEP*2,cy - INTSEP * 3 - BHEIGHT, SWP_SHOWWINDOW);

        int lalign = INTSEP; 
        GetDlgItem(IDNEWCUR)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);
        lalign+=BWIDTH+INTSEP;
        GetDlgItem(IDEDITCUR)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);
        lalign+=BWIDTH+INTSEP;
        GetDlgItem(IDDELETECUR)->SetWindowPos(&wndTop, lalign, cy - INTSEP - BHEIGHT, BWIDTH,BHEIGHT, SWP_SHOWWINDOW);

}