// DlgCurAdd.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgCurAdd.h"


// Cuadro de dilogo de CDlgCurAdd

IMPLEMENT_DYNAMIC(CDlgCurAdd, CDialog)

CDlgCurAdd::CDlgCurAdd(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgCurAdd::IDD, pParent)
{

}

CDlgCurAdd::~CDlgCurAdd()
{
}

void CDlgCurAdd::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_DEFAULT, ChkDefault);
        DDX_Control(pDX, IDC_CONV, EdtConv);
}


BEGIN_MESSAGE_MAP(CDlgCurAdd, CDialog)
        ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()

BOOL CDlgCurAdd::OnInitDialog()
{
        CString strdata, strsql;
        
        CDialog::OnInitDialog();
        EdtConv.SetMaxDecimalPlaces(4);

        if (iOper==1)
                this->SetWindowTextA(LS(IDS_CUR_TIT_EDIT));
        else
                this->SetWindowTextA(LS(IDS_CUR_TIT_NEW));

        if (iOper==1)
        {
                strsql.Format("SELECT * FROM CURRENCIES WHERE ID = %d",idcur);
                CppSQLite3Query q = db->execQuery(strsql);      
                GetDlgItem(IDC_NAME)->SetWindowTextA(q.getStringField("NAME"));
                GetDlgItem(IDC_ABR)->SetWindowTextA(q.getStringField("ABR"));
                ChkDefault.SetCheck(q.getIntField("DEFAULT_CUR"));
                //strdata.Format("%8.2f", q.getFloatField("CONVERSION"));
                EdtConv.SetDouble(q.getFloatField("CONVERSION"));
                //GetDlgItem(IDC_CONV)->SetWindowTextA(strdata);
        }
        return TRUE;
}
// Controladores de mensajes de CDlgCurAdd

void CDlgCurAdd::OnBnClickedOk()
{
        CString AccError;
        AccError = GetAccError();
        if (AccError!= "")
        {
                AfxMessageBox(AccError);
                return;
        }
        SaveInfo();
        OnOK();
}
void CDlgCurAdd::SaveInfo()
{
        CString strname, strabr, strdef, strconv, strsql;
        GetDlgItem(IDC_NAME)->GetWindowTextA(strname);
        GetDlgItem(IDC_ABR)->GetWindowTextA(strabr);
        
        EdtConv.GetWindowTextA(strconv);
        strdef.Format("%d",ChkDefault.GetCheck());
        
        strconv.Format("%8.4f",EdtConv.GetDouble());
        
        strsql.Format("UPDATE CURRENCIES SET NAME='" + strname + "', ABR='" + strabr + "',DEFAULT_CUR=" + strdef + ",CONVERSION=" + strconv + " WHERE ID = %d",idcur);
        if (iOper==1)
        {
                db->execDML(strsql);
        }
        else
        {
                CppSQLite3Query q = db->execQuery("SELECT MAX(ID) FROM CURRENCIES");
                int maxid = q.getIntField(0) + 1;
                q.finalize();
                strsql.Format("INSERT INTO CURRENCIES (ID,NAME,ABR,DEFAULT_CUR,CONVERSION) VALUES (%d,'" + strname + "','" + strabr + "'," + strdef + "," + strconv + ");",maxid);
                db->execDML(strsql);
        }
}
CString CDlgCurAdd::GetAccError()
{
        CString strdata, stredit="";

        if (iOper==1)
                stredit.Format(" AND ID != %d", idcur);

        GetDlgItem(IDC_NAME)->GetWindowTextA(strdata);
        if (strdata=="")
        {
                GetDlgItem(IDC_NAME)->SetFocus();
                return LS(IDS_CUR_VALID_EMPTY);
        }
        CppSQLite3Query q = db->execQuery("SELECT COUNT(*) FROM CURRENCIES WHERE NAME = '" + strdata + "'" + stredit);  
        if (q.getIntField(0) > 0)
        {
                GetDlgItem(IDC_NAME)->SetFocus();
                return LS(IDS_CUR_VALID_DUP);
        }

        GetDlgItem(IDC_ABR)->GetWindowTextA(strdata);
        if (strdata=="")
        {
                GetDlgItem(IDC_ABR)->SetFocus();
                return LS(IDS_CUR_VALID_ABR);
        }
        q = db->execQuery("SELECT COUNT(*) FROM CURRENCIES WHERE ABR = '" + strdata + "'" + stredit);   
        if (q.getIntField(0) > 0)
        {
                GetDlgItem(IDC_ABR)->SetFocus();
                return LS(IDS_CUR_VALID_ABR_DUP);
        }
        EdtConv.GetWindowTextA(strdata);
        if (strdata.GetLength() == 0)
        {
                EdtConv.SetFocus();
                return LS(IDS_CUR_VALID_CONV_EMPTY);
        }

        strdata.Format("%8.4f", EdtConv.GetDouble());

        if (atof(strdata) == 0)
        {
                EdtConv.SetFocus();
                return LS(IDS_CUR_VALID_CONV_ZERO);
        }
        if (ChkDefault.GetCheck() == 1)
        {
                q = db->execQuery("SELECT COUNT(*) FROM CURRENCIES WHERE DEFAULT_CUR = 1" + stredit);
                if (q.getIntField(0) > 0)
                {
                        ChkDefault.SetFocus();
                        return LS(IDS_CUR_VALID_DEFAULT_DUP);
                }

        }
        return "";
}