// DlgAccountAdd.cpp: archivo de implementacin
//

#include "stdafx.h"
#include "CashM.h"
#include "DlgAccountAdd.h"


// Cuadro de dilogo de CDlgAccountAdd

IMPLEMENT_DYNAMIC(CDlgAccountAdd, CDialog)

CDlgAccountAdd::CDlgAccountAdd(CWnd* pParent /*=NULL*/)
        : CDialog(CDlgAccountAdd::IDD, pParent)
{

}
BOOL CDlgAccountAdd::OnInitDialog()
{
        CDialog::OnInitDialog();
        LoadCurs();

        if (m_ptree->Edit)
        {
                GetDlgItem(IDC_NAME)->SetWindowTextA(Name);
                CboCurs.SetCurSel(CboCurs.FindString(0,strcur));
                HkcShortcut.SetHotKey(wVirtualKeyCode,Modifiers);
                BtnRMinus.SetCheck(rminus);
                BtnRPlus.SetCheck(rplus);
        }
        if (m_ptree->Edit)
                this->SetWindowTextA(LS(IDS_ACC_TIT_EDIT));
        else
                this->SetWindowTextA(LS(IDS_ACC_TIT_NEW));

        if (m_ptree->Edit || Name=="")
        {
                GetDlgItem(IDC_OTHER)->EnableWindow(FALSE);
                GetDlgItem(IDC_ROOT)->EnableWindow(FALSE);
        }
        if (Name=="")
                ((CButton*)GetDlgItem(IDC_ROOT))->SetCheck(1);
        else
        {
                GetDlgItem(IDC_OTHER)->SetWindowTextA(Name);
                ((CButton*)GetDlgItem(IDC_OTHER))->SetCheck(1);
        }
        return TRUE;
}
CDlgAccountAdd::~CDlgAccountAdd()
{
}
void CDlgAccountAdd::LoadCurs()
{
        CString strname;
        CppSQLite3Query q = db->execQuery("SELECT * FROM CURRENCIES ORDER BY DEFAULT_CUR DESC");
        
        while (!q.eof())
        {
                CboCurs.AddString(q.getStringField("NAME"));
                q.nextRow();
        }
        if (CboCurs.GetCount() > 0)
                CboCurs.SetCurSel(0);
}
void CDlgAccountAdd::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        DDX_Control(pDX, IDC_ACCHOTKEY, HkcShortcut);
        DDX_Control(pDX, IDC_CBOCUR, CboCurs);
        DDX_Control(pDX, IDC_RPLUS, BtnRPlus);
        DDX_Control(pDX, IDC_RMINUS, BtnRMinus);
}


BEGIN_MESSAGE_MAP(CDlgAccountAdd, CDialog)
        ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
        ON_BN_CLICKED(IDOK, OnBnClickedOk)
        ON_BN_CLICKED(IDC_RPLUS, OnBnClickedRplus)
        ON_BN_CLICKED(IDC_RMINUS, OnBnClickedRminus)
END_MESSAGE_MAP()

void CDlgAccountAdd::OnBnClickedCancel()
{
        OnCancel();
}

void CDlgAccountAdd::OnBnClickedOk()
{
        CString NodeName, AccError, strcur;
        GetDlgItem(IDC_NAME)->GetWindowTextA(NodeName);
        int check = ((CButton*)GetDlgItem(IDC_OTHER))->GetCheck();
        
        HkcShortcut.GetHotKey(wVirtualKeyCode, Modifiers);
        rminus = BtnRMinus.GetCheck();
        rplus = BtnRPlus.GetCheck();
                
        AccError = GetAccError();
        if (AccError!= "")
        {
                AfxMessageBox(AccError);
                return;
        }
        CboCurs.GetWindowTextA(strcur);
        m_ptree->OpAccount(NodeName, check,Modifiers, wVirtualKeyCode,strcur,rplus,rminus);
        OnOK();
}
CString CDlgAccountAdd::GetAccError()
{
        CString NodeName, strsql, stredit="";
        CppSQLite3Query q;
        GetDlgItem(IDC_NAME)->GetWindowTextA(NodeName);
        if (m_ptree->Edit)
                stredit.Format(" AND ID != %d", NodeKey);

        if (NodeName == "")
        {
                GetDlgItem(IDC_NAME)->SetFocus();
                return LS(IDS_ACC_VALID_ACCEMPTY);
        }
        q = db->execQuery("SELECT COUNT(*) FROM ACCOUNTS WHERE NAME = '" + NodeName + "'" + stredit);
        if (q.getIntField(0) > 0)
        {
                GetDlgItem(IDC_NAME)->SetFocus();
                q.finalize();
                return LS(IDS_ACC_VALID_DUP);
        }
        q.finalize();
        if (Modifiers!= 0 && wVirtualKeyCode!=0)
        {
                strsql.Format("SELECT COUNT(*) FROM ACCOUNTS WHERE SHORTCUT1 = %d AND SHORTCUT2 = %d" + stredit, Modifiers, wVirtualKeyCode);
                q = db->execQuery(strsql);
                if (q.getIntField(0) > 0)
                {       
                        HkcShortcut.SetFocus();
                        q.finalize();
                        return LS(IDS_ACC_VALID_SHORT);
                }
                q.finalize();
        }
        return "";
}

void CDlgAccountAdd::OnBnClickedRplus()
{
        if (BtnRPlus.GetCheck() == 1)
                BtnRMinus.SetCheck(0);
}

void CDlgAccountAdd::OnBnClickedRminus()
{
        if (BtnRMinus.GetCheck() == 1)
                BtnRPlus.SetCheck(0);
}
