
#pragma once

#define IDC_TEXTCOMBO                   1025

#include "ComboEdit.h"
#include "ComboTree.h"
#include "XmlDocument.h"

class CTreeComboBox : public CButton
{
        DECLARE_DYNAMIC(CTreeComboBox)

public:
        BOOL FindItemByText(CString strfind);
        CTreeComboBox()
        {
                m_pActiveCombo = NULL;
                m_parentWndProc = NULL;

                m_icon = NULL;
                m_multiline = FALSE;
                m_pressed = FALSE;
                m_sort = TRUE;
        }

        virtual ~CTreeComboBox()
        {
        }

        CComboEdit * GetEdit()
        {
                return &m_edit;
        }

        CComboTree * GetTree()
        {
                return &m_tree;
        }

        BOOL IsMultiline()
        {
                return m_multiline;
        }

        BOOL IsSortEnabled()
        {
                return m_sort;
        }

        BOOL EnableSort(BOOL sort=TRUE)
        {
                m_sort = sort;
        }

        void UpdateIcon(HICON icon)
        {
                if (icon!=m_icon)
                {
                        m_icon = icon;
                        Invalidate();
                }
        }



        void LoadXml(CString filename, int bmp);
        void LoadString(CString info, int bmp);
        
        void Accept();

        void ShowDropDown();
        void HideDropDown();

private:

        HICON m_icon;
        HTREEITEM GetNextTreeItem(HTREEITEM hItem);
        BOOL m_multiline;
        BOOL m_pressed;
        BOOL m_sort;
        CComboEdit m_edit;
        CFont m_font;
        CComboTree m_tree;

        CImageList m_imagelist;
        CXmlDocument m_xmlDocument;

        void SetText(CString str)
        {
                m_edit.SetWindowText(str);
                m_edit.UpdateTooltip();
        }

        CString GetText()
        {
                CString str;
                m_edit.GetWindowText(str);
                return str;
        }

                                
        static WNDPROC m_parentWndProc;

        static CTreeComboBox *m_pActiveCombo;

        void LoadXmlSubTree(CXmlElement *pElement, HTREEITEM hItem);
        void InterceptParentWndProc();
        void UnInterceptParentWndProc();


        static LRESULT CALLBACK ParentWindowProc(HWND hWnd, UINT nMsg, WPARAM wParam, LPARAM lParam);
        static BOOL IsMsgOK(HWND hWnd, UINT nMsg,/* WPARAM wParam,*/ LPARAM lParam);
        
protected:


//{{AFX_VIRTUAL(CTreeComboBox)
        public:
        virtual LRESULT WindowProc( UINT message, WPARAM wParam, LPARAM lParam );
        virtual void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );
        protected:
        virtual void PreSubclassWindow();
        //}}AFX_VIRTUAL

//{{AFX_MSG(CTreeComboBox)
        afx_msg void OnDestroy();
        afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
        afx_msg void OnKillFocus(CWnd* pNewWnd);
        afx_msg void OnSetFocus(CWnd* pOldWnd);
        afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
        afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
        //}}AFX_MSG

        DECLARE_MESSAGE_MAP()

};
