
#include "stdafx.h"
#include "ComboTree.h"
#include "TreeComboBox.h"



BEGIN_MESSAGE_MAP(CComboTree, CTreeCtrl)
        //{{AFX_MSG_MAP(CComboTree)
        ON_WM_LBUTTONDBLCLK()
        ON_WM_MOUSEMOVE()
        ON_WM_LBUTTONDOWN()
        ON_WM_KILLFOCUS()
        ON_WM_KEYDOWN()
        ON_NOTIFY_REFLECT(TVN_ITEMEXPANDED, OnItemexpanded)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CComboTree::OnMouseMove(UINT nFlags, CPoint point) 
{
        UINT flags ;
        HTREEITEM item = HitTest(point, &flags);
        if (item != NULL)
                CTreeCtrl::SelectItem(item);    
        CTreeCtrl::OnMouseMove(nFlags, point);
}

void CComboTree::OnLButtonDown(UINT nFlags, CPoint point) 
{
        if (m_pCombo!=NULL)
        {
                UINT flags;
                HitTest(point, &flags);
                if (flags!=TVHT_ONITEMBUTTON)
                {
                        HTREEITEM item = GetSelectedItem();
                        CString str = "";
                        if (!ItemHasChildren(item) || m_allowfolders)
                        {
                                ((CTreeComboBox*)m_pCombo)->Accept();
                                return;
                        }       
                }
        }       
        CTreeCtrl::OnLButtonDown(nFlags, point);
}

void CComboTree::OnKillFocus(CWnd* pNewWnd) 
{
        CTreeCtrl::OnKillFocus(pNewWnd);

        if (pNewWnd != ((CTreeComboBox*)m_pCombo)->GetEdit())
                ((CTreeComboBox*)m_pCombo)->HideDropDown();
                
}

void CComboTree::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
        if (nChar == VK_ESCAPE)
        {
                ((CTreeComboBox*)m_pCombo)->HideDropDown();
                return;
        }

        if (nChar == VK_RETURN)
        {
                ((CTreeComboBox*)m_pCombo)->Accept();
                return;
        }

        CTreeCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CComboTree::OnItemexpanded(NMHDR* pNMHDR, LRESULT* pResult) 
{
        NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

        int image = (pNMTreeView->itemNew.state&TVIS_EXPANDED)?1:0;
        SetItemImage(pNMTreeView->itemNew.hItem, image, image);
        
        *pResult = 0;
}
