


#include "stdafx.h"
#include "ComboEdit.h"
#include "TreeComboBox.h"


BEGIN_MESSAGE_MAP(CComboEdit, CEdit)
        //{{AFX_MSG_MAP(CComboEdit)
        ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
        ON_WM_MOUSEMOVE()
        ON_WM_CREATE()
        ON_WM_CHAR()
        ON_WM_KEYDOWN()
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CComboEdit::OnChange() 
{
        if (m_pCombo)
        {
                ((CTreeComboBox*)m_pCombo)->UpdateIcon(0);      
                UpdateTooltip();
                Refresh();
        }
}
void CComboEdit::Refresh()
{
        if (m_pCombo)
        {
                CString strfind;
                GetWindowTextA(strfind);
                ((CTreeComboBox*)m_pCombo)->FindItemByText(strfind);    
                UpdateTooltip();
        }
}



void CComboEdit::SelectText(BOOL multi, int pos)
{
        if (multi)
        {
                if (pos==-1)
                        SetSel(LineIndex(GetLineCount()-1),-1);
                else
                {
                        CString str;
                        GetWindowText(str);
                        int end = str.Find("\r\n",pos);
                        SetSel(pos,end);
                }
        }
        else
                SetSel(0,-1);
}


int CComboEdit::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
        if (CEdit::OnCreate(lpCreateStruct) == -1)
                return -1;
        
        m_tooltip.Create(this);
        m_tooltip.AddTool(this, "");
        m_tooltip.SetMaxTipWidth(500);
        m_tooltip.SetMargin(CRect(1,1,1,1));
        
        return 0;
}
void CComboEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
        return;
        //CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}
void CComboEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
        return;
}

BOOL CComboEdit::PreTranslateMessage(MSG* pMsg) 
{
        if (pMsg->message==WM_MOUSEMOVE)
        {
                if (((CTreeComboBox*)m_pCombo)->IsMultiline())
                {
                        m_tooltip.Activate(TRUE);
                        m_tooltip.RelayEvent(pMsg);             
                }
        }
        if (pMsg->message == WM_KEYDOWN ||
                pMsg->message == WM_LBUTTONDOWN)
                ((CTreeComboBox*)m_pCombo)->HideDropDown();


        if (pMsg->message == WM_SYSKEYDOWN && pMsg->wParam==VK_DOWN)
                ((CTreeComboBox*)m_pCombo)->ShowDropDown();

        if (pMsg->message == WM_KEYDOWN)
        {
                if (pMsg->wParam==VK_TAB)
                {
                        if (GetKeyState(VK_SHIFT)<0)
                                ((CDialog*)((CTreeComboBox*)m_pCombo)->GetParent())->PrevDlgCtrl();
                        else
                                ((CDialog*)((CTreeComboBox*)m_pCombo)->GetParent())->NextDlgCtrl();
                }
                else if (pMsg->wParam==VK_BACK)
                {
                        SetWindowTextA("");
                }


        }
        return CEdit::PreTranslateMessage(pMsg);
}

