
#pragma once

#ifndef __AFXWIN_H__
        #error "incluir 'stdafx.h' antes de incluir este archivo para PCH"
#endif

#include "resource.h"           // Smbolos principales
#include "../SQLite/CppSQLite3.h"  // Smbolos principales
#include "Utilities/DiskObject.h"

#define BWIDTH 100
#define BHEIGHT 32

#define THEIGHT 20
#define INTSEP 5

#define WMIN 400
#define HMIN 200

extern CString decimalsep;
extern CString dig3sep;

static CString strconvdate(CString strDate)
{
        CString strresult;
        if (strDate == "")
                return "";
        strresult = strDate.Right(4) + "-" + strDate.Mid(3,2) + "-" + strDate.Left(2);
        return strresult;
}
static CString strdeconvdate(CString strDate)
{
        CString strresult;
        if (strDate == "")
                return "";
        strresult = strDate.Right(2) + "-" + strDate.Mid(5,2) + "-" + strDate.Left(4);
        return strresult;
}

static CString NumberFormat(double num, int decimals)
{
        CString str,strdec;
        strdec.Format("%d",decimals);
        str.Format("%8." + strdec + "f",num);
        str.Replace(".",decimalsep);
        int lstr = str.GetLength();
        if (num >= 1000)
                str.Insert(lstr - 6,dig3sep); 
        if (num >= 1000000)
                str.Insert(lstr - 9,dig3sep);
        return str;
}

class CCashMApp : public CWinApp
{
public:
        CCashMApp();

        public:
        virtual BOOL InitInstance();
        CppSQLite3DB db;
        HICON m_pIconList[3];
        DECLARE_MESSAGE_MAP()
private:
        void OpenDatabase();
        CString GetAppPath();
        void LoadSeparators();
        
};

extern CCashMApp theApp;