// CashM.cpp : define los comportamientos de las clases para la aplicacin.
//

#include "stdafx.h"
#include "CashM.h"
#include "CashMDlg.h"
#include "DlgMain.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CCashMApp

BEGIN_MESSAGE_MAP(CCashMApp, CWinApp)
        ON_COMMAND(ID_HELP, OnHelp)
END_MESSAGE_MAP()

CString decimalsep;
CString dig3sep;

CString EncodeToUTF8(LPCTSTR szSource)
{
  WORD ch;

  BYTE bt1, bt2, bt3, bt4, bt5, bt6;

  int n, nMax = _tcslen(szSource);

  CString sFinal, sTemp;

  for (n = 0; n < nMax; ++n)
  {
    ch = (WORD)szSource[n];

    if (ch == _T('='))
    {
      sTemp.Format(_T("=%02X"), ch);

      sFinal += sTemp;
    }
    else if (ch < 128)
    {
      sFinal += szSource[n];
    }
    else if (ch <= 2047)
    {
       bt1 = (BYTE)(192 + (ch / 64));
       bt2 = (BYTE)(128 + (ch % 64));

      sTemp.Format(_T("=%02X=%02X"), bt1, bt2);
            
      sFinal += sTemp;
    }
    else if (ch <= 65535)
    {
       bt1 = (BYTE)(224 + (ch / 4096));
       bt2 = (BYTE)(128 + ((ch / 64) % 64));
       bt3 = (BYTE)(128 + (ch % 64));

      sTemp.Format(_T("=%02X=%02X=%02X"), bt1, bt2, bt3);
            
      sFinal += sTemp;
    }
    else if (ch <= 2097151)
    {
       bt1 = (BYTE)(240 + (ch / 262144));
       bt2 = (BYTE)(128 + ((ch / 4096) % 64));
       bt3 = (BYTE)(128 + ((ch / 64) % 64));
       bt4 = (BYTE)(128 + (ch % 64));

      sTemp.Format(_T("=%02X=%02X=%02X=%02X"), bt1, bt2, bt3, bt4);
      sFinal += sTemp;
    }
    else if (ch <=67108863)
    {
      bt1 = (BYTE)(248 + (ch / 16777216));
      bt2 = (BYTE)(128 + ((ch / 262144) % 64));
      bt3 = (BYTE)(128 + ((ch / 4096) % 64));
      bt4 = (BYTE)(128 + ((ch / 64) % 64));
      bt5 = (BYTE)(128 + (ch % 64));

      sTemp.Format(_T("=%02X=%02X=%02X=%02X=%02X"), bt1, bt2, bt3, bt4, bt5);
      sFinal += sTemp;
    }
    else if (ch <=2147483647)
    {
       bt1 = (BYTE)(252 + (ch / 1073741824));
       bt2 = (BYTE)(128 + ((ch / 16777216) % 64));
       bt3 = (BYTE)(128 + ((ch / 262144) % 64));
       bt4 = (BYTE)(128 + ((ch / 4096) % 64));
       bt5 = (BYTE)(128 + ((ch / 64) % 64));
       bt6 = (BYTE)(128 + (ch % 64));

      sTemp.Format(_T("=%02X=%02X=%02X=%02X=%02X=%02X"), 
                bt1, bt2, bt3, bt4, bt5, bt6);
      sFinal += sTemp;
    }

  }

  return sFinal;
}

CCashMApp::CCashMApp()
{
}

CCashMApp theApp;


BOOL CCashMApp::InitInstance()
{
        INITCOMMONCONTROLSEX InitCtrls;
        InitCtrls.dwSize = sizeof(InitCtrls);

        InitCtrls.dwICC = ICC_WIN95_CLASSES;
        InitCommonControlsEx(&InitCtrls);

        CWinApp::InitInstance();
        
        SetRegistryKey(_T("Aplicaciones generadas con el Asistente para aplicaciones local"));
        
        m_pIconList[0] = LoadIcon (MAKEINTRESOURCE(IDR_MAINFRAME));
        m_pIconList[1] = LoadIcon (MAKEINTRESOURCE(IDR_MAINFRAME));
        m_pIconList[2] = LoadIcon (MAKEINTRESOURCE(IDR_MAINFRAME));
        // Get the system's decimal point       
        LoadSeparators();

        OpenDatabase();

        //CCashMDlg dlg;
        CDlgMain dlg;
        dlg.m_app = this;
        m_pMainWnd = &dlg;

        INT_PTR nResponse = dlg.DoModal();
        if (nResponse == IDOK)
        {
        }
        else if (nResponse == IDCANCEL)
        {
        }
        return FALSE;
}
void CCashMApp::LoadSeparators()
{
        TCHAR m_cDecimalPoint;
        TCHAR m_cGroupSeparator;
        if (::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_SDECIMAL, NULL, 0))
                ::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_SDECIMAL, &m_cDecimalPoint, sizeof(m_cDecimalPoint));

        // Get the system's group separator
        if (::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, NULL, 0))
                ::GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, &m_cGroupSeparator, sizeof(m_cGroupSeparator));

        decimalsep = m_cDecimalPoint;
        dig3sep = m_cGroupSeparator;
}
void CCashMApp::OpenDatabase()
{
        CString strDir = GetAppPath();
        CString strNomdb = strDir + "CashM.db";
        CDiskObject testFile;

        if (!testFile.FileExists(strNomdb))
        {
                db.open(EncodeToUTF8(strNomdb));
                db.execDML("CREATE TABLE ACCOUNTS (ID_PARENT INTEGER, ID INTEGER PRIMARY KEY, NAME TEXT, SHORTCUT1 INTEGER, SHORTCUT2 INTEGER, ID_CUR INTEGER, RPLUS INTEGER, RMINUS INTEGER)");
                db.execDML("CREATE TABLE CASHM (ID INTEGER PRIMARY KEY, ID_DATE TEXT, ACCOUNT_FROM INTEGER, ACCOUNT_TO INTEGER, AMOUNT REAL, OBS TEXT)");
                db.execDML("CREATE TABLE CURRENCIES (ID INTEGER PRIMARY KEY, NAME TEXT, ABR TEXT, DEFAULT_CUR INTEGER, CONVERSION REAL)");
        }
        else
                db.open(strNomdb);
}
CString CCashMApp::GetAppPath()
{
        char temp[200];
        GetModuleFileName(AfxGetApp()->m_hInstance,temp,200);
        CString strDir = temp;
        strDir.TrimLeft();
        CString strApp = "CashM";
        strDir = strDir.Left(strDir.GetLength() - 4 - strApp.GetLength());
        return strDir;
}