// CashMDlg.h: archivo de encabezado
//

#pragma once
#include "Grid/GridCtrl.h"
#include "ItemKey.h"
#include "DlgInfoAdd.h"

class CCashMDlg : public CDialog
{
public:
        CCashMDlg(CWnd* pParent = NULL);

        enum { IDD = IDD_CASHM_DIALOG };

protected:
        virtual void DoDataExchange(CDataExchange* pDX);
        
protected:
        void OnBnClickedEdit();
        void LoadEditForm();
        int currow;
        HICON m_hIcon;
        CGridCtrl m_Grid;
        virtual BOOL OnInitDialog();
        afx_msg void OnPaint();

        void GridFormat();
        void GridLoad();

        CDlgInfoAdd dlginfoadd;
        BOOL InfoAddLoaded;
        
        static int OrderById(void* p1,void* p2);

        afx_msg HCURSOR OnQueryDragIcon();
        void OnGridRowChange(NMHDR *pNotifyStruct, LRESULT* /*pResult*/);
        void OnChangeFilter();
        BOOL PreTranslateMessage(MSG* pMsg);
        DECLARE_MESSAGE_MAP()
        void OnSize(UINT nType, int cx, int cy);
public:
        BOOL Refresh;
        void RefreshAccounts();
        CArray<Citemkey, Citemkey> arraccounts;
        BOOL gridrefresh;
        void LoadKeys();
        void GridAdd(CString date, CString from, CString to, CString amount, CString obs, CString id);
        CCashMApp* m_app;
        afx_msg void OnBnClickedNew();
        
        void SearchAccounts(Citemkey* item, int id);
public:
        afx_msg void OnBnClickedDelete();
public:
        afx_msg void OnBnClickedStats();
        afx_msg void OnBnClickedCurrencies();
};
