       01  WINDOWS-INITIALIZATION.
      *                         :---------------------------------------
      * ------------------------: This sets various ScreenIO runtime
      *                         : options in the Windows environment;
      *                         :
      *                         : It is also used on an INFO call to
      *                         : obtain current state information,
      *                         : which can be saved and used to restore
      *                         : the state of your ScreenIO application
      *                         : the next time it is fired up.
      *                         :---------------------------------------

           05  FILLER                       PIC S9(4) COMP-5 VALUE -1.

      * ------------------------: Name of your application's .INI file.
      *                         :
      *                         : If no .INI file is found, or if it
      *                         : contains no [ScreenIO] section,
      *                         : ScreenIO will initialize using the
      *                         : values in this copybook.
      *                         :
      *                         : NOTE:  You may specify a complete
      *                         : path to your .INI file.  If you
      *                         : specify only the filename, ScreenIO
      *                         : places it in the Windows directory.
      *                         :
      *                         : When you finish up and call ScreenIO
      *                         : with function 15 to close down,
      *                         : ScreenIO will save font, size, and
      *                         : location information in a [ScreenIO]
      *                         : section.  If the .INI file isn't found
      *                         : ScreenIO will create it for you.

           05  SCREENIO-INI-FILE            PIC X(255).

      * ------------------------: Returns ScreenIO handles
      *                         : to your application (needed if you
      *                         : call some Windows APIs directly in
      *                         : your application); ignored by
      *                         : ScreenIO at initialization time.

           05  SCREENIO-HWND-32             PIC 9(9) COMP-5.
           05  FILLER REDEFINES SCREENIO-HWND-32.
             10  SCREENIO-HWND-16           PIC 9(4) COMP-5.
             10  FILLER                     PIC XX.

           05  SCREENIO-HINST-32            PIC 9(9) COMP-5.
           05  FILLER REDEFINES SCREENIO-HINST-32.
             10  SCREENIO-HINST-16          PIC 9(4) COMP-5.
             10  FILLER                     PIC XX.

      * ------------------------: Displayed in your application's title

           05  SCREENIO-TITLE               PIC X(255).

      * ------------------------: Windows About box contents

           05  SCREENIO-ABOUT-TITLE         PIC X(255).
           05  SCREENIO-ABOUT-TEXT          PIC X(255).

      * ------------------------: ScreenIO Windows options:

           05  SCREENIO-OPTIONS.
      *
      * ------------------------: Font Definition.  This is documented
      *                         : in the Windows SDK, but the easiest
      *                         : way is to select the font you like
      *                         : within your ScreenIO application,
      *                         : make a ScreenIO function 17 call
      *                         : to obtain this data, then save it.
      *
             10  SCREENIO-FONT.
               15  SF-HEIGHT                PIC S9(4) COMP-5 VALUE  16.
               15  SF-WIDTH                 PIC S9(4) COMP-5 VALUE   0.
               15  SF-ESCAPEMENT            PIC S9(4) COMP-5 VALUE   0.
               15  SF-ORIENTATION           PIC S9(4) COMP-5 VALUE   0.
               15  SF-WEIGHT                PIC S9(4) COMP-5 VALUE  40.
               15  SF-ITALIC                PIC X.
               15  SF-UNDERLINE             PIC X.
               15  SF-STRIKEOUT             PIC X.
               15  SF-CHARSET               PIC X VALUE X'FF'.
               15  SF-OUTPRECISION          PIC X VALUE X'01'.
               15  SF-CLIPPRECISION         PIC X VALUE X'02'.
               15  SF-QUALITY               PIC X VALUE X'01'.
               15  SF-PITCHANDFAMILY        PIC X VALUE X'31'.
               15  SF-FACENAME              PIC X(32)
                                          VALUE 'New Courier'.
      *        15  SF-FACENAME              PIC X(32)
      *                                     VALUE 'Terminal' & x'00'.
             10  FILLER                     PIC X(32).

      * ------------------------: Menu translation;
      *                         :   WIN translates them to Windows menu
      *                         : NOWIN does not; but default menu remai

             10  SCREENIO-OPTIONS-MENU      PIC X VALUE '0'.
               88  SCREENIO-MENU-WIN        VALUE '0'.
               88  SCREENIO-MENU-NOWIN      VALUE '1'.
               88  SCREENIO-MENU-NOMENU     VALUE '2'.

      * ------------------------: ALT- key handling;
      *                         :   WIN is Windows conventions
      *                         : NOWIN is DOS convention (ALT- key
      *                         :       combinations are trapped by
      *                         :       ScreenIO).

             10  SCREENIO-OPTIONS-ALT       PIC X VALUE '1'.
               88  SCREENIO-ALT-WIN         VALUE '0'.
               88  SCREENIO-ALT-NOWIN       VALUE '1'.

      * ------------------------: SYSMENU
      *                         : (X box in upper right and box in
      *                         :  upper left with Move/Size/Minimize/
      *                         :  Maximize/Close options)
      *                         :
      *                         :    ON enables system menu.
      *                         :   OFF disables system menu.
      *                         :
      *                         : See also SCREENIO-CLOSE-VALUE below

             10  SCREENIO-SYSMENU           PIC X VALUE '0'.
               88  SCREENIO-SYSMENU-ON      VALUE '0'.
               88  SCREENIO-SYSMENU-OFF     VALUE '1'.

      * ------------------------: PANEL-EXIT-KEY value ScreenIO returns
      *                         : when user selects FILE/EXIT or CLOSE
      *                         :
      *                         : Note: If left 0, the system menu CLOSE
      *                         : options will be grayed and disabled,
      *                         : and may be enabled on a panel-by-panel
      *                         : basis...
      *                         :
      *                         : If set to, say, 79 (END-key), then
      *                         : ScreenIO will ALWAYS return 79 to you
      *                         : if the user attempts to close your
      *                         : application (systemwide).  If your
      *                         : program calls ScreenIO dynamically,
      *                         : you could handle this in your SCRNIO.

             10  SCREENIO-CLOSE-VALUE       PIC S9(4) COMP-5 VALUE 0.

      * ------------------------: Status bar (32-bit only)
      *                         : Shows states of NumLock, CapsLock,
      *                         : and Insert mode, if enabled;

             10  SCREENIO-STATUS-NUMLOCK    PIC X VALUE 'Y'.
             10  SCREENIO-STATUS-CAPLOCK    PIC X VALUE 'Y'.
             10  SCREENIO-STATUS-INSERT     PIC X VALUE 'Y'.

      * ------------------------: Location of upper left window corner
      *                         : expressed as window coordinates/pixels

             10  SCREENIO-ORIGIN.
               15  ORIGIN-X                 PIC S9(4) COMP-5 VALUE 20.
               15  ORIGIN-Y                 PIC S9(4) COMP-5 VALUE 20.

      * ------------------------: Size of your application's window
      *                         : expressed as window coordinates/pixels

             10  SCREENIO-NORMAL-SIZE.
               15  SIZE-X                   PIC S9(4) COMP-5 VALUE 9999.
               15  SIZE-Y                   PIC S9(4) COMP-5 VALUE 9999.

             10  FILLER                     PIC X(49).

      * ------------------------: Allow/disallow multiple instances of
      *                         : your application to run on a single
      *                         : computer.

             10  SCREENIO-INSTANCES         PIC X VALUE 'Y'.
               88  MULTIPLE-INSTANCES-NO    VALUE 'N'.
               88  MULTIPLE-INSTANCES-YES   VALUE 'Y'.

      * ------------------------: Mouse parameters
      *                         :
      *                         : Action returned on left button
      *                         : double-click if no other action is
      *                         : defined for the location (menu or
      *                         : selector field); default is Enter
      *                         : (value 13).

             10  SCREENIO-MB1-DOUBLE.
               15  SCREENIO-MB1DBL-CHAR     PIC S9(4) COMP-5 VALUE 13.
               15  SCREENIO-MB1DBL-FUNC     PIC S9(4) COMP-5 VALUE 0.
      *
      * ------------------------: Mouse action in selector/pointer flds
      *                         : when button is released
      *                         :  0 = No action
      *                         :  1 = Simulate Enter key
      *
             10  SCREENIO-MB1-SELECTOR      PIC 9 VALUE 1.
      *
      * ------------------------: Translate mouse actions to arrow keys
      *                         : if button 1 is held down (dragging).
      *                         :
      *                         : Note:  Generally useful only if an
      *                         :        arrow key exit is active, as
      *                         :        for drawing or painting...
      *
             10  SCREENIO-MB-ARROW-KEYS     PIC X VALUE 'N'.
               88  MB1-ARROW-ON             VALUE 'Y'.
               88  MB1-ARROW-OFF            VALUE 'N'.
      *
      * ------------------------: Keystroke simulated if you release
      *                         : button 1 while in the ScreenIO menu
      *                         : line, but didn't hit a menu item.
      *                         : This could invoke a HELP key...
      *
             10  SCREENIO-MB1-MISSED-CHAR   PIC S9(4) COMP-5 VALUE 0.
             10  SCREENIO-MB1-MISSED-FUNC   PIC S9(4) COMP-5 VALUE 0.
      *
      * ------------------------: Action of caret when you mouse to
      *                         : a new field; normally, position the
      *                         : caret to the first position, then
      *                         : match to mouse cursor if there's
      *                         : another mouse action.  Other option
      *                         : immediately matches caret to mouse
      *                         : position (automatic if MB1-ARROW-ON).
      *
             10  SCREENIO-MB1-FIELD-OPTION  PIC X VALUE LOW-VALUE.
               88  MB1-SIMULATE-TAB         VALUE LOW-VALUE.
               88  MB1-MATCH-MOUSE          VALUE X'01'.
      *
      * ------------------------: Keystroke simulated if left button
      *                         : is released when NOT in a field.
      *
             10  SCREENIO-MB1-NO-FIELD-CHAR PIC S9(4) COMP-5 VALUE 0.
             10  SCREENIO-MB1-NO-FIELD-FUNC PIC S9(4) COMP-5 VALUE 0.
      *
      * ------------------------: Value returned on Right button
      *                         : double-click.
      *
             10  SCREENIO-MB2-DOUBLE-CHAR   PIC S9(4) COMP-5 VALUE 0.
             10  SCREENIO-MB2-DOUBLE-FUNC   PIC S9(4) COMP-5 VALUE 0.
      *
      * ------------------------: Value returned on Right button
      *                         : release.  Could be used to
      *                         : display context-sensitive menu.
      *
             10  SCREENIO-MB2-RELEASE-CHAR  PIC S9(4) COMP-5 VALUE 0.
             10  SCREENIO-MB2-RELEASE-FUNC  PIC S9(4) COMP-5 VALUE 0.

      * ------------------------: Reserved for future use...

             10  FILLER                     PIC X(666).
