package com.microfocus.book;

import javax.servlet.http.HttpSession;

import com.microfocus.cobol.program.IObjectControl;
import com.microfocus.cobol.runtimeservices.IRunUnit;
import com.microfocus.cobol.runtimeservices.servlet.ServletRunUnitManager;

public class BookInterface
{
  public static final String READ_RECORD = "1";
  public static final String ADD_RECORD = "2";
  public static final String DELETE_RECORD = "3";
  public static final String NEXT_RECORD = "4";

  public final IRunUnit runUnit;
  public final BookLegacy bookLegacy;

  public BookInterface(HttpSession session)
  {
    this(ServletRunUnitManager.getManager().GetSessionRunUnit(session));
  }

  public BookInterface(IRunUnit runUnit)
  {
    this.runUnit = runUnit;
    BookLegacy bookLegacy = (BookLegacy) runUnit.GetInstance(BookLegacy.class);

    if (bookLegacy == null)
    {
      bookLegacy = new BookLegacy();
      runUnit.Add(bookLegacy);
    }

    this.bookLegacy = bookLegacy;
  }

  public BookBean readBook(String stockNo) throws JavaBookException
  {
    Details details = getObject(Details.class);
    FileStatus status = getObject(FileStatus.class);

    details.setStockno(stockNo);
    bookLegacy.BookLegacy(READ_RECORD, details, status);

    throwExceptionIfError(status);

    return BookBean.fromDetails(details);
  }

  public BookBean addBook(BookBean book) throws JavaBookException
  {
    Details details = getObject(Details.class);
    FileStatus status = getObject(FileStatus.class);

    book.toDetails(details);
    bookLegacy.BookLegacy(ADD_RECORD, details, status);

    throwExceptionIfError(status);

    return BookBean.fromDetails(details);
  }

  public BookBean deleteBook(String stockNo) throws JavaBookException
  {
    Details details = getObject(Details.class);
    FileStatus status = getObject(FileStatus.class);

    details.setStockno(stockNo);
    bookLegacy.BookLegacy(DELETE_RECORD, details, status);

    throwExceptionIfError(status);

    return BookBean.fromDetails(details);
  }

  public BookBean nextBook(String stockNo) throws JavaBookException
  {
    Details details = getObject(Details.class);
    FileStatus status = getObject(FileStatus.class);

    details.setStockno(stockNo);
    bookLegacy.BookLegacy(NEXT_RECORD, details, status);

    throwExceptionIfError(status);

    return BookBean.fromDetails(details);
  }

  public void setFileName(String filename)
  {
    bookLegacy.SET_FILENAME(getFilenameObject(filename));
  }

  private static void throwExceptionIfError(FileStatus statusCode)
      throws JavaBookException
  {
    throwExceptionIfError(statusCode.getFileStatus().trim());
  }

  private static void throwExceptionIfError(String statusCode)
      throws JavaBookException
  {
    if (!"00".equals(statusCode) && !"02".equals(statusCode))
    {
      throw new JavaBookException(statusCode);
    }
  }

  private Filename getFilenameObject(String filename)
  {
    Filename output = getObject(Filename.class);

    output.setFilename(filename);

    return output;
  }

  private <T extends IObjectControl> T getObject(Class<T> cls)
  {
    try
    {
      T output = cls.newInstance();
      runUnit.Add(output);

      return output;
    } catch (Throwable t)
    {
      throw new RuntimeException(t);
    }
  }
}
