package com.microfocus.book;

import com.microfocus.cobol.program.ScaledInteger;

public class BookBean
{
  private final String _stockno;
  private final String _isbn;
  private final String _title;
  private final String _author;
  private final String _type;
  private final String _price;
  private final String _onhand;
  private final String _sold;
  private final String _stockval;

  BookBean(String stockno, String isbn, String title, String author,
      String type, String price, String onhand, String sold, String stockval)
  {
    this._stockno = stockno;
    this._isbn = isbn;
    this._title = title;
    this._author = author;
    this._type = type;
    this._price = price;
    this._onhand = onhand;
    this._sold = sold;
    this._stockval = stockval;
  }

  public String getStockno()
  {
    return _stockno;
  }

  public String getIsbn()
  {
    return _isbn;
  }

  public String getTitle()
  {
    return _title;
  }

  public String getAuthor()
  {
    return _author;
  }

  public String getType()
  {
    return _type;
  }

  public String getPrice()
  {
    return _price;
  }

  public String getOnhand()
  {
    return _onhand;
  }

  public String getSold()
  {
    return _sold;
  }

  public String getStockval()
  {
    return _stockval;
  }

  public void toDetails(Details details)
  {
    details.setStockno(_stockno);
    details.setIsbn(Long.parseLong(_isbn));
    details.setTitle(_title);
    details.setAuthor(_author);
    details.setType(_type);
    details.setRetail(ScaledInteger.parseScaledInteger(_price));

    int onHandInt = Integer.parseInt(_onhand);
    if (onHandInt < 0)
      throw new RuntimeException(
          "The number of books on hand must be 0 or positive");
    details.setOnhand(onHandInt);

    int soldInt = Integer.parseInt(_sold);
    if (soldInt < 0)
      throw new RuntimeException(
          "The number of books sold must be 0 or positive");
    details.setSold(soldInt);
  }

  public static BookBean fromDetails(Details details)
  {
    String stockno = details.getStockno().trim();
    String isbn = "" + details.getIsbn();
    String title = details.getTitle().trim();
    String author = details.getAuthor().trim();
    String type = details.getType().trim();
    String price = details.getRetail().toString();
    String onhand = "" + details.getOnhand();
    String sold = "" + details.getSold();
    ScaledInteger stockvalInt = details.getRetail().multiply(
        new ScaledInteger(details.getOnhand(), 0));
    String stockval = stockvalInt.toString();

    return new BookBean(stockno, isbn, title, author, type, price, onhand,
        sold, stockval);
  }

  public static BookBean blankBook()
  {
    return msgBook("*************************************");
  }

  public static BookBean msgBook(String msg)
  {
    String stockno = "****";
    String isbn = "*************";
    String title = msg;
    String author = "*************************************";
    String type = "****";
    String price = "****";
    String onhand = "****";
    String sold = "****";
    String stockval = "****";

    return new BookBean(stockno, isbn, title, author, type, price, onhand,
        sold, stockval);
  }
}
