       IDENTIFICATION DIVISION.
       PROGRAM-ID.  HTTPPOST-JSON.

      * COPYRIGHT (C) 2021 MICRO FOCUS. ALL RIGHTS RESERVED.
      *
      * THIS SAMPLE CODE IS SUPPLIED FOR DEMONSTRATION PURPOSES ONLY
      * ON AN "AS IS" BASIS AND IS FOR USE AT YOUR OWN RISK.

       DATA DIVISION.
       WORKING-STORAGE SECTION.
       COPY "acucobol.def".

       01  REQUEST-PAYLOAD             USAGE POINTER.
       01  REQUEST-LEN                 PIC S9(6) VALUE ZERO.
       01  RESPONSE-PAYLOAD            USAGE POINTER.
       01  RESPONSE-LEN                PIC S9(6) VALUE ZERO.
       01  RESPONSE-STATUS             PIC 9(3) VALUE ZERO.
       01  SSL-VERIFYPEER-FLAG         PIC 9 VALUE 0.
       01  STATUS-CODE                 PIC 9(3) VALUE ZERO.
       01  MESSAGE-DATA                PIC X(64) VALUE SPACES.
       01  JSON-DATA                   PIC X(1024).
       01  POST-ADDRESS                PIC X(200) VALUE 
                                             "https://httpbin.org/post".
       78  CONTENT-TYPE VALUE 'application/json'.
       
       linkage section.
       01  RESPONSE-DATA               PIC X(2000).

       PROCEDURE DIVISION.
           PERFORM SETUP
           PERFORM HTTPPOST
           PERFORM GET-RESPONSE
           GOBACK.

       SETUP.
           INITIALIZE REQUEST-PAYLOAD REQUEST-LEN
           SET REQUEST-PAYLOAD TO ADDRESS OF JSON-DATA
           
           CALL "NETINIT" GIVING RESPONSE-STATUS
           CALL "NETSSLVERIFYPEER" USING SSL-VERIFYPEER-FLAG 
                                   GIVING STATUS-CODE.
           CALL "HTTPSETRESPONSEHEADER" USING 0 
                                        GIVING STATUS-CODE
           
           DISPLAY "Enter Message: " AT 0510
           ACCEPT MESSAGE-DATA AT 0526
      *    STRING '{"content": "' DELIMITED BY SIZE
      *           MESSAGE-DATA DELIMITED BY "  "
      *           '"}' DELIMITED BY SIZE
      *           INTO REQUEST-DATA

           JSON GENERATE JSON-DATA FROM MESSAGE-DATA
               NAME OF MESSAGE-DATA IS "content"

           SET REQUEST-LEN TO SIZE OF JSON-DATA.
          

       HTTPPOST.
           CALL "HTTPPOST"
             USING
               POST-ADDRESS
               CONTENT-TYPE
               REQUEST-PAYLOAD
               REQUEST-LEN
               RESPONSE-PAYLOAD
               RESPONSE-LEN
             GIVING
               RESPONSE-STATUS.

       GET-RESPONSE.          
           SET ADDRESS OF RESPONSE-DATA TO RESPONSE-PAYLOAD           

           IF NOT RESPONSE-STATUS = 0
               DISPLAY MESSAGE BOX "RESPONSE STATUS = " RESPONSE-STATUS
           ELSE
               DISPLAY MESSAGE RESPONSE-DATA
           END-IF

           CALL "NETFREE" USING RESPONSE-PAYLOAD.