package com.microfocus.businesslogic;

import com.microfocus.business.ITemperatureConverter;


import com.microfocus.cobol.runtimeservices.*;
import com.microfocus.converter.TemperatureConverter;

import javax.ejb.Stateless;
import javax.ws.rs.*;
import javax.ws.rs.core.*;

@Stateless
@Path("/RestApp1")
public class TemperatureConverterBean implements ITemperatureConverter { 

	RunUnit rununit = null ;

	@GET
	@Path("/getCelsius")
	@Produces(MediaType.APPLICATION_JSON)
	public Response toCelsius(@QueryParam("fahrenheit") float f ) 
	{
		float c = 0;
		TemperatureConverter temperatureConverter = createTemperatureConverter();		
		try
		{			
			c  = temperatureConverter.toCelsius(f);
					
		}
		finally
		{		
			rununit.StopRun();
		}		
		
		return Response.ok(new Temperature(f, c), MediaType.APPLICATION_JSON).build();
	}
	
	@GET
	@Path("/getFahrenheit")
	@Produces(MediaType.APPLICATION_JSON)
	public Response toFahrenheit(@QueryParam("celsius") float c) 
	{
		TemperatureConverter temperatureConverter = createTemperatureConverter();
		float f = 0;
		try
		{
			f = temperatureConverter.toFahrenheit(c);			
		}
		finally
		{
			rununit.StopRun();
		}
		return Response.ok(new Temperature(f, c), MediaType.APPLICATION_JSON).build();
	}
	
	private TemperatureConverter createTemperatureConverter()
	{
		rununit = new RunUnit();		
		TemperatureConverter tempConverter = new TemperatureConverter();
		rununit.Add(tempConverter);
		return tempConverter;
	}
	
}
