      *>*****************************************************************
      *>
      *> Copyright (C) Micro Focus. All rights reserved.
      *>
      *> This sample code is supplied for demonstration purposes only on
      *> an "as is" basis and is for use at your own risk.
      *>
      *>*****************************************************************

      *> The value of Cset-Flag indicates the following functions
      *> 0: Convert mixed SBCS/DBCS buffer from EBCDIC to ASCII.
      *>    Requires SOSI codes to surround DBCS characters
      *> 1: Convert mixed SBCS/DBCS buffer from ASCII to EBCDIC.
      *>    Requires SOSI codes to surround DBCS characters
      *> 2: Return the SBCS EBCDIC to ASCII table
      *> 3: Return the SBCS ASCII to EBCDIC table
      *> 4: Convert a pure DBCS buffer from EBCDIC to ASCII. No SOSI codes required
      *> 5: Convert a pure DBCS buffer from ASCII to EBCDIC. NO SOSI codes required

      $set dialect(mf)
      $set nocancel sourceformat(variable) reentrant
      $set fastcalls nocheck linkalias(none) opt(4)

       identification division.
       environment division.
       special-names.
           call-convention 4 is void.
       data division.
       working-storage section.

       copy "codeset.cpy".
       
       local-storage section.

       01  func-no                  pic x    comp-x.
       01  Source-Length            pic x(4) comp-x.

       01  Len-Left                 pic x(4) comp-5.
       01  Len-of-DBCS              pic x(4) comp-5.
       01  Current-Position         pic x(4) comp-5.
       01  Area-Length              pic x(4) comp-5.

       linkage section.
       01  Cset-Flag                pic x    comp-x.
       01  Cset-Length              pic x(4) comp-x.
       01  Cset-Area.  *> In practice, as long as parameter passed in.
           03  Cset-Area-ch         pic x    comp-x occurs 65537.
       
       01  conv-table-area.
           03  conv-table           pic x occurs 256.

       procedure division void using Cset-Flag Cset-Length Cset-Area.
           evaluate Cset-Flag
           when <= 1
               if Cset-Flag = 0
		   move 4 to func-no
		   set address of conv-table-area to address of Cset-EBCDIC-ASCII
	       else
		   move 5 to func-no
		   set address of conv-table-area to address of Cset-ASCII-EBCDIC
               end-if
               perform conv
           when 2
               move Cset-EBCDIC-ASCII to Cset-Area(1:256)
           when 3
               move Cset-ASCII-EBCDIC to Cset-Area(1:256)
           when <= 5
               call void "MFTRNSDT" using Cset-Flag Cset-Length Cset-area
           end-evaluate
           goback
           .

       *> Convert mixed string of SBCS and DBCS characters.
       *> SBCS characters are converted using the internal table.
       *> DBCS characters, delimited by SO and SI characters,
       *> are passed to MFTRNSDT for conversion.
       conv section.
           move Cset-Length to Area-Length
           move 0 to Current-Position
           perform until Current-Position >= Area-Length
               if Cset-Area-ch(Current-Position + 1) not = h"0E"
                   move conv-table(Cset-Area-ch(Current-Position + 1) + 1)
                     to Cset-Area(Current-Position + 1:1)
                   add 1 to Current-Position
               else
                   add 1 to Current-Position
                   compute len-left = Area-length - Current-Position
                   move 0 to len-of-dbcs
                   inspect Cset-area(Current-Position + 1:len-left)
                       tallying len-of-dbcs for characters before
                       initial x"0F"

                   move len-of-dbcs to Source-Length
                   call void "MFTRNSDT" using func-no Source-Length
                                   Cset-area(Current-Position + 1:len-of-dbcs)
                   add 1 len-of-dbcs to Current-position
               end-if
           end-perform
           .
