/******************************************************************************
*
*  Copyright (C) Micro Focus 2013. All rights reserved.
*
*  This sample code is supplied for demonstration purposes only on an "as is" basis and is for use at your own risk.
*
******************************************************************************/
package com.company.project.Book;

import com.microfocus.bookwrapper.*;
import com.microfocus.cobol.program.IObjectControl;
import com.microfocus.cobol.program.ScaledInteger;
import com.microfocus.cobol.runtimeservices.*;
import com.company.project.booklegacy.*;

public class BookOperation {
		
	public static final String BOOK_FILE = "C:[user path]//AxisDEMO/bookfile.dat";
	public static final String READ_RECORD   = "1";
    public static final String ADD_RECORD    = "2";
    public static final String DELETE_RECORD = "3";
    public static final String NEXT_RECORD   = "4";
	
		
	static public BookReturnE nextBook(StockNoE stockNo)
	{
		return doOperation(NEXT_RECORD, stockNo);
	}
	
	static public BookReturnE readBook(StockNoE stockNo)
	{
		return doOperation(READ_RECORD, stockNo);
	}
	
	static public BookReturnE deleteBook(StockNoE stockNo)
	{
		return doOperation(DELETE_RECORD, stockNo);
	}
	
	static public BookReturnE addBook(NewBook newBook)
	{
		return doOperation(ADD_RECORD, newBook);
	}
	
	static private BookReturnE doOperation(String action, StockNoE stockNo)
	{			
		IRunUnit runUnit = new RunUnit();		
		BookReturnE br = doOperation(action, getDetails(stockNo, runUnit), runUnit);
		runUnit.StopRun();
		return br;
		
	}
	
	static private BookReturnE doOperation(String action, NewBook newBook)
	{
		IRunUnit runUnit = new RunUnit();				
		BookReturnE br = doOperation(action, getDetails(newBook, runUnit), runUnit);
		runUnit.StopRun();
		return br;
	}
		
		
	static private BookReturnE doOperation(String action, Details details, IRunUnit runUnit)
	{		
		StatusGroup statusGroup = getObject(StatusGroup.class, runUnit);
		
		BookWrapper bookWrapper = getObject(BookWrapper.class, runUnit);		
		bookWrapper.setfilename(BOOK_FILE);				
		bookWrapper.BookWrapper(action, details, statusGroup);
		
		return getBookReturnE(details, statusGroup);
	}	
	
	
	static private <T extends IObjectControl> T getObject(Class<T> cls, IRunUnit runUnit)
	{		
		try
		{
			T output = cls.newInstance();
			runUnit.Add(output);
			
			return output;
		}
		catch (Throwable t)
		{
			throw new RuntimeException(t);
		}
	}
	
	static private BookReturnE getBookReturnE(Details details, StatusGroup statusGroup)
	{ 
		BookDetail bd = new BookDetail();
		
		bd.setAuthor(details.getAuthor());		
		bd.setISBN(details.getIsbn());
		bd.setOnhand(details.getOnhand());
		bd.setRetail(details.getRetail().toString());		
		bd.setSold(details.getSold());
		bd.setStockNo(details.getStockno());
		bd.setTitle(details.getTitle());
		bd.setType(details.getType());
		
		BookReturn br = new BookReturn();
		
		br.setBook(bd);
		br.setStatus(statusGroup.getStatus());
		br.setStatusNo(statusGroup.getStatusNo());
		
		BookReturnE e = new BookReturnE();
		e.setBookReturnE(br);
		return e;	
	}
	
	static private Details getDetails(StockNoE stockNo, IRunUnit runUnit)
	{
		Details details = getObject(Details.class, runUnit);		
		details.setStockno(stockNo.getStockNo().getStockNo());
		return details;
	}	
	
	static private Details getDetails(NewBook newBook, IRunUnit runUnit)
	{
		Details details = getObject(Details.class, runUnit);
		BookDetail bd = newBook.getNewBook();
		
		details.setAuthor(bd.getAuthor());
		details.setIsbn(bd.getISBN());		
		details.setOnhand(bd.getOnhand());		
		details.setRetail(ScaledInteger.parseScaledInteger(bd.getRetail()));
		details.setSold(bd.getSold());
		details.setStockno(bd.getStockNo());
		details.setTitle(bd.getTitle());
		details.setType(bd.getType());		
		return details;
	}
	
}
