******************************************************************************
*
*  Copyright (C) Micro Focus 2013. All rights reserved.
*
*  This sample code is supplied for demonstration purposes only on an "as is" basis and is for *use at your own risk.
*
******************************************************************************
      $set ilnamespace(com.microfocus.bookwrapper)
      $set ilusing(com.microfocus.book)  
       program-id. BookWrapper.

       data division.
       working-storage section.
      * copy "book-rec.cpy" replacing ==(prefix)== by ==b==.             
       01 b-file-status    pic xx.
       
       78 status-ok value 0.
       78 status-file-not-found value 1.
       78 status-item-not-found value 2.
       78 status-no-more value 3.
       78 status-already-exists value 4.
       78 status-file-error value 5.
       78 status-no-key value 6.
       78 status-unknown value 7.
       
       1 str1 pic x(256).
       
       linkage section.       
       copy "book-rec.cpy" replacing ==(prefix)== by ==lnk-b==.
       01 lnk-function       pic x.
       01 lnk-status-group.
          03 lnk-status pic x(30).
          03 lnk-status-No    binary-long.
      * 01 lnk-filename       pic x(256).
       01 lnk-filename       String.
     
       procedure division using by value lnk-function by reference lnk-b-details lnk-status-group. *> i io o 
           call "BookLegacy" using by value lnk-function by reference lnk-b-details b-file-status
           perform setup-status     
           goback
           .
                      
       entry "setfilename" using by value lnk-filename. *> i  *> grab property from java stub, not part of WSDL
           *> display "PATH" upon environment-name
           *> accept str1 from environment-value
           call "SET_FILENAME" using by value lnk-filename
           goback
           .
                                  
       setup-status section.
           evaluate b-file-status
           when "00"
           when "02"
               move "Okay" to lnk-status
               move status-ok to lnk-status-no
           when "35"
               move "Error: Data file not found" to lnk-status
               move status-file-not-found to lnk-status-no
           when "23"
               move "Error: Stock item not found" to lnk-status
               move status-item-not-found to lnk-status-no
           when "46"
               move "No more items left" to lnk-status
               move status-no-more to lnk-status-no
           when "99"
               move "Error: Item already exists" to lnk-status
               move status-already-exists to lnk-status-no
           when "01"
               move "Error: File error" to lnk-status
               move status-file-error to lnk-status-no
           when "B1"
               move "Error: No key entered" to lnk-status
               move status-no-key to lnk-status-no              
           when other
               move "Unknown Error: " to lnk-status
               move b-file-status to lnk-status(16:2)
               move status-unknown to lnk-status-no
           end-evaluate
           .
       
       end program BookWrapper.
