package com.microfocus.book;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.microfocus.cobol.runtimeservices.IRunUnit;
import com.microfocus.cobol.runtimeservices.servlet.ServletRunUnitManager;

public class BookServlet extends HttpServlet
{

  /**
	 * 
	 */
  private static final long serialVersionUID = -3563065100184185678L;

  public static final String STATUS_ATTRIBUTE = "status";
  public static final String RUN_UNIT_ID_ATTRIBUTE = "rununitid";

  public static final String SUBMIT_PARAMETER = "submit";
  public static final String READ_PARAMETER = "Read";
  public static final String ADD_PARAMETER = "Add";
  public static final String DELETE_PARAMETER = "Delete";
  public static final String NEXT_PARAMETER = "Next";
  public static final String END_PARAMETER = "End Session";
  public static final String DEFAULT_VALUE = "DEFAULT";
  public static final String VIEW_URL = "/BookJsp.jsp";


  protected void doProcessing(HttpServletRequest req, HttpServletResponse res,
      boolean isGet)
  {
    String subValue = req.getParameter(SUBMIT_PARAMETER);

    if (subValue == null)
    {
      subValue = DEFAULT_VALUE;
    }

    setRunUnitId(req);

    if (subValue.equals(READ_PARAMETER))
    {
      performRead(req, res);
    } else if (subValue.equals(ADD_PARAMETER))
    {
      performAdd(req, res);
    } else if (subValue.equals(DELETE_PARAMETER))
    {
      performDelete(req, res);
    } else if (subValue.equals(NEXT_PARAMETER))
    {
      performNext(req, res);
    } else if (subValue.equals(END_PARAMETER))
    {
      performEndSession(req, res);
    } else
    {
      outputBlankBook(req, res);
    }

    RequestDispatcher dispatcher = getServletContext().getRequestDispatcher(
        VIEW_URL);
    try
    {
      dispatcher.forward(req, res);
    } catch (Exception e)
    {
      throw new RuntimeException(e);
    }
  }

  @Override
  protected void doGet(HttpServletRequest req, HttpServletResponse res)
  {
    doProcessing(req, res, true);
  }

  @Override
  protected void doPost(HttpServletRequest req, HttpServletResponse res)
  {
    doProcessing(req, res, false);
  }

  private void performRead(HttpServletRequest req, HttpServletResponse res)
  {
    BookInterface bookInterface = getBookInterface(req.getSession());
    String bookId = BookBean.getStockno(req, res);

    try
    {
      BookBean book = bookInterface.readBook(bookId);

      outputBook(req, res, book);
    } catch (JavaBookException e)
    {
      outputBookException(req, res, e);
    } catch (Exception e)
    {
      outputException(req, res, e);
    }
  }

  private void performAdd(HttpServletRequest req, HttpServletResponse res)
  {
    BookInterface bookInterface = getBookInterface(req.getSession());

    try
    {
      BookBean book = BookBean.getBook(req, res);

      book = bookInterface.addBook(book);

      outputBook(req, res, book);
    } catch (JavaBookException e)
    {
      outputBookException(req, res, e);
    } catch (Exception e)
    {
      outputException(req, res, e);
    }
  }

  private void performDelete(HttpServletRequest req, HttpServletResponse res)
  {
    BookInterface bookInterface = getBookInterface(req.getSession());
    String bookId = BookBean.getStockno(req, res);

    try
    {
      BookBean book = bookInterface.deleteBook(bookId);

      outputBook(req, res, book);
    } catch (JavaBookException e)
    {
      outputBookException(req, res, e);
    } catch (Exception e)
    {
      outputException(req, res, e);
    }
  }

  private void performNext(HttpServletRequest req, HttpServletResponse res)
  {
    BookInterface bookInterface = getBookInterface(req.getSession());
    String bookId = BookBean.getStockno(req, res);

    try
    {
      BookBean book = bookInterface.nextBook(bookId);

      outputBook(req, res, book);
    } catch (JavaBookException e)
    {
      outputBookException(req, res, e);
    } catch (Exception e)
    {
      outputException(req, res, e);
    }
  }

  private void performEndSession(HttpServletRequest req, HttpServletResponse res)
  {
    HttpSession session = req.getSession();
    session.invalidate();

    outputError(req, res, "Session invalidated");
  }

  private void outputBlankBook(HttpServletRequest req, HttpServletResponse res)
  {
    outputBook(req, res, BookBean.blankBook());
  }

  private void outputBookException(HttpServletRequest req,
      HttpServletResponse res, JavaBookException jbe)
  {
    outputError(req, res, jbe.getMessage());
  }

  private void outputException(HttpServletRequest req, HttpServletResponse res,
      Exception e)
  {
    String msg = e.getClass().getName() + " [" + e.getMessage() + "]";
    StringWriter strWriter = new StringWriter();
    PrintWriter printWriter = new PrintWriter(strWriter);
    e.printStackTrace(printWriter);
    req.setAttribute(STATUS_ATTRIBUTE, strWriter.toString());
    outputError(req, res, msg);
  }

  private void outputBook(HttpServletRequest req, HttpServletResponse res,
      BookBean book)
  {
    if (book != null)
    {
      req.setAttribute("book", book);
    } else
    {
      req.setAttribute("book",
          BookBean.msgBook("ERROR! book is null in output book"));
    }
  }

  private void outputError(HttpServletRequest req, HttpServletResponse res,
      String msg)
  {
    outputBook(req, res, BookBean.msgBook(msg));
  }

  private IRunUnit getRunUnit(HttpSession session)
  {
    return ServletRunUnitManager.getManager().GetSessionRunUnit(session);
  }

  private void setRunUnitId(HttpServletRequest req)
  {
    HttpSession session = req.getSession();
    IRunUnit runUnit = getRunUnit(session);
    String ruid = "" + runUnit.getRunUnitID();
    req.setAttribute(RUN_UNIT_ID_ATTRIBUTE, ruid);
  }

  private BookInterface getBookInterface(HttpSession session)
  {
    BookInterface output = new BookInterface(session);

    return output;
  }
}
