package com.microfocus.book;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BookBean
{
  private final String _stockno;
  private final String _isbn;
  private final String _title;
  private final String _author;
  private final String _type;
  private final String _price;
  private final String _onhand;
  private final String _sold;
  private final String _stockval;
  
  public static final String STOCK_NO_ATTRIBUTE = "stockno";
  public static final String TITLE_ATTRIBUTE = "title";
  public static final String AUTHOR_ATTRIBUTE = "author";
  public static final String TYPE_ATTRIBUTE = "type";
  public static final String ISBN_ATTRIBUTE = "isbn";
  public static final String PRICE_ATTRIBUTE = "price";
  public static final String ONHAND_ATTRIBUTE = "onhand";
  public static final String SOLD_ATTRIBUTE = "sold";
  
  private static final String ERROR_VALUE = "ERROR";

  BookBean(String stockno, String isbn, String title, String author,
      String type, String price, String onhand, String sold, String stockval)
  {
    this._stockno = stockno;
    this._isbn = isbn;
    this._title = title;
    this._author = author;
    this._type = type;
    this._price = price;
    this._onhand = onhand;
    this._sold = sold;
    this._stockval = stockval;
  }

  public String getStockno()
  {
    return _stockno;
  }

  public String getIsbn()
  {
    return _isbn;
  }

  public String getTitle()
  {
    return _title;
  }

  public String getAuthor()
  {
    return _author;
  }

  public String getType()
  {
    return _type;
  }

  public String getPrice()
  {
    return _price;
  }

  public String getOnhand()
  {
    return _onhand;
  }

  public String getSold()
  {
    return _sold;
  }

  public String getStockval()
  {
    return _stockval;
  }

  public static BookBean blankBook()
  {
    return msgBook("*************************************");
  }

  public static BookBean msgBook(String msg)
  {
    String stockno = "****";
    String isbn = "*************";
    String title = msg;
    String author = "*************************************";
    String type = "****";
    String price = "****";
    String onhand = "****";
    String sold = "****";
    String stockval = "****";

    return new BookBean(stockno, isbn, title, author, type, price, onhand,
        sold, stockval);
  }

  public static BookBean getBook(HttpServletRequest req, HttpServletResponse res)
  {
    return new BookBean(getStockno(req, res), getIsbn(req, res), getTitle(req,
        res), getAuthor(req, res), getType(req, res), getPrice(req, res),
        getOnhand(req, res), getSold(req, res), "");
  }

  private static String getAttribute(HttpServletRequest req, HttpServletResponse res,
      String attribute)
  {
    String stockNoStr;
    stockNoStr = req.getParameter(attribute);
    if (stockNoStr == null)
    {
      stockNoStr = ERROR_VALUE;
    }

    return stockNoStr;
  }

  public static String getStockno(HttpServletRequest req, HttpServletResponse res)
  {
    String output = getAttribute(req, res, BookBean.STOCK_NO_ATTRIBUTE);

    if (output == null)
    {
      output = ERROR_VALUE;
    }
    
    return output;
  }

  private static String getTitle(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.TITLE_ATTRIBUTE);
  }

  private static String getAuthor(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.AUTHOR_ATTRIBUTE);
  }

  private static String getType(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.TYPE_ATTRIBUTE);
  }

  private static String getIsbn(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.ISBN_ATTRIBUTE);
  }

  private static String getPrice(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.PRICE_ATTRIBUTE);
  }

  private static String getOnhand(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.ONHAND_ATTRIBUTE);
  }

  private static String getSold(HttpServletRequest req, HttpServletResponse res)
  {
    return getAttribute(req, res, BookBean.SOLD_ATTRIBUTE);
  }
}
