       program-id. DockerDemo as "DockerDemo".

       environment division.
       configuration section.
       input-output section.
       file-control.
           select report-file assign "run-report.txt"
                organization line sequential
                file status is run-report-status
                lock mode automatic.
      /
       data division.
       file section.
       fd  report-file.
       01 report-rec                    pic x(100).
       working-storage section.
       01 run-report-status             pic xx.

       copy cbltypes.cpy.

       01 expanded-bits.
         05 filler                      pic x(24).
         05 docker-sw                   pic x value spaces.
           88 running-on-docker         value '1'.
           88 not-running-on-docker     value '0'.
         05 filler                      pic x(4) value spaces.
         05 64bit-capable               pic x.
         05 mainframe-compat            pic x.
         05 multithreaded               pic x.

       01 parameter-block               usage cblt-os-info-params.
       01 version-info.
         05 current-product-version     pic z9.
         05 current-product-revision    pic z9.
         05 pu-status                   pic x(40).
       01 status-code                   pic x(2) comp-5.
       01 docker-status                 pic x(40).

       procedure division.
           open output report-file
           if run-report-status equal 00
               perform report-product-info
           end-if
           close report-file
           goback
           .

       report-product-info.
           call "CBL_GET_OS_INFO" using parameter-block
                              returning status-code

      *   Report product version
           move cblte-osi-product-version to current-product-version
           move spaces                    to report-rec
           string
             "Current Product Version: "
             current-product-version
             delimited by size
             into report-rec
           end-string
           write report-rec

      *   Report container status
           perform determine-docker

           move spaces to report-rec
           string
             "Container Status: "
             docker-status
             delimited by size
             into report-rec
           end-string
           write report-rec
           .

       determine-docker.
      *    The BIT-OF function is new in Visual COBOL 6.0...
           move function BIT-OF (cblte-osi-rts-capabilities) to
             expanded-bits
       
           evaluate true
               when running-on-docker
                   move "Running in a Docker Container" to docker-status
               when other
                   move "Running on Full O/S" to docker-status
           end-evaluate
           display docker-status
           .
       end program DockerDemo.
