/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.stream;

import com.softwareag.tamino.db.api.common.TPreconditionViolation;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXObjectModel;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.sax.TSAXInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.stream.TStreamElement;
import com.softwareag.tamino.db.api.response.stream.TStreamElementDefaultHandler;
import java.io.IOException;
import java.util.Iterator;

public class TStreamInputStreamInterpreter
extends TInputStreamInterpreter {
    private boolean isInitialized = false;
    private TStreamElementDefaultHandler elementDefaultHandler = null;
    private TStreamWritingDeclHandler elementDeclHandler = null;
    private TStreamWritingLexicalHandler elementLexicalHandler = null;
    private TSAXInputStreamInterpreter inputStreamInterpreter = null;

    public void setProperty(String string, Object object) {
    }

    public TResponseInfoContent getResponseInfoContent() {
        if (this.inputStreamInterpreter == null) {
            return null;
        }
        return this.inputStreamInterpreter.getResponseInfoContent();
    }

    protected void doInterpret(TInputStream tInputStream) throws TStreamInterpretException {
        TResponseQueryContent tResponseQueryContent;
        if (!this.isInitialized) {
            this.initialize();
        }
        this.resetInterpretState();
        TStreamHeader tStreamHeader = tInputStream.getHeader();
        this.inputStreamInterpreter.interpret(tInputStream);
        if (this.elementDefaultHandler != null && this.elementDefaultHandler.getFirstElement() != null) {
            this.setResponseQueryContent(this.elementDefaultHandler.getElementIterator(), tStreamHeader.getValue("X-API-Collection"), tStreamHeader.getValue("X-API-Doctype"));
        }
        if ((tResponseQueryContent = this.inputStreamInterpreter.getResponseQueryContent()) != null && tResponseQueryContent.getText().length() > 0) {
            this.getResponseQueryContent().setText(tResponseQueryContent.getText());
        }
    }

    private void initialize() {
        try {
            this.inputStreamInterpreter = new TSAXInputStreamInterpreter();
            this.elementDeclHandler = new TStreamWritingDeclHandler(null);
            this.inputStreamInterpreter.setProperty("http://xml.org/sax/properties/declaration-handler", this.elementDeclHandler);
            this.elementLexicalHandler = new TStreamWritingLexicalHandler(null, this.elementDeclHandler);
            this.inputStreamInterpreter.setProperty("http://xml.org/sax/properties/lexical-handler", this.elementLexicalHandler);
            this.elementDefaultHandler = new TStreamElementDefaultHandler(this.elementDeclHandler, this.elementLexicalHandler);
            this.inputStreamInterpreter.setProperty(TSAXElementDefaultHandler.SPECIFIER, this.elementDefaultHandler);
            TXMLObjectModel.register(new StreamBasedSAXObjectModel(this.elementDefaultHandler));
        }
        catch (Exception exception) {
            throw new TPreconditionViolation("Problems finding the TXMLReaderDecorator!");
        }
    }

    private void resetInterpretState() {
        this.elementDefaultHandler.clear();
    }

    private void setResponseQueryContent(Iterator iterator, String string, String string2) throws TStreamInterpretException {
        if (iterator == null || !iterator.hasNext()) {
            return;
        }
        TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
        try {
            while (iterator.hasNext()) {
                TStreamElement tStreamElement = (TStreamElement)iterator.next();
                TXMLObject tXMLObject = TXMLObject.newInstance(tStreamElement.getCharacterInputStream());
                tXMLObject.setCollection(string);
                tXMLObject.setDoctype(string2);
                tResponseQueryContent.add(tXMLObject);
            }
        }
        catch (IOException iOException) {
            throw new TStreamInterpretException("Problem when building TXMLObject from Tamino input stream!", iOException);
        }
    }

    protected static class StreamBasedSAXObjectModel
    extends TSAXObjectModel {
        static /* synthetic */ Class class$com$softwareag$tamino$db$api$response$stream$TStreamElement;

        public StreamBasedSAXObjectModel(TSAXElementDefaultHandler tSAXElementDefaultHandler) {
            super("StreamBasedSAXObjectModel", null, class$com$softwareag$tamino$db$api$response$stream$TStreamElement == null ? (class$com$softwareag$tamino$db$api$response$stream$TStreamElement = StreamBasedSAXObjectModel.class$("com.softwareag.tamino.db.api.response.stream.TStreamElement")) : class$com$softwareag$tamino$db$api$response$stream$TStreamElement, null, tSAXElementDefaultHandler);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

