/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.stream;

import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import com.softwareag.tamino.db.api.response.stream.TStreamElement;
import java.io.Writer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TStreamElementDefaultHandler
extends TSAXElementDefaultHandler {
    private StringBuffer startElementBuffer = null;
    private int currentLevel = 0;
    private TStreamElement currentElement = null;
    private ArrayList streamElementList = null;
    private TStreamWritingDeclHandler elementDeclHandler = null;
    private TStreamWritingLexicalHandler elementLexicalHandler = null;

    public TStreamElementDefaultHandler(TStreamWritingDeclHandler tStreamWritingDeclHandler, TStreamWritingLexicalHandler tStreamWritingLexicalHandler) {
        this.elementDeclHandler = tStreamWritingDeclHandler;
        this.elementLexicalHandler = tStreamWritingLexicalHandler;
        this.startElementBuffer = new StringBuffer();
        this.streamElementList = new ArrayList();
    }

    public TSAXElement getFirstElement() {
        return this.streamElementList.size() > 0 ? (TStreamElement)this.streamElementList.get(0) : null;
    }

    public Iterator getElementIterator() {
        return ((AbstractList)this.streamElementList).iterator();
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?" + string + " " + string2 + "?>");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.currentLevel == 0) {
            this.appendStreamElement();
        }
        if (attributes.getLength() > 0) {
            this.startElementBuffer.delete(0, this.startElementBuffer.length());
            this.startElementBuffer.append("<" + string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.startElementBuffer.append(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                ++n;
            }
            this.startElementBuffer.append(">");
            this.write(this.startElementBuffer.toString());
        } else {
            this.write("<" + string3 + ">");
        }
        ++this.currentLevel;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.write("</" + string3 + ">");
        --this.currentLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.write(cArray, n, n2);
    }

    public void clear() {
        this.startElementBuffer = new StringBuffer();
        this.streamElementList.clear();
    }

    protected final Writer getElementWriter() {
        return this.currentElement.getWriter();
    }

    private void write(String string) throws SAXException {
        try {
            this.currentElement.writeContent(string);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void write(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.currentElement.writeContent(cArray, n, n2);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void appendStreamElement() {
        this.currentElement = new TStreamElement();
        this.elementDeclHandler.setWriter(this.currentElement.getWriter());
        this.elementLexicalHandler.setWriter(this.currentElement.getWriter());
        this.streamElementList.add(this.currentElement);
    }
}

