/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.jdom;

import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.namespace.TXQLNamespace;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItemFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TSessionContentItem;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class TJDOMInputStreamInterpreter
extends TInputStreamInterpreter {
    private Namespace inoNamespace = null;
    private Namespace xqlNamespace = null;
    private String parserName = "";
    private Document document = null;
    private TResponseContentItemFactory responseContentItemFactory = null;

    public TJDOMInputStreamInterpreter(String string) {
        this.initialize(string);
    }

    public TJDOMInputStreamInterpreter() {
        this.initialize(null);
    }

    public void setProperty(String string, Object object) {
    }

    protected void doInterpret(TInputStream tInputStream) throws TStreamInterpretException {
        try {
            SAXBuilder sAXBuilder = this.parserName == null || this.parserName.equals("") ? new SAXBuilder() : new SAXBuilder(this.parserName);
            this.document = sAXBuilder.build((InputStream)tInputStream);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            this.setResponseInfoContent(this.document);
            if (this.document.getRootElement().getChild(TXQLNamespace.QUERY.getName(), this.xqlNamespace) != null) {
                this.setResponseQueryContent(this.document, tStreamHeader.getValue("X-API-Collection"), tStreamHeader.getValue("X-API-Doctype"));
            }
        }
        catch (JDOMException jDOMException) {
            throw new TStreamInterpretException("Interpreting the input stream for JDOM failed!", (Exception)((Object)jDOMException));
        }
        catch (Exception exception) {
            throw new TStreamInterpretException("Interpreting the input stream failed!", exception);
        }
    }

    private void initialize(String string) {
        this.parserName = string;
        this.inoNamespace = Namespace.getNamespace((String)TInoNamespace.getInstance().getPrefix(), (String)TInoNamespace.getInstance().getUri());
        this.xqlNamespace = Namespace.getNamespace((String)TXQLNamespace.getInstance().getPrefix(), (String)TXQLNamespace.getInstance().getUri());
        this.responseContentItemFactory = TResponseContentItemFactory.getInstance();
    }

    private void setResponseInfoContent(Document document) {
        TResponseInfoContent tResponseInfoContent = this.getResponseInfoContent();
        this.setMessageContentItem(tResponseInfoContent, document);
        this.setQueryContentItem(tResponseInfoContent, document);
        this.setSessionContentItem(tResponseInfoContent, document);
        this.setObjectContentItem(tResponseInfoContent, document);
        this.setCursorContentItem(tResponseInfoContent, document);
    }

    private void setMessageContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getRootElement();
        List list = element.getChildren(TInoNamespace.MESSAGE.getName(), this.inoNamespace);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            Object object;
            Element element2;
            Element element3 = (Element)iterator.next();
            String string2 = element3.getAttributeValue(TInoNamespace.RETURN_VALUE.getName(), this.inoNamespace);
            TMessageLineContentItem[] tMessageLineContentItemArray = null;
            List list2 = element3.getChildren(TInoNamespace.MESSAGE_LINE.getName(), this.inoNamespace);
            if (list2.size() > 0) {
                tMessageLineContentItemArray = new TMessageLineContentItem[list2.size()];
                int n = 0;
                element2 = list2.iterator();
                while (element2.hasNext()) {
                    object = (Element)element2.next();
                    string = object.getAttributeValue(TInoNamespace.SUBJECT.getName(), this.inoNamespace);
                    String string3 = object.getAttributeValue(TInoNamespace.UNIT.getName(), this.inoNamespace);
                    String string4 = object.getText();
                    TMessageLineContentItem tMessageLineContentItem = this.responseContentItemFactory.newMessageLineContentItem(string, string4);
                    if (string3 != null && !string3.equals("")) {
                        tMessageLineContentItem.addAttribute(TInoNamespace.UNIT.getQualifiedName(), string3);
                    }
                    tMessageLineContentItemArray[n++] = tMessageLineContentItem;
                }
            }
            TMessageTextContentItem tMessageTextContentItem = null;
            element2 = element3.getChild(TInoNamespace.MESSAGE_TEXT.getName(), this.inoNamespace);
            if (element2 != null) {
                object = element2.getAttributeValue(TInoNamespace.CODE.getName(), this.inoNamespace);
                string = element2.getText();
                tMessageTextContentItem = this.responseContentItemFactory.newMessageTextContentItem((String)object, string);
            }
            object = this.responseContentItemFactory.newMessageContentItem(string2, tMessageLineContentItemArray, tMessageTextContentItem);
            tResponseInfoContent.putItem(TMessageContentItem.SPECIFIER, (TResponseContentItem)object);
        }
    }

    private void setQueryContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getRootElement();
        Element element2 = element.getChild(TXQLNamespace.QUERY.getName(), this.xqlNamespace);
        if (element2 != null) {
            TQueryContentItem tQueryContentItem = this.responseContentItemFactory.newQueryContentItem(element2.getText());
            tResponseInfoContent.putItem(TQueryContentItem.SPECIFIER, tQueryContentItem);
        }
    }

    private void setSessionContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getRootElement();
        String string = element.getAttributeValue(TInoNamespace.SESSION_ID.getName(), this.inoNamespace);
        String string2 = element.getAttributeValue(TInoNamespace.SESSION_KEY.getName(), this.inoNamespace);
        if (string != null && string2 != null) {
            TSessionContentItem tSessionContentItem = this.responseContentItemFactory.newSessionContentItem(string, string2);
            tResponseInfoContent.putItem(TSessionContentItem.SPECIFIER, tSessionContentItem);
        }
    }

    private void setObjectContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getRootElement();
        Element element2 = element.getChild(TInoNamespace.OBJECT.getName(), this.inoNamespace);
        if (element2 != null) {
            String string = element2.getAttributeValue(TInoNamespace.COLLECTION.getName(), this.inoNamespace);
            String string2 = element2.getAttributeValue(TInoNamespace.DOCTYPE.getName(), this.inoNamespace);
            String string3 = element2.getAttributeValue(TInoNamespace.ID.getName(), this.inoNamespace);
            TObjectContentItem tObjectContentItem = this.responseContentItemFactory.newObjectContentItem(string, string2, string3);
            tResponseInfoContent.putItem(TObjectContentItem.SPECIFIER, tObjectContentItem);
        }
    }

    private void setCursorContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getRootElement();
        Element element2 = element.getChild(TInoNamespace.CURSOR.getName(), this.inoNamespace);
        if (element2 != null) {
            String string = element2.getAttributeValue(TInoNamespace.HANDLE.getName(), this.inoNamespace);
            Element element3 = element2.getChild(TInoNamespace.CURRENT.getName(), this.inoNamespace);
            Element element4 = element2.getChild(TInoNamespace.NEXT.getName(), this.inoNamespace);
            Element element5 = element2.getChild(TInoNamespace.PREVIOUS.getName(), this.inoNamespace);
            String string2 = element3 != null ? element3.getAttributeValue(TInoNamespace.POSITION.getName(), this.inoNamespace) : null;
            String string3 = element3 != null ? element3.getAttributeValue(TInoNamespace.QUANTITY.getName(), this.inoNamespace) : null;
            String string4 = element4 != null ? element4.getAttributeValue(TInoNamespace.POSITION.getName(), this.inoNamespace) : null;
            String string5 = element5 != null ? element5.getAttributeValue(TInoNamespace.POSITION.getName(), this.inoNamespace) : null;
            TCursorContentItem tCursorContentItem = this.responseContentItemFactory.newCursorContentItem(string, string2, string3, string4, string5);
            tResponseInfoContent.putItem(TCursorContentItem.SPECIFIER, tCursorContentItem);
        }
    }

    private void setResponseQueryContent(Document document, String string, String string2) {
        Element element = document.getRootElement();
        Element element2 = element.getChild(TXQLNamespace.RESULT.getName(), this.xqlNamespace);
        if (element2 == null) {
            return;
        }
        List list = element2.getMixedContent();
        if (list.size() == 0) {
            return;
        }
        TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof String) {
                tResponseQueryContent.setText(e.toString());
                continue;
            }
            if (!(e instanceof Element)) continue;
            Element element3 = (Element)e;
            TXMLObject tXMLObject = TXMLObject.newInstance(element3);
            tXMLObject.setCollection(string);
            tXMLObject.setDoctype(string2);
            tResponseQueryContent.add(tXMLObject);
        }
    }
}

