/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import java.util.Iterator;

public class TXMLObjectIteratorImpl
implements TXMLObjectIterator {
    protected static final int START_AT_BEGIN = 1;
    protected static final int START_AT_END = 2;
    protected static final int NEXT = 0;
    protected static final int PREVIOUS = 1;
    protected int lastMoveDirection = 1;
    private TResponseQueryContent responseQueryContent = null;
    private int size = 0;
    private int nextIndex = 0;

    public TXMLObjectIteratorImpl() {
        this(null);
    }

    public TXMLObjectIteratorImpl(TResponseQueryContent tResponseQueryContent) {
        if (tResponseQueryContent == null) {
            tResponseQueryContent = TResponseContentFactory.getInstance().newResponseQueryContent();
        }
        this.setResponseQueryContent(tResponseQueryContent.iterator(), 1);
    }

    public boolean hasNext() {
        return this.nextIndex < this.size;
    }

    public TXMLObject next() throws TNoSuchXMLObjectException, TIteratorException {
        if (this.hasNext()) {
            this.lastMoveDirection = 0;
            return this.responseQueryContent.get(this.nextIndex++);
        }
        throw new TNoSuchXMLObjectException("No next TXMLObject available!");
    }

    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    public TXMLObject previous() throws TNoSuchXMLObjectException, TIteratorException {
        if (this.hasPrevious()) {
            this.lastMoveDirection = 1;
            return this.responseQueryContent.get(--this.nextIndex);
        }
        throw new TNoSuchXMLObjectException("No previous TXMLObject available!");
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        int n2 = this.nextIndex + n;
        return n2 >= 0 && n2 <= this.size;
    }

    public void moveBy(int n) throws TNoSuchXMLObjectException, TIteratorException {
        if (!this.canMoveBy(n)) {
            throw new TNoSuchXMLObjectException("No such TXMLObject for move by " + n + " instances!");
        }
        this.nextIndex += n;
        if (n < 0) {
            this.lastMoveDirection = 1;
        } else if (n > 0) {
            this.lastMoveDirection = 0;
        }
    }

    public void reset() throws TIteratorException {
        this.initIndex(1);
    }

    protected final int getCurrentIndex() {
        return this.nextIndex;
    }

    protected final void setCurrentIndex(int n) {
        this.nextIndex = n;
    }

    public void close() throws TIteratorException {
    }

    protected void setResponseQueryContent(Iterator iterator, int n) {
        if (this.responseQueryContent == null) {
            this.responseQueryContent = TResponseContentFactory.getInstance().newResponseQueryContent();
        }
        this.responseQueryContent.clear();
        while (iterator.hasNext()) {
            this.responseQueryContent.add((TXMLObject)iterator.next());
        }
        this.initIndex(n);
    }

    protected TResponseQueryContent getResponseQueryContent() {
        return this.responseQueryContent;
    }

    protected void initIndex(int n) {
        if (this.responseQueryContent == null) {
            this.nextIndex = 0;
            this.size = 0;
            return;
        }
        this.size = this.responseQueryContent.size();
        switch (n) {
            case 1: {
                this.nextIndex = 0;
                this.lastMoveDirection = 0;
                break;
            }
            case 2: {
                this.nextIndex = this.responseQueryContent.size();
                this.lastMoveDirection = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("TXMLObjectIteratorImpl.initIndex has been called with an inappopiate startAt indicator!");
            }
        }
    }
}

