/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.accessor.TAccessFailureMessage;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;

public class TXMLObjectFetchingIterator
extends TXMLObjectIteratorImpl {
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private TCommandStatement commandStatement = null;
    private TInvocation invocation = null;
    private String collection = null;
    private int primaryQuantity = 0;
    private String cursorHandle = "";
    private int currentLogicalIndex = 0;

    public TXMLObjectFetchingIterator(TInputStreamInterpreter tInputStreamInterpreter, TInvocation tInvocation) {
        super(tInputStreamInterpreter.getResponseQueryContent());
        this.invocation = tInvocation;
        this.inputStreamInterpreter = tInputStreamInterpreter;
        this.commandStatement = new TCommandStatement();
        if (this.getResponseQueryContent() != null && this.getResponseQueryContent().size() > 0 && this.getCursorContentItem() != null) {
            this.collection = this.getResponseQueryContent().get(0).getCollection();
            this.primaryQuantity = Integer.parseInt(this.getCursorContentItem().getQuantity());
            this.cursorHandle = this.getCursorContentItem().getHandle();
            TContractVerifier.precondition(this.collection != null && !this.collection.equals(""), "Illegal state, no collection given!");
        }
    }

    public boolean hasNext() {
        return super.hasNext() || this.hasNextCursorObject();
    }

    protected boolean hasNextCursorObject() {
        if (this.getCursorContentItem() != null) {
            return this.getCursorContentItem().hasNext();
        }
        TTrace.trace(this, "No cursor content item in hasNextCursorObject() ");
        return false;
    }

    public TXMLObject next() throws TNoSuchXMLObjectException, TIteratorException {
        TXMLObject tXMLObject = null;
        if (super.hasNext()) {
            tXMLObject = super.next();
        } else if (this.hasNextCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 0, false);
            tXMLObject = super.next();
        } else {
            throw new TNoSuchXMLObjectException("No next TXMLObject available!");
        }
        ++this.currentLogicalIndex;
        return tXMLObject;
    }

    public boolean hasPrevious() {
        return super.hasPrevious() || this.hasPreviousCursorObject();
    }

    protected boolean hasPreviousCursorObject() {
        if (this.getCursorContentItem() != null) {
            return this.getCursorContentItem().hasPrevious();
        }
        TTrace.trace(this, "No cursor content item in hasPreviousCursorObject() ");
        return false;
    }

    public TXMLObject previous() throws TNoSuchXMLObjectException, TIteratorException {
        TXMLObject tXMLObject = null;
        --this.currentLogicalIndex;
        if (super.hasPrevious()) {
            tXMLObject = super.previous();
        } else if (this.hasPreviousCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 1, false);
            tXMLObject = super.previous();
        } else {
            throw new TNoSuchXMLObjectException("No previous TXMLObject available!");
        }
        return tXMLObject;
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        if (super.canMoveBy(n)) {
            return true;
        }
        int n2 = this.currentLogicalIndex + n;
        return this.isCursorPossibleAt(n2 + 1);
    }

    public void moveBy(int n) throws TNoSuchXMLObjectException, TIteratorException {
        this.currentLogicalIndex += n;
        if (super.canMoveBy(n)) {
            super.moveBy(n);
            return;
        }
        int n2 = this.fetchBlockWith(this.currentLogicalIndex, 0, true);
        if (n2 > 0) {
            return;
        }
        n2 = this.fetchBlockWith(this.currentLogicalIndex - 1, 0, true);
        if (n2 <= 0) {
            throw new TNoSuchXMLObjectException("No such TXMLObject for move by " + n + " instances!");
        }
        this.setCurrentIndex(this.getCurrentIndex() + 1);
    }

    public void reset() throws TIteratorException {
        if (this.currentLogicalIndex < this.primaryQuantity) {
            super.reset();
        } else {
            this.fetchBlockWith(0, 0, false);
        }
        this.currentLogicalIndex = 0;
    }

    public void close() throws TIteratorException {
        if (this.getCursorContentItem() != null) {
            try {
                TInputStream tInputStream = this.invokeCloseCursor(this.cursorHandle);
                this.inputStreamInterpreter.interpret(tInputStream);
                TMessageContentItem tMessageContentItem = this.getMessageContentItem();
                if (tMessageContentItem != null && !tMessageContentItem.getReturnValue().equals("0")) {
                    throw this.newIteratorException(tMessageContentItem);
                }
            }
            catch (TException tException) {
                TMessageContentItem tMessageContentItem = this.getMessageContentItem();
                throw this.newIteratorException(tMessageContentItem);
            }
        }
    }

    private int fetchBlockWith(int n, int n2, boolean bl) throws TIteratorException {
        int n3 = n / this.primaryQuantity;
        int n4 = this.fetchBlockAt(n3 * this.primaryQuantity + 1, this.primaryQuantity, bl);
        this.setCurrentIndex(n % this.primaryQuantity + n2);
        return n4;
    }

    private int fetchBlockAt(int n, int n2, boolean bl) throws TIteratorException {
        Object object;
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, n2);
            this.inputStreamInterpreter.interpret((TInputStream)object);
        }
        catch (TException tException) {
            throw new TIteratorException("Problem during retrieval of previous query cursor content.", tException);
        }
        object = this.getMessageContentItem();
        if (object != null && (bl ? !((TMessageContentItem)object).getReturnValue().equals("8306") && !((TMessageContentItem)object).getReturnValue().equals("0") : !((TMessageContentItem)object).getReturnValue().equals("0"))) {
            throw this.newIteratorException((TMessageContentItem)object);
        }
        this.setResponseQueryContent(this.inputStreamInterpreter.getResponseQueryContent().iterator(), 2);
        return this.getResponseQueryContent().size();
    }

    private boolean isCursorPossibleAt(int n) throws TIteratorException {
        return this.isCursorPossibleAt(n, true);
    }

    private boolean isCursorPossibleAt(int n, boolean bl) throws TIteratorException {
        Object object;
        if (n < 1) {
            return false;
        }
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, 0);
            this.inputStreamInterpreter.interpret((TInputStream)object);
        }
        catch (TException tException) {
            throw new TIteratorException("Problem during checking cursor position.", tException);
        }
        object = this.getMessageContentItem();
        if (object != null) {
            if (((TMessageContentItem)object).getReturnValue().equals("8306") && bl) {
                return this.isCursorPossibleAt(n - 1, false);
            }
            if (!((TMessageContentItem)object).getReturnValue().equals("0")) {
                TTrace.trace(this, "isCursorPossibleAt(): returnValue=" + ((TMessageContentItem)object).getReturnValue());
                return false;
            }
            return true;
        }
        if (object == null) {
            return true;
        }
        return ((TMessageContentItem)object).getReturnValue().equals("0");
    }

    private TInputStream invokeFetchCursor(String string, int n, int n2) throws TInvocationException {
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        return this.invocation.invoke(tCommandStatement, this.collection);
    }

    private TInputStream invokeCloseCursor(String string) throws TInvocationException {
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        return this.invocation.invoke(tCommandStatement, this.collection);
    }

    private TCommandStatement getCommandStatement() {
        this.commandStatement.clear();
        return this.commandStatement;
    }

    private TIteratorException newIteratorException(TMessageContentItem tMessageContentItem) {
        Object object;
        Object object2;
        if (tMessageContentItem == null) {
            return new TIteratorException("Unkown iterator problem.");
        }
        String string = tMessageContentItem.getReturnValue();
        String string2 = "";
        if (!string.equals("")) {
            object2 = tMessageContentItem.getMessageText();
            string2 = object2 != null ? ((TMessageTextContentItem)object2).getCode() : "";
        }
        object2 = "";
        if (!string.equals("")) {
            object = tMessageContentItem.getMessageText();
            object2 = object != null ? ((TMessageTextContentItem)object).getText() : "";
        }
        object = "";
        if (!string.equals("")) {
            TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
            object = tMessageLineContentItem != null ? tMessageLineContentItem.getText() : "";
        }
        return new TIteratorException(new TAccessFailureMessage(string, string2, (String)object2, (String)object));
    }

    private TMessageContentItem getMessageContentItem() {
        TMessageContentItem tMessageContentItem;
        TMessageContentItem tMessageContentItem2 = (TMessageContentItem)this.getResponseInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem2 != null && tMessageContentItem2.getReturnValue().equals("0") && (tMessageContentItem = (TMessageContentItem)this.getResponseInfoContent().getItem(1, TMessageContentItem.SPECIFIER)) != null) {
            tMessageContentItem2 = tMessageContentItem;
        }
        return tMessageContentItem2;
    }

    private TResponseInfoContent getResponseInfoContent() {
        return this.inputStreamInterpreter.getResponseInfoContent();
    }

    private TCursorContentItem getCursorContentItem() {
        return (TCursorContentItem)this.getResponseInfoContent().getItem(0, TCursorContentItem.SPECIFIER);
    }
}

