/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TNonXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TXMLObjectFetchingIterator;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;
import java.util.Iterator;

public class TResponseBuilderImpl
implements TResponseBuilder {
    private static final int XML_ACCESS = 1;
    private static final int NON_XML_ACCESS = 2;
    private TInvocation invocation = null;
    private TResponseContentFactory contentFactory = null;
    private TInputStreamInterpreter inputStreamInterpreter = null;

    public TResponseBuilderImpl(TXMLObjectModel tXMLObjectModel, TInvocation tInvocation) {
        this.invocation = tInvocation;
        this.contentFactory = TResponseContentFactory.getInstance();
        this.inputStreamInterpreter = this.newInputStreamInterpreter(tXMLObjectModel);
    }

    public TResponse buildForXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(1, tInputStream);
    }

    public TResponse buildForNonXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(2, tInputStream);
    }

    private TResponse doBuild(int n, TInputStream tInputStream) throws TResponseBuildException {
        TResponse tResponse = null;
        try {
            this.inputStreamInterpreter.interpret(tInputStream);
            boolean bl = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TQueryContentItem.SPECIFIER);
            boolean bl2 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TCursorContentItem.SPECIFIER);
            if (bl && !bl2) {
                tResponse = n == 1 ? this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent())) : this.contentFactory.newResponse(this.inputStreamInterpreter, this.newNonXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent()));
            } else if (bl && bl2) {
                tResponse = this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectFetchingIterator());
            } else if (!bl && bl2) {
                TContractVerifier.precondition(false, "Cursor command other than open not yet implemented.");
            } else {
                tResponse = this.contentFactory.newResponse(this.inputStreamInterpreter);
            }
            return tResponse;
        }
        catch (Exception exception) {
            throw new TResponseBuildException("Response could not be built for XML access.", exception);
        }
    }

    private TInputStreamInterpreter newInputStreamInterpreter(TXMLObjectModel tXMLObjectModel) {
        TInputStreamInterpreter tInputStreamInterpreter = null;
        Class clazz = tXMLObjectModel.getInputStreamInterpreterClass();
        try {
            Object t = clazz.newInstance();
            tInputStreamInterpreter = (TInputStreamInterpreter)t;
            Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
            Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                Object e = iterator2.next();
                TTrace.trace(this, "Key:" + string + " Value:" + e);
                tInputStreamInterpreter.setProperty(string, e);
            }
        }
        catch (Exception exception) {
            TContractVerifier.precondition(false, "Problem instantiating concrete TInputStreamInterpreter. Check XML object model " + tXMLObjectModel.toString());
        }
        return tInputStreamInterpreter;
    }

    private TXMLObjectIterator newXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        return new TXMLObjectIteratorImpl(tResponseQueryContent);
    }

    private TXMLObjectIterator newXMLObjectFetchingIterator() {
        return new TXMLObjectFetchingIterator(this.inputStreamInterpreter, this.invocation);
    }

    private TNonXMLObjectIterator newNonXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        return new TNonXMLObjectIteratorImpl(this.newXMLObjectIterator(tResponseQueryContent), this.invocation);
    }
}

