/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TNonXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TResponseContentItemFactory;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;
import java.io.StringWriter;

public class TResponseBody
implements TResponseHandle {
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private TMessageContentItem defaultMessageContentItem = null;
    private TXMLObject firstXMLObject = null;
    private TXMLObjectIterator xmlObjectIterator = null;
    private TNonXMLObject firstNonXMLObject = null;
    private TNonXMLObjectIterator nonXMLObjectIterator = null;
    private StringWriter queryContentWriter = null;
    private static TXMLObjectIterator defaultXMLObjectIterator = new TXMLObjectIteratorImpl();
    private static TNonXMLObjectIterator defaultNonXMLObjectIterator = new TNonXMLObjectIteratorImpl();

    public TResponseBody(TInputStreamInterpreter tInputStreamInterpreter) {
        this.initialize(tInputStreamInterpreter, null, null);
    }

    public TResponseBody(TInputStreamInterpreter tInputStreamInterpreter, TXMLObjectIterator tXMLObjectIterator) {
        this.initialize(tInputStreamInterpreter, tXMLObjectIterator, null);
    }

    public TResponseBody(TInputStreamInterpreter tInputStreamInterpreter, TNonXMLObjectIterator tNonXMLObjectIterator) {
        this.initialize(tInputStreamInterpreter, null, tNonXMLObjectIterator);
    }

    public String getReturnValue() {
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        return tMessageContentItem != null ? tMessageContentItem.getReturnValue() : "";
    }

    public String getMessageLine() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
        return tMessageLineContentItem != null ? tMessageLineContentItem.getText() : "";
    }

    public String getMessageText() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageTextContentItem tMessageTextContentItem = tMessageContentItem.getMessageText();
        return tMessageTextContentItem != null ? tMessageTextContentItem.getText() : "";
    }

    public String getMessageCode() {
        if (this.getReturnValue().equals("")) {
            return "";
        }
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        TMessageTextContentItem tMessageTextContentItem = tMessageContentItem.getMessageText();
        return tMessageTextContentItem != null ? tMessageTextContentItem.getCode() : "";
    }

    public TResponseInfoContent getInfoContent() {
        return this.inputStreamInterpreter.getResponseInfoContent();
    }

    public TXMLObjectIterator getXMLObjectIterator() {
        return this.xmlObjectIterator;
    }

    public TXMLObject getFirstXMLObject() {
        return this.firstXMLObject;
    }

    public boolean hasFirstXMLObject() {
        return this.firstXMLObject != null;
    }

    public TNonXMLObjectIterator getNonXMLObjectIterator() {
        return this.nonXMLObjectIterator;
    }

    public TNonXMLObject getFirstNonXMLObject() {
        return this.firstNonXMLObject;
    }

    public boolean hasFirstNonXMLObject() {
        return this.firstNonXMLObject != null;
    }

    public boolean hasQueryContent() {
        boolean bl;
        boolean bl2 = bl = this.firstXMLObject != null || this.firstNonXMLObject != null;
        if (!bl) {
            bl = this.inputStreamInterpreter.getResponseQueryContent().hasText();
        }
        return bl;
    }

    public String toString() {
        TMessageContentItem tMessageContentItem = this.getMessageContentItem();
        if (tMessageContentItem != null) {
            return tMessageContentItem.toString();
        }
        return "";
    }

    public String getQueryContentAsString() {
        TResponseQueryContent tResponseQueryContent = this.inputStreamInterpreter.getResponseQueryContent();
        if (tResponseQueryContent != null) {
            StringBuffer stringBuffer = this.queryContentWriter.getBuffer();
            stringBuffer.delete(0, stringBuffer.toString().length());
            tResponseQueryContent.writeTo(this.queryContentWriter);
            return this.queryContentWriter.toString();
        }
        return "";
    }

    private void initialize(TInputStreamInterpreter tInputStreamInterpreter, TXMLObjectIterator tXMLObjectIterator, TNonXMLObjectIterator tNonXMLObjectIterator) {
        this.inputStreamInterpreter = tInputStreamInterpreter;
        this.defaultMessageContentItem = TResponseContentItemFactory.getInstance().newMessageContentItem("0", null, null);
        TResponseQueryContent tResponseQueryContent = tInputStreamInterpreter.getResponseQueryContent();
        if (tResponseQueryContent != null && tResponseQueryContent.size() > 0) {
            if (tXMLObjectIterator != null) {
                this.firstXMLObject = tResponseQueryContent.get(0);
            } else if (tNonXMLObjectIterator != null) {
                TXMLObject tXMLObject = tResponseQueryContent.get(0);
                try {
                    this.firstNonXMLObject = tNonXMLObjectIterator.next();
                    tNonXMLObjectIterator.reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.xmlObjectIterator = tXMLObjectIterator != null ? tXMLObjectIterator : defaultXMLObjectIterator;
        this.nonXMLObjectIterator = tNonXMLObjectIterator != null ? tNonXMLObjectIterator : defaultNonXMLObjectIterator;
        this.queryContentWriter = new StringWriter(1024);
    }

    private TMessageContentItem getMessageContentItem() {
        TResponseInfoContent tResponseInfoContent = this.getInfoContent();
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseInfoContent.getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem == null) {
            return this.defaultMessageContentItem;
        }
        if (!tMessageContentItem.getReturnValue().equals("0")) {
            return tMessageContentItem;
        }
        TMessageContentItem tMessageContentItem2 = (TMessageContentItem)tResponseInfoContent.getItem(1, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem2 != null) {
            tMessageContentItem = tMessageContentItem2;
        }
        return tMessageContentItem;
    }
}

