/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import java.io.IOException;

public abstract class TInputStreamInterpreter {
    private TResponseInfoContent responseInfoContent = null;
    private TResponseQueryContent responseQueryContent = null;
    private THeaderEnlister headerEnlister = null;

    protected TInputStreamInterpreter() {
        TResponseContentFactory tResponseContentFactory = TResponseContentFactory.getInstance();
        this.responseInfoContent = tResponseContentFactory.newResponseInfoContent();
        this.responseQueryContent = tResponseContentFactory.newResponseQueryContent();
        this.headerEnlister = THeaderEnlister.getInstance();
    }

    public void interpret(TInputStream tInputStream) throws TStreamInterpretException {
        try {
            this.resetInterpretState();
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            this.responseInfoContent.setHeader(tStreamHeader.getKeys(), tStreamHeader.getValues());
            this.doInterpret(tInputStream);
            TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
            if (tResponseQueryContent != null && tResponseQueryContent.size() == 1) {
                this.headerEnlister.enlistLastModified(tInputStream, (TDataObject)tResponseQueryContent.get(0));
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                tInputStream.close();
            }
            catch (IOException iOException) {
                TTrace.trace(this, "Error closing input stream.");
            }
            throw throwable;
        }
        try {
            tInputStream.close();
        }
        catch (IOException iOException) {
            TTrace.trace(this, "Error closing input stream.");
        }
    }

    public TResponseInfoContent getResponseInfoContent() {
        return this.responseInfoContent;
    }

    public TResponseQueryContent getResponseQueryContent() {
        return this.responseQueryContent;
    }

    public abstract void setProperty(String var1, Object var2);

    protected abstract void doInterpret(TInputStream var1) throws TStreamInterpretException;

    private void resetInterpretState() {
        this.responseInfoContent.clear();
        this.responseQueryContent.clear();
    }
}

