/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TStreamWritingDefaultHandler
extends DefaultHandler {
    private static final char[] LOWER_THEN = "&lt;".toCharArray();
    private static final char[] GREATER_THEN = "&gt;".toCharArray();
    private static final char[] AMPERSAND = "&amp;".toCharArray();
    private static final char[] APOSTROPHE = "&apos;".toCharArray();
    private static final char[] QUOTATION = "&quot;".toCharArray();
    private boolean documentHasStarted = false;
    private String rootElement = null;
    private StringBuffer startElementBuffer = new StringBuffer();
    private Writer writer = null;

    public TStreamWritingDefaultHandler(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setRootElement(String string) {
        this.rootElement = string != null && !string.equals("") ? string : null;
    }

    public void startDocument() throws SAXException {
        this.documentHasStarted = true;
        this.write("<?xml version=\"1.0\"?>");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?" + string + " " + string2 + "?>");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.documentHasStarted && this.rootElement != null) {
            this.write(this.rootElement);
        } else if (attributes.getLength() > 0) {
            this.startElementBuffer.delete(0, this.startElementBuffer.length());
            this.startElementBuffer.append("<" + string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.startElementBuffer.append(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                ++n;
            }
            this.startElementBuffer.append(">");
            this.write(this.startElementBuffer.toString());
        } else {
            this.write("<" + string3 + ">");
        }
        this.documentHasStarted = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.write("</" + string3 + ">");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3;
        int n4 = n3 = n;
        int n5 = n + n2 - 1;
        while (n3 <= n5) {
            char[] cArray2 = this.getEntityReference(cArray[n3]);
            if (cArray2 != null) {
                if (n3 != n4) {
                    this.write(cArray, n4, n3 - n4);
                }
                this.write(cArray2, 0, cArray2.length);
                n4 = ++n3;
                continue;
            }
            ++n3;
        }
        if (n4 < n3) {
            this.write(cArray, n4, n3 - n4);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.write(cArray, n, n2);
    }

    private void write(String string) throws SAXException {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(string);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private void write(char[] cArray, int n, int n2) throws SAXException {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(cArray, n, n2);
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    private char[] getEntityReference(char c) {
        char[] cArray = null;
        if (c == '&') {
            cArray = AMPERSAND;
        } else if (c == '<') {
            cArray = LOWER_THEN;
        } else if (c == '>') {
            cArray = GREATER_THEN;
        } else if (c == '\'') {
            cArray = APOSTROPHE;
        } else if (c == '\"') {
            cArray = QUOTATION;
        }
        return cArray;
    }
}

