/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TBufferedByteArrayInputStream;
import com.softwareag.tamino.db.api.io.TBufferedReader;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamRootElementHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TStreamWriter {
    private boolean hasWritableStream = false;
    private InputSource inputSource = null;
    private TStreamRootElementHandler streamRootElementHandler = null;
    private TStreamWritingDefaultHandler streamWritingDefaultHandler = null;
    private TStreamWritingLexicalHandler streamWritingLexicalHandler = null;
    private TStreamWritingDeclHandler streamWritingDeclHandler = null;

    public TStreamWriter() throws Exception {
        this.initialize(null, null, -1);
    }

    public TStreamWriter(InputStream inputStream, int n) throws Exception {
        this.initialize(inputStream, null, n);
    }

    public TStreamWriter(InputStream inputStream) throws Exception {
        this.initialize(inputStream, null, -1);
    }

    public TStreamWriter(Reader reader, int n) throws Exception {
        this.initialize(null, reader, n);
    }

    public TStreamWriter(Reader reader) throws Exception {
        this.initialize(null, reader, -1);
    }

    public void setDocname(String string) {
        this.streamRootElementHandler.setDocname(string);
    }

    public void setId(String string) {
        this.streamRootElementHandler.setId(string);
    }

    public String getDocname() {
        return this.streamRootElementHandler.getDocname();
    }

    public String getId() {
        return this.streamRootElementHandler.getId();
    }

    public String getStartTag() {
        return this.streamRootElementHandler.getTagName();
    }

    public void setWritableStream(InputStream inputStream) throws Exception {
        TBufferedByteArrayInputStream tBufferedByteArrayInputStream = new TBufferedByteArrayInputStream(inputStream, true);
        tBufferedByteArrayInputStream.mark(Integer.MAX_VALUE);
        try {
            this.newSAXParser().parse(new InputSource(tBufferedByteArrayInputStream), (DefaultHandler)this.streamRootElementHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == TStreamRootElementHandler.getRootElementEndedException()) {
                tBufferedByteArrayInputStream.reset();
                this.inputSource = new InputSource(tBufferedByteArrayInputStream);
                this.hasWritableStream = true;
            }
            throw sAXException;
        }
    }

    public void setWritableStream(Reader reader) throws Exception {
        TBufferedReader tBufferedReader = new TBufferedReader(reader, true);
        tBufferedReader.mark(Integer.MAX_VALUE);
        try {
            this.newSAXParser().parse(new InputSource(tBufferedReader), (DefaultHandler)this.streamRootElementHandler);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() == TStreamRootElementHandler.getRootElementEndedException()) {
                tBufferedReader.reset();
                this.inputSource = new InputSource(tBufferedReader);
                this.hasWritableStream = true;
            }
            throw sAXException;
        }
    }

    public void writeTo(Writer writer) throws Exception {
        TContractVerifier.precondition(this.hasWritableStream, "No consumable stream is given!");
        if (this.streamWritingDefaultHandler == null) {
            this.streamWritingDefaultHandler = new TStreamWritingDefaultHandler(writer);
            this.streamWritingDeclHandler = new TStreamWritingDeclHandler(writer);
            this.streamWritingLexicalHandler = new TStreamWritingLexicalHandler(writer, this.streamWritingDeclHandler);
        } else {
            this.streamWritingDefaultHandler.setWriter(writer);
            this.streamWritingLexicalHandler.setWriter(writer);
            this.streamWritingDeclHandler.setWriter(writer);
        }
        this.streamWritingDefaultHandler.setRootElement(this.streamRootElementHandler.getRootElementAsString());
        SAXParser sAXParser = this.newSAXParser();
        sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this.streamWritingLexicalHandler);
        sAXParser.getXMLReader().setProperty("http://xml.org/sax/properties/declaration-handler", this.streamWritingDeclHandler);
        sAXParser.parse(this.inputSource, (DefaultHandler)this.streamWritingDefaultHandler);
        if (writer != null) {
            writer.flush();
        }
        this.hasWritableStream = false;
    }

    public void writeTo(OutputStream outputStream) throws Exception {
        TContractVerifier.precondition(this.hasWritableStream, "No consumable stream is given!");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, TPreference.getInstance().getEncoding());
        this.writeTo(outputStreamWriter);
    }

    public boolean hasWritableStream() {
        return this.hasWritableStream;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    private void initialize(InputStream inputStream, Reader reader, int n) throws Exception {
        if (this.streamRootElementHandler == null) {
            this.streamRootElementHandler = new TStreamRootElementHandler();
        }
        if (inputStream != null) {
            this.setWritableStream(inputStream);
        } else if (reader != null) {
            this.setWritableStream(reader);
        }
    }

    private SAXParser newSAXParser() throws Exception {
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/validation", false);
        sAXParser.getXMLReader().setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return sAXParser;
    }
}

