/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamRootElementEnded;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TStreamRootElementHandler
extends DefaultHandler {
    private static final RuntimeException ROOT_ELEMENT_ENDED = new TStreamRootElementEnded("End of start element reached, aborting sax event handling now!");
    private StringBuffer rootElementBuffer = null;
    private StringBuffer temporaryBuffer = new StringBuffer();
    private StringBuffer idAttributes = new StringBuffer();
    private String startTag = "";
    private String id = "";
    private String docname = "";

    public TStreamRootElementHandler() {
        this.rootElementBuffer = new StringBuffer();
    }

    public static Exception getRootElementEndedException() {
        return ROOT_ELEMENT_ENDED;
    }

    public void setDocname(String string) {
        this.docname = string != null ? string : "";
    }

    public void setId(String string) {
        this.id = string != null ? string : "";
    }

    public String getDocname() {
        return this.docname;
    }

    public String getId() {
        return this.id;
    }

    public String getTagName() {
        return this.startTag;
    }

    public boolean hasRootElement() {
        return this.rootElementBuffer != null && this.rootElementBuffer.length() > 0;
    }

    public void writeRootElementTo(Writer writer) throws IOException {
        TContractVerifier.precondition(this.hasRootElement(), "No root element is given to write to Writer!");
        if (writer == null) {
            return;
        }
        writer.write(this.rootElementBuffer.toString());
        writer.write(this.getIdAttributes());
    }

    public String getRootElementAsString() {
        this.temporaryBuffer.delete(0, this.temporaryBuffer.length());
        this.temporaryBuffer.append(this.rootElementBuffer.toString());
        this.temporaryBuffer.append(this.getIdAttributes());
        return this.temporaryBuffer.toString();
    }

    public void startDocument() throws SAXException {
        this.releaseRootElement();
        this.setId(null);
        this.setDocname(null);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!this.hasRootElement()) {
            this.processRootElement(string, string2, string3, attributes);
            throw ROOT_ELEMENT_ENDED;
        }
        TContractVerifier.precondition(false, "Start element has already been consumed. No more elements processable!");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        TContractVerifier.precondition(false, "Start element has already been consumed. No more elements processable!");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        TContractVerifier.precondition(false, "Start element has already been consumed. No more elements processable!");
    }

    public void endDocument() throws SAXException {
        TContractVerifier.precondition(false, "Start element has already been consumed. No more elements processable!");
    }

    private void processRootElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.rootElementBuffer.append("<" + string3);
        this.startTag = string3;
        if (attributes.getLength() > 0) {
            int n = 0;
            while (n < attributes.getLength()) {
                if (attributes.getQName(n).equals(TInoNamespace.ID.getQualifiedName())) {
                    this.id = attributes.getValue(n);
                } else if (attributes.getQName(n).equals(TInoNamespace.DOCNAME.getQualifiedName())) {
                    this.docname = attributes.getValue(n);
                } else {
                    this.rootElementBuffer.append(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                }
                ++n;
            }
        }
    }

    private void releaseRootElement() {
        this.rootElementBuffer.delete(0, this.rootElementBuffer.length());
    }

    private String getIdAttributes() {
        this.idAttributes.delete(0, this.idAttributes.length());
        if (!this.id.equals("")) {
            this.idAttributes.append(" " + TInoNamespace.ID.getQualifiedName() + "=\"" + this.id + "\"");
        }
        if (!this.docname.equals("")) {
            this.idAttributes.append(" " + TInoNamespace.DOCNAME.getQualifiedName() + "=\"" + this.docname + "\"");
        }
        this.idAttributes.append(">");
        return this.idAttributes.toString();
    }
}

